/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.util.Optional;
import org.springframework.web.util.UriComponentsBuilder;

public class IdentityServiceConfig {
    private static final String REALMS = "realms";
    private int clientConnectionTimeout;
    private int clientSocketTimeout;
    private String resource;
    private String clientSecret;
    private String authServerUrl;
    private String realm;
    private int connectionPoolSize;
    private boolean allowAnyHostname;
    private boolean disableTrustManager;
    private String truststore;
    private String truststorePassword;
    private String clientKeystore;
    private String clientKeystorePassword;
    private String clientKeyPassword;
    private String realmKey;
    private int publicKeyCacheTtl;
    private boolean publicClient;

    public int getClientConnectionTimeout() {
        return this.clientConnectionTimeout;
    }

    public void setClientConnectionTimeout(int clientConnectionTimeout) {
        this.clientConnectionTimeout = clientConnectionTimeout;
    }

    public int getClientSocketTimeout() {
        return this.clientSocketTimeout;
    }

    public void setClientSocketTimeout(int clientSocketTimeout) {
        this.clientSocketTimeout = clientSocketTimeout;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public String getAuthServerUrl() {
        return this.authServerUrl;
    }

    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = authServerUrl;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientSecret() {
        return Optional.ofNullable(this.clientSecret).orElse("");
    }

    public String getIssuerUrl() {
        return UriComponentsBuilder.fromUriString((String)this.getAuthServerUrl()).pathSegment(new String[]{REALMS, this.getRealm()}).build().toString();
    }

    public void setAllowAnyHostname(boolean allowAnyHostname) {
        this.allowAnyHostname = allowAnyHostname;
    }

    public boolean isAllowAnyHostname() {
        return this.allowAnyHostname;
    }

    public void setDisableTrustManager(boolean disableTrustManager) {
        this.disableTrustManager = disableTrustManager;
    }

    public boolean isDisableTrustManager() {
        return this.disableTrustManager;
    }

    public void setTruststore(String truststore) {
        this.truststore = truststore;
    }

    public String getTruststore() {
        return this.truststore;
    }

    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public void setClientKeystore(String clientKeystore) {
        this.clientKeystore = clientKeystore;
    }

    public String getClientKeystore() {
        return this.clientKeystore;
    }

    public void setClientKeystorePassword(String clientKeystorePassword) {
        this.clientKeystorePassword = clientKeystorePassword;
    }

    public String getClientKeystorePassword() {
        return this.clientKeystorePassword;
    }

    public void setClientKeyPassword(String clientKeyPassword) {
        this.clientKeyPassword = clientKeyPassword;
    }

    public String getClientKeyPassword() {
        return this.clientKeyPassword;
    }

    public void setRealmKey(String realmKey) {
        this.realmKey = realmKey;
    }

    public String getRealmKey() {
        return this.realmKey;
    }

    public void setPublicKeyCacheTtl(int publicKeyCacheTtl) {
        this.publicKeyCacheTtl = publicKeyCacheTtl;
    }

    public int getPublicKeyCacheTtl() {
        return this.publicKeyCacheTtl;
    }

    public void setPublicClient(boolean publicClient) {
        this.publicClient = publicClient;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }
}

