/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.DefaultPasswordTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.DefaultRefreshTokenTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2PasswordGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationExchange;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponse;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.web.client.RestOperations;

class SpringBasedIdentityServiceFacade
implements IdentityServiceFacade {
    private static final Log LOGGER = LogFactory.getLog(SpringBasedIdentityServiceFacade.class);
    private static final Instant SOME_INSIGNIFICANT_DATE_IN_THE_PAST = Instant.MIN.plusSeconds(12345L);
    private final Map<AuthorizationGrantType, OAuth2AccessTokenResponseClient> clients;
    private final ClientRegistration clientRegistration;
    private final JwtDecoder jwtDecoder;

    SpringBasedIdentityServiceFacade(RestOperations restOperations, ClientRegistration clientRegistration, JwtDecoder jwtDecoder) {
        Objects.requireNonNull(restOperations);
        this.clientRegistration = Objects.requireNonNull(clientRegistration);
        this.jwtDecoder = Objects.requireNonNull(jwtDecoder);
        this.clients = Map.of(AuthorizationGrantType.AUTHORIZATION_CODE, SpringBasedIdentityServiceFacade.createAuthorizationCodeClient(restOperations), AuthorizationGrantType.REFRESH_TOKEN, SpringBasedIdentityServiceFacade.createRefreshTokenClient(restOperations), AuthorizationGrantType.PASSWORD, SpringBasedIdentityServiceFacade.createPasswordClient(restOperations));
    }

    @Override
    public IdentityServiceFacade.AccessTokenAuthorization authorize(IdentityServiceFacade.AuthorizationGrant authorizationGrant) {
        OAuth2AccessTokenResponse response;
        AbstractOAuth2AuthorizationGrantRequest request = this.createRequest(authorizationGrant);
        OAuth2AccessTokenResponseClient client = this.getClient(request);
        try {
            response = client.getTokenResponse(request);
        }
        catch (OAuth2AuthorizationException e) {
            LOGGER.debug((Object)("Failed to authorize against Authorization Server. Reason: " + e.getError() + "."));
            throw new IdentityServiceFacade.AuthorizationException("Failed to obtain access token. " + e.getError(), e);
        }
        catch (RuntimeException e) {
            LOGGER.warn((Object)("Failed to authorize against Authorization Server. Reason: " + e.getMessage()));
            throw new IdentityServiceFacade.AuthorizationException("Failed to obtain access token.", e);
        }
        return new SpringAccessTokenAuthorization(response);
    }

    @Override
    public IdentityServiceFacade.DecodedAccessToken decodeToken(String token) {
        Jwt validToken;
        try {
            validToken = this.jwtDecoder.decode(token);
        }
        catch (RuntimeException e) {
            throw new IdentityServiceFacade.TokenDecodingException("Failed to decode token. " + e.getMessage(), e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Bearer token outcome: " + validToken.getClaims()));
        }
        return new SpringDecodedAccessToken(validToken);
    }

    private AbstractOAuth2AuthorizationGrantRequest createRequest(IdentityServiceFacade.AuthorizationGrant grant) {
        if (grant.isPassword()) {
            return new OAuth2PasswordGrantRequest(this.clientRegistration, grant.getUsername(), grant.getPassword());
        }
        if (grant.isRefreshToken()) {
            OAuth2AccessToken expiredAccessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, "JUST_FOR_FULFILLING_THE_SPRING_API", SOME_INSIGNIFICANT_DATE_IN_THE_PAST, SOME_INSIGNIFICANT_DATE_IN_THE_PAST.plusSeconds(1L));
            OAuth2RefreshToken refreshToken = new OAuth2RefreshToken(grant.getRefreshToken(), null);
            return new OAuth2RefreshTokenGrantRequest(this.clientRegistration, expiredAccessToken, refreshToken, this.clientRegistration.getScopes());
        }
        if (grant.isAuthorizationCode()) {
            OAuth2AuthorizationExchange authzExchange = new OAuth2AuthorizationExchange(OAuth2AuthorizationRequest.authorizationCode().clientId(this.clientRegistration.getClientId()).authorizationUri(this.clientRegistration.getProviderDetails().getAuthorizationUri()).redirectUri(grant.getRedirectUri()).scopes(this.clientRegistration.getScopes()).build(), OAuth2AuthorizationResponse.success((String)grant.getAuthorizationCode()).redirectUri(grant.getRedirectUri()).build());
            return new OAuth2AuthorizationCodeGrantRequest(this.clientRegistration, authzExchange);
        }
        throw new UnsupportedOperationException("Unsupported grant type.");
    }

    private OAuth2AccessTokenResponseClient getClient(AbstractOAuth2AuthorizationGrantRequest request) {
        AuthorizationGrantType grantType = request.getGrantType();
        OAuth2AccessTokenResponseClient client = this.clients.get(grantType);
        if (client == null) {
            throw new UnsupportedOperationException("Unsupported grant type `" + grantType + "`.");
        }
        return client;
    }

    private static OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> createAuthorizationCodeClient(RestOperations rest) {
        DefaultAuthorizationCodeTokenResponseClient client = new DefaultAuthorizationCodeTokenResponseClient();
        client.setRestOperations(rest);
        return client;
    }

    private static OAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest> createRefreshTokenClient(RestOperations rest) {
        DefaultRefreshTokenTokenResponseClient client = new DefaultRefreshTokenTokenResponseClient();
        client.setRestOperations(rest);
        return client;
    }

    private static OAuth2AccessTokenResponseClient<OAuth2PasswordGrantRequest> createPasswordClient(RestOperations rest) {
        DefaultPasswordTokenResponseClient client = new DefaultPasswordTokenResponseClient();
        client.setRestOperations(rest);
        return client;
    }

    private static class SpringAccessToken
    implements IdentityServiceFacade.AccessToken {
        private final AbstractOAuth2Token token;

        private SpringAccessToken(AbstractOAuth2Token token) {
            this.token = Objects.requireNonNull(token);
        }

        @Override
        public String getTokenValue() {
            return this.token.getTokenValue();
        }

        @Override
        public Instant getExpiresAt() {
            return this.token.getExpiresAt();
        }

        /* synthetic */ SpringAccessToken(AbstractOAuth2Token abstractOAuth2Token, SpringAccessToken springAccessToken, SpringAccessToken springAccessToken2) {
            this(abstractOAuth2Token);
        }
    }

    private static class SpringAccessTokenAuthorization
    implements IdentityServiceFacade.AccessTokenAuthorization {
        private final OAuth2AccessTokenResponse tokenResponse;

        private SpringAccessTokenAuthorization(OAuth2AccessTokenResponse tokenResponse) {
            this.tokenResponse = Objects.requireNonNull(tokenResponse);
        }

        @Override
        public IdentityServiceFacade.AccessToken getAccessToken() {
            return new SpringAccessToken((AbstractOAuth2Token)this.tokenResponse.getAccessToken());
        }

        @Override
        public String getRefreshTokenValue() {
            return Optional.of(this.tokenResponse).map(OAuth2AccessTokenResponse::getRefreshToken).map(AbstractOAuth2Token::getTokenValue).orElse(null);
        }
    }

    private static class SpringDecodedAccessToken
    extends SpringAccessToken
    implements IdentityServiceFacade.DecodedAccessToken {
        private final Jwt jwt;

        private SpringDecodedAccessToken(Jwt jwt) {
            super((AbstractOAuth2Token)jwt, null, null);
            this.jwt = jwt;
        }

        @Override
        public Object getClaim(String claim) {
            return this.jwt.getClaim(claim);
        }
    }
}

