/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import java.lang.reflect.Method;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.transaction.UserTransaction;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.error.ExceptionStackUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.DoNotRetryException;
import org.alfresco.service.license.LicenseIntegrityException;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.LockHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DeadlockLoserDataAccessException;
import org.springframework.jdbc.JdbcUpdateAffectedIncorrectNumberOfRowsException;
import org.springframework.jdbc.UncategorizedSQLException;

@AlfrescoPublicApi
public class RetryingTransactionHelper {
    private static final String MSG_READ_ONLY = "permissions.err_read_only";
    private static final String KEY_ACTIVE_TRANSACTION = "RetryingTransactionHelper.ActiveTxn";
    private static Log logger = LogFactory.getLog(RetryingTransactionHelper.class);
    public static final Class[] RETRY_EXCEPTIONS;
    private TransactionService txnService;
    private int maxRetries = 20;
    private int minRetryWaitMs = 100;
    private int maxRetryWaitMs = 2000;
    private int retryWaitIncrementMs = 100;
    private long maxExecutionMs;
    private SortedMap<Long, List<Throwable>> txnsInProgress = new TreeMap<Long, List<Throwable>>();
    private int txnCount;
    private boolean readOnly;
    private boolean forceWritable = false;
    private Random random = new Random(System.currentTimeMillis());
    private List<Class<?>> extraExceptions;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$alfresco$repo$transaction$AlfrescoTransactionSupport$TxnReadState;

    static {
        Class[] coreClasses = new Class[]{ConcurrencyFailureException.class, DeadlockLoserDataAccessException.class, JdbcUpdateAffectedIncorrectNumberOfRowsException.class, UncategorizedSQLException.class, SQLException.class, BatchUpdateException.class, DataIntegrityViolationException.class, LicenseIntegrityException.class, TooManyResultsException.class, LockHelper.LockTryException.class, PersistenceException.class};
        ArrayList retryExceptions = new ArrayList();
        retryExceptions.addAll(Arrays.asList(coreClasses));
        retryExceptions.addAll(RetryingTransactionHelper.enterpriseRetryExceptions());
        RETRY_EXCEPTIONS = retryExceptions.toArray(new Class[0]);
    }

    private static List<Class<?>> enterpriseRetryExceptions() {
        List<Class<?>> retryExceptions = null;
        try {
            Class<?> c = Class.forName("org.alfresco.enterprise.repo.transaction.RetryExceptions");
            retryExceptions = (List<Class<?>>)c.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
            throw new AlfrescoRuntimeException("Unable to instantiate enterprise RetryExceptions.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlfrescoRuntimeException("Unable to instantiate enterprise RetryExceptions.");
        }
        if (retryExceptions == null) {
            retryExceptions = Collections.emptyList();
        }
        return retryExceptions;
    }

    public void setTransactionService(TransactionService service) {
        this.txnService = service;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setMinRetryWaitMs(int minRetryWaitMs) {
        this.minRetryWaitMs = minRetryWaitMs;
    }

    public void setMaxRetryWaitMs(int maxRetryWaitMs) {
        this.maxRetryWaitMs = maxRetryWaitMs;
    }

    public void setRetryWaitIncrementMs(int retryWaitIncrementMs) {
        if (retryWaitIncrementMs <= 0) {
            throw new IllegalArgumentException("'retryWaitIncrementMs' must be a positive integer.");
        }
        this.retryWaitIncrementMs = retryWaitIncrementMs;
    }

    public void setMaxExecutionMs(long maxExecutionMs) {
        this.maxExecutionMs = maxExecutionMs;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setForceWritable(boolean forceWritable) {
        this.forceWritable = forceWritable;
        this.readOnly = false;
    }

    public void setExtraExceptions(List<Class<?>> extraExceptions) {
        this.extraExceptions = extraExceptions;
    }

    public <R> R doInTransaction(RetryingTransactionCallback<R> cb) {
        return this.doInTransaction(cb, false, false);
    }

    public <R> R doInTransaction(RetryingTransactionCallback<R> cb, boolean readOnly) {
        return this.doInTransaction(cb, readOnly, false);
    }

    /*
     * Exception decompiling
     */
    public <R> R doInTransaction(RetryingTransactionCallback<R> cb, boolean readOnly, boolean requiresNew) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 23[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Throwable extractRetryCause(Throwable cause) {
        Throwable retryCause = ExceptionStackUtil.getCause((Throwable)cause, (Class[])RETRY_EXCEPTIONS);
        if (retryCause == null) {
            return null;
        }
        if (ExceptionStackUtil.getCause((Throwable)cause, (Class[])new Class[]{DoNotRetryException.class}) != null) {
            return null;
        }
        if (retryCause instanceof UncategorizedSQLException) {
            if (retryCause.getCause() != null && retryCause.getCause() != retryCause) {
                cause = retryCause.getCause();
                if (retryCause.getMessage().toLowerCase().contains("deadlock")) {
                    return retryCause;
                }
                if (retryCause.getMessage().toLowerCase().contains("constraint")) {
                    return retryCause;
                }
                return RetryingTransactionHelper.extractRetryCause(cause);
            }
            return null;
        }
        return retryCause;
    }

    public static UserTransaction getActiveUserTransaction() {
        if (AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            return null;
        }
        UserTransaction txn = (UserTransaction)AlfrescoTransactionSupport.getResource((Object)KEY_ACTIVE_TRANSACTION);
        if (txn == null) {
            return null;
        }
        return txn;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$alfresco$repo$transaction$AlfrescoTransactionSupport$TxnReadState() {
        if ($SWITCH_TABLE$org$alfresco$repo$transaction$AlfrescoTransactionSupport$TxnReadState != null) {
            return $SWITCH_TABLE$org$alfresco$repo$transaction$AlfrescoTransactionSupport$TxnReadState;
        }
        int[] nArray = new int[AlfrescoTransactionSupport.TxnReadState.values().length];
        try {
            nArray[AlfrescoTransactionSupport.TxnReadState.TXN_NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$alfresco$repo$transaction$AlfrescoTransactionSupport$TxnReadState = nArray;
        return nArray;
    }

    @AlfrescoPublicApi
    public static interface RetryingTransactionCallback<Result> {
        public Result execute() throws Throwable;
    }

    private static class UserTransactionProtectionAdvise
    implements MethodBeforeAdvice {
        private UserTransactionProtectionAdvise() {
        }

        public void before(Method method, Object[] args, Object target) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("begin") || methodName.equals("commit") || methodName.equals("rollback")) {
                throw new IllegalAccessException("The user transaction cannot be manipulated from within the transactional work load");
            }
        }
    }
}

