/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderServiceType;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

public class FileFolderUtil {
    public static FileInfo makeFolders(FileFolderService service, NodeRef parentNodeRef, List<String> pathElements, QName folderTypeQName) {
        return FileFolderUtil.makeFolders(service, parentNodeRef, pathElements, folderTypeQName, null, null);
    }

    public static FileInfo makeFolders(FileFolderService service, NodeRef parentNodeRef, List<String> pathElements, QName folderTypeQName, BehaviourFilter behaviourFilter, Set<QName> parentBehavioursToDisable) {
        FileFolderUtil.validate(pathElements, service, folderTypeQName);
        ArrayList<PathElementDetails> list = new ArrayList<PathElementDetails>(pathElements.size());
        for (String pathElement : pathElements) {
            list.add(new PathElementDetails(pathElement, null));
        }
        FileInfo fileInfo = FileFolderUtil.makeFolders(service, null, parentNodeRef, list, folderTypeQName, behaviourFilter, parentBehavioursToDisable);
        return fileInfo;
    }

    public static FileInfo makeFolders(FileFolderService service, NodeService nodeService, NodeRef parentNodeRef, List<PathElementDetails> pathElementDetails, QName folderTypeQName, BehaviourFilter behaviourFilter, Set<QName> parentBehavioursToDisable) {
        return FileFolderUtil.makeFolders(service, nodeService, parentNodeRef, pathElementDetails, folderTypeQName, behaviourFilter, parentBehavioursToDisable, null);
    }

    /*
     * Unable to fully structure code
     */
    public static FileInfo makeFolders(FileFolderService service, NodeService nodeService, NodeRef parentNodeRef, List<PathElementDetails> pathElementDetails, QName folderTypeQName, BehaviourFilter behaviourFilter, Set<QName> parentBehavioursToDisable, Set<NodeRef> allFoldersRefsInThePath) {
        FileFolderUtil.validate(pathElementDetails, service, folderTypeQName);
        currentParentRef = parentNodeRef;
        for (PathElementDetails pathElement : pathElementDetails) {
            block9: {
                block10: {
                    nodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new SearchAsSystem(service, currentParentRef, pathElement.getFolderName()), (String)AuthenticationUtil.getSystemUserName());
                    if (nodeRef != null) break block10;
                    if (behaviourFilter != null && parentBehavioursToDisable != null) {
                        for (QName parentBehaviourToDisable : parentBehavioursToDisable) {
                            behaviourFilter.disableBehaviour(currentParentRef, parentBehaviourToDisable);
                        }
                    }
                    try {
                        createdFileInfo = service.create(currentParentRef, pathElement.getFolderName(), folderTypeQName);
                        currentParentRef = createdFileInfo.getNodeRef();
                        requireddAspects = pathElement.getAspects();
                        if (requireddAspects.size() <= 0) ** break block11
                        if (nodeService != null) {
                            for (QName aspect : requireddAspects.keySet()) {
                                nodeService.addAspect(currentParentRef, aspect, requireddAspects.get(aspect));
                            }
                        }
                        break block12;
                    }
                    finally {
                        if (behaviourFilter == null || parentBehavioursToDisable == null) break block9;
                        var18_17 = parentBehavioursToDisable.iterator();
                        if (true) ** GOTO lbl32
                    }
                    {
                        block12: {
                        }
                    }
                    do {
                        parentBehaviourToDisable = var18_17.next();
                        behaviourFilter.enableBehaviour(currentParentRef, parentBehaviourToDisable);
lbl32:
                        // 2 sources

                    } while (var18_17.hasNext());
                    break block9;
                }
                currentParentRef = nodeRef;
            }
            if (allFoldersRefsInThePath == null) continue;
            allFoldersRefsInThePath.add(currentParentRef);
        }
        fileInfo = service.getFileInfo(currentParentRef);
        return fileInfo;
    }

    private static <T> void validate(List<T> pathElements, FileFolderService service, QName folderTypeQName) {
        boolean isFolder;
        if (pathElements.size() == 0) {
            throw new IllegalArgumentException("Path element list is empty");
        }
        boolean bl = isFolder = service.getType(folderTypeQName) == FileFolderServiceType.FOLDER;
        if (!isFolder) {
            throw new IllegalArgumentException("Type is invalid to make folders with: " + folderTypeQName);
        }
    }

    public static class PathElementDetails {
        private final String folderName;
        private final Map<QName, Map<QName, Serializable>> aspects;

        public PathElementDetails(String folderName, Map<QName, Map<QName, Serializable>> aspects) {
            this.folderName = folderName;
            this.aspects = aspects == null ? Collections.emptyMap() : Collections.unmodifiableMap(aspects);
        }

        public String getFolderName() {
            return this.folderName;
        }

        public Map<QName, Map<QName, Serializable>> getAspects() {
            return this.aspects;
        }
    }

    private static class SearchAsSystem
    implements AuthenticationUtil.RunAsWork<NodeRef> {
        FileFolderService service;
        NodeRef node;
        String name;

        SearchAsSystem(FileFolderService service, NodeRef node, String name) {
            this.service = service;
            this.node = node;
            this.name = name;
        }

        public NodeRef doWork() throws Exception {
            return this.service.searchSimple(this.node, this.name);
        }
    }
}

