/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.alfresco.heartbeat.InfoDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.repo.deployment.DeploymentMethod;
import org.alfresco.repo.deployment.DeploymentMethodProvider;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.repo.descriptor.DescriptorServiceImpl;
import org.alfresco.service.cmr.repository.HBDataCollectorService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class InfoDataCollectorTest {
    private InfoDataCollector infoCollector;
    private HBDataCollectorService mockCollectorService;
    private DescriptorDAO mockDescriptorDAO;
    private DescriptorDAO mockServerDescriptorDAO;
    private List<HBData> collectedData;
    private DescriptorServiceImpl.BaseDescriptor spyDescriptor;
    private DeploymentMethodProvider mockDeploymentMethodProvider;
    private HeartBeatJobScheduler mockScheduler;
    private DatabaseMetaData mockDatabaseMetaData;
    private ServletContext mockServletContext;

    @Before
    public void setUp() throws SQLException {
        this.spyDescriptor = (DescriptorServiceImpl.BaseDescriptor)Mockito.spy(DescriptorServiceImpl.BaseDescriptor.class);
        this.mockDescriptorDAO = (DescriptorDAO)Mockito.mock(DescriptorDAO.class);
        this.mockServerDescriptorDAO = (DescriptorDAO)Mockito.mock(DescriptorDAO.class);
        this.mockCollectorService = (HBDataCollectorService)Mockito.mock(HBDataCollectorService.class);
        this.mockDeploymentMethodProvider = (DeploymentMethodProvider)Mockito.mock(DeploymentMethodProvider.class);
        this.mockScheduler = (HeartBeatJobScheduler)Mockito.mock(HeartBeatJobScheduler.class);
        this.mockDatabaseMetaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        this.mockServletContext = (ServletContext)Mockito.mock(ServletContext.class);
        DataSource mockDataSource = (DataSource)Mockito.mock(DataSource.class);
        Connection mockCon = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)mockDataSource.getConnection()).thenReturn((Object)mockCon);
        Mockito.when((Object)mockCon.getMetaData()).thenReturn((Object)this.mockDatabaseMetaData);
        Mockito.when((Object)this.spyDescriptor.getId()).thenReturn((Object)"mock_id");
        Mockito.when((Object)this.mockServerDescriptorDAO.getDescriptor()).thenReturn((Object)this.spyDescriptor);
        Mockito.when((Object)this.mockDescriptorDAO.getDescriptor()).thenReturn((Object)this.spyDescriptor);
        Mockito.when((Object)this.mockDeploymentMethodProvider.getDeploymentMethod()).thenReturn((Object)DeploymentMethod.DEFAULT);
        Mockito.when((Object)this.mockServletContext.getServerInfo()).thenReturn((Object)"Apache Tomcat/7.0.47");
        this.infoCollector = new InfoDataCollector("acs.repository.info", "1.0", "0 0 0 ? * *", this.mockScheduler);
        this.infoCollector.setHbDataCollectorService(this.mockCollectorService);
        this.infoCollector.setCurrentRepoDescriptorDAO(this.mockDescriptorDAO);
        this.infoCollector.setServerDescriptorDAO(this.mockServerDescriptorDAO);
        this.infoCollector.setDeploymentMethodProvider(this.mockDeploymentMethodProvider);
        this.infoCollector.setDataSource(mockDataSource);
        this.infoCollector.setServletContext(this.mockServletContext);
    }

    @Test
    public void testHBDataFields() {
        this.mockVersionDetails("6", "0", "0", "");
        this.collectedData = this.infoCollector.collectData();
        HBData repoInfo = this.grabDataByCollectorId(this.infoCollector.getCollectorId());
        Assert.assertNotNull((String)"Repository info data missing.", (Object)repoInfo);
        for (HBData data : this.collectedData) {
            Assert.assertNotNull((Object)data.getCollectorId());
            Assert.assertNotNull((Object)data.getCollectorVersion());
            Assert.assertNotNull((Object)data.getSchemaVersion());
            Assert.assertNotNull((Object)data.getSystemId());
            Assert.assertNotNull((Object)data.getTimestamp());
            Assert.assertNotNull((Object)data.getData());
        }
    }

    @Test
    public void testInfoDataIsCollected() {
        this.mockVersionDetails("5", "1", "2", ".4");
        this.mockDatabaseMetaData("PostgreSQL", "10.1", "PostgreSQL JDBC Driver", "42.2.5");
        this.collectedData = this.infoCollector.collectData();
        HBData repoInfo = this.grabDataByCollectorId(this.infoCollector.getCollectorId());
        Assert.assertNotNull((String)"Repository info data missing.", (Object)repoInfo);
        Map data = repoInfo.getData();
        Assert.assertEquals((Object)"repository", data.get("repoName"));
        Assert.assertEquals((Object)1000, data.get("schema"));
        Assert.assertEquals((Object)"Community", data.get("edition"));
        Assert.assertEquals((Object)DeploymentMethod.DEFAULT.toString(), data.get("deploymentMethod"));
        Assert.assertTrue((boolean)data.containsKey("version"));
        Map version = (Map)data.get("version");
        Assert.assertEquals((Object)"5.1.2 (.4 rc08e1b5a-b192)", version.get("full"));
        Assert.assertEquals((Object)"5.1", version.get("servicePack"));
        Assert.assertEquals((Object)"5", version.get("major"));
        Assert.assertEquals((Object)"1", version.get("minor"));
        Assert.assertEquals((Object)"2", version.get("patch"));
        Assert.assertEquals((Object)"4", version.get("hotfix"));
        Assert.assertNotNull((String)"Check if data is collected", data.get("osVendor"));
        Assert.assertNotNull((String)"Check if data is collected", data.get("osVersion"));
        Assert.assertNotNull((String)"Check if data is collected", data.get("osArch"));
        Assert.assertNotNull((String)"Check if data is collected", data.get("javaVendor"));
        Assert.assertNotNull((String)"Check if data is collected", data.get("javaVersion"));
        Assert.assertNotNull((String)"Check if data is collected", data.get("userLanguage"));
        Assert.assertNotNull((String)"Check if data is collected", data.get("userTimezone"));
        Assert.assertNotNull((String)"Check if data is collected", data.get("userUTCOffset"));
        Assert.assertEquals((Object)"Apache Tomcat/7.0.47", data.get("serverInfo"));
        Assert.assertTrue((boolean)data.containsKey("db"));
        Map db = (Map)data.get("db");
        Assert.assertEquals((Object)"PostgreSQL", db.get("vendor"));
        Assert.assertEquals((Object)"10.1", db.get("version"));
        Assert.assertEquals((Object)"PostgreSQL JDBC Driver", db.get("driverName"));
        Assert.assertEquals((Object)"42.2.5", db.get("driverVersion"));
    }

    @Test
    public void testInfoDataIsCollectedHotfixNoDot() {
        this.mockVersionDetails("5", "1", "2", "4");
        this.collectedData = this.infoCollector.collectData();
        HBData repoInfo = this.grabDataByCollectorId(this.infoCollector.getCollectorId());
        Assert.assertNotNull((String)"Repository info data missing.", (Object)repoInfo);
        Map data = repoInfo.getData();
        Assert.assertEquals((Object)"repository", data.get("repoName"));
        Assert.assertEquals((Object)1000, data.get("schema"));
        Assert.assertEquals((Object)"Community", data.get("edition"));
        Assert.assertTrue((boolean)data.containsKey("version"));
        Map version = (Map)data.get("version");
        Assert.assertEquals((Object)"5.1.2 (4 rc08e1b5a-b192)", version.get("full"));
        Assert.assertEquals((Object)"5.1", version.get("servicePack"));
        Assert.assertEquals((Object)"5", version.get("major"));
        Assert.assertEquals((Object)"1", version.get("minor"));
        Assert.assertEquals((Object)"2", version.get("patch"));
        Assert.assertEquals((Object)"4", version.get("hotfix"));
    }

    @Test
    public void testInfoDataIsCollectedNoHotfix() {
        this.mockVersionDetails("5", "1", "2", "");
        this.collectedData = this.infoCollector.collectData();
        HBData repoInfo = this.grabDataByCollectorId(this.infoCollector.getCollectorId());
        Assert.assertNotNull((String)"Repository info data missing.", (Object)repoInfo);
        Map data = repoInfo.getData();
        Assert.assertEquals((Object)"repository", data.get("repoName"));
        Assert.assertEquals((Object)1000, data.get("schema"));
        Assert.assertEquals((Object)"Community", data.get("edition"));
        Assert.assertTrue((boolean)data.containsKey("version"));
        Map version = (Map)data.get("version");
        Assert.assertEquals((Object)"5.1.2 (rc08e1b5a-b192)", version.get("full"));
        Assert.assertEquals((Object)"5.1", version.get("servicePack"));
        Assert.assertEquals((Object)"5", version.get("major"));
        Assert.assertEquals((Object)"1", version.get("minor"));
        Assert.assertEquals((Object)"2", version.get("patch"));
    }

    private HBData grabDataByCollectorId(String collectorId) {
        for (HBData d : this.collectedData) {
            if (d.getCollectorId() == null || !d.getCollectorId().equals(collectorId)) continue;
            return d;
        }
        return null;
    }

    private void mockVersionDetails(String major, String minor, String patch, String hotfix) {
        Mockito.when((Object)this.spyDescriptor.getName()).thenReturn((Object)"repository");
        Mockito.when((Object)this.spyDescriptor.getVersionMajor()).thenReturn((Object)major);
        Mockito.when((Object)this.spyDescriptor.getVersionMinor()).thenReturn((Object)minor);
        Mockito.when((Object)this.spyDescriptor.getVersionRevision()).thenReturn((Object)patch);
        Mockito.when((Object)this.spyDescriptor.getVersionLabel()).thenReturn((Object)hotfix);
        Mockito.when((Object)this.spyDescriptor.getSchema()).thenReturn((Object)1000);
        Mockito.when((Object)this.spyDescriptor.getEdition()).thenReturn((Object)"Community");
        Mockito.when((Object)this.spyDescriptor.getVersionBuild()).thenReturn((Object)"rc08e1b5a-b192");
    }

    private void mockDatabaseMetaData(String vendor, String version, String driverName, String driverVersion) {
        try {
            Mockito.when((Object)this.mockDatabaseMetaData.getDatabaseProductName()).thenReturn((Object)vendor);
            Mockito.when((Object)this.mockDatabaseMetaData.getDatabaseProductVersion()).thenReturn((Object)version);
            Mockito.when((Object)this.mockDatabaseMetaData.getDriverName()).thenReturn((Object)driverName);
            Mockito.when((Object)this.mockDatabaseMetaData.getDriverVersion()).thenReturn((Object)driverVersion);
        }
        catch (SQLException sQLException) {}
    }
}

