/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event2.AbstractContextAwareRepoEvent;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class EventGeneratorDisabledTest
extends AbstractContextAwareRepoEvent {
    private static final String EVENT2_TOPIC_NAME = "alfresco.repo.event2";
    private static final String BROKER_URL = "tcp://localhost:61616";
    @Autowired
    @Qualifier(value="event2ObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    protected ObjectMapper event2ObjectMapper;
    private ActiveMQConnection connection;
    protected List<RepoEvent<?>> receivedEvents;

    @Before
    public void setup() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(BROKER_URL);
        this.connection = (ActiveMQConnection)connectionFactory.createConnection();
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Topic destination = session.createTopic(EVENT2_TOPIC_NAME);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.receivedEvents = Collections.synchronizedList(new LinkedList());
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                String text = EventGeneratorDisabledTest.getText(message);
                RepoEvent<?> event = this.toRepoEvent(text);
                EventGeneratorDisabledTest.this.receivedEvents.add(event);
            }

            private RepoEvent<?> toRepoEvent(String json) {
                try {
                    return (RepoEvent)EventGeneratorDisabledTest.this.objectMapper.readValue(json, RepoEvent.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
    }

    @After
    public void shutdownTopicListener() throws Exception {
        this.connection.close();
        this.connection = null;
    }

    @Test
    public void shouldNotReceiveEvent2EventsOnNodeCreation() throws Exception {
        if (this.eventGenerator.isEnabled()) {
            this.eventGenerator.disable();
        }
        this.createNode(ContentModel.TYPE_CONTENT);
        Awaitility.await().pollDelay(6L, TimeUnit.SECONDS).until(() -> this.receivedEvents.size() == 0);
        EventGeneratorDisabledTest.assertTrue((AbstractContextAwareRepoEvent.EVENT_CONTAINER.getEvents().size() == 0 ? 1 : 0) != 0);
        EventGeneratorDisabledTest.assertTrue((this.receivedEvents.size() == 0 ? 1 : 0) != 0);
        this.eventGenerator.enable();
    }

    @Test
    public void shouldReceiveEvent2EventsOnNodeCreation() throws Exception {
        if (!this.eventGenerator.isEnabled()) {
            this.eventGenerator.enable();
        }
        this.createNode(ContentModel.TYPE_CONTENT);
        Awaitility.await().atMost(6L, TimeUnit.SECONDS).until(() -> this.receivedEvents.size() == 1);
        EventGeneratorDisabledTest.assertTrue((AbstractContextAwareRepoEvent.EVENT_CONTAINER.getEvents().size() == 1 ? 1 : 0) != 0);
        EventGeneratorDisabledTest.assertTrue((this.receivedEvents.size() == 1 ? 1 : 0) != 0);
        RepoEvent sent = this.getRepoEvent(1);
        RepoEvent<?> received = this.receivedEvents.get(0);
        this.assertEventsEquals("Events are different!", sent, received);
    }

    private void assertEventsEquals(String message, RepoEvent<?> expected, RepoEvent<?> current) {
        EventGeneratorDisabledTest.assertEquals((String)message, expected, current);
    }

    private static String getText(Message message) {
        try {
            ActiveMQTextMessage am = (ActiveMQTextMessage)message;
            return am.getText();
        }
        catch (JMSException jMSException) {
            return null;
        }
    }
}

