/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event2.Event2MessageProducer;
import org.alfresco.repo.event2.EventGeneratorQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class EventGeneratorQueueUnitTest {
    private EventGeneratorQueue queue;
    private Event2MessageProducer bus;
    private ExecutorService enqueuePool;
    private ExecutorService dequeuePool;
    private List<RepoEvent<?>> recordedEvents;
    private Map<String, RepoEvent<?>> events;
    public static final Executor SYNC_EXECUTOR_SAME_THREAD = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    };
    public static final Executor SYNC_EXECUTOR_NEW_THREAD = new Executor(){

        @Override
        public void execute(Runnable command) {
            Thread t = new Thread(command);
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    };

    @Before
    public void setup() {
        this.queue = new EventGeneratorQueue();
        this.enqueuePool = EventGeneratorQueueUnitTest.newThreadPool();
        this.queue.setEnqueueThreadPoolExecutor((Executor)this.enqueuePool);
        this.dequeuePool = EventGeneratorQueueUnitTest.newThreadPool();
        this.queue.setDequeueThreadPoolExecutor((Executor)this.dequeuePool);
        this.bus = (Event2MessageProducer)Mockito.mock(Event2MessageProducer.class);
        this.queue.setEvent2MessageProducer(this.bus);
        this.events = new HashMap();
        this.setupEventsRecorder();
    }

    @After
    public void teardown() {
        this.enqueuePool.shutdown();
    }

    private void setupEventsRecorder() {
        this.recordedEvents = new CopyOnWriteArrayList();
        ((Event2MessageProducer)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                RepoEvent event = (RepoEvent)invocation.getArgument(0, RepoEvent.class);
                EventGeneratorQueueUnitTest.this.recordedEvents.add(event);
                return null;
            }
        }).when((Object)this.bus)).send(ArgumentMatchers.any());
    }

    @Test
    public void shouldReceiveSingleQuickMessage() throws Exception {
        this.queue.accept(this.messageWithDelay("A", 55L));
        Thread.sleep(150L);
        Assert.assertEquals((long)1L, (long)this.recordedEvents.size());
        Assert.assertEquals((Object)"A", (Object)this.recordedEvents.get(0).getId());
    }

    @Test
    public void shouldNotReceiveEventsWhenMessageIsNull() throws Exception {
        this.queue.accept(() -> null);
        Thread.sleep(150L);
        Assert.assertEquals((long)0L, (long)this.recordedEvents.size());
    }

    @Test
    public void shouldReceiveMultipleMessagesPreservingOrderScenarioOne() throws Exception {
        this.queue.accept(this.messageWithDelay("A", 0L));
        this.queue.accept(this.messageWithDelay("B", 100L));
        this.queue.accept(this.messageWithDelay("C", 200L));
        Thread.sleep(450L);
        Assert.assertEquals((long)3L, (long)this.recordedEvents.size());
        Assert.assertEquals((Object)"A", (Object)this.recordedEvents.get(0).getId());
        Assert.assertEquals((Object)"B", (Object)this.recordedEvents.get(1).getId());
        Assert.assertEquals((Object)"C", (Object)this.recordedEvents.get(2).getId());
    }

    @Test
    public void shouldReceiveMultipleMessagesPreservingOrderScenarioTwo() throws Exception {
        this.queue.accept(this.messageWithDelay("A", 300L));
        this.queue.accept(this.messageWithDelay("B", 150L));
        this.queue.accept(this.messageWithDelay("C", 0L));
        Thread.sleep(950L);
        Assert.assertEquals((long)3L, (long)this.recordedEvents.size());
        Assert.assertEquals((Object)"A", (Object)this.recordedEvents.get(0).getId());
        Assert.assertEquals((Object)"B", (Object)this.recordedEvents.get(1).getId());
        Assert.assertEquals((Object)"C", (Object)this.recordedEvents.get(2).getId());
    }

    @Test
    public void shouldReceiveMultipleMessagesPreservingOrderEvenWhenMakerPoisoned() throws Exception {
        this.queue.accept(this.messageWithDelay("A", 300L));
        this.queue.accept(() -> {
            throw new RuntimeException("Boom! (not to worry, this is a test)");
        });
        this.queue.accept(this.messageWithDelay("B", 55L));
        this.queue.accept(this.messageWithDelay("C", 0L));
        Thread.sleep(950L);
        Assert.assertEquals((long)3L, (long)this.recordedEvents.size());
        Assert.assertEquals((Object)"A", (Object)this.recordedEvents.get(0).getId());
        Assert.assertEquals((Object)"B", (Object)this.recordedEvents.get(1).getId());
        Assert.assertEquals((Object)"C", (Object)this.recordedEvents.get(2).getId());
    }

    @Test
    public void shouldReceiveMultipleMessagesPreservingOrderEvenWhenSenderPoisoned() throws Exception {
        Callable<RepoEvent<?>> makerB = this.messageWithDelay("B", 55L);
        RepoEvent<?> messageB = makerB.call();
        ((Event2MessageProducer)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Boom! (not to worry, this is a test)")}).when((Object)this.bus)).send(messageB);
        this.queue.accept(this.messageWithDelay("A", 300L));
        this.queue.accept(makerB);
        this.queue.accept(this.messageWithDelay("C", 0L));
        Thread.sleep(950L);
        Assert.assertEquals((long)2L, (long)this.recordedEvents.size());
        Assert.assertEquals((Object)"A", (Object)this.recordedEvents.get(0).getId());
        Assert.assertEquals((Object)"C", (Object)this.recordedEvents.get(1).getId());
    }

    @Test
    public void shouldReceiveMultipleMessagesPreservingOrderEvenWhenMakerPoisonedWithError() throws Exception {
        this.queue.accept(this.messageWithDelay("A", 300L));
        this.queue.accept(() -> {
            throw new OutOfMemoryError("Boom! (not to worry, this is a test)");
        });
        this.queue.accept(this.messageWithDelay("B", 55L));
        this.queue.accept(this.messageWithDelay("C", 0L));
        Thread.sleep(950L);
        Assert.assertEquals((long)3L, (long)this.recordedEvents.size());
        Assert.assertEquals((Object)"A", (Object)this.recordedEvents.get(0).getId());
        Assert.assertEquals((Object)"B", (Object)this.recordedEvents.get(1).getId());
        Assert.assertEquals((Object)"C", (Object)this.recordedEvents.get(2).getId());
    }

    @Test
    public void shouldReceiveMultipleMessagesPreservingOrderEvenWhenSenderPoisonedWithError() throws Exception {
        Callable<RepoEvent<?>> makerB = this.messageWithDelay("B", 55L);
        RepoEvent<?> messageB = makerB.call();
        ((Event2MessageProducer)Mockito.doThrow((Throwable[])new Throwable[]{new OutOfMemoryError("Boom! (not to worry, this is a test)")}).when((Object)this.bus)).send(messageB);
        this.queue.accept(this.messageWithDelay("A", 300L));
        this.queue.accept(makerB);
        this.queue.accept(this.messageWithDelay("C", 0L));
        Thread.sleep(950L);
        Assert.assertEquals((long)2L, (long)this.recordedEvents.size());
        Assert.assertEquals((Object)"A", (Object)this.recordedEvents.get(0).getId());
        Assert.assertEquals((Object)"C", (Object)this.recordedEvents.get(1).getId());
    }

    private Callable<RepoEvent<?>> messageWithDelay(final String id, final long delay) {
        Callable res = new Callable<RepoEvent<?>>(){

            @Override
            public RepoEvent<?> call() throws Exception {
                if (delay != 0L) {
                    Thread.sleep(delay);
                }
                return EventGeneratorQueueUnitTest.this.newRepoEvent(id);
            }

            public String toString() {
                return id;
            }
        };
        return res;
    }

    private RepoEvent<?> newRepoEvent(String id) {
        RepoEvent ev = this.events.get(id);
        if (ev != null) {
            return ev;
        }
        ev = (RepoEvent)Mockito.mock(RepoEvent.class);
        Mockito.when((Object)ev.getId()).thenReturn((Object)id);
        Mockito.when((Object)ev.toString()).thenReturn((Object)id);
        this.events.put(id, ev);
        return ev;
    }

    public static ExecutorService newThreadPool() {
        return new ThreadPoolExecutor(2, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }
}

