/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.crypto.SealedObject;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.encryption.MetadataEncryptor;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidAspectException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationExistsException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CyclicChildRelationshipException;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.test.annotation.Commit;
import org.springframework.test.context.transaction.TestTransaction;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class BaseNodeServiceTest
extends BaseSpringTest {
    public static final String NAMESPACE = "http://www.alfresco.org/test/BaseNodeServiceTest";
    public static final String TEST_PREFIX = "test";
    public static final String DEFAULT_VALUE = "defaultValue";
    public static final String NOT_DEFAULT_VALUE = "notDefaultValue";
    public static final QName TYPE_QNAME_TEST_CONTENT = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"content");
    public static final QName TYPE_QNAME_TEST_MANY_PROPERTIES = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"many-properties");
    public static final QName TYPE_QNAME_TEST_MAFullNodeServiceTestNY_PROPERTIES_ENCRYPTED = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"many-properties-encrypted");
    public static final QName TYPE_QNAME_TEST_MANY_ML_PROPERTIES = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"many-ml-properties");
    public static final QName TYPE_QNAME_EXTENDED_CONTENT = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"extendedcontent");
    public static final QName ASPECT_QNAME_TEST_TITLED = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"titled");
    public static final QName ASPECT_QNAME_TEST_MARKER = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"marker");
    public static final QName ASPECT_QNAME_TEST_MARKER2 = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"marker2");
    public static final QName ASPECT_QNAME_MANDATORY = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"mandatoryaspect");
    public static final QName ASPECT_QNAME_WITH_DEFAULT_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"withDefaultValue");
    public static final QName PROP_QNAME_TEST_TITLE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"title");
    public static final QName PROP_QNAME_TEST_DESCRIPTION = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"description");
    public static final QName PROP_QNAME_TEST_CONTENT = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"content");
    public static final QName PROP_QNAME_BOOLEAN_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"booleanValue");
    public static final QName PROP_QNAME_INTEGER_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"integerValue");
    public static final QName PROP_QNAME_LONG_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"longValue");
    public static final QName PROP_QNAME_FLOAT_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"floatValue");
    public static final QName PROP_QNAME_DOUBLE_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"doubleValue");
    public static final QName PROP_QNAME_STRING_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"stringValue");
    public static final QName PROP_QNAME_ML_TEXT_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"mlTextValue");
    public static final QName PROP_QNAME_DATE_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"dateValue");
    public static final QName PROP_QNAME_SERIALIZABLE_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"serializableValue");
    public static final QName PROP_QNAME_NODEREF_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"nodeRefValue");
    public static final QName PROP_QNAME_QNAME_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"qnameValue");
    public static final QName PROP_QNAME_CONTENT_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"contentValue");
    public static final QName PROP_QNAME_PATH_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"pathValue");
    public static final QName PROP_QNAME_CATEGORY_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"categoryValue");
    public static final QName PROP_QNAME_LOCALE_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"localeValue");
    public static final QName PROP_QNAME_NULL_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"nullValue");
    public static final QName PROP_QNAME_MULTI_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"multiValue");
    public static final QName PROP_QNAME_PERIOD_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"periodValue");
    public static final QName PROP_QNAME_MULTI_ML_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"multiMLValue");
    public static final QName PROP_QNAME_MARKER_PROP = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"markerProp");
    public static final QName PROP_QNAME_PROP1 = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"prop1");
    public static final QName PROP_QNAME_PROP2 = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"prop2");
    public static final QName ASSOC_TYPE_QNAME_TEST_CHILDREN = ContentModel.ASSOC_CHILDREN;
    public static final QName ASSOC_TYPE_QNAME_TEST_CONTAINS = ContentModel.ASSOC_CONTAINS;
    public static final QName ASSOC_TYPE_QNAME_TEST_NEXT = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"next");
    public static final QName ASPECT_RESIDUAL = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"residual");
    public static final QName PROP_QNAME_RESIDUAL_STRING = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"residualString");
    public static final QName PROP_QNAME_RESIDUAL_LONG = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"residualLong");
    public static final QName ASPECT_WITH_ASSOCIATIONS = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"withAssociations");
    public static final QName ASSOC_ASPECT_CHILD_ASSOC = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"aspect-child-assoc");
    public static final QName ASSOC_ASPECT_NORMAL_ASSOC = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"aspect-normal-assoc");
    public static final QName ASPECT_WITH_ASSOCIATIONS_EXTRA = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"withAssociationsExtra");
    public static final QName ASSOC_ASPECT_CHILD_ASSOC_01 = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"aspect-child-assoc-01");
    public static final QName ASSOC_ASPECT_CHILD_ASSOC_02 = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"aspect-child-assoc-02");
    public static final QName ASSOC_ASPECT_NORMAL_ASSOC_01 = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"aspect-normal-assoc-01");
    public static final QName ASSOC_ASPECT_NORMAL_ASSOC_02 = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"aspect-normal-assoc-02");
    public static final QName TYPE_QNAME_TEST_MULTIPLE_TESTER = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"multiple-tester");
    public static final QName PROP_QNAME_STRING_PROP_SINGLE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"stringprop-single");
    public static final QName PROP_QNAME_STRING_PROP_MULTIPLE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"stringprop-multiple");
    public static final QName PROP_QNAME_ANY_PROP_SINGLE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"anyprop-single");
    public static final QName PROP_QNAME_ANY_PROP_MULTIPLE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"anyprop-multiple");
    public static final QName ASPECT_WITH_ENCRYPTED = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"withEncrypted");
    public static final QName PROP_QNAME_ENCRYPTED_VALUE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"encryptedValue");
    protected PolicyComponent policyComponent;
    protected DictionaryService dictionaryService;
    protected TransactionService transactionService;
    protected RetryingTransactionHelper retryingTransactionHelper;
    protected AuthenticationComponent authenticationComponent;
    protected NodeService nodeService;
    protected ContentService contentService;
    protected MetadataEncryptor metadataEncryptor;
    protected NodeRef rootNodeRef;
    private NodeRef cat;
    private static final QName ASPECT_QNAME_TEST_RENDERED = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"rendered");
    private static final QName ASSOC_TYPE_QNAME_TEST_RENDITION = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"rendition-page");
    private static final QName TYPE_QNAME_TEST_RENDITION_PAGE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"rendition-page");
    private static final QName PROP_QNAME_TEST_RENDITION_PAGE_CONTENT = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"rendition-page-content");
    private static final int MAX_RENDITION_PAGES = 100;
    static boolean behaviourExecuted = false;

    @Before
    public void before() {
        this.metadataEncryptor = (MetadataEncryptor)this.applicationContext.getBean("metadataEncryptor");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.retryingTransactionHelper = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        this.policyComponent = (PolicyComponent)this.applicationContext.getBean("policyComponent");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        DictionaryDAO dictionaryDao = (DictionaryDAO)this.applicationContext.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("alfresco/model/contentModel.xml");
        BaseNodeServiceTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        modelStream = cl.getResourceAsStream("org/alfresco/repo/node/BaseNodeServiceTest_model.xml");
        BaseNodeServiceTest.assertNotNull((Object)modelStream);
        model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        DictionaryComponent dictionary = new DictionaryComponent();
        dictionary.setDictionaryDAO(dictionaryDao);
        this.dictionaryService = BaseNodeServiceTest.loadModel(this.applicationContext);
        this.nodeService = this.getNodeService();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        StoreRef catStoreRef = this.nodeService.createStore("workspace", "Test_cat_" + System.currentTimeMillis());
        NodeRef catRootNodeRef = this.nodeService.getRootNode(catStoreRef);
        this.cat = this.nodeService.createNode(catRootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        IntegrityChecker.setWarnInTransaction();
    }

    @After
    public void after() {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable throwable) {}
    }

    public static DictionaryService loadModel(ApplicationContext applicationContext) {
        DictionaryDAO dictionaryDao = (DictionaryDAO)applicationContext.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("alfresco/model/contentModel.xml");
        BaseNodeServiceTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        modelStream = cl.getResourceAsStream("org/alfresco/repo/node/BaseNodeServiceTest_model.xml");
        BaseNodeServiceTest.assertNotNull((Object)modelStream);
        model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        DictionaryComponent dictionary = new DictionaryComponent();
        dictionary.setDictionaryDAO(dictionaryDao);
        return dictionary;
    }

    protected abstract NodeService getNodeService();

    @Test
    public void testSetUp() throws Exception {
        BaseNodeServiceTest.assertNotNull((String)"StoreService not set", (Object)this.nodeService);
        BaseNodeServiceTest.assertNotNull((String)"NodeService not set", (Object)this.nodeService);
        BaseNodeServiceTest.assertNotNull((String)"rootNodeRef not created", (Object)this.rootNodeRef);
    }

    public Map<QName, ChildAssociationRef> buildNodeGraph() throws Exception {
        return BaseNodeServiceTest.buildNodeGraph(this.nodeService, this.rootNodeRef);
    }

    public static Map<QName, ChildAssociationRef> buildNodeGraph(NodeService nodeService, NodeRef rootNodeRef) throws Exception {
        String ns = NAMESPACE;
        QName qname = null;
        ChildAssociationRef assoc = null;
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        HashMap<QName, ChildAssociationRef> ret = new HashMap<QName, ChildAssociationRef>(13);
        qname = QName.createQName((String)ns, (String)"root_p_n1");
        assoc = nodeService.createNode(rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, ContentModel.TYPE_CONTAINER);
        ret.put(qname, assoc);
        NodeRef n1 = assoc.getChildRef();
        qname = QName.createQName((String)ns, (String)"root_p_n2");
        assoc = nodeService.createNode(rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, ContentModel.TYPE_CONTAINER);
        ret.put(qname, assoc);
        NodeRef n2 = assoc.getChildRef();
        properties.clear();
        properties.put(QName.createQName((String)ns, (String)"animal"), "monkey");
        properties.put(QName.createQName((String)ns, (String)"UPPERANIMAL"), "MONKEY");
        properties.put(QName.createQName((String)ns, (String)"reference"), n2.toString());
        properties.put(QName.createQName((String)ns, (String)"text1"), "bun");
        properties.put(QName.createQName((String)ns, (String)"text2"), "cake");
        properties.put(QName.createQName((String)ns, (String)"text3"), "biscuit");
        properties.put(QName.createQName((String)ns, (String)"text12"), "bun, cake");
        properties.put(QName.createQName((String)ns, (String)"text13"), "bun, biscuit");
        properties.put(QName.createQName((String)ns, (String)"text23"), "cake, biscuit");
        properties.put(QName.createQName((String)ns, (String)"text123"), "bun, cake, biscuit");
        ArrayList<String> slist = new ArrayList<String>();
        slist.add("first");
        slist.add("second");
        slist.add("third");
        properties.put(QName.createQName((String)ns, (String)"mvp"), slist);
        ArrayList<Integer> ilist = new ArrayList<Integer>();
        ilist.add(new Integer(1));
        ilist.add(new Integer(2));
        ilist.add(new Integer(3));
        properties.put(QName.createQName((String)ns, (String)"mvi"), ilist);
        qname = QName.createQName((String)ns, (String)"n1_p_n3");
        assoc = nodeService.createNode(n1, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, ContentModel.TYPE_CONTAINER, properties);
        ret.put(qname, assoc);
        NodeRef n3 = assoc.getChildRef();
        qname = QName.createQName((String)ns, (String)"n2_p_n4");
        assoc = nodeService.createNode(n2, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, ContentModel.TYPE_CONTAINER);
        ret.put(qname, assoc);
        NodeRef n4 = assoc.getChildRef();
        qname = QName.createQName((String)ns, (String)"n1_n4");
        assoc = nodeService.addChild(n1, n4, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname);
        ret.put(qname, assoc);
        qname = QName.createQName((String)ns, (String)"n2_p_n5");
        assoc = nodeService.createNode(n2, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, ContentModel.TYPE_CONTAINER);
        ret.put(qname, assoc);
        NodeRef n5 = assoc.getChildRef();
        qname = QName.createQName((String)ns, (String)"n3_p_n6");
        assoc = nodeService.createNode(n3, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, ContentModel.TYPE_CONTAINER);
        ret.put(qname, assoc);
        NodeRef n6 = assoc.getChildRef();
        nodeService.addAspect(n6, ContentModel.ASPECT_ROOT, Collections.emptyMap());
        qname = QName.createQName((String)ns, (String)"n4_n6");
        assoc = nodeService.addChild(n4, n6, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname);
        ret.put(qname, assoc);
        qname = QName.createQName((String)ns, (String)"n5_p_n7");
        assoc = nodeService.createNode(n5, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, ContentModel.TYPE_CONTAINER);
        ret.put(qname, assoc);
        NodeRef n7 = assoc.getChildRef();
        properties.clear();
        properties.put(PROP_QNAME_TEST_TITLE, "node8");
        qname = QName.createQName((String)ns, (String)"n6_p_n8");
        assoc = nodeService.createNode(n6, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, TYPE_QNAME_TEST_CONTENT, properties);
        ret.put(qname, assoc);
        NodeRef n8 = assoc.getChildRef();
        qname = QName.createQName((String)ns, (String)"n7_n8");
        assoc = nodeService.addChild(n7, n8, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname);
        ret.put(qname, assoc);
        qname = QName.createQName((String)ns, (String)"n1_n8");
        assoc = nodeService.addChild(n1, n8, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname);
        ret.put(qname, assoc);
        return ret;
    }

    private StoreRef createStore() throws Exception {
        StoreRef storeRef = this.nodeService.createStore("workspace", String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + System.nanoTime());
        BaseNodeServiceTest.assertNotNull((String)"No reference returned", (Object)storeRef);
        return storeRef;
    }

    @Test
    public void testCreateStore() throws Exception {
        StoreRef storeRef = this.createStore();
        BaseNodeServiceTest.assertTrue((String)"NodeService reports that store doesn't exist", (boolean)this.nodeService.exists(storeRef));
        NodeRef storeRootNode = this.nodeService.getRootNode(storeRef);
        boolean isRoot = this.nodeService.hasAspect(storeRootNode, ContentModel.ASPECT_ROOT);
        BaseNodeServiceTest.assertTrue((String)"Root node of store does not have root aspect", (boolean)isRoot);
        QName rootType = this.nodeService.getType(storeRootNode);
        BaseNodeServiceTest.assertEquals((String)"Store root node of incorrect type", (Object)ContentModel.TYPE_STOREROOT, (Object)rootType);
    }

    @Test
    public void testGetStores() throws Exception {
        StoreRef storeRef = this.createStore();
        List storeRefs = this.nodeService.getStores();
        BaseNodeServiceTest.assertTrue((String)"New store not present is list of stores", (boolean)storeRefs.contains(storeRef));
    }

    @Commit
    @Test
    public void testDeleteStore() throws Exception {
        StoreRef storeRef = this.createStore();
        NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
        NodeRef nodeRef = this.nodeService.createNode(rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), ContentModel.TYPE_CONTAINER).getChildRef();
        ArrayList<NodeRef> beforeDeleteNodeRefs = new ArrayList<NodeRef>();
        ArrayList<NodeRef> onDeleteNodeRefs = new ArrayList<NodeRef>();
        BadOnDeleteNodePolicy policy = new BadOnDeleteNodePolicy(this.nodeService, beforeDeleteNodeRefs, onDeleteNodeRefs);
        policy.setOnDeleteCreateChild(false);
        policy.setBeforeDeleteCreateChild(false);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnDeleteNodePolicy.QNAME, (Object)policy, (Behaviour)new JavaBehaviour((Object)policy, "onDeleteNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, (Object)policy, (Behaviour)new JavaBehaviour((Object)policy, "beforeDeleteNode"));
        List storeRefs = this.nodeService.getStores();
        BaseNodeServiceTest.assertTrue((String)"New store not present in list of stores", (boolean)storeRefs.contains(storeRef));
        BaseNodeServiceTest.assertTrue((String)"Store should still exist", (boolean)this.nodeService.exists(storeRef));
        BaseNodeServiceTest.assertTrue((String)"Node should still exist", (boolean)this.nodeService.exists(rootNodeRef));
        this.nodeService.deleteStore(storeRef);
        storeRefs = this.nodeService.getStores();
        BaseNodeServiceTest.assertFalse((String)"Deleted store should not present in list of stores", (boolean)storeRefs.contains(storeRef));
        for (StoreRef retrievedStoreRef : storeRefs) {
            if (!retrievedStoreRef.getProtocol().equals("deleted")) continue;
            BaseNodeServiceTest.fail((String)("NodeService should not have returned 'deleted' stores." + storeRefs));
        }
        BaseNodeServiceTest.assertFalse((String)"Store should still exist", (boolean)this.nodeService.exists(storeRef));
        BaseNodeServiceTest.assertFalse((String)"Node should still exist", (boolean)this.nodeService.exists(rootNodeRef));
        BaseNodeServiceTest.assertEquals((String)"Incorrect number of node beforeDelete notifications", (int)1, (int)beforeDeleteNodeRefs.size());
        BaseNodeServiceTest.assertEquals((String)"Incorrect node for beforeDelete callback", (Object)nodeRef, beforeDeleteNodeRefs.get(0));
        BaseNodeServiceTest.assertEquals((String)"Incorrect number of node onDelete notifications", (int)1, (int)onDeleteNodeRefs.size());
        BaseNodeServiceTest.assertEquals((String)"Incorrect node for onDelete callback", (Object)nodeRef, onDeleteNodeRefs.get(0));
    }

    @Test
    public void testExists() throws Exception {
        StoreRef storeRef = this.createStore();
        boolean exists = this.nodeService.exists(storeRef);
        BaseNodeServiceTest.assertEquals((String)"Exists failed", (boolean)true, (boolean)exists);
        StoreRef bogusRef = new StoreRef("What", "the");
        exists = this.nodeService.exists(bogusRef);
        BaseNodeServiceTest.assertEquals((String)"Exists failed", (boolean)false, (boolean)exists);
    }

    @Test
    public void testGetRootNode() throws Exception {
        StoreRef storeRef = this.createStore();
        NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
        BaseNodeServiceTest.assertNotNull((String)"No root node reference returned", (Object)rootNodeRef);
        NodeRef rootNodeRefCheck = this.nodeService.getRootNode(storeRef);
        BaseNodeServiceTest.assertEquals((String)"Root nodes returned different refs", (Object)rootNodeRef, (Object)rootNodeRefCheck);
    }

    @Test
    public void testCreateNode() throws Exception {
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), ContentModel.TYPE_CONTAINER);
        BaseNodeServiceTest.assertEquals((String)"Assoc type qname not set", (Object)ASSOC_TYPE_QNAME_TEST_CHILDREN, (Object)assocRef.getTypeQName());
        BaseNodeServiceTest.assertEquals((String)"Assoc qname not set", (Object)QName.createQName((String)"pathA"), (Object)assocRef.getQName());
        NodeRef childRef = assocRef.getChildRef();
        QName checkType = this.nodeService.getType(childRef);
        BaseNodeServiceTest.assertEquals((String)"Child node type incorrect", (Object)ContentModel.TYPE_CONTAINER, (Object)checkType);
    }

    @Test
    public void testCreateWithTooLongPathLocalname() throws Exception {
        try {
            this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"Recognize that VSEPR theory states that nonbonded electrons (lone pairs) exert strong electrostatic repulsive forces against the bonded pairs of electrons and, as a result, the electron pairs arrange themselves as far apart as possible in order to minimize the repulsive forces"), ContentModel.TYPE_CONTAINER);
            BaseNodeServiceTest.fail((String)"Expected too-long QName localname to have been kicked out as illegal argument.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testCreateNodeWithId() throws Exception {
        String uuid = GUID.generate();
        HashMap<QName, String> properties = new HashMap<QName, String>(5);
        properties.put(ContentModel.PROP_NODE_UUID, uuid);
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), ContentModel.TYPE_CONTAINER, properties);
        NodeRef expectedNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), uuid);
        NodeRef checkNodeRef = assocRef.getChildRef();
        BaseNodeServiceTest.assertEquals((String)"Failed to create node with a chosen ID", (Object)expectedNodeRef, (Object)checkNodeRef);
    }

    @Test
    public void testGetType() throws Exception {
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), ContentModel.TYPE_CONTAINER);
        NodeRef nodeRef = assocRef.getChildRef();
        QName type = this.nodeService.getType(nodeRef);
        BaseNodeServiceTest.assertEquals((String)"Type mismatch", (Object)ContentModel.TYPE_CONTAINER, (Object)type);
    }

    @Test
    public void testSetType() throws Exception {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"setTypeTest"), TYPE_QNAME_TEST_CONTENT).getChildRef();
        BaseNodeServiceTest.assertEquals((Object)TYPE_QNAME_TEST_CONTENT, (Object)this.nodeService.getType(nodeRef));
        BaseNodeServiceTest.assertNull((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_PROP1));
        this.nodeService.setType(nodeRef, TYPE_QNAME_EXTENDED_CONTENT);
        BaseNodeServiceTest.assertEquals((Object)TYPE_QNAME_EXTENDED_CONTENT, (Object)this.nodeService.getType(nodeRef));
        Serializable defaultValue = this.nodeService.getProperty(nodeRef, PROP_QNAME_PROP1);
        BaseNodeServiceTest.assertNotNull((String)"No default property value assigned", (Object)defaultValue);
        BaseNodeServiceTest.assertEquals((Object)DEFAULT_VALUE, (Object)defaultValue);
    }

    protected void fillProperties(QName qname, Map<QName, Serializable> properties) {
        ClassDefinition classDef = this.dictionaryService.getClass(qname);
        if (classDef == null) {
            throw new RuntimeException("No such class: " + qname);
        }
        Map propertyDefs = classDef.getProperties();
        for (Map.Entry entry : propertyDefs.entrySet()) {
            QName propertyQName = (QName)entry.getKey();
            QName propertyTypeQName = ((PropertyDefinition)entry.getValue()).getDataType().getName();
            Object value = null;
            if (propertyTypeQName.equals((Object)DataTypeDefinition.CONTENT)) continue;
            value = propertyTypeQName.equals((Object)DataTypeDefinition.LOCALE) ? Locale.CHINESE : (propertyTypeQName.equals((Object)DataTypeDefinition.BOOLEAN) ? Boolean.TRUE : (propertyTypeQName.equals((Object)DataTypeDefinition.PATH) ? new Path() : (propertyTypeQName.equals((Object)DataTypeDefinition.QNAME) ? TYPE_QNAME_EXTENDED_CONTENT : (propertyTypeQName.equals((Object)DataTypeDefinition.CATEGORY) || propertyTypeQName.equals((Object)DataTypeDefinition.NODE_REF) ? new NodeRef("workspace://SpacesStore/12345") : new Long(System.currentTimeMillis())))));
            properties.put(propertyQName, (Serializable)value);
        }
    }

    @Test
    public void testAspects() throws Exception {
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)NAMESPACE, (String)"test-container"), ContentModel.TYPE_CONTAINER);
        NodeRef nodeRef = assocRef.getChildRef();
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(20);
        this.nodeService.addAspect(nodeRef, ASPECT_QNAME_TEST_TITLED, properties);
        this.fillProperties(ASPECT_QNAME_TEST_TITLED, properties);
        Map propertiesBefore = this.nodeService.getProperties(nodeRef);
        this.nodeService.addAspect(nodeRef, ASPECT_QNAME_TEST_TITLED, properties);
        Map propertiesAfter = this.nodeService.getProperties(nodeRef);
        BaseNodeServiceTest.assertEquals((String)"Aspect properties not added", (int)(propertiesBefore.size() + 2), (int)propertiesAfter.size());
        Set aspects = this.nodeService.getAspects(nodeRef);
        BaseNodeServiceTest.assertTrue((String)"Titled aspect not present", (boolean)aspects.contains(ASPECT_QNAME_TEST_TITLED));
        boolean hasAspect = this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_TITLED);
        BaseNodeServiceTest.assertTrue((String)"Aspect not confirmed to be on node", (boolean)hasAspect);
        this.nodeService.removeAspect(nodeRef, ASPECT_QNAME_TEST_TITLED);
        hasAspect = this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_TITLED);
        BaseNodeServiceTest.assertFalse((String)"Aspect not removed from node", (boolean)hasAspect);
        propertiesAfter = this.nodeService.getProperties(nodeRef);
        BaseNodeServiceTest.assertEquals((String)"Aspect properties not removed", (int)propertiesBefore.size(), (int)propertiesAfter.size());
    }

    @Test
    public void testAspectsAddedAutomatically() throws Exception {
        Map<Object, Serializable> properties = new HashMap<QName, Serializable>(20);
        this.fillProperties(ASPECT_QNAME_TEST_TITLED, properties);
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)NAMESPACE, (String)"test-container"), ContentModel.TYPE_CONTAINER, properties).getChildRef();
        BaseNodeServiceTest.assertTrue((String)"Aspect not automatically added during 'createNode'", (boolean)this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_TITLED));
        this.nodeService.removeAspect(nodeRef, ASPECT_QNAME_TEST_TITLED);
        properties = this.nodeService.getProperties(nodeRef);
        BaseNodeServiceTest.assertFalse((String)"test:titled properties not removed", (boolean)properties.containsKey(PROP_QNAME_TEST_TITLE));
        BaseNodeServiceTest.assertFalse((String)"test:titled properties not removed", (boolean)properties.containsKey(PROP_QNAME_TEST_DESCRIPTION));
        properties.put(PROP_QNAME_TEST_DESCRIPTION, (Serializable)((Object)"A description"));
        this.nodeService.setProperties(nodeRef, properties);
        BaseNodeServiceTest.assertTrue((String)"Aspect not automatically added during 'setProperties'", (boolean)this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_TITLED));
        this.nodeService.removeAspect(nodeRef, ASPECT_QNAME_TEST_TITLED);
        properties = new HashMap(5);
        properties.put(PROP_QNAME_TEST_DESCRIPTION, (Serializable)((Object)"A description"));
        this.nodeService.addProperties(nodeRef, properties);
        BaseNodeServiceTest.assertTrue((String)"Aspect not automatically added during 'addProperties'", (boolean)this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_TITLED));
        this.nodeService.removeAspect(nodeRef, ASPECT_QNAME_TEST_TITLED);
        this.nodeService.setProperty(nodeRef, PROP_QNAME_TEST_DESCRIPTION, (Serializable)((Object)"A description"));
        BaseNodeServiceTest.assertTrue((String)"Aspect not automatically added during 'setProperty'", (boolean)this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_TITLED));
        this.nodeService.setProperty(nodeRef, PROP_QNAME_MARKER_PROP, (Serializable)((Object)"Marker value"));
        BaseNodeServiceTest.assertTrue((String)"Aspect not automatically added during 'setProperty'", (boolean)this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_MARKER));
        BaseNodeServiceTest.assertTrue((String)"Aspect not automatically added during 'setProperty' (second-level)", (boolean)this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_MARKER2));
        NodeRef childNodeRef = this.nodeService.createNode(nodeRef, ASSOC_ASPECT_CHILD_ASSOC, ASSOC_ASPECT_CHILD_ASSOC, ContentModel.TYPE_CMOBJECT).getChildRef();
        BaseNodeServiceTest.assertTrue((String)"Aspect not automatically added by child association during 'createNode'", (boolean)this.nodeService.hasAspect(nodeRef, ASPECT_WITH_ASSOCIATIONS));
        BaseNodeServiceTest.assertFalse((String)"Unexpected 'aspect' added by child association during 'createNode'", (boolean)this.nodeService.hasAspect(nodeRef, ASSOC_ASPECT_CHILD_ASSOC));
        this.nodeService.removeAspect(nodeRef, ASPECT_WITH_ASSOCIATIONS);
        BaseNodeServiceTest.assertFalse((String)"Child node should have been deleted", (boolean)this.nodeService.exists(childNodeRef));
        this.nodeService.createAssociation(nodeRef, this.rootNodeRef, ASSOC_ASPECT_NORMAL_ASSOC);
        BaseNodeServiceTest.assertTrue((String)"Aspect not automatically added by peer association during 'createAssociation'", (boolean)this.nodeService.hasAspect(nodeRef, ASPECT_WITH_ASSOCIATIONS));
        BaseNodeServiceTest.assertFalse((String)"Unexpected aspect added by peer association during 'createAssociation'", (boolean)this.nodeService.hasAspect(nodeRef, ASSOC_ASPECT_NORMAL_ASSOC));
    }

    @Test
    public void testAspectRemoval() throws Exception {
        NodeRef sourceNodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)NAMESPACE, (String)"testAspectRemoval-source"), ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef targetNodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)NAMESPACE, (String)"testAspectRemoval-target"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.addAspect(sourceNodeRef, ASPECT_WITH_ASSOCIATIONS, null);
        this.nodeService.addChild(sourceNodeRef, targetNodeRef, ASSOC_ASPECT_CHILD_ASSOC, QName.createQName((String)NAMESPACE, (String)"aspect-child"));
        this.nodeService.createAssociation(sourceNodeRef, targetNodeRef, ASSOC_ASPECT_NORMAL_ASSOC);
        BaseNodeServiceTest.assertEquals((String)"Expected exactly one child", (int)1, (int)this.nodeService.getChildAssocs(sourceNodeRef).size());
        BaseNodeServiceTest.assertEquals((String)"Expected exactly one target", (int)1, (int)this.nodeService.getTargetAssocs(sourceNodeRef, RegexQNamePattern.MATCH_ALL).size());
        this.nodeService.removeAspect(sourceNodeRef, ASPECT_WITH_ASSOCIATIONS);
        BaseNodeServiceTest.assertEquals((String)"Expected exactly zero child", (int)0, (int)this.nodeService.getChildAssocs(sourceNodeRef).size());
        BaseNodeServiceTest.assertEquals((String)"Expected exactly zero target", (int)0, (int)this.nodeService.getTargetAssocs(sourceNodeRef, RegexQNamePattern.MATCH_ALL).size());
        this.nodeService.addAspect(sourceNodeRef, ASPECT_WITH_ASSOCIATIONS_EXTRA, null);
        this.nodeService.addChild(sourceNodeRef, targetNodeRef, ASSOC_ASPECT_CHILD_ASSOC_01, QName.createQName((String)NAMESPACE, (String)"aspect-child-01"));
        this.nodeService.addChild(sourceNodeRef, targetNodeRef, ASSOC_ASPECT_CHILD_ASSOC_02, QName.createQName((String)NAMESPACE, (String)"aspect-child-02"));
        this.nodeService.createAssociation(sourceNodeRef, targetNodeRef, ASSOC_ASPECT_NORMAL_ASSOC_01);
        this.nodeService.createAssociation(sourceNodeRef, targetNodeRef, ASSOC_ASPECT_NORMAL_ASSOC_02);
        this.nodeService.removeAspect(sourceNodeRef, ASPECT_WITH_ASSOCIATIONS_EXTRA);
    }

    @Commit
    @Test
    public void testAspectRemovalCascadeDelete() throws Exception {
        NodeRef sourceNodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)NAMESPACE, (String)"testAspectRemovalCascadeDelete"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.addAspect(sourceNodeRef, ASPECT_WITH_ASSOCIATIONS, null);
        NodeRef targetNodeRef = this.nodeService.createNode(sourceNodeRef, ASSOC_ASPECT_CHILD_ASSOC, QName.createQName((String)NAMESPACE, (String)"testAspectRemovalCascadeDelete"), ContentModel.TYPE_CONTAINER).getChildRef();
        BaseNodeServiceTest.assertTrue((String)"Child node must exist", (boolean)this.nodeService.exists(targetNodeRef));
        this.nodeService.removeAspect(sourceNodeRef, ASPECT_WITH_ASSOCIATIONS);
        BaseNodeServiceTest.assertFalse((String)"Child node must have been cascade-deleted", (boolean)this.nodeService.exists(targetNodeRef));
    }

    @Test
    public void testAspectWithChildAssociationsCreationAndRetrieval() throws Exception {
        NodeRef folderNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)NAMESPACE, (String)("UserX-" + GUID.generate())), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef fileNodeRef = this.nodeService.createNode(folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)NAMESPACE, (String)"Uploaded.pdf"), ContentModel.TYPE_FOLDER).getChildRef();
        ArrayList<ContentData> renditionContentPages = new ArrayList<ContentData>(20);
        int i = 0;
        while (i < 100) {
            ContentData contentData = new ContentData(null, "application/pdf", 10245L, "UTF-8");
            renditionContentPages.add(contentData);
            ++i;
        }
        this.nodeService.addAspect(fileNodeRef, ASPECT_QNAME_TEST_RENDERED, null);
        int pageNumber = 0;
        int i2 = 0;
        while (i2 < 100) {
            QName renditionQName = BaseNodeServiceTest.makePageAssocName(++pageNumber);
            NodeRef nodeRef = this.nodeService.createNode(fileNodeRef, ASSOC_TYPE_QNAME_TEST_RENDITION, renditionQName, TYPE_QNAME_TEST_RENDITION_PAGE).getChildRef();
            ContentWriter writer = this.contentService.getWriter(nodeRef, PROP_QNAME_TEST_RENDITION_PAGE_CONTENT, true);
            writer.setMimetype("application/pdf");
            writer.setEncoding("UTF-8");
            writer.putContent("Some content");
            ++i2;
        }
        if (!this.nodeService.hasAspect(fileNodeRef, ASPECT_QNAME_TEST_RENDERED)) {
            return;
        }
        List fetchedRenditionChildAssocs = this.nodeService.getChildAssocs(fileNodeRef, (QNamePattern)ASSOC_TYPE_QNAME_TEST_RENDITION, RegexQNamePattern.MATCH_ALL);
        BaseNodeServiceTest.assertEquals((String)"We didn't get the correct number of pages back", (int)renditionContentPages.size(), (int)fetchedRenditionChildAssocs.size());
        ChildAssociationRef fetchedRenditionChildAssoc5 = (ChildAssociationRef)fetchedRenditionChildAssocs.get(4);
        QName page5QName = BaseNodeServiceTest.makePageAssocName(5);
        BaseNodeServiceTest.assertEquals((String)"Local name of page 5 assoc is not correct", (Object)page5QName, (Object)fetchedRenditionChildAssoc5.getQName());
        List fetchedRenditionChildAssocsPage5 = this.nodeService.getChildAssocs(fileNodeRef, (QNamePattern)ASSOC_TYPE_QNAME_TEST_RENDITION, (QNamePattern)page5QName);
        BaseNodeServiceTest.assertEquals((String)"Expected exactly one result", (int)1, (int)fetchedRenditionChildAssocsPage5.size());
        BaseNodeServiceTest.assertEquals((String)"Targeted page retrieval was not correct", (Object)page5QName, (Object)((ChildAssociationRef)fetchedRenditionChildAssocsPage5.get(0)).getQName());
    }

    private static QName makePageAssocName(int pageNumber) {
        if (pageNumber > 100) {
            throw new IllegalArgumentException("Rendition page number may not exceed 100");
        }
        String pageLocalName = String.format("renditionpage%05d", pageNumber);
        QName renditionQName = QName.createQName((String)NAMESPACE, (String)pageLocalName);
        return renditionQName;
    }

    @Test
    public void testCreateNodeNoProperties() throws Exception {
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"path1"), ContentModel.TYPE_CONTAINER);
        NodeRef nodeRef = assocRef.getChildRef();
        BaseNodeServiceTest.assertTrue((boolean)this.nodeService.exists(nodeRef));
    }

    @Test
    public void testLargeStrings() throws Exception {
        StringBuilder sb = new StringBuilder(2056);
        int i = 0;
        while (i < 1024) {
            sb.append("\u1234");
            ++i;
        }
        String longString = sb.toString();
        longString.length();
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(5);
        this.fillProperties(ASPECT_QNAME_TEST_TITLED, properties);
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"MyContent"), TYPE_QNAME_TEST_CONTENT, properties).getChildRef();
        ContentWriter writer = this.contentService.getWriter(nodeRef, TYPE_QNAME_TEST_CONTENT, true);
        writer.putContent("Some content");
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)longString));
    }

    @Test
    public void testCreateNodeWithProperties() throws Exception {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(5);
        this.fillProperties(ASPECT_QNAME_TEST_TITLED, properties);
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"MyContent"), TYPE_QNAME_TEST_CONTENT, properties);
        NodeRef nodeRef = assocRef.getChildRef();
        BaseNodeServiceTest.assertTrue((String)"Titled aspect not present", (boolean)this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_TITLED));
    }

    @Test
    public void testCascadeDelete() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = BaseNodeServiceTest.buildNodeGraph(this.nodeService, this.rootNodeRef);
        NodeRef n3Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n1_p_n3")).getChildRef();
        NodeRef n4Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n2_p_n4")).getChildRef();
        NodeRef n6Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n3_p_n6")).getChildRef();
        NodeRef n7Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n5_p_n7")).getChildRef();
        NodeRef n8Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n6_p_n8")).getChildRef();
        BaseNodeServiceTest.assertTrue((String)"n6 not present", (boolean)this.nodeService.exists(n6Ref));
        BaseNodeServiceTest.assertTrue((String)"n8 not present", (boolean)this.nodeService.exists(n8Ref));
        BaseNodeServiceTest.assertTrue((String)"n8 exists failure", (boolean)this.nodeService.exists(n8Ref));
        BaseNodeServiceTest.assertEquals((String)"n6 primary parent association not present on n3", (int)1, (int)this.countChildrenOfNode(n3Ref));
        BaseNodeServiceTest.assertEquals((String)"n6 secondary parent association not present on n4", (int)1, (int)this.countChildrenOfNode(n4Ref));
        BaseNodeServiceTest.assertEquals((String)"n8 secondary parent association not present on n7", (int)1, (int)this.countChildrenOfNode(n7Ref));
        this.nodeService.deleteNode(n6Ref);
        BaseNodeServiceTest.assertFalse((String)"n8 not cascade deleted in-transaction", (boolean)this.nodeService.exists(n8Ref));
        TestTransaction.flagForCommit();
        TestTransaction.end();
        TestTransaction.start();
        BaseNodeServiceTest.assertFalse((String)"n6 not directly deleted", (boolean)this.nodeService.exists(n6Ref));
        BaseNodeServiceTest.assertFalse((String)"n8 not cascade deleted", (boolean)this.nodeService.exists(n8Ref));
        BaseNodeServiceTest.assertEquals((String)"n6 primary parent association not removed from n3", (int)0, (int)this.countChildrenOfNode(n3Ref));
        BaseNodeServiceTest.assertEquals((String)"n6 secondary parent association not removed from n4", (int)0, (int)this.countChildrenOfNode(n4Ref));
        BaseNodeServiceTest.assertEquals((String)"n8 secondary parent association not removed from n7", (int)0, (int)this.countChildrenOfNode(n7Ref));
    }

    @Commit
    @Test
    public void testDelete() throws Exception {
        ArrayList<NodeRef> beforeDeleteNodeRefs = new ArrayList<NodeRef>(5);
        ArrayList<NodeRef> deletedNodeRefs = new ArrayList<NodeRef>(5);
        BadOnDeleteNodePolicy nasty = new BadOnDeleteNodePolicy(this.nodeService, beforeDeleteNodeRefs, deletedNodeRefs);
        nasty.setOnDeleteCreateChild(false);
        nasty.setBeforeDeleteCreateChild(false);
        BadOnDeleteNodePolicy policy = nasty;
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnDeleteNodePolicy.QNAME, (Object)policy, (Behaviour)new JavaBehaviour((Object)policy, "onDeleteNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, (Object)policy, (Behaviour)new JavaBehaviour((Object)policy, "beforeDeleteNode"));
        Map<QName, ChildAssociationRef> assocRefs = BaseNodeServiceTest.buildNodeGraph(this.nodeService, this.rootNodeRef);
        NodeRef n1Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"root_p_n1")).getChildRef();
        NodeRef n3Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n1_p_n3")).getChildRef();
        NodeRef n4Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n2_p_n4")).getChildRef();
        NodeRef n6Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n3_p_n6")).getChildRef();
        NodeRef n8Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n6_p_n8")).getChildRef();
        this.nodeService.deleteNode(n1Ref);
        BaseNodeServiceTest.assertFalse((String)"Node not directly deleted", (boolean)this.nodeService.exists(n1Ref));
        BaseNodeServiceTest.assertFalse((String)"Node not cascade deleted", (boolean)this.nodeService.exists(n3Ref));
        BaseNodeServiceTest.assertTrue((String)"Node incorrectly cascade deleted", (boolean)this.nodeService.exists(n4Ref));
        BaseNodeServiceTest.assertFalse((String)"Node not cascade deleted", (boolean)this.nodeService.exists(n6Ref));
        BaseNodeServiceTest.assertFalse((String)"Node not cascade deleted", (boolean)this.nodeService.exists(n8Ref));
        BaseNodeServiceTest.assertTrue((String)"n1Ref before delete policy not called", (boolean)beforeDeleteNodeRefs.contains(n1Ref));
        BaseNodeServiceTest.assertTrue((String)"n3Ref before delete policy not called", (boolean)beforeDeleteNodeRefs.contains(n3Ref));
        BaseNodeServiceTest.assertTrue((String)"n6Ref before delete policy not called", (boolean)beforeDeleteNodeRefs.contains(n6Ref));
        BaseNodeServiceTest.assertTrue((String)"n8Ref before delete policy not called", (boolean)beforeDeleteNodeRefs.contains(n8Ref));
        BaseNodeServiceTest.assertTrue((String)"n1Ref delete policy not called", (boolean)deletedNodeRefs.contains(n1Ref));
        BaseNodeServiceTest.assertTrue((String)"n3Ref delete policy not called", (boolean)deletedNodeRefs.contains(n3Ref));
        BaseNodeServiceTest.assertTrue((String)"n6Ref delete policy not called", (boolean)deletedNodeRefs.contains(n6Ref));
        BaseNodeServiceTest.assertTrue((String)"n8Ref delete policy not called", (boolean)deletedNodeRefs.contains(n8Ref));
    }

    @Test
    public void testDeleteWithBadlyBehavedOnDeletePolicies() throws Exception {
        ArrayList<NodeRef> beforeDeleteNodeRefs = new ArrayList<NodeRef>(5);
        ArrayList<NodeRef> deletedNodeRefs = new ArrayList<NodeRef>(5);
        BadOnDeleteNodePolicy nasty = new BadOnDeleteNodePolicy(this.nodeService, beforeDeleteNodeRefs, deletedNodeRefs);
        try {
            try {
                nasty.setOnDeleteCreateChild(true);
                nasty.setBeforeDeleteCreateChild(false);
                BadOnDeleteNodePolicy policy = nasty;
                this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onDeleteNode"), (Object)policy, (Behaviour)new JavaBehaviour((Object)policy, "onDeleteNode"));
                this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), (Object)policy, (Behaviour)new JavaBehaviour((Object)policy, "beforeDeleteNode"));
                Map<QName, ChildAssociationRef> assocRefs = BaseNodeServiceTest.buildNodeGraph(this.nodeService, this.rootNodeRef);
                NodeRef n1Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"root_p_n1")).getChildRef();
                assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n1_p_n3")).getChildRef();
                assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n2_p_n4")).getChildRef();
                assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n3_p_n6")).getChildRef();
                assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n6_p_n8")).getChildRef();
                this.nodeService.deleteNode(n1Ref);
                BaseNodeServiceTest.fail((String)"test has not detected orphan children");
                TestTransaction.start();
            }
            catch (Exception exception) {
                nasty.setOnDeleteCreateChild(false);
                nasty.setBeforeDeleteCreateChild(false);
            }
        }
        finally {
            nasty.setOnDeleteCreateChild(false);
            nasty.setBeforeDeleteCreateChild(false);
        }
    }

    @Test
    public void testDeleteWithBadlyBehavedBeforeDeletePolicies() throws Exception {
        ArrayList<NodeRef> beforeDeleteNodeRefs = new ArrayList<NodeRef>(5);
        ArrayList<NodeRef> deletedNodeRefs = new ArrayList<NodeRef>(5);
        BadOnDeleteNodePolicy nasty = new BadOnDeleteNodePolicy(this.nodeService, beforeDeleteNodeRefs, deletedNodeRefs);
        try {
            try {
                nasty.setOnDeleteCreateChild(false);
                nasty.setBeforeDeleteCreateChild(true);
                BadOnDeleteNodePolicy policy = nasty;
                this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onDeleteNode"), (Object)policy, (Behaviour)new JavaBehaviour((Object)policy, "onDeleteNode"));
                this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), (Object)policy, (Behaviour)new JavaBehaviour((Object)policy, "beforeDeleteNode"));
                Map<QName, ChildAssociationRef> assocRefs = BaseNodeServiceTest.buildNodeGraph(this.nodeService, this.rootNodeRef);
                NodeRef n1Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"root_p_n1")).getChildRef();
                assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n1_p_n3")).getChildRef();
                assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n2_p_n4")).getChildRef();
                assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n3_p_n6")).getChildRef();
                assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n6_p_n8")).getChildRef();
                this.nodeService.deleteNode(n1Ref);
                BaseNodeServiceTest.fail((String)"test has not detected orphan children");
            }
            catch (Exception exception) {
                nasty.setOnDeleteCreateChild(false);
                nasty.setBeforeDeleteCreateChild(false);
            }
        }
        finally {
            nasty.setOnDeleteCreateChild(false);
            nasty.setBeforeDeleteCreateChild(false);
        }
    }

    protected int countChildrenOfNode(NodeRef nodeRef) {
        List children = this.nodeService.getChildAssocs(nodeRef);
        return children.size();
    }

    @Test
    public void testAddBogusChild() throws Exception {
        NodeRef bogusChildRef = new NodeRef(this.rootNodeRef.getStoreRef(), "BOGUS");
        try {
            this.nodeService.addChild(this.rootNodeRef, bogusChildRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"BOGUS_PATH"));
            BaseNodeServiceTest.fail((String)"Failed to detect invalid child node reference");
        }
        catch (InvalidNodeRefException invalidNodeRefException) {}
    }

    @Test
    public void testAddChild() throws Exception {
        NodeRef childNodeRef1 = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"C1"), ContentModel.TYPE_CONTAINER).getChildRef();
        int count = this.countChildrenOfNode(this.rootNodeRef);
        BaseNodeServiceTest.assertEquals((String)"Root children count incorrect", (int)1, (int)count);
        NodeRef childNodeRef2 = this.nodeService.createNode(childNodeRef1, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"C2"), ContentModel.TYPE_CONTAINER).getChildRef();
        count = this.countChildrenOfNode(this.rootNodeRef);
        BaseNodeServiceTest.assertEquals((String)"Root children count incorrect", (int)1, (int)count);
        this.nodeService.addChild(this.rootNodeRef, childNodeRef2, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathB"));
        int countAfter = this.countChildrenOfNode(this.rootNodeRef);
        BaseNodeServiceTest.assertEquals((String)"Root children count incorrect", (int)2, (int)countAfter);
        try {
            this.nodeService.addChild(childNodeRef1, this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"backToRoot"));
            BaseNodeServiceTest.fail((String)"Failed to detect cyclic child relationship during addition of child");
        }
        catch (CyclicChildRelationshipException cyclicChildRelationshipException) {}
    }

    @Test
    public void testRemoveSpecificChild() throws Exception {
        ChildAssociationRef pathPrimaryRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"parent_child"), ContentModel.TYPE_CONTAINER);
        NodeRef parentRef = pathPrimaryRef.getParentRef();
        ChildAssociationRef pathARef = this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), ContentModel.TYPE_CONTAINER);
        ChildAssociationRef pathBRef = this.nodeService.addChild(parentRef, pathARef.getChildRef(), ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathB"));
        ChildAssociationRef pathCRef = this.nodeService.addChild(parentRef, pathARef.getChildRef(), ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathC"));
        boolean removedB = this.nodeService.removeChildAssociation(pathBRef);
        BaseNodeServiceTest.assertTrue((String)"Association was not removed", (boolean)removedB);
        removedB = this.nodeService.removeChildAssociation(pathBRef);
        BaseNodeServiceTest.assertFalse((String)"Non-existent association was apparently removed", (boolean)removedB);
        boolean removedC = this.nodeService.removeChildAssociation(pathCRef);
        BaseNodeServiceTest.assertTrue((String)"Association was not removed", (boolean)removedC);
        removedC = this.nodeService.removeSecondaryChildAssociation(pathCRef);
        BaseNodeServiceTest.assertFalse((String)"Non-existent association was apparently removed", (boolean)removedC);
        try {
            this.nodeService.removeSecondaryChildAssociation(pathPrimaryRef);
            BaseNodeServiceTest.fail((String)"Primary association not detected");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testRemoveChildPolicyFires() throws Exception {
        ChildAssociationRef pathPrimaryRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"parent_child"), ContentModel.TYPE_CONTAINER);
        NodeRef parentRef = pathPrimaryRef.getParentRef();
        ChildAssociationRef pathARef = this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"patha"), ContentModel.TYPE_CONTAINER);
        ChildAssociationRef pathBRef = this.nodeService.addChild(parentRef, pathARef.getChildRef(), ContentModel.ASSOC_ARCHIVED_LINK, QName.createQName((String)"pathb"));
        ChildAssociationRef pathCRef = this.nodeService.addChild(parentRef, pathARef.getChildRef(), ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathc"));
        BeforeDeletePolicyTester beforeDeletePolicy = new BeforeDeletePolicyTester();
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.BeforeDeleteChildAssociationPolicy.QNAME, (Object)beforeDeletePolicy, (Behaviour)new JavaBehaviour((Object)beforeDeletePolicy, "beforeDeleteChildAssociation"));
        boolean removed = this.nodeService.removeSecondaryChildAssociation(pathBRef);
        BaseNodeServiceTest.assertTrue((String)"Association was removed", (boolean)removed);
        BaseNodeServiceTest.assertEquals((String)"The BeforeDeleteChildAssociationPolicy must fire on removeSecondaryChildAssociation", (Object)pathBRef, (Object)beforeDeletePolicy.childRef);
        removed = this.nodeService.removeChildAssociation(pathCRef);
        BaseNodeServiceTest.assertTrue((String)"Association was removed", (boolean)removed);
        BaseNodeServiceTest.assertEquals((String)"The BeforeDeleteChildAssociationPolicy must fire on removeChildAssociation", (Object)pathCRef, (Object)beforeDeletePolicy.childRef);
    }

    @Test
    public void testRemoveChildByRef() throws Exception {
        NodeRef parentRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"parent_child"), ContentModel.TYPE_CONTAINER).getChildRef();
        ChildAssociationRef pathARef = this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), ContentModel.TYPE_CONTAINER);
        NodeRef childARef = pathARef.getChildRef();
        this.nodeService.createAssociation(parentRef, childARef, ASSOC_TYPE_QNAME_TEST_NEXT);
        this.nodeService.removeChild(parentRef, childARef);
        BaseNodeServiceTest.assertFalse((String)"Primary child not deleted", (boolean)this.nodeService.exists(childARef));
        BaseNodeServiceTest.assertEquals((String)"Child assocs not removed", (int)0, (int)this.nodeService.getChildAssocs(parentRef, (QNamePattern)ASSOC_TYPE_QNAME_TEST_CHILDREN, (QNamePattern)new RegexQNamePattern(".*", "path*")).size());
        BaseNodeServiceTest.assertEquals((String)"Node assoc not removed", (int)0, (int)this.nodeService.getTargetAssocs(parentRef, RegexQNamePattern.MATCH_ALL).size());
    }

    @Test
    public void testProperties() throws Exception {
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"playThing"), ContentModel.TYPE_CONTAINER);
        NodeRef nodeRef = assocRef.getChildRef();
        QName qnameProperty1 = QName.createQName((String)"PROPERTY1");
        String valueProperty1 = "VALUE1";
        QName qnameProperty2 = QName.createQName((String)"PROPERTY2");
        String valueProperty2 = "VALUE2";
        QName qnameProperty3 = QName.createQName((String)"PROPERTY3");
        QName qnameProperty4 = QName.createQName((String)"PROPERTY4");
        Map<QName, Object> properties = new HashMap<QName, String>(5);
        properties.put(qnameProperty1, valueProperty1);
        this.nodeService.setProperties(nodeRef, properties);
        this.nodeService.setProperty(nodeRef, qnameProperty2, (Serializable)((Object)valueProperty2));
        this.nodeService.setProperty(nodeRef, qnameProperty3, null);
        this.nodeService.setProperty(nodeRef, qnameProperty4, (Serializable)((Object)TestEnum.TEST_ONE));
        Map checkMap = this.nodeService.getProperties(nodeRef);
        BaseNodeServiceTest.assertNotNull((String)"Properties were not set/retrieved", (Object)checkMap);
        BaseNodeServiceTest.assertNotNull((String)"Name property not set automatically", checkMap.get(ContentModel.PROP_NAME));
        BaseNodeServiceTest.assertEquals((String)"Name property to set to ID of node", (Object)nodeRef.getId(), checkMap.get(ContentModel.PROP_NAME));
        BaseNodeServiceTest.assertEquals((String)"Property value incorrect", (Object)valueProperty1, checkMap.get(qnameProperty1));
        BaseNodeServiceTest.assertEquals((String)"Property value incorrect", (Object)valueProperty2, checkMap.get(qnameProperty2));
        BaseNodeServiceTest.assertTrue((String)"Null property not persisted", (boolean)checkMap.containsKey(qnameProperty3));
        BaseNodeServiceTest.assertNull((String)"Null value not persisted correctly", checkMap.get(qnameProperty3));
        BaseNodeServiceTest.assertEquals((String)"Enum property not retrieved", (Object)((Object)TestEnum.TEST_ONE), checkMap.get(qnameProperty4));
        Serializable valueCheck = this.nodeService.getProperty(nodeRef, qnameProperty2);
        BaseNodeServiceTest.assertNotNull((String)"Property value not set", (Object)valueCheck);
        BaseNodeServiceTest.assertEquals((String)"Property value incorrect", (Object)"VALUE2", (Object)valueCheck);
        this.nodeService.removeProperty(nodeRef, qnameProperty2);
        valueCheck = this.nodeService.getProperty(nodeRef, qnameProperty2);
        BaseNodeServiceTest.assertNull((String)"Property not removed", (Object)valueCheck);
        try {
            this.nodeService.setProperty(nodeRef, qnameProperty2, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BaseNodeServiceTest.fail((String)"Null property values are allowed");
        }
        try {
            properties = this.nodeService.getProperties(nodeRef);
            properties.put(qnameProperty1, null);
            this.nodeService.setProperties(nodeRef, properties);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BaseNodeServiceTest.fail((String)"Null property values are allowed in the map");
        }
    }

    @Test
    public void testAddProperties() throws Exception {
        this.nodeService.getProperties(this.rootNodeRef);
        this.nodeService.addAspect(this.rootNodeRef, ASPECT_QNAME_TEST_TITLED, null);
        BaseNodeServiceTest.assertNull((String)"Expected null property", (Object)this.nodeService.getProperty(this.rootNodeRef, PROP_QNAME_TEST_TITLE));
        BaseNodeServiceTest.assertNull((String)"Expected null property", (Object)this.nodeService.getProperty(this.rootNodeRef, PROP_QNAME_TEST_DESCRIPTION));
        HashMap<QName, String> addProperties = new HashMap<QName, String>(11);
        addProperties.put(PROP_QNAME_TEST_TITLE, "Title");
        addProperties.put(PROP_QNAME_TEST_DESCRIPTION, "Description");
        this.nodeService.addProperties(this.rootNodeRef, addProperties);
        Map checkProperties = this.nodeService.getProperties(this.rootNodeRef);
        BaseNodeServiceTest.assertEquals((Object)"Title", checkProperties.get(PROP_QNAME_TEST_TITLE));
        BaseNodeServiceTest.assertEquals((Object)"Description", checkProperties.get(PROP_QNAME_TEST_DESCRIPTION));
    }

    @Test
    public void testDefaultPropertyOverride_AddAspect() throws Exception {
        Serializable nullValue = this.nodeService.getProperty(this.rootNodeRef, PROP_QNAME_PROP2);
        BaseNodeServiceTest.assertNull((String)"Property should not be present", (Object)nullValue);
        String valueOverride = "VALUE_OVERRIDE";
        Map<QName, String> properties = Collections.singletonMap(PROP_QNAME_PROP2, valueOverride);
        this.nodeService.addAspect(this.rootNodeRef, ASPECT_QNAME_WITH_DEFAULT_VALUE, properties);
        Serializable checkValue = this.nodeService.getProperty(this.rootNodeRef, PROP_QNAME_PROP2);
        BaseNodeServiceTest.assertEquals((String)"Property should not be defaulted", (Object)valueOverride, (Object)checkValue);
    }

    @Test
    public void testDefaultPropertyOverride_CreateNode() throws Exception {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), TYPE_QNAME_EXTENDED_CONTENT).getChildRef();
        Serializable checkValue = this.nodeService.getProperty(nodeRef, PROP_QNAME_PROP1);
        BaseNodeServiceTest.assertEquals((String)"Property should be defaulted", (Object)DEFAULT_VALUE, (Object)checkValue);
        String valueOverride = "VALUE_OVERRIDE";
        Map<QName, String> properties = Collections.singletonMap(PROP_QNAME_PROP1, valueOverride);
        nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), TYPE_QNAME_EXTENDED_CONTENT, properties).getChildRef();
        checkValue = this.nodeService.getProperty(nodeRef, PROP_QNAME_PROP1);
        BaseNodeServiceTest.assertEquals((String)"Property should not be defaulted", (Object)valueOverride, (Object)checkValue);
    }

    @Test
    public void testDefaultPropertyOverride_SpecializeWithoutProperty() throws Exception {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), ContentModel.TYPE_CONTENT).getChildRef();
        Serializable checkValue = this.nodeService.getProperty(nodeRef, PROP_QNAME_PROP1);
        BaseNodeServiceTest.assertNull((String)"Property should not exist", (Object)checkValue);
        this.nodeService.setType(nodeRef, TYPE_QNAME_EXTENDED_CONTENT);
        checkValue = this.nodeService.getProperty(nodeRef, PROP_QNAME_PROP1);
        BaseNodeServiceTest.assertEquals((String)"Property should be defaulted", (Object)DEFAULT_VALUE, (Object)checkValue);
    }

    @Test
    public void testDefaultPropertyOverride_SpecializeWithProperty() throws Exception {
        String valueOverride = "VALUE_OVERRIDE";
        Map<QName, String> properties = Collections.singletonMap(PROP_QNAME_PROP1, valueOverride);
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), ContentModel.TYPE_CONTENT, properties).getChildRef();
        Serializable checkValue = this.nodeService.getProperty(nodeRef, PROP_QNAME_PROP1);
        BaseNodeServiceTest.assertEquals((String)"Property should not be defaulted", (Object)valueOverride, (Object)checkValue);
        this.nodeService.setType(nodeRef, TYPE_QNAME_EXTENDED_CONTENT);
        checkValue = this.nodeService.getProperty(nodeRef, PROP_QNAME_PROP1);
        BaseNodeServiceTest.assertEquals((String)"Property should *still* not be defaulted", (Object)valueOverride, (Object)checkValue);
    }

    @Test
    public void testRemoveProperty() throws Exception {
        Map properties = this.nodeService.getProperties(this.rootNodeRef);
        this.nodeService.addAspect(this.rootNodeRef, ASPECT_QNAME_WITH_DEFAULT_VALUE, null);
        Serializable defaultValue = this.nodeService.getProperty(this.rootNodeRef, PROP_QNAME_PROP2);
        BaseNodeServiceTest.assertNotNull((String)"No default property value assigned", (Object)defaultValue);
        BaseNodeServiceTest.assertEquals((String)"Property should be defaulted", (Object)DEFAULT_VALUE, (Object)defaultValue);
        this.nodeService.setProperties(this.rootNodeRef, properties);
        Serializable nullValue = this.nodeService.getProperty(this.rootNodeRef, PROP_QNAME_PROP2);
        BaseNodeServiceTest.assertNull((String)"Property was not removed", (Object)nullValue);
        this.nodeService.removeAspect(this.rootNodeRef, ASPECT_QNAME_WITH_DEFAULT_VALUE);
        nullValue = this.nodeService.getProperty(this.rootNodeRef, PROP_QNAME_PROP2);
        BaseNodeServiceTest.assertNull((String)"Property was not removed", (Object)nullValue);
        this.nodeService.addAspect(this.rootNodeRef, ASPECT_QNAME_WITH_DEFAULT_VALUE, null);
        defaultValue = this.nodeService.getProperty(this.rootNodeRef, PROP_QNAME_PROP2);
        BaseNodeServiceTest.assertNotNull((String)"No default property value assigned", (Object)defaultValue);
        this.nodeService.setProperty(this.rootNodeRef, PROP_QNAME_PROP2, null);
        nullValue = this.nodeService.getProperty(this.rootNodeRef, PROP_QNAME_PROP2);
        BaseNodeServiceTest.assertNull((String)"Property was not removed", (Object)nullValue);
        this.nodeService.removeAspect(this.rootNodeRef, ASPECT_QNAME_WITH_DEFAULT_VALUE);
        this.nodeService.addAspect(this.rootNodeRef, ASPECT_QNAME_WITH_DEFAULT_VALUE, null);
        defaultValue = this.nodeService.getProperty(this.rootNodeRef, PROP_QNAME_PROP2);
        BaseNodeServiceTest.assertNotNull((String)"No default property value assigned", (Object)defaultValue);
        this.nodeService.removeProperty(this.rootNodeRef, PROP_QNAME_PROP2);
        nullValue = this.nodeService.getProperty(this.rootNodeRef, PROP_QNAME_PROP2);
        BaseNodeServiceTest.assertNull((String)"Property was not removed", (Object)nullValue);
    }

    @Test
    public void testGetUnknownProperty() throws Exception {
        TestTransaction.flagForCommit();
        TestTransaction.end();
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef nodeRef = BaseNodeServiceTest.this.nodeService.createNode(BaseNodeServiceTest.this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), ContentModel.TYPE_CONTAINER).getChildRef();
                return nodeRef;
            }
        };
        final NodeRef nodeRef = (NodeRef)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createCallback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                QName ficticiousQName = QName.createQName((String)GUID.generate(), (String)GUID.generate());
                Serializable value = BaseNodeServiceTest.this.nodeService.getProperty(nodeRef, ficticiousQName);
                BaseNodeServiceTest.assertNull((String)"Didn't expect a value back", (Object)value);
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)testCallback, true, true);
    }

    @Test
    public void testSerializableProperties() throws Exception {
        QName qname = PROP_QNAME_CONTENT_VALUE;
        HashMap<QName, QName> properties = new HashMap<QName, QName>(17);
        properties.put(PROP_QNAME_SERIALIZABLE_VALUE, qname);
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), ContentModel.TYPE_CONTAINER, properties).getChildRef();
        Map checkProperties = this.nodeService.getProperties(nodeRef);
        Serializable checkPropertyQname = (Serializable)checkProperties.get(PROP_QNAME_SERIALIZABLE_VALUE);
        BaseNodeServiceTest.assertTrue((String)"Serialization/deserialization failed", (boolean)(checkPropertyQname instanceof QName));
    }

    @Test
    public void testEncryptionAndDecryptionOfProperties() {
        QName valueToEncrypt = PROP_QNAME_CONTENT_VALUE;
        QName value = PROP_QNAME_CONTENT_VALUE;
        Serializable encryptedProperty = this.metadataEncryptor.encrypt(PROP_QNAME_ENCRYPTED_VALUE, (Serializable)valueToEncrypt);
        BaseNodeServiceTest.assertTrue((String)"Not a SealedObject", (boolean)(encryptedProperty instanceof SealedObject));
        Serializable encryptedPropertyAgain = this.metadataEncryptor.encrypt(PROP_QNAME_ENCRYPTED_VALUE, encryptedProperty);
        BaseNodeServiceTest.assertTrue((String)"Re-encryption not expected", (encryptedProperty == encryptedPropertyAgain ? 1 : 0) != 0);
        Serializable decryptedProperty = this.metadataEncryptor.decrypt(PROP_QNAME_ENCRYPTED_VALUE, encryptedProperty);
        BaseNodeServiceTest.assertEquals((String)"Value not decrypted correctly", (Object)valueToEncrypt, (Object)decryptedProperty);
        HashMap<QName, QName> properties = new HashMap<QName, QName>(5);
        properties.put(PROP_QNAME_ENCRYPTED_VALUE, valueToEncrypt);
        properties.put(PROP_QNAME_QNAME_VALUE, value);
        Map encryptedProperties = this.metadataEncryptor.encrypt(properties);
        BaseNodeServiceTest.assertTrue((String)"Not a SealedObject", (boolean)(encryptedProperties.get(PROP_QNAME_ENCRYPTED_VALUE) instanceof SealedObject));
        BaseNodeServiceTest.assertTrue((String)"Should not encrypt", (boolean)(encryptedProperties.get(PROP_QNAME_QNAME_VALUE) instanceof QName));
        Map encryptedPropertiesAgain = this.metadataEncryptor.encrypt(encryptedProperties);
        BaseNodeServiceTest.assertTrue((String)"Map should not change", (encryptedProperties == encryptedPropertiesAgain ? 1 : 0) != 0);
        BaseNodeServiceTest.assertTrue((String)"Re-encryption not expected", (encryptedProperties.get(PROP_QNAME_ENCRYPTED_VALUE) == encryptedPropertiesAgain.get(PROP_QNAME_ENCRYPTED_VALUE) ? 1 : 0) != 0);
        BaseNodeServiceTest.assertTrue((String)"Should not encrypt", (boolean)(encryptedProperties.get(PROP_QNAME_QNAME_VALUE) instanceof QName));
        Map decryptedProperties = this.metadataEncryptor.decrypt(encryptedProperties);
        BaseNodeServiceTest.assertEquals((String)"Values not decrypted correctly", (Object)valueToEncrypt, decryptedProperties.get(PROP_QNAME_ENCRYPTED_VALUE));
        BaseNodeServiceTest.assertEquals((String)"Values not decrypted correctly", (Object)value, decryptedProperties.get(PROP_QNAME_QNAME_VALUE));
        HashMap<QName, Object> propertiesNull = new HashMap<QName, Object>(5);
        propertiesNull.put(PROP_QNAME_ENCRYPTED_VALUE, null);
        propertiesNull.put(PROP_QNAME_QNAME_VALUE, null);
        Map encryptedPropertiesNull = this.metadataEncryptor.encrypt(propertiesNull);
        BaseNodeServiceTest.assertTrue((String)"Map should not change", (encryptedPropertiesNull == propertiesNull ? 1 : 0) != 0);
        BaseNodeServiceTest.assertNull((String)"Null should remain", encryptedPropertiesNull.get(PROP_QNAME_ENCRYPTED_VALUE));
        Map decryptedPropertiesNull = this.metadataEncryptor.decrypt(encryptedPropertiesNull);
        BaseNodeServiceTest.assertTrue((String)"Map should not change", (encryptedPropertiesNull == decryptedPropertiesNull ? 1 : 0) != 0);
        BaseNodeServiceTest.assertNull((String)"Null should remain", decryptedPropertiesNull.get(PROP_QNAME_ENCRYPTED_VALUE));
    }

    @Test
    public void testEncryptedProperties() throws Exception {
        QName property = PROP_QNAME_CONTENT_VALUE;
        Map properties = new HashMap<QName, QName>(17);
        properties.put(PROP_QNAME_ENCRYPTED_VALUE, property);
        properties = this.metadataEncryptor.encrypt(properties);
        Serializable checkProperty = (Serializable)properties.get(PROP_QNAME_ENCRYPTED_VALUE);
        BaseNodeServiceTest.assertTrue((String)"Properties not encrypted", (boolean)(checkProperty instanceof SealedObject));
        final NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), ContentModel.TYPE_CONTAINER, properties).getChildRef();
        TestTransaction.flagForCommit();
        TestTransaction.end();
        TestTransaction.start();
        Map checkProperties = this.nodeService.getProperties(nodeRef);
        checkProperty = (Serializable)checkProperties.get(PROP_QNAME_ENCRYPTED_VALUE);
        BaseNodeServiceTest.assertTrue((String)"Encrypted property not persisted", (boolean)(checkProperty instanceof SealedObject));
        checkProperty = this.metadataEncryptor.decrypt(PROP_QNAME_ENCRYPTED_VALUE, checkProperty);
        BaseNodeServiceTest.assertEquals((String)"Bulk property decryption failed", (Object)property, (Object)checkProperty);
        checkProperties = this.metadataEncryptor.decrypt(checkProperties);
        checkProperty = (Serializable)checkProperties.get(PROP_QNAME_ENCRYPTED_VALUE);
        BaseNodeServiceTest.assertEquals((String)"Bulk property decryption failed", (Object)property, (Object)checkProperty);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> setNullPropCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                BaseNodeServiceTest.this.nodeService.setProperty(nodeRef, PROP_QNAME_ENCRYPTED_VALUE, null);
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setNullPropCallback);
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Void> setUnencryptedPropCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    BaseNodeServiceTest.this.nodeService.setProperty(nodeRef, PROP_QNAME_ENCRYPTED_VALUE, (Serializable)((Object)"No encrypted"));
                    return null;
                }
            };
            this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setUnencryptedPropCallback);
            BaseNodeServiceTest.fail((String)"Failed to detect unencrypted property");
        }
        catch (RuntimeException runtimeException) {}
    }

    @Test
    public void testMultiProp() throws Exception {
        ArrayList<Object> values;
        NodeRef nodeRef;
        block10: {
            QName undeclaredPropQName = QName.createQName((String)NAMESPACE, (String)((Object)((Object)this)).getClass().getName());
            nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), TYPE_QNAME_TEST_MULTIPLE_TESTER).getChildRef();
            values = new ArrayList<Object>(1);
            values.add("ABC");
            values.add("DEF");
            this.nodeService.setProperty(nodeRef, PROP_QNAME_STRING_PROP_SINGLE, (Serializable)((Object)"ABC"));
            this.nodeService.setProperty(nodeRef, PROP_QNAME_STRING_PROP_MULTIPLE, (Serializable)((Object)"ABC"));
            this.nodeService.setProperty(nodeRef, PROP_QNAME_STRING_PROP_MULTIPLE, values);
            this.nodeService.setProperty(nodeRef, PROP_QNAME_ANY_PROP_SINGLE, (Serializable)((Object)"ABC"));
            this.nodeService.setProperty(nodeRef, PROP_QNAME_ANY_PROP_SINGLE, values);
            this.nodeService.setProperty(nodeRef, PROP_QNAME_ANY_PROP_MULTIPLE, (Serializable)((Object)"ABC"));
            this.nodeService.setProperty(nodeRef, PROP_QNAME_ANY_PROP_MULTIPLE, values);
            this.nodeService.setProperty(nodeRef, undeclaredPropQName, (Serializable)((Object)"ABC"));
            this.nodeService.setProperty(nodeRef, undeclaredPropQName, values);
            TestTransaction.flagForCommit();
            TestTransaction.end();
            TestTransaction.start();
            try {
                try {
                    this.nodeService.setProperty(nodeRef, PROP_QNAME_STRING_PROP_SINGLE, values);
                }
                catch (DictionaryException dictionaryException) {
                    TestTransaction.flagForRollback();
                    TestTransaction.end();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                TestTransaction.flagForRollback();
                TestTransaction.end();
                throw throwable;
            }
            TestTransaction.flagForRollback();
            TestTransaction.end();
        }
        TestTransaction.start();
        try {
            try {
                values.clear();
                values.add(new MLText("ABC"));
                values.add(new MLText("DEF"));
                this.nodeService.setProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE, values);
                List checkValues = (List)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE));
                BaseNodeServiceTest.assertEquals((String)"Expected 2 MLText values back", (int)2, (int)checkValues.size());
                BaseNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(0) instanceof MLText));
                BaseNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(1) instanceof MLText));
                values.clear();
                ArrayList<String> arrayListVal = new ArrayList<String>(2);
                HashSet<String> hashSetVal = new HashSet<String>(2);
                values.add(arrayListVal);
                values.add(hashSetVal);
                this.nodeService.setProperty(nodeRef, PROP_QNAME_ANY_PROP_MULTIPLE, values);
                checkValues = (List)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_ANY_PROP_MULTIPLE));
                BaseNodeServiceTest.assertEquals((String)"Expected 2 Collection values back", (int)2, (int)checkValues.size());
                BaseNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(0) instanceof ArrayList));
                BaseNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(1) instanceof HashSet));
                arrayListVal.add("ONE");
                arrayListVal.add("TWO");
                hashSetVal.add("ONE");
                hashSetVal.add("TWO");
                values.clear();
                values.add(arrayListVal);
                values.add(hashSetVal);
                this.nodeService.setProperty(nodeRef, PROP_QNAME_ANY_PROP_MULTIPLE, values);
                checkValues = (List)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_ANY_PROP_MULTIPLE));
                BaseNodeServiceTest.assertEquals((String)"Expected 2 Collection values back", (int)2, (int)checkValues.size());
                BaseNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(0) instanceof ArrayList));
                BaseNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(1) instanceof HashSet));
                BaseNodeServiceTest.assertEquals((String)"First collection incorrect", (int)2, (int)((Collection)checkValues.get(0)).size());
                BaseNodeServiceTest.assertEquals((String)"Second collection incorrect", (int)2, (int)((Collection)checkValues.get(1)).size());
            }
            catch (DictionaryException dictionaryException) {
                TestTransaction.flagForRollback();
                TestTransaction.end();
            }
        }
        finally {
            TestTransaction.flagForRollback();
            TestTransaction.end();
        }
    }

    protected void getExpectedPropertyValues(Map<QName, Serializable> checkProperties) {
    }

    private void checkProperties(Map<QName, Serializable> checkProperties, Map<QName, Serializable> expectedProperties) {
        for (QName qname : expectedProperties.keySet()) {
            Serializable value = expectedProperties.get(qname);
            Serializable checkValue = checkProperties.get(qname);
            BaseNodeServiceTest.assertEquals((String)("Property mismatch - " + qname), (Object)value, (Object)checkValue);
        }
    }

    @Test
    public void testPropertyTypes() throws Exception {
        ArrayList<String> listProperty = new ArrayList<String>(2);
        listProperty.add("ABC");
        listProperty.add("DEF");
        Path pathProperty = new Path();
        pathProperty.append((Path.Element)new Path.SelfElement()).append((Path.Element)new Path.AttributeElement(TYPE_QNAME_TEST_CONTENT));
        HashMap<QName, Object> properties = new HashMap<QName, Object>(17);
        properties.put(PROP_QNAME_BOOLEAN_VALUE, true);
        properties.put(PROP_QNAME_INTEGER_VALUE, 123);
        properties.put(PROP_QNAME_LONG_VALUE, 123L);
        properties.put(PROP_QNAME_FLOAT_VALUE, Float.valueOf(123.0f));
        properties.put(PROP_QNAME_DOUBLE_VALUE, 123.0);
        properties.put(PROP_QNAME_STRING_VALUE, "123.0");
        properties.put(PROP_QNAME_ML_TEXT_VALUE, new MLText("This is ML text in the default language"));
        properties.put(PROP_QNAME_DATE_VALUE, new Date());
        properties.put(PROP_QNAME_SERIALIZABLE_VALUE, "456");
        properties.put(PROP_QNAME_NODEREF_VALUE, this.rootNodeRef);
        properties.put(PROP_QNAME_PATH_VALUE, pathProperty);
        properties.put(PROP_QNAME_CATEGORY_VALUE, this.cat);
        properties.put(PROP_QNAME_LOCALE_VALUE, Locale.CHINESE);
        properties.put(PROP_QNAME_NULL_VALUE, null);
        properties.put(PROP_QNAME_MULTI_VALUE, listProperty);
        properties.put(PROP_QNAME_PERIOD_VALUE, "period|1");
        HashMap<QName, Serializable> expectedProperties = new HashMap<QName, Serializable>(properties);
        this.getExpectedPropertyValues(expectedProperties);
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), TYPE_QNAME_TEST_MANY_PROPERTIES, properties).getChildRef();
        Map checkProperties = this.nodeService.getProperties(nodeRef);
        this.checkProperties(checkProperties, expectedProperties);
        this.nodeService.setProperty(nodeRef, PROP_QNAME_MULTI_VALUE, (Serializable)((Object)"GHI"));
        Serializable checkProperty = this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_VALUE);
        BaseNodeServiceTest.assertTrue((String)"Property not converted to a Collection", (boolean)(checkProperty instanceof Collection));
        BaseNodeServiceTest.assertTrue((String)"Collection doesn't contain value", (boolean)((Collection)((Object)checkProperty)).contains("GHI"));
        this.nodeService.setProperty(nodeRef, PROP_QNAME_DOUBLE_VALUE, (Serializable)Double.valueOf(Double.NaN));
        BaseNodeServiceTest.assertEquals((String)"Double.NaN failed", (Object)Double.NaN, (Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_DOUBLE_VALUE));
        this.nodeService.setProperty(nodeRef, PROP_QNAME_DOUBLE_VALUE, (Serializable)Double.valueOf(Double.NEGATIVE_INFINITY));
        BaseNodeServiceTest.assertEquals((String)"Double.NEGATIVE_INFINITY failed", (Object)Double.NEGATIVE_INFINITY, (Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_DOUBLE_VALUE));
        this.nodeService.setProperty(nodeRef, PROP_QNAME_DOUBLE_VALUE, (Serializable)Double.valueOf(Double.POSITIVE_INFINITY));
        BaseNodeServiceTest.assertEquals((String)"Double.POSITIVE_INFINITY failed", (Object)Double.POSITIVE_INFINITY, (Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_DOUBLE_VALUE));
        this.nodeService.setProperty(nodeRef, PROP_QNAME_FLOAT_VALUE, (Serializable)Float.valueOf(Float.NaN));
        BaseNodeServiceTest.assertEquals((String)"Float.NaN failed", (Object)Float.valueOf(Float.NaN), (Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_FLOAT_VALUE));
        this.nodeService.setProperty(nodeRef, PROP_QNAME_FLOAT_VALUE, (Serializable)Float.valueOf(Float.NEGATIVE_INFINITY));
        BaseNodeServiceTest.assertEquals((String)"Float.NEGATIVE_INFINITY failed", (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_FLOAT_VALUE));
        this.nodeService.setProperty(nodeRef, PROP_QNAME_FLOAT_VALUE, (Serializable)Float.valueOf(Float.POSITIVE_INFINITY));
        BaseNodeServiceTest.assertEquals((String)"Float.POSITIVE_INFINITY failed", (Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_FLOAT_VALUE));
    }

    @Test
    public void testPropertySpecialNumbers() throws Exception {
        HashMap<QName, Double> properties = new HashMap<QName, Double>(17);
        properties.put(PROP_QNAME_DOUBLE_VALUE, Double.NaN);
    }

    @Commit
    @Test
    public void testPropertyLocaleBehaviour() throws Exception {
        HashMap<QName, Object> properties = new HashMap<QName, Object>(17);
        properties.put(PROP_QNAME_BOOLEAN_VALUE, true);
        properties.put(PROP_QNAME_INTEGER_VALUE, 123);
        properties.put(PROP_QNAME_LONG_VALUE, 123L);
        properties.put(PROP_QNAME_FLOAT_VALUE, Float.valueOf(123.0f));
        properties.put(PROP_QNAME_DOUBLE_VALUE, 123.0);
        properties.put(PROP_QNAME_STRING_VALUE, "123.0");
        properties.put(PROP_QNAME_ML_TEXT_VALUE, new MLText("This is ML text in the default language"));
        properties.put(PROP_QNAME_DATE_VALUE, new Date());
        HashMap<QName, Serializable> expectedProperties = new HashMap<QName, Serializable>(properties);
        this.getExpectedPropertyValues(expectedProperties);
        Locale.setDefault(Locale.JAPANESE);
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), TYPE_QNAME_TEST_MANY_PROPERTIES, properties).getChildRef();
        Map checkProperties = this.nodeService.getProperties(nodeRef);
        this.checkProperties(checkProperties, expectedProperties);
        I18NUtil.setLocale((Locale)Locale.US);
        this.nodeService.setProperties(nodeRef, properties);
        checkProperties = this.nodeService.getProperties(nodeRef);
        this.checkProperties(checkProperties, expectedProperties);
        I18NUtil.setLocale((Locale)Locale.UK);
        this.nodeService.setProperties(nodeRef, properties);
        checkProperties = this.nodeService.getProperties(nodeRef);
        this.checkProperties(checkProperties, expectedProperties);
        I18NUtil.setLocale((Locale)Locale.US);
        this.nodeService.addProperties(nodeRef, properties);
        checkProperties = this.nodeService.getProperties(nodeRef);
        this.checkProperties(checkProperties, expectedProperties);
        I18NUtil.setLocale((Locale)Locale.UK);
        this.nodeService.addProperties(nodeRef, properties);
        checkProperties = this.nodeService.getProperties(nodeRef);
        this.checkProperties(checkProperties, expectedProperties);
        I18NUtil.setLocale((Locale)Locale.US);
        this.nodeService.setProperty(nodeRef, PROP_QNAME_DATE_VALUE, (Serializable)properties.get(PROP_QNAME_DATE_VALUE));
        checkProperties = this.nodeService.getProperties(nodeRef);
        this.checkProperties(checkProperties, expectedProperties);
        I18NUtil.setLocale((Locale)Locale.UK);
        this.nodeService.setProperty(nodeRef, PROP_QNAME_DATE_VALUE, (Serializable)properties.get(PROP_QNAME_DATE_VALUE));
        checkProperties = this.nodeService.getProperties(nodeRef);
        this.checkProperties(checkProperties, expectedProperties);
    }

    @Test
    public void testEmptyCollections() throws Exception {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), TYPE_QNAME_TEST_MANY_PROPERTIES).getChildRef();
        ArrayList<String> filledCollection = new ArrayList<String>(2);
        filledCollection.add("ABC");
        filledCollection.add("DEF");
        List emptyCollection = Collections.emptyList();
        this.nodeService.setProperty(nodeRef, PROP_QNAME_MULTI_VALUE, (Serializable)filledCollection);
        List checkFilledCollection = (List)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_VALUE));
        BaseNodeServiceTest.assertEquals((String)"Filled collection didn't come back with correct values", filledCollection, (Object)checkFilledCollection);
        this.nodeService.setProperty(nodeRef, PROP_QNAME_MULTI_VALUE, (Serializable)((Object)emptyCollection));
        List checkEmptyCollection = (List)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_VALUE));
        BaseNodeServiceTest.assertEquals((String)"Empty collection didn't come back with correct values", emptyCollection, (Object)checkEmptyCollection);
        this.nodeService.setProperty(nodeRef, PROP_QNAME_MULTI_VALUE, null);
        List checkNullCollection = (List)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_VALUE));
        BaseNodeServiceTest.assertNull((String)"Null property should stay null", (Object)checkNullCollection);
    }

    @Test
    public void testBigCollections() throws Exception {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), TYPE_QNAME_TEST_MANY_PROPERTIES).getChildRef();
        int inc = 0;
        while (inc < 5) {
            System.out.println("----------------------------------------------");
            int collectionSize = (int)Math.pow(10.0, inc);
            ArrayList<String> largeCollection = new ArrayList<String>(collectionSize);
            int i = 0;
            while (i < collectionSize) {
                largeCollection.add(String.format("Large-collection-value-%05d", i));
                ++i;
            }
            List emptyCollection = Collections.emptyList();
            long t1 = System.nanoTime();
            this.nodeService.setProperty(nodeRef, PROP_QNAME_MULTI_VALUE, (Serializable)largeCollection);
            double tDelta = (double)(System.nanoTime() - t1) / 1000000.0;
            System.out.println("Setting " + collectionSize + " multi-valued property took: " + tDelta + "ms");
            t1 = System.nanoTime();
            List checkLargeCollection = (List)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_VALUE));
            tDelta = (double)(System.nanoTime() - t1) / 1000000.0;
            System.out.println("First fetch of " + collectionSize + " multi-valued property took: " + tDelta + "ms");
            BaseNodeServiceTest.assertEquals((String)"Large collection didn't come back with correct values", largeCollection, (Object)checkLargeCollection);
            t1 = System.nanoTime();
            checkLargeCollection = (List)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_VALUE));
            tDelta = (double)(System.nanoTime() - t1) / 1000000.0;
            System.out.println("Second fetch of " + collectionSize + " multi-valued property took: " + tDelta + "ms");
            largeCollection.add("First addition");
            t1 = System.nanoTime();
            this.nodeService.setProperty(nodeRef, PROP_QNAME_MULTI_VALUE, (Serializable)largeCollection);
            tDelta = (double)(System.nanoTime() - t1) / 1000000.0;
            System.out.println("Re-setting " + largeCollection.size() + " multi-valued property took: " + tDelta + "ms");
            largeCollection.add("Second addition");
            t1 = System.nanoTime();
            this.nodeService.setProperty(nodeRef, PROP_QNAME_MULTI_VALUE, (Serializable)largeCollection);
            tDelta = (double)(System.nanoTime() - t1) / 1000000.0;
            System.out.println("Re-setting " + largeCollection.size() + " multi-valued property took: " + tDelta + "ms");
            this.nodeService.setProperty(nodeRef, PROP_QNAME_MULTI_VALUE, (Serializable)((Object)emptyCollection));
            List checkEmptyCollection = (List)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_VALUE));
            BaseNodeServiceTest.assertEquals((String)"Empty collection didn't come back with correct values", emptyCollection, (Object)checkEmptyCollection);
            this.nodeService.setProperty(nodeRef, PROP_QNAME_MULTI_VALUE, null);
            List checkNullCollection = (List)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_VALUE));
            BaseNodeServiceTest.assertNull((String)"Null property should stay null", (Object)checkNullCollection);
            ++inc;
        }
    }

    @Test
    public void testMultiValueMLTextProperties() throws Exception {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), TYPE_QNAME_TEST_MANY_ML_PROPERTIES).getChildRef();
        ArrayList<MLText> mlTextCollection = new ArrayList<MLText>(2);
        MLText mlText0 = new MLText();
        mlText0.addValue(Locale.ENGLISH, "Hello");
        mlText0.addValue(Locale.FRENCH, "Bonjour");
        mlTextCollection.add(mlText0);
        MLText mlText1 = new MLText();
        mlText1.addValue(Locale.ENGLISH, "Bye bye");
        mlText1.addValue(Locale.FRENCH, "Au revoir");
        mlTextCollection.add(mlText1);
        this.nodeService.setProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE, (Serializable)mlTextCollection);
        Collection mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE));
        BaseNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", mlTextCollection, (Object)mlTextCollectionCheck);
    }

    @Test
    public void testMultivaluedSerializable() throws Exception {
        ArrayList<String> listProp = new ArrayList<String>();
        listProp.clear();
        this.nodeService.addProperties(this.rootNodeRef, Collections.singletonMap(PROP_QNAME_ANY_PROP_MULTIPLE, listProp));
        listProp.add("ONE");
        this.nodeService.addProperties(this.rootNodeRef, Collections.singletonMap(PROP_QNAME_ANY_PROP_MULTIPLE, listProp));
        listProp.add("TWO");
        this.nodeService.addProperties(this.rootNodeRef, Collections.singletonMap(PROP_QNAME_ANY_PROP_MULTIPLE, listProp));
        listProp.clear();
        this.nodeService.addProperties(this.rootNodeRef, Collections.singletonMap(PROP_QNAME_ANY_PROP_SINGLE, listProp));
        listProp.add("ONE");
        this.nodeService.addProperties(this.rootNodeRef, Collections.singletonMap(PROP_QNAME_ANY_PROP_SINGLE, listProp));
        listProp.add("TWO");
        this.nodeService.addProperties(this.rootNodeRef, Collections.singletonMap(PROP_QNAME_ANY_PROP_SINGLE, listProp));
    }

    @Test
    public void testGetReferencableProperties() throws Exception {
        Serializable wsProtocol = this.nodeService.getProperty(this.rootNodeRef, ContentModel.PROP_STORE_PROTOCOL);
        Serializable wsIdentifier = this.nodeService.getProperty(this.rootNodeRef, ContentModel.PROP_STORE_IDENTIFIER);
        Serializable nodeUuid = this.nodeService.getProperty(this.rootNodeRef, ContentModel.PROP_NODE_UUID);
        Serializable nodeDbId = this.nodeService.getProperty(this.rootNodeRef, ContentModel.PROP_NODE_DBID);
        BaseNodeServiceTest.assertNotNull((String)"Workspace Protocol property not present", (Object)wsProtocol);
        BaseNodeServiceTest.assertNotNull((String)"Workspace Identifier property not present", (Object)wsIdentifier);
        BaseNodeServiceTest.assertNotNull((String)"Node UUID property not present", (Object)nodeUuid);
        BaseNodeServiceTest.assertNotNull((String)"Node DB ID property not present", (Object)nodeDbId);
        BaseNodeServiceTest.assertEquals((String)"Workspace Protocol property incorrect", (Object)this.rootNodeRef.getStoreRef().getProtocol(), (Object)wsProtocol);
        BaseNodeServiceTest.assertEquals((String)"Workspace Identifier property incorrect", (Object)this.rootNodeRef.getStoreRef().getIdentifier(), (Object)wsIdentifier);
        BaseNodeServiceTest.assertEquals((String)"Node UUID property incorrect", (Object)this.rootNodeRef.getId(), (Object)nodeUuid);
        Map properties = this.nodeService.getProperties(this.rootNodeRef);
        BaseNodeServiceTest.assertTrue((String)"Workspace Protocol property not present in map", (boolean)properties.containsKey(ContentModel.PROP_STORE_PROTOCOL));
        BaseNodeServiceTest.assertTrue((String)"Workspace Identifier property not present in map", (boolean)properties.containsKey(ContentModel.PROP_STORE_IDENTIFIER));
        BaseNodeServiceTest.assertTrue((String)"Node UUID property not present in map", (boolean)properties.containsKey(ContentModel.PROP_NODE_UUID));
        BaseNodeServiceTest.assertTrue((String)"Node DB ID property not present in map", (boolean)properties.containsKey(ContentModel.PROP_NODE_DBID));
    }

    @Test
    public void testReferencePropertySet() throws Exception {
        Serializable nodeDbId = this.nodeService.getProperty(this.rootNodeRef, ContentModel.PROP_NODE_DBID);
        this.nodeService.setProperty(this.rootNodeRef, ContentModel.PROP_NODE_DBID, (Serializable)new Long(-1L));
        Serializable nodeDbIdCheck = this.nodeService.getProperty(this.rootNodeRef, ContentModel.PROP_NODE_DBID);
        BaseNodeServiceTest.assertEquals((String)"Cannot set Node DB ID", (Object)nodeDbId, (Object)nodeDbIdCheck);
    }

    @Test
    public void testResidual() throws Exception {
        HashMap<QName, Object> props = new HashMap<QName, Object>(5);
        props.put(PROP_QNAME_RESIDUAL_STRING, "ABC");
        props.put(PROP_QNAME_RESIDUAL_LONG, 123L);
        try {
            this.nodeService.addAspect(this.rootNodeRef, ASPECT_RESIDUAL, props);
        }
        catch (InvalidAspectException invalidAspectException) {}
    }

    @Test
    public void testGetParentAssocs() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n3_p_n6"));
        assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n5_p_n7"));
        ChildAssociationRef n6pn8Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n6_p_n8"));
        ChildAssociationRef n7n8Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n7_n8"));
        NodeRef n8Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n6_p_n8")).getChildRef();
        List parentAssocs = this.nodeService.getParentAssocs(n8Ref);
        BaseNodeServiceTest.assertEquals((String)"Incorrect number of parents", (int)3, (int)parentAssocs.size());
        BaseNodeServiceTest.assertTrue((String)"Expected assoc not found", (boolean)parentAssocs.contains(n6pn8Ref));
        BaseNodeServiceTest.assertTrue((String)"Expected assoc not found", (boolean)parentAssocs.contains(n7n8Ref));
        ChildAssociationRef primaryParentAssocCheck = this.nodeService.getPrimaryParent(n8Ref);
        BaseNodeServiceTest.assertEquals((String)"Primary parent assoc not retrieved", (Object)n6pn8Ref, (Object)primaryParentAssocCheck);
        ChildAssociationRef rootNodePrimaryAssoc = this.nodeService.getPrimaryParent(this.rootNodeRef);
        BaseNodeServiceTest.assertNull((String)"Expected null primary parent for root node", (Object)rootNodePrimaryAssoc.getParentRef());
        List parentAssocRefsByQName = this.nodeService.getParentAssocs(n8Ref, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)NAMESPACE, (String)"n7_n8"));
        BaseNodeServiceTest.assertEquals((String)"Expected to get exactly one match", (int)1, (int)parentAssocRefsByQName.size());
        this.nodeService.getChildAssocs(n8Ref, (QNamePattern)ASSOC_TYPE_QNAME_TEST_CHILDREN, RegexQNamePattern.MATCH_ALL);
    }

    @Test
    public void testGetChildAssocs() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        NodeRef n1Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"root_p_n1")).getChildRef();
        ChildAssociationRef n1pn3Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n1_p_n3"));
        ChildAssociationRef n1n4Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n1_n4"));
        ChildAssociationRef n1n8Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n1_n8"));
        List childAssocRefs = this.nodeService.getChildAssocs(n1Ref);
        BaseNodeServiceTest.assertEquals((String)"Incorrect number of children", (int)3, (int)childAssocRefs.size());
        BaseNodeServiceTest.assertEquals((String)"First child added to n1 was primary to n3: Order of refs is wrong", (Object)n1pn3Ref, childAssocRefs.get(0));
        BaseNodeServiceTest.assertEquals((String)"Second child added to n1 was to n4: Order of refs is wrong", (Object)n1n4Ref, childAssocRefs.get(1));
        this.nodeService.setChildAssociationIndex(n1pn3Ref, 2);
        this.nodeService.setChildAssociationIndex(n1n8Ref, 1);
        this.nodeService.setChildAssociationIndex(n1n4Ref, 0);
        childAssocRefs = this.nodeService.getChildAssocs(n1Ref);
        BaseNodeServiceTest.assertEquals((String)"Order of refs is wrong", (Object)n1pn3Ref, childAssocRefs.get(2));
        BaseNodeServiceTest.assertEquals((String)"Order of refs is wrong", (Object)n1n8Ref, childAssocRefs.get(1));
        BaseNodeServiceTest.assertEquals((String)"Order of refs is wrong", (Object)n1n4Ref, childAssocRefs.get(0));
        List childAssocRefsByQName = this.nodeService.getChildAssocs(n1Ref, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)NAMESPACE, (String)"n1_p_n3"));
        BaseNodeServiceTest.assertEquals((String)"Expected to get exactly one match", (int)1, (int)childAssocRefsByQName.size());
        List childAssocRefsByTypeQName = this.nodeService.getChildAssocs(n1Ref, (QNamePattern)ASSOC_TYPE_QNAME_TEST_CHILDREN, RegexQNamePattern.MATCH_ALL);
        BaseNodeServiceTest.assertEquals((String)"Incorrect number of children", (int)3, (int)childAssocRefsByTypeQName.size());
        childAssocRefsByTypeQName = this.nodeService.getChildAssocs(n1Ref, (QNamePattern)ASSOC_TYPE_QNAME_TEST_CHILDREN, RegexQNamePattern.MATCH_ALL, 1, false);
        BaseNodeServiceTest.assertEquals((String)"Incorrect number of children", (int)1, (int)childAssocRefsByTypeQName.size());
    }

    @Commit
    @Test
    public void testDuplicateChildAssocCleanup() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        assocRefs.get(QName.createQName((String)NAMESPACE, (String)"root_p_n1")).getChildRef();
        ChildAssociationRef n1pn3Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n1_p_n3"));
        QName assocQName = QName.createQName((String)NAMESPACE, (String)"dup");
        ChildAssociationRef dup1 = this.nodeService.addChild(n1pn3Ref.getParentRef(), n1pn3Ref.getChildRef(), n1pn3Ref.getTypeQName(), assocQName);
        ChildAssociationRef dup2 = this.nodeService.addChild(n1pn3Ref.getParentRef(), n1pn3Ref.getChildRef(), n1pn3Ref.getTypeQName(), assocQName);
        BaseNodeServiceTest.assertEquals((String)"Duplicate not created", (Object)dup1, (Object)dup2);
        List dupAssocs = this.nodeService.getChildAssocs(n1pn3Ref.getParentRef(), (QNamePattern)n1pn3Ref.getTypeQName(), (QNamePattern)assocQName);
        BaseNodeServiceTest.assertEquals((String)"Expected duplicates", (int)2, (int)dupAssocs.size());
        this.nodeService.removeChildAssociation(dup1);
    }

    @Test
    public void testGetChildAssocsByChildType() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        NodeRef n1Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"root_p_n1")).getChildRef();
        assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n6_p_n8")).getChildRef();
        ChildAssociationRef n1pn3Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n1_p_n3"));
        ChildAssociationRef n1n4Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n1_n4"));
        ChildAssociationRef n1n8Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n1_n8"));
        List childAssocRefsContainers = this.nodeService.getChildAssocs(n1Ref, Collections.singleton(ContentModel.TYPE_CONTAINER));
        BaseNodeServiceTest.assertEquals((String)"Incorrect number of cm:container children", (int)2, (int)childAssocRefsContainers.size());
        BaseNodeServiceTest.assertTrue((String)"Expected assoc not found", (boolean)childAssocRefsContainers.contains(n1pn3Ref));
        BaseNodeServiceTest.assertTrue((String)"Expected assoc not found", (boolean)childAssocRefsContainers.contains(n1n4Ref));
        List childAssocRefsFiles = this.nodeService.getChildAssocs(n1Ref, Collections.singleton(TYPE_QNAME_TEST_CONTENT));
        BaseNodeServiceTest.assertEquals((String)"Incorrect number of test:content children", (int)1, (int)childAssocRefsFiles.size());
        BaseNodeServiceTest.assertTrue((String)"Expected assoc not found", (boolean)childAssocRefsFiles.contains(n1n8Ref));
    }

    @Test
    public void testMoveNode() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        ChildAssociationRef n2pn4Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n2_p_n4"));
        ChildAssociationRef n5pn7Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n5_p_n7"));
        ChildAssociationRef n6pn8Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n6_p_n8"));
        NodeRef n4Ref = n2pn4Ref.getChildRef();
        NodeRef n5Ref = n5pn7Ref.getParentRef();
        NodeRef n6Ref = n6pn8Ref.getParentRef();
        NodeRef n8Ref = n6pn8Ref.getChildRef();
        MovePolicyTester policy = new MovePolicyTester();
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onMoveNode"), (Object)policy, (Behaviour)new JavaBehaviour((Object)policy, "onMoveNode"));
        ChildAssociationRef assocRef = this.nodeService.moveNode(n8Ref, n5Ref, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)NAMESPACE, (String)"n5_p_n8"));
        BaseNodeServiceTest.assertEquals((String)"Move policy not fired", (int)2, (int)policy.policyAssocRefs.size());
        List n6ChildRefs = this.nodeService.getChildAssocs(n6Ref, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)NAMESPACE, (String)"n6_p_n8"));
        BaseNodeServiceTest.assertEquals((String)"Primary child assoc is still present", (int)0, (int)n6ChildRefs.size());
        ChildAssociationRef checkRef = this.nodeService.getPrimaryParent(n8Ref);
        BaseNodeServiceTest.assertEquals((String)"Primary assoc incorrent", (Object)assocRef, (Object)checkRef);
        try {
            this.nodeService.moveNode(n4Ref, n6Ref, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)NAMESPACE, (String)"n6_p_n4"));
            BaseNodeServiceTest.fail((String)"Failed to detect cyclic relationship during move");
        }
        catch (CyclicChildRelationshipException cyclicChildRelationshipException) {}
    }

    private AssociationRef createAssociation() throws Exception {
        return this.createAssociation(null);
    }

    private AssociationRef createAssociation(NodeRef sourceRef) throws Exception {
        ChildAssociationRef childAssocRef;
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(5);
        this.fillProperties(TYPE_QNAME_TEST_CONTENT, properties);
        this.fillProperties(ASPECT_QNAME_TEST_TITLED, properties);
        if (sourceRef == null) {
            childAssocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName(null, (String)"N1"), TYPE_QNAME_TEST_CONTENT, properties);
            sourceRef = childAssocRef.getChildRef();
        }
        childAssocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName(null, (String)"N2"), TYPE_QNAME_TEST_CONTENT, properties);
        NodeRef targetRef = childAssocRef.getChildRef();
        AssociationRef assocRef = this.nodeService.createAssociation(sourceRef, targetRef, ASSOC_TYPE_QNAME_TEST_NEXT);
        return assocRef;
    }

    @Test
    public void testDuplicateAssociationDetection() throws Exception {
        AssociationRef assocRef = this.createAssociation();
        NodeRef sourceRef = assocRef.getSourceRef();
        NodeRef targetRef = assocRef.getTargetRef();
        QName qname = assocRef.getTypeQName();
        try {
            this.nodeService.createAssociation(sourceRef, targetRef, qname);
            BaseNodeServiceTest.fail((String)"Duplicate assocation not detected");
        }
        catch (AssociationExistsException associationExistsException) {}
    }

    @Test
    public void testCreateAndRemoveAssociation() throws Exception {
        AssociationRef assocRef = this.createAssociation();
        NodeRef sourceRef = assocRef.getSourceRef();
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(5);
        this.fillProperties(ASPECT_QNAME_TEST_TITLED, properties);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName(null, (String)"N3"), TYPE_QNAME_TEST_CONTENT, properties);
        NodeRef anotherTargetRef = childAssocRef.getChildRef();
        AssociationRef anotherAssocRef = this.nodeService.createAssociation(sourceRef, anotherTargetRef, ASSOC_TYPE_QNAME_TEST_NEXT);
        Long anotherAssocId = anotherAssocRef.getId();
        BaseNodeServiceTest.assertNotNull((String)"Created association does not have an ID", (Object)anotherAssocId);
        AssociationRef anotherAssocRefCheck = this.nodeService.getAssoc(anotherAssocId);
        BaseNodeServiceTest.assertEquals((String)"Assoc fetched by ID is incorrect.", (Object)anotherAssocRef, (Object)anotherAssocRefCheck);
        List assocs = this.nodeService.getTargetAssocs(sourceRef, (QNamePattern)ASSOC_TYPE_QNAME_TEST_NEXT);
        for (AssociationRef assoc : assocs) {
            this.nodeService.removeAssociation(assoc.getSourceRef(), assoc.getTargetRef(), assoc.getTypeQName());
        }
    }

    @Test
    public void testGetTargetAssocs() throws Exception {
        AssociationRef assocRef = this.createAssociation();
        NodeRef sourceRef = assocRef.getSourceRef();
        assocRef.getTargetRef();
        QName qname = assocRef.getTypeQName();
        List targetAssocs = this.nodeService.getTargetAssocs(sourceRef, (QNamePattern)qname);
        BaseNodeServiceTest.assertEquals((String)"Incorrect number of targets", (int)1, (int)targetAssocs.size());
        BaseNodeServiceTest.assertTrue((String)"Target not found", (boolean)targetAssocs.contains(assocRef));
        for (AssociationRef targetAssoc : targetAssocs) {
            BaseNodeServiceTest.assertNotNull((String)"Association does not have ID", (Object)targetAssoc.getId());
        }
    }

    @Commit
    @Test
    public void testTargetAssoc_Ordering() throws Exception {
        AssociationRef assocRef = this.createAssociation();
        NodeRef sourceRef = assocRef.getSourceRef();
        assocRef.getTypeQName();
        int i = 0;
        while (i < 99) {
            assocRef = this.createAssociation(sourceRef);
            ++i;
        }
        List assocs = this.nodeService.getTargetAssocs(sourceRef, (QNamePattern)ASSOC_TYPE_QNAME_TEST_NEXT);
        Long lastId = 0L;
        for (AssociationRef associationRef : assocs) {
            Long id = associationRef.getId();
            BaseNodeServiceTest.assertNotNull((String)("Null association ID: " + associationRef), (Object)id);
            BaseNodeServiceTest.assertTrue((String)"Results should be in ID order", (id > lastId ? 1 : 0) != 0);
            lastId = id;
        }
        Comparator<AssociationRef> descendingId = new Comparator<AssociationRef>(){

            @Override
            public int compare(AssociationRef assoc1, AssociationRef assoc2) {
                return assoc1.getId().compareTo(assoc2.getId()) * -1;
            }
        };
        Collections.sort(assocs, descendingId);
        ArrayList<NodeRef> targetNodeRefs = new ArrayList<NodeRef>(100);
        for (AssociationRef associationRef : assocs) {
            targetNodeRefs.add(associationRef.getTargetRef());
        }
        int i2 = targetNodeRefs.size();
        while (i2 > 0) {
            this.nodeService.setAssociations(sourceRef, ASSOC_TYPE_QNAME_TEST_NEXT, targetNodeRefs);
            assocs = this.nodeService.getTargetAssocs(sourceRef, (QNamePattern)ASSOC_TYPE_QNAME_TEST_NEXT);
            BaseNodeServiceTest.assertEquals((String)"Incorrect number of results", (int)i2, (int)assocs.size());
            lastId = Long.MAX_VALUE;
            for (AssociationRef associationRef : assocs) {
                Long id = associationRef.getId();
                BaseNodeServiceTest.assertNotNull((String)("Null association ID: " + associationRef), (Object)id);
                BaseNodeServiceTest.assertTrue((String)"Results should be in inverse ID order", (id < lastId ? 1 : 0) != 0);
                lastId = id;
            }
            targetNodeRefs.remove(0);
            --i2;
        }
    }

    @Test
    public void testGetTargetAssocsByPropertyValue() throws Exception {
        AssociationRef assocRef = this.createAssociation();
        NodeRef sourceRef = assocRef.getSourceRef();
        this.createAssociation(sourceRef);
        NodeRef targetRef = assocRef.getTargetRef();
        QName qname = assocRef.getTypeQName();
        List targetAssocs = this.nodeService.getTargetAssocsByPropertyValue(sourceRef, (QNamePattern)qname, null, null);
        BaseNodeServiceTest.assertEquals((String)"Incorrect number of targets", (int)2, (int)targetAssocs.size());
        HashMap<QName, Object> checkProperties = new HashMap<QName, Object>();
        checkProperties.put(ContentModel.PROP_ENABLED, Boolean.TRUE);
        checkProperties.put(ContentModel.PROP_COUNTER, 100);
        checkProperties.put(ContentModel.PROP_LATITUDE, new Double(51.521));
        checkProperties.put(ContentModel.PROP_SUBJECT, "Hello World");
        for (QName propertyQName : checkProperties.keySet()) {
            Serializable propertyValue = (Serializable)checkProperties.get(propertyQName);
            this.nodeService.setProperty(targetRef, propertyQName, propertyValue);
            targetAssocs = this.nodeService.getTargetAssocsByPropertyValue(sourceRef, (QNamePattern)qname, propertyQName, propertyValue);
            BaseNodeServiceTest.assertEquals((String)"Incorrect number of targets", (int)1, (int)targetAssocs.size());
            BaseNodeServiceTest.assertTrue((String)"Target not found", (boolean)targetAssocs.contains(assocRef));
            AssociationRef targetAssoc = (AssociationRef)targetAssocs.get(0);
            BaseNodeServiceTest.assertNotNull((String)"Association does not have ID", (Object)targetAssoc.getId());
            NodeRef targetRefFound = targetAssoc.getTargetRef();
            BaseNodeServiceTest.assertEquals((String)"Incorrect value found", (Object)propertyValue, (Object)this.nodeService.getProperty(targetRefFound, propertyQName));
        }
        try {
            targetAssocs = this.nodeService.getTargetAssocsByPropertyValue(sourceRef, (QNamePattern)qname, ContentModel.PROP_NODE_DBID, (Serializable)((Object)"Fail"));
            BaseNodeServiceTest.fail((String)"sys:node-dbid not rejected");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            String title = (String)((Object)this.nodeService.getProperty(sourceRef, ContentModel.PROP_TITLE));
            targetAssocs = this.nodeService.getTargetAssocsByPropertyValue(sourceRef, (QNamePattern)qname, ContentModel.PROP_NAME, (Serializable)((Object)title));
            BaseNodeServiceTest.fail((String)"MLText type not rejected");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testGetSourceAssocs() throws Exception {
        AssociationRef assocRef = this.createAssociation();
        assocRef.getSourceRef();
        NodeRef targetRef = assocRef.getTargetRef();
        QName qname = assocRef.getTypeQName();
        List sourceAssocs = this.nodeService.getSourceAssocs(targetRef, (QNamePattern)qname);
        BaseNodeServiceTest.assertEquals((String)"Incorrect number of source assocs", (int)1, (int)sourceAssocs.size());
        BaseNodeServiceTest.assertTrue((String)"Source not found", (boolean)sourceAssocs.contains(assocRef));
        for (AssociationRef sourceAssoc : sourceAssocs) {
            BaseNodeServiceTest.assertNotNull((String)"Association does not have ID", (Object)sourceAssoc.getId());
        }
    }

    @Test
    public void testGetPath() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        NodeRef n8Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n6_p_n8")).getChildRef();
        Path path = this.nodeService.getPath(n8Ref);
        BaseNodeServiceTest.assertEquals((String)"Primary path incorrect", (String)"/{http://www.alfresco.org/test/BaseNodeServiceTest}root_p_n1/{http://www.alfresco.org/test/BaseNodeServiceTest}n1_p_n3/{http://www.alfresco.org/test/BaseNodeServiceTest}n3_p_n6/{http://www.alfresco.org/test/BaseNodeServiceTest}n6_p_n8", (String)path.toString());
    }

    @Test
    public void testGetPaths() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        NodeRef n1Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"root_p_n1")).getChildRef();
        NodeRef n6Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n3_p_n6")).getChildRef();
        NodeRef n8Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n6_p_n8")).getChildRef();
        List paths = this.nodeService.getPaths(this.rootNodeRef, false);
        BaseNodeServiceTest.assertEquals((String)"Root node must have exactly 1 path", (int)1, (int)paths.size());
        Path rootPath = paths.toArray(new Path[1])[0];
        BaseNodeServiceTest.assertNotNull((String)"Root node path must have 1 element", (Object)rootPath.last());
        BaseNodeServiceTest.assertEquals((String)"Root node path must have 1 element", (Object)rootPath.first(), (Object)rootPath.last());
        paths = this.nodeService.getPaths(n8Ref, false);
        BaseNodeServiceTest.assertEquals((String)"Incorrect path count", (int)6, (int)paths.size());
        for (Path path : paths) {
            for (Path.Element element : path) {
                BaseNodeServiceTest.assertTrue((String)"Path element of incorrect type", (boolean)(element instanceof Path.ChildAssocElement));
                Path.ChildAssocElement childAssocElement = (Path.ChildAssocElement)element;
                ChildAssociationRef ref = childAssocElement.getRef();
                if (childAssocElement != path.first()) {
                    BaseNodeServiceTest.assertNotNull((String)"Parent node ref not set", (Object)ref.getParentRef());
                    BaseNodeServiceTest.assertNotNull((String)"QName not set", (Object)ref.getQName());
                }
                BaseNodeServiceTest.assertNotNull((String)"Child node ref not set", (Object)ref.getChildRef());
            }
        }
        paths = this.nodeService.getPaths(n8Ref, true);
        BaseNodeServiceTest.assertEquals((String)"Incorrect path count", (int)1, (int)paths.size());
        try {
            this.nodeService.addChild(n6Ref, n1Ref, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"n6_n1"));
            this.nodeService.getPaths(n6Ref, false);
            BaseNodeServiceTest.fail((String)"Cyclic relationship not detected");
        }
        catch (CyclicChildRelationshipException cyclicChildRelationshipException) {
        }
        catch (StackOverflowError e) {
            throw e;
        }
    }

    @Test
    public void testPrimaryPathCascadeDelete() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        NodeRef n1Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"root_p_n1")).getChildRef();
        NodeRef n6Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n3_p_n6")).getChildRef();
        NodeRef n8Ref = assocRefs.get(QName.createQName((String)NAMESPACE, (String)"n6_p_n8")).getChildRef();
        this.nodeService.deleteNode(n1Ref);
        BaseNodeServiceTest.assertFalse((String)"n6 not cascade deleted", (boolean)this.nodeService.exists(n6Ref));
        BaseNodeServiceTest.assertFalse((String)"n8 not cascade deleted", (boolean)this.nodeService.exists(n8Ref));
    }

    @Test
    public void testDefaultValues() throws Exception {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"testDefaultValues"), TYPE_QNAME_EXTENDED_CONTENT).getChildRef();
        BaseNodeServiceTest.assertEquals((Object)DEFAULT_VALUE, (Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_PROP1));
        this.nodeService.addAspect(nodeRef, ASPECT_QNAME_WITH_DEFAULT_VALUE, null);
        BaseNodeServiceTest.assertEquals((Object)DEFAULT_VALUE, (Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_PROP2));
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(PROP_QNAME_PROP1, NOT_DEFAULT_VALUE);
        NodeRef nodeRef2 = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"testDefaultValues"), TYPE_QNAME_EXTENDED_CONTENT, props).getChildRef();
        BaseNodeServiceTest.assertEquals((Object)NOT_DEFAULT_VALUE, (Object)this.nodeService.getProperty(nodeRef2, PROP_QNAME_PROP1));
        HashMap<QName, String> prop2 = new HashMap<QName, String>(1);
        prop2.put(PROP_QNAME_PROP2, NOT_DEFAULT_VALUE);
        this.nodeService.addAspect(nodeRef2, ASPECT_QNAME_WITH_DEFAULT_VALUE, prop2);
        BaseNodeServiceTest.assertEquals((Object)NOT_DEFAULT_VALUE, (Object)this.nodeService.getProperty(nodeRef2, PROP_QNAME_PROP2));
    }

    @Test
    public void testMandatoryAspects() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"testDefaultValues"), TYPE_QNAME_TEST_CONTENT).getChildRef();
        BaseNodeServiceTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_TITLED));
        BaseNodeServiceTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_MANDATORY));
        this.nodeService.addAspect(nodeRef, ASPECT_QNAME_TEST_MARKER, null);
        BaseNodeServiceTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_MARKER));
        BaseNodeServiceTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_MARKER2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void garbageCollect() throws Exception {
        int i = 0;
        while (i < 50) {
            Runtime.getRuntime().gc();
            BaseNodeServiceTest baseNodeServiceTest = this;
            synchronized (baseNodeServiceTest) {
                ((Object)((Object)this)).wait(20L);
            }
            ++i;
        }
    }

    private void reportFlushPerformance(String msg, Map<QName, ChildAssociationRef> lastNodeGraph, int testCount, long startBytes, long startTime) throws Exception {
        long endTime = System.nanoTime();
        double deltaTime = (double)(endTime - startTime) / 1.0E9;
        System.out.println(String.valueOf(msg) + "\n" + "   Build and flushed " + testCount + " node graphs: \n" + "   total time: " + deltaTime + "s \n" + "   average: " + (double)testCount / deltaTime + " graphs/s");
        this.garbageCollect();
        long endBytes = Runtime.getRuntime().freeMemory();
        double diffBytes = startBytes - endBytes;
        System.out.println("   total bytes: " + diffBytes / 1024.0 / 1024.0 + " MB \n" + "   average: " + diffBytes / (double)testCount / 1024.0 + " kb/graph");
        int assocsPerGraph = lastNodeGraph.size();
        int nodesPerGraph = 0;
        for (ChildAssociationRef assoc : lastNodeGraph.values()) {
            if (!assoc.getQName().toString().contains("_p_")) continue;
            ++nodesPerGraph;
        }
        int totalAssocs = assocsPerGraph * testCount;
        int totalNodes = nodesPerGraph * testCount;
        System.out.println("   assocs per graph: " + assocsPerGraph + "\n" + "   nodes per graph: " + nodesPerGraph + "\n" + "   total nodes: " + totalNodes + "\n" + "   total assocs: " + totalAssocs);
    }

    @Test
    public void testDuplicateCatch() throws Exception {
        NodeRef parentRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"parent_child"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CONTAINS, QName.createQName((String)"pathA"), ContentModel.TYPE_CONTENT);
        this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CONTAINS, QName.createQName((String)"pathB"), ContentModel.TYPE_CONTENT);
        this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CONTAINS, QName.createQName((String)"pathB"), ContentModel.TYPE_CONTENT);
        HashMap<QName, String> props = new HashMap<QName, String>(5);
        props.put(ContentModel.PROP_NAME, "ABC");
        this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CONTAINS, QName.createQName((String)"ABC"), ContentModel.TYPE_CONTENT, props);
        try {
            props.put(ContentModel.PROP_NAME, "abc");
            this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CONTAINS, QName.createQName((String)"ABC-duplicate"), ContentModel.TYPE_CONTENT, props);
            BaseNodeServiceTest.fail((String)"Failed to throw duplicate child name exception");
        }
        catch (DuplicateChildNodeNameException duplicateChildNodeNameException) {}
    }

    @Test
    public void testNonDuplicateAssocsWithSuppliedName() throws Throwable {
        Map<QName, String> properties = Collections.singletonMap(ContentModel.PROP_NAME, ((Object)((Object)this)).getClass().getName());
        NodeRef parentRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"parent_child"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), ContentModel.TYPE_CONTENT, properties);
        this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathB"), ContentModel.TYPE_CONTENT, properties);
    }

    @Test
    public void testDuplicateAssocsWithoutSuppliedName() throws Throwable {
        Map properties = Collections.emptyMap();
        NodeRef parentRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"parent_child"), ContentModel.TYPE_CONTAINER).getChildRef();
        ChildAssociationRef pathARef = this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CONTAINS, QName.createQName((String)"pathA"), ContentModel.TYPE_CONTENT, properties);
        try {
            this.nodeService.addChild(parentRef, pathARef.getChildRef(), ASSOC_TYPE_QNAME_TEST_CONTAINS, QName.createQName((String)"pathB"));
            BaseNodeServiceTest.fail((String)"Re-added node to parent when cm:name was not set; it should have failed.");
        }
        catch (DuplicateChildNodeNameException duplicateChildNodeNameException) {}
    }

    @Test
    public void testDeleteAndAddSameName() throws Exception {
        NodeRef parentRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"parent_child"), ContentModel.TYPE_CONTAINER).getChildRef();
        HashMap<QName, String> props = new HashMap<QName, String>(5);
        props.put(ContentModel.PROP_NAME, "ABC");
        ChildAssociationRef pathAbcRef = this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CONTAINS, QName.createQName((String)"ABC"), ContentModel.TYPE_CONTENT, props);
        NodeRef abcRef = pathAbcRef.getChildRef();
        this.nodeService.deleteNode(abcRef);
        pathAbcRef = this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CONTAINS, QName.createQName((String)"ABC"), ContentModel.TYPE_CONTENT, props);
    }

    @Test
    public void testGetByName() throws Exception {
        NodeRef parentRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"parent_child"), ContentModel.TYPE_CONTAINER).getChildRef();
        HashMap<QName, String> props = new HashMap<QName, String>(5);
        props.put(ContentModel.PROP_NAME, "ABC");
        ChildAssociationRef pathAbcRef = this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CONTAINS, QName.createQName((String)"ABC"), ContentModel.TYPE_CONTENT, props);
        NodeRef abcRef = pathAbcRef.getChildRef();
        props.put(ContentModel.PROP_NAME, "DEF");
        ChildAssociationRef pathDefRef = this.nodeService.createNode(abcRef, ASSOC_TYPE_QNAME_TEST_CONTAINS, QName.createQName((String)"DEF"), ContentModel.TYPE_CONTENT, props);
        NodeRef defRef = pathDefRef.getChildRef();
        props.put(ContentModel.PROP_NAME, "KLM");
        ChildAssociationRef pathKlmRef = this.nodeService.createNode(abcRef, ASSOC_TYPE_QNAME_TEST_CONTAINS, QName.createQName((String)"KLM"), ContentModel.TYPE_CONTENT, props);
        pathDefRef.getChildRef();
        NodeRef checkAbcRef = this.nodeService.getChildByName(parentRef, ASSOC_TYPE_QNAME_TEST_CONTAINS, "abc");
        BaseNodeServiceTest.assertNotNull((String)"Second level, named node 'ABC' not found", (Object)checkAbcRef);
        BaseNodeServiceTest.assertEquals((Object)abcRef, (Object)checkAbcRef);
        NodeRef checkDefRef = this.nodeService.getChildByName(checkAbcRef, ASSOC_TYPE_QNAME_TEST_CONTAINS, "def");
        BaseNodeServiceTest.assertNotNull((String)"Third level, named node 'DEF' not found", (Object)checkDefRef);
        BaseNodeServiceTest.assertEquals((Object)defRef, (Object)checkDefRef);
        NodeRef checkHijRef = this.nodeService.getChildByName(checkAbcRef, ASSOC_TYPE_QNAME_TEST_CONTAINS, "hij");
        BaseNodeServiceTest.assertNull((String)"Third level, named node 'HIJ' should not have been found", (Object)checkHijRef);
        List<String> namesList = Arrays.asList("ABC", "DEF", "HIJ", "KLM");
        List childAssocRefs = this.nodeService.getChildrenByName(checkAbcRef, ASSOC_TYPE_QNAME_TEST_CONTAINS, namesList);
        BaseNodeServiceTest.assertEquals((String)"Expected exactly 2 results", (int)2, (int)childAssocRefs.size());
        BaseNodeServiceTest.assertTrue((String)"Expected result not included", (boolean)childAssocRefs.contains(pathDefRef));
        BaseNodeServiceTest.assertTrue((String)"Expected result not included", (boolean)childAssocRefs.contains(pathKlmRef));
    }

    @Commit
    @Test
    public void testLocalizedAspect() throws Exception {
        this.nodeService.addAspect(this.rootNodeRef, ContentModel.ASPECT_LOCALIZED, Collections.singletonMap(ContentModel.PROP_LOCALE, Locale.CANADA_FRENCH));
    }

    @Test
    public void testAR1303() throws Exception {
        PolicyComponent policyComponent = (PolicyComponent)this.applicationContext.getBean("policyComponent");
        JavaBehaviour behaviour = new JavaBehaviour((Object)this, "onUpdateProperties");
        BehaviourDefinition bindClassBehaviour = null;
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, "test_testAR1303.txt");
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, props).getChildRef();
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TITLED, null);
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"my description"));
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"my title"));
        try {
            bindClassBehaviour = policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), ContentModel.ASPECT_TITLED, (Behaviour)behaviour);
            behaviourExecuted = false;
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"changed title"));
            BaseNodeServiceTest.assertTrue((String)"The onUpdateProperties behaviour has not been fired.", (boolean)behaviourExecuted);
        }
        catch (Throwable throwable) {
            if (bindClassBehaviour != null) {
                policyComponent.removeClassDefinition(bindClassBehaviour);
            }
            throw throwable;
        }
        if (bindClassBehaviour != null) {
            policyComponent.removeClassDefinition(bindClassBehaviour);
        }
    }

    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        behaviourExecuted = true;
        BaseNodeServiceTest.assertFalse((String)("Should not be equal:\nbefore: " + before.get(ContentModel.PROP_TITLE) + "\nafter: " + after.get(ContentModel.PROP_TITLE)), (boolean)String.valueOf(before.get(ContentModel.PROP_TITLE)).equals(String.valueOf(after.get(ContentModel.PROP_TITLE))));
    }

    @Test
    public void testAR782() throws Exception {
        Map properties = this.nodeService.getProperties(this.rootNodeRef);
        properties.put(ContentModel.PROP_ACCOUNT_EXPIRY_DATE, new Date());
        this.nodeService.setProperties(this.rootNodeRef, properties);
        try {
            properties.put(ContentModel.PROP_ACCOUNT_EXPIRY_DATE, "blah");
            this.nodeService.setProperties(this.rootNodeRef, properties);
            BaseNodeServiceTest.fail((String)"Failed to catch type conversion issue early.");
        }
        catch (TypeConversionException typeConversionException) {}
    }

    @Test
    public void testAR1414() throws Exception {
        AR1414Blob blob = new AR1414Blob();
        QName propertyQName = QName.createQName((String)NAMESPACE, (String)"testAR1414Prop");
        this.nodeService.setProperty(this.rootNodeRef, propertyQName, (Serializable)blob);
        blob.i = 100;
        AR1414Blob checkBlob = (AR1414Blob)this.nodeService.getProperty(this.rootNodeRef, propertyQName);
        BaseNodeServiceTest.assertNotNull((Object)checkBlob);
        BaseNodeServiceTest.assertEquals((String)"Blob was modified while persisted", (int)0, (int)checkBlob.i);
    }

    @Test
    public void testGetNodeRefById() {
        Long nodeId = (Long)this.nodeService.getProperty(this.rootNodeRef, ContentModel.PROP_NODE_DBID);
        BaseNodeServiceTest.assertEquals((String)"Incorrect NodeRef back ", (Object)this.rootNodeRef, (Object)this.nodeService.getNodeRef(nodeId));
    }

    private static class AR1414Blob
    implements Serializable {
        private static final long serialVersionUID = 5616094206968290908L;
        int i = 0;

        private AR1414Blob() {
        }
    }

    public static class BadOnDeleteNodePolicy
    implements NodeServicePolicies.OnDeleteNodePolicy,
    NodeServicePolicies.BeforeDeleteNodePolicy {
        private NodeService nodeService;
        private List<NodeRef> deletedNodeRefs;
        private List<NodeRef> beforeDeleteNodeRefs;
        private boolean onDeleteCreateChild = true;
        private boolean beforeDeleteCreateChild = true;

        public BadOnDeleteNodePolicy(NodeService nodeService, List<NodeRef> beforeDeleteNodeRefs, List<NodeRef> deletedNodeRefs) {
            this.nodeService = nodeService;
            this.beforeDeleteNodeRefs = beforeDeleteNodeRefs;
            this.deletedNodeRefs = deletedNodeRefs;
        }

        public void beforeDeleteNode(NodeRef nodeRef) {
            this.nodeService.getProperties(nodeRef);
            this.beforeDeleteNodeRefs.add(nodeRef);
            if (this.beforeDeleteCreateChild) {
                System.out.println("before delete node - add child.");
                this.nodeService.createNode(nodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pre-delete new child"), ContentModel.TYPE_CONTAINER);
                this.nodeService.setProperty(nodeRef, PROP_QNAME_BOOLEAN_VALUE, (Serializable)((Object)"true"));
                this.nodeService.addAspect(nodeRef, ASPECT_QNAME_TEST_TITLED, null);
            }
        }

        public void onDeleteNode(ChildAssociationRef childAssocRef, boolean isArchivedNode) {
            this.deletedNodeRefs.add(childAssocRef.getChildRef());
            if (this.onDeleteCreateChild) {
                System.out.println("on delete node - add sibling.");
                NodeRef parentRef = childAssocRef.getParentRef();
                childAssocRef.getChildRef();
                this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"post-delete new child"), ContentModel.TYPE_CONTAINER);
            }
        }

        private void setOnDeleteCreateChild(boolean onDeleteCreateChild) {
            this.onDeleteCreateChild = onDeleteCreateChild;
        }

        private boolean isOnDeleteCreateChild() {
            return this.onDeleteCreateChild;
        }

        private void setBeforeDeleteCreateChild(boolean beforeDeleteCreateChild) {
            this.beforeDeleteCreateChild = beforeDeleteCreateChild;
        }

        private boolean isBeforeDeleteCreateChild() {
            return this.beforeDeleteCreateChild;
        }
    }

    public static class BeforeDeletePolicyTester
    implements NodeServicePolicies.BeforeDeleteChildAssociationPolicy {
        ChildAssociationRef childRef;

        public void beforeDeleteChildAssociation(ChildAssociationRef childAssocRef) {
            this.childRef = childAssocRef;
        }
    }

    public static class MovePolicyTester
    implements NodeServicePolicies.OnMoveNodePolicy {
        public List<ChildAssociationRef> policyAssocRefs = new ArrayList<ChildAssociationRef>(2);

        public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
            this.policyAssocRefs.add(oldChildAssocRef);
            this.policyAssocRefs.add(newChildAssocRef);
        }
    }

    public static enum TestEnum {
        TEST_ONE,
        TEST_TWO;

    }
}

