/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.history.HistoricProcessInstance;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.workflow.AbstractWorkflowServiceIntegrationTest;
import org.alfresco.repo.workflow.WorkflowBuilder;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowInstanceQuery;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LuceneTests.class})
public class ActivitiWorkflowServiceIntegrationTest
extends AbstractWorkflowServiceIntegrationTest {
    private static final String USER_RECREATED = "WFUserRecreated" + GUID.generate();
    public static final String ACTIVITI_TEST_TRANSACTION_BPMN20_XML = "activiti/testTransaction.bpmn20.xml";
    public static final String ALFRESCO_WORKFLOW_ADHOC_BPMN20_XML = "alfresco/workflow/adhoc.bpmn20.xml";
    public static final String ALFRESCO_WORKFLOW_REVIEW_POOLED_BPMN20_XML = "alfresco/workflow/review-pooled.bpmn20.xml";
    public static final String ALFRESCO_WORKFLOW_PARALLEL_REVIEW_BPMN20_XML = "alfresco/workflow/parallel-review.bpmn20.xml";
    public static final String ACTIVITI_TEST_TIMER_BPMN20_XML = "activiti/testTimer.bpmn20.xml";
    public static final String ACTIVITI_TEST_WITH_SUB_PROCESS_XML = "activiti/testWorkflowWithSubprocess.xml";

    @Test
    public void testOutcome() throws Exception {
        WorkflowDefinition definition = this.deployDefinition("alfresco/workflow/review.bpmn20.xml");
        this.personManager.setUser(AbstractWorkflowServiceIntegrationTest.USER1);
        HashMap<QName, NodeRef> params = new HashMap<QName, NodeRef>();
        NodeRef wfPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, wfPackage);
        NodeRef assignee = this.personManager.get(AbstractWorkflowServiceIntegrationTest.USER2);
        params.put(WorkflowModel.ASSOC_ASSIGNEE, assignee);
        WorkflowPath path = this.workflowService.startWorkflow(definition.getId(), params);
        String instanceId = path.getInstance().getId();
        WorkflowTask startTask = this.workflowService.getStartTask(instanceId);
        this.workflowService.endTask(startTask.getId(), null);
        List paths = this.workflowService.getWorkflowPaths(instanceId);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((int)1, (int)paths.size());
        path = (WorkflowPath)paths.get(0);
        List tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        ActivitiWorkflowServiceIntegrationTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask reviewTask = (WorkflowTask)tasks.get(0);
        QName outcomePropName = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"reviewOutcome");
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(outcomePropName, "Approve");
        this.workflowService.updateTask(reviewTask.getId(), props, null, null);
        WorkflowTask result = this.workflowService.endTask(reviewTask.getId(), null);
        Serializable outcome = (Serializable)result.getProperties().get(WorkflowModel.PROP_OUTCOME);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((Object)"Approve", (Object)outcome);
    }

    @Test
    public void testStartTaskEndsAutomatically() {
        WorkflowDefinition definition = this.deployDefinition(this.getTestDefinitionPath());
        WorkflowPath path = this.workflowService.startWorkflow(definition.getId(), null);
        String instanceId = path.getInstance().getId();
        WorkflowTask startTask = this.workflowService.getStartTask(instanceId);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((Object)WorkflowTaskState.COMPLETED, (Object)startTask.getState());
        List tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        ActivitiWorkflowServiceIntegrationTest.assertEquals((int)1, (int)tasks.size());
        String taskName = ((WorkflowTask)tasks.get(0)).getName();
        ActivitiWorkflowServiceIntegrationTest.assertEquals((String)"bpm_foo_task", (String)taskName);
    }

    @Test
    public void testPriorityIsValid() {
        WorkflowDefinition definition = this.deployDefinition("activiti/testCustomActiviti.bpmn20.xml");
        this.personManager.setUser(AbstractWorkflowServiceIntegrationTest.USER1);
        WorkflowPath path = this.workflowService.startWorkflow(definition.getId(), null);
        String instanceId = path.getInstance().getId();
        WorkflowTask startTask = this.workflowService.getStartTask(instanceId);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((Object)WorkflowTaskState.COMPLETED, (Object)startTask.getState());
        List tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        for (WorkflowTask workflowTask : tasks) {
            Map props = workflowTask.getProperties();
            TypeDefinition typeDefinition = workflowTask.getDefinition().getMetadata();
            Map propertyDefs = typeDefinition.getProperties();
            PropertyDefinition priorDef = (PropertyDefinition)propertyDefs.get(WorkflowModel.PROP_PRIORITY);
            ActivitiWorkflowServiceIntegrationTest.assertEquals(props.get(WorkflowModel.PROP_PRIORITY), (Object)Integer.valueOf(priorDef.getDefaultValue()));
        }
    }

    @Test
    public void testReviewAndPooledNotModifiedDate() {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, "MNT-11522-testfile.txt");
        ChildAssociationRef childAssoc = this.nodeService.createNode(this.companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)"MNT-11522-test"), ContentModel.TYPE_CONTENT, props);
        NodeRef addedNodeRef = childAssoc.getChildRef();
        Date lastModifiedDate = (Date)this.nodeService.getProperty(addedNodeRef, ContentModel.PROP_MODIFIED);
        WorkflowDefinition definition = this.deployDefinition(this.getPooledReviewDefinitionPath());
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)definition);
        HashMap<QName, NodeRef> params = new HashMap<QName, NodeRef>();
        NodeRef workflowPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, workflowPackage);
        NodeRef group = this.groupManager.get(AbstractWorkflowServiceIntegrationTest.GROUP);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)group);
        params.put(WorkflowModel.ASSOC_GROUP_ASSIGNEE, group);
        this.nodeService.addChild(workflowPackage, addedNodeRef, WorkflowModel.ASSOC_PACKAGE_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)((String)((Object)this.nodeService.getProperty(addedNodeRef, ContentModel.PROP_NAME))))));
        WorkflowPath workflowPath = this.workflowService.startWorkflow(definition.getId(), params);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)workflowPath);
        ActivitiWorkflowServiceIntegrationTest.assertTrue((boolean)workflowPath.isActive());
        String workflowInstanceId = workflowPath.getInstance().getId();
        List pooledTasks = this.workflowService.getPooledTasks(AbstractWorkflowServiceIntegrationTest.GROUP);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)pooledTasks);
        WorkflowTask startTask = this.workflowService.getStartTask(workflowInstanceId);
        String startTaskId = startTask.getId();
        this.workflowService.endTask(startTaskId, null);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((Object)lastModifiedDate, (Object)this.nodeService.getProperty(addedNodeRef, ContentModel.PROP_MODIFIED));
    }

    @Test
    public void testGetWorkflowTaskDefinitionsWithMultiInstanceTask() {
        WorkflowDefinition definition = this.deployDefinition(this.getParallelReviewDefinitionPath());
        String workflowDefId = definition.getId();
        List taskDefs = this.workflowService.getTaskDefinitions(workflowDefId);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((int)4, (int)taskDefs.size());
        WorkflowTaskDefinition taskDef = (WorkflowTaskDefinition)taskDefs.get(1);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((String)"wf:activitiReviewTask", (String)taskDef.getId());
    }

    @Test
    public void testCompletedTaskInWorkflowWithSubProcess() {
        WorkflowDefinition definition = this.deployDefinition(ACTIVITI_TEST_WITH_SUB_PROCESS_XML);
        String workflowDefId = definition.getId();
        List taskDefs = this.workflowService.getTaskDefinitions(workflowDefId);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((int)2, (int)taskDefs.size());
        ActivitiWorkflowServiceIntegrationTest.assertEquals((String)"Alfresco start", (String)((WorkflowTaskDefinition)taskDefs.get(0)).getNode().getTitle());
        ActivitiWorkflowServiceIntegrationTest.assertEquals((String)"Alfresco User Task", (String)((WorkflowTaskDefinition)taskDefs.get(1)).getNode().getTitle());
    }

    @Test
    public void testAccessStartTaskAsAssigneeFromTaskPartOfProcess() {
        WorkflowDefinition definition = this.deployDefinition(this.getAdhocDefinitionPath());
        this.personManager.setUser(AbstractWorkflowServiceIntegrationTest.USER1);
        HashMap<QName, NodeRef> params = new HashMap<QName, NodeRef>();
        NodeRef wfPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, wfPackage);
        NodeRef assignee = this.personManager.get(AbstractWorkflowServiceIntegrationTest.USER2);
        params.put(WorkflowModel.ASSOC_ASSIGNEE, assignee);
        WorkflowPath path = this.workflowService.startWorkflow(definition.getId(), params);
        String instanceId = path.getInstance().getId();
        WorkflowTask startTask = this.workflowService.getStartTask(instanceId);
        this.workflowService.endTask(startTask.getId(), null);
        List taskPackage = this.workflowService.getPackageContents(startTask.getId());
        ActivitiWorkflowServiceIntegrationTest.assertTrue((boolean)taskPackage.isEmpty());
        List packageContents = this.workflowService.getPackageContents(wfPackage);
        ActivitiWorkflowServiceIntegrationTest.assertTrue((boolean)packageContents.isEmpty());
        List tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        ActivitiWorkflowServiceIntegrationTest.assertEquals((int)1, (int)tasks.size());
        this.workflowService.updateTask(((WorkflowTask)tasks.get(0)).getId(), Collections.singletonMap(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(AbstractWorkflowServiceIntegrationTest.USER3)), null, null);
        this.personManager.setUser(AbstractWorkflowServiceIntegrationTest.USER3);
        startTask = this.workflowService.getStartTask(instanceId);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)startTask);
        startTask = this.workflowService.getTaskById(startTask.getId());
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)startTask);
        this.personManager.setUser(AbstractWorkflowServiceIntegrationTest.USER4);
        try {
            this.workflowService.getStartTask(instanceId);
            ActivitiWorkflowServiceIntegrationTest.fail((String)"AccessDeniedException expected");
        }
        catch (AccessDeniedException accessDeniedException) {}
        try {
            this.workflowService.getTaskById(startTask.getId());
            ActivitiWorkflowServiceIntegrationTest.fail((String)"AccessDeniedException expected");
        }
        catch (AccessDeniedException accessDeniedException) {}
    }

    @Test
    public void testMultiInstanceListenersCalled() throws Exception {
        WorkflowDefinition workflowDef = this.deployDefinition(this.getParallelReviewDefinitionPath());
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)workflowDef);
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        NodeRef wfPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, wfPackage);
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, 1);
        params.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, "This is the description");
        NodeRef group = this.groupManager.get(AbstractWorkflowServiceIntegrationTest.GROUP);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)group);
        List<NodeRef> assignees = Arrays.asList(this.personManager.get(AbstractWorkflowServiceIntegrationTest.USER2), this.personManager.get(AbstractWorkflowServiceIntegrationTest.USER3));
        params.put(WorkflowModel.ASSOC_ASSIGNEES, (Serializable)((Object)assignees));
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.getId(), params);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)path);
        ActivitiWorkflowServiceIntegrationTest.assertTrue((boolean)path.isActive());
        String instnaceId = path.getInstance().getId();
        WorkflowTask startTask = this.workflowService.getStartTask(instnaceId);
        this.workflowService.endTask(startTask.getId(), null);
        this.personManager.setUser(AbstractWorkflowServiceIntegrationTest.USER2);
        List tasks = this.workflowService.getAssignedTasks(AbstractWorkflowServiceIntegrationTest.USER2, WorkflowTaskState.IN_PROGRESS);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((int)1, (int)tasks.size());
        ActivitiWorkflowServiceIntegrationTest.assertEquals((String)"Documents for review and approval", (String)((WorkflowTask)tasks.get(0)).getDescription());
        ActivitiWorkflowServiceIntegrationTest.assertEquals((Object)"This is the description", ((WorkflowTask)tasks.get(0)).getProperties().get(WorkflowModel.PROP_DESCRIPTION));
    }

    @Test
    public void testLongTextValues() throws Exception {
        String veryLongTextValue = this.getLongString(10000);
        WorkflowDefinition workflowDef = this.deployDefinition(this.getAdhocDefinitionPath());
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)workflowDef);
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        NodeRef wfPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, wfPackage);
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, 1);
        params.put(WorkflowModel.PROP_COMMENT, veryLongTextValue);
        NodeRef assignee = this.personManager.get(AbstractWorkflowServiceIntegrationTest.USER2);
        params.put(WorkflowModel.ASSOC_ASSIGNEE, assignee);
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.getId(), params);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)path);
        WorkflowTask startTask = this.workflowService.getStartTask(path.getInstance().getId());
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)startTask);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((Object)veryLongTextValue, startTask.getProperties().get(WorkflowModel.PROP_COMMENT));
    }

    @Test
    public void testAssignmentListener() {
        WorkflowDefinition definition = this.deployDefinition(this.getAssignmentListenerDefinitionPath());
        HashMap<QName, String> params = new HashMap<QName, String>();
        params.put(ContentModel.PROP_OWNER, AbstractWorkflowServiceIntegrationTest.USER1);
        NodeRef assignee = this.personManager.get(AbstractWorkflowServiceIntegrationTest.USER1);
        params.put(WorkflowModel.ASSOC_ASSIGNEE, (String)assignee);
        WorkflowPath path = this.workflowService.startWorkflow(definition.getId(), params);
        List tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        this.workflowService.endTask(((WorkflowTask)tasks.get(0)).getId(), null);
        tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        this.workflowService.updateTask(((WorkflowTask)tasks.get(0)).getId(), params, null, null);
        this.workflowService.endTask(((WorkflowTask)tasks.get(0)).getId(), null);
        WorkflowTask result = this.workflowService.getTaskById(((WorkflowTask)tasks.get(0)).getId());
        Map props = result.getProperties();
        Double create1 = (Double)props.get(QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"create1"));
        ActivitiWorkflowServiceIntegrationTest.assertEquals((String)"Create listener was not triggered", (Object)new Double(1.0), (Object)create1);
        Double complete1 = (Double)props.get(QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"complete1"));
        ActivitiWorkflowServiceIntegrationTest.assertEquals((String)"Complete listener was not triggered", (Object)new Double(1.0), (Object)complete1);
        Double assignment1 = (Double)props.get(QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"assignment1"));
        ActivitiWorkflowServiceIntegrationTest.assertEquals((String)"Assign listener was not triggered", (Object)new Double(1.0), (Object)assignment1);
    }

    @Test
    public void testWorkflowRecreatedUser() {
        WorkflowDefinition definition = this.deployDefinition("alfresco/workflow/review.bpmn20.xml");
        this.personManager.createPerson(USER_RECREATED);
        this.personManager.setUser(USER_RECREATED);
        HashMap<QName, NodeRef> params = new HashMap<QName, NodeRef>();
        NodeRef wfPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, wfPackage);
        NodeRef assignee = this.personManager.get(AbstractWorkflowServiceIntegrationTest.USER2);
        params.put(WorkflowModel.ASSOC_ASSIGNEE, assignee);
        WorkflowPath path = this.workflowService.startWorkflow(definition.getId(), params);
        String instanceId = path.getInstance().getId();
        WorkflowTask startTask = this.workflowService.getStartTask(instanceId);
        String owner = (String)startTask.getProperties().get(ContentModel.PROP_OWNER);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((String)owner, (String)USER_RECREATED);
        this.personManager.deletePerson(USER_RECREATED);
        this.personManager.createPerson(USER_RECREATED);
        this.personManager.setUser(USER_RECREATED);
        startTask = this.workflowService.getStartTask(instanceId);
        owner = (String)startTask.getProperties().get(ContentModel.PROP_OWNER);
        ActivitiWorkflowServiceIntegrationTest.assertNull((Object)owner);
        this.workflowService.endTask(startTask.getId(), null);
    }

    protected String getLongString(int numberOfCharacters) {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < numberOfCharacters / 10) {
            stringBuffer.append("ABCDEFGHIJ");
            ++i;
        }
        return stringBuffer.toString();
    }

    @Override
    protected void checkTaskQueryStartTaskCompleted(String workflowInstanceId, WorkflowTask startTask) {
        List<String> expectedTasks = Arrays.asList(startTask.getId());
        this.checkProcessIdQuery(workflowInstanceId, expectedTasks, WorkflowTaskState.COMPLETED);
        this.checkTaskIdQuery(startTask.getId(), WorkflowTaskState.COMPLETED);
        QName startTaskName = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"submitAdhocTask");
        this.checkTaskNameQuery(startTaskName, expectedTasks, WorkflowTaskState.COMPLETED, workflowInstanceId);
        this.checkActorIdQuery(AbstractWorkflowServiceIntegrationTest.USER1, expectedTasks, WorkflowTaskState.COMPLETED, workflowInstanceId);
        this.checkIsActiveQuery(expectedTasks, WorkflowTaskState.COMPLETED, workflowInstanceId);
        this.checkTaskPropsQuery(expectedTasks, WorkflowTaskState.COMPLETED, workflowInstanceId);
    }

    @Override
    protected void checkTaskQueryTaskCompleted(String workflowInstanceId, WorkflowTask theTask, WorkflowTask startTask) {
        List<String> withoutStartTask = Arrays.asList(theTask.getId());
        List<String> bothTasks = Arrays.asList(theTask.getId(), startTask.getId());
        this.checkProcessIdQuery(workflowInstanceId, bothTasks, WorkflowTaskState.COMPLETED);
        QName taskName = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"adhocTask");
        this.checkTaskNameQuery(taskName, withoutStartTask, WorkflowTaskState.COMPLETED, null);
        this.checkActorIdQuery(AbstractWorkflowServiceIntegrationTest.USER2, withoutStartTask, WorkflowTaskState.COMPLETED, null);
        this.checkIsActiveQuery(bothTasks, WorkflowTaskState.COMPLETED, workflowInstanceId);
        this.checkTaskPropsQuery(withoutStartTask, WorkflowTaskState.COMPLETED, null);
        this.checkProcessPropsQuery(withoutStartTask, WorkflowTaskState.COMPLETED);
    }

    @Override
    protected void checkQueryTasksInactiveWorkflow(String workflowInstanceId) {
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setActive(Boolean.valueOf(false));
        taskQuery.setProcessId(workflowInstanceId);
        List tasks = this.workflowService.queryTasks(taskQuery);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)tasks);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((int)3, (int)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setActive(Boolean.valueOf(true));
        taskQuery.setProcessId(workflowInstanceId);
        this.checkNoTasksFoundUsingQuery(taskQuery);
    }

    @Category(value={RedundantTests.class})
    @Test
    public void testStartWorkflowFromTaskListener() throws Exception {
        WorkflowDefinition testDefinition = this.deployDefinition("activiti/testStartWfFromListener.bpmn20.xml");
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, "MNT-11926-testfile.txt");
        ChildAssociationRef childAssoc = this.nodeService.createNode(this.companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)"MNT-11926-test"), ContentModel.TYPE_CONTENT, props);
        try {
            HashMap<QName, NodeRef> params = new HashMap<QName, NodeRef>();
            NodeRef wfPackage = this.workflowService.createPackage(null);
            params.put(WorkflowModel.ASSOC_PACKAGE, wfPackage);
            NodeRef assignee = this.personManager.get(AbstractWorkflowServiceIntegrationTest.USER1);
            params.put(WorkflowModel.ASSOC_ASSIGNEE, assignee);
            WorkflowPath path = this.workflowService.startWorkflow(testDefinition.getId(), params);
            String instanceId = path.getInstance().getId();
            WorkflowTask startTask = this.workflowService.getStartTask(instanceId);
            this.workflowService.endTask(startTask.getId(), null);
        }
        finally {
            this.nodeService.deleteNode(childAssoc.getChildRef());
        }
    }

    @Test
    public void testWorkflowWithNodes() throws Exception {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        FileInfo incorrectNode = this.serviceRegistry.getFileFolderService().create(this.companyHome, "NO_WORKFLOW" + GUID.generate() + ".xml", ContentModel.TYPE_CONTENT);
        FileInfo fileInfo = this.serviceRegistry.getFileFolderService().create(this.companyHome, "workflow" + GUID.generate() + ".xml", WorkflowModel.TYPE_WORKFLOW_DEF);
        NodeRef workflowNode = fileInfo.getNodeRef();
        this.nodeService.setProperty(workflowNode, WorkflowModel.PROP_WORKFLOW_DEF_ENGINE_ID, (Serializable)((Object)this.getEngine()));
        InputStream input = this.getInputStream("activiti/testDiagram.bpmn20.xml");
        ContentWriter contentWriter = this.serviceRegistry.getContentService().getWriter(fileInfo.getNodeRef(), ContentModel.TYPE_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent(input);
        try {
            this.workflowService.isDefinitionDeployed(incorrectNode.getNodeRef());
            ActivitiWorkflowServiceIntegrationTest.fail((String)"The content type is incorrect, it should not get here");
        }
        catch (WorkflowException we) {
            ActivitiWorkflowServiceIntegrationTest.assertTrue((boolean)we.getMessage().contains(" is not of type 'bpm:workflowDefinition'"));
        }
        this.workflowService.isDefinitionDeployed(workflowNode);
        try {
            this.workflowService.deployDefinition(incorrectNode.getNodeRef());
            ActivitiWorkflowServiceIntegrationTest.fail((String)"The content type is incorrect, it should not get here");
        }
        catch (WorkflowException we) {
            ActivitiWorkflowServiceIntegrationTest.assertTrue((boolean)we.getMessage().contains(" is not of type 'bpm:workflowDefinition'"));
        }
        ActivitiWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isDefinitionDeployed(workflowNode));
        WorkflowDeployment workflowDeployment = this.workflowService.deployDefinition(workflowNode);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)workflowDeployment);
        ActivitiWorkflowServiceIntegrationTest.assertTrue((boolean)this.workflowService.isDefinitionDeployed(workflowNode));
        List defs = this.workflowService.getAllDefinitionsByName(workflowDeployment.getDefinition().getName());
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)defs);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((int)1, (int)defs.size());
        this.workflowService.undeployDefinition(workflowDeployment.getDefinition().getId());
        ActivitiWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.isDefinitionDeployed(workflowNode));
        try {
            this.workflowService.startWorkflowFromTemplate(incorrectNode.getNodeRef());
            ActivitiWorkflowServiceIntegrationTest.fail((String)"This method hasn't be implemented");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        boolean multi = this.workflowService.isMultiTenantWorkflowDeploymentEnabled();
        ActivitiWorkflowServiceIntegrationTest.assertTrue((boolean)multi);
    }

    @Test
    public void testWorkflowVarious() throws Exception {
        WorkflowDefinition definition = this.deployDefinition(this.getTestDefinitionPath());
        WorkflowPath path = this.workflowService.startWorkflow(definition.getId(), null);
        String instanceId = path.getInstance().getId();
        List workflowTasks = this.workflowService.getStartTasks(Arrays.asList(instanceId), true);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)workflowTasks);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((int)1, (int)workflowTasks.size());
        ActivitiWorkflowServiceIntegrationTest.assertFalse((boolean)this.workflowService.hasWorkflowImage(instanceId));
        ActivitiWorkflowServiceIntegrationTest.assertNull((Object)this.workflowService.getWorkflowImage(instanceId));
        List instances = this.workflowService.cancelWorkflows(null);
        ActivitiWorkflowServiceIntegrationTest.assertTrue((boolean)instances.isEmpty());
        WorkflowInstance wfi = this.workflowService.deleteWorkflow(instanceId);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((String)instanceId, (String)wfi.getId());
        try {
            this.workflowService.getDefinitionImage(definition.getId());
        }
        catch (WorkflowException we) {
            ActivitiWorkflowServiceIntegrationTest.assertTrue((boolean)we.getMessage().contains("Failed to retrieve workflow definition"));
        }
    }

    @Test
    public void testWorkflowQueries() throws Exception {
        WorkflowDefinition definition = this.deployDefinition(this.getTestDefinitionPath());
        WorkflowInstanceQuery workflowInstanceQuery = new WorkflowInstanceQuery(Boolean.valueOf(true));
        long active = this.workflowService.countWorkflows(workflowInstanceQuery);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)active);
        workflowInstanceQuery.setWorkflowDefinitionId(definition.getId());
        workflowInstanceQuery.setEngineId(this.getEngine());
        active = this.workflowService.countWorkflows(workflowInstanceQuery);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)active);
        WorkflowTaskQuery workflowTaskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        long completed = this.workflowService.countTasks(workflowTaskQuery);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)completed);
        workflowTaskQuery.setEngineId(this.getEngine());
        completed = this.workflowService.countTasks(workflowTaskQuery);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)completed);
    }

    @Test
    public void testBuildWorkflowWithNoUserTasks() throws Exception {
        WorkflowDefinition testDefinition = this.deployDefinition("activiti/testWorkflowNoUserTasks.bpmn20.xml");
        WorkflowBuilder builder = new WorkflowBuilder(testDefinition, this.workflowService, this.nodeService, null);
        WorkflowInstance builtInstance = builder.build();
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)builtInstance);
        List activeInstances = this.workflowService.getActiveWorkflows(testDefinition.getId());
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)activeInstances);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((int)0, (int)activeInstances.size());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().finishedAfter(builtInstance.getStartDate()).singleResult();
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)historicProcessInstance);
    }

    @Test
    public void testNonAdminCannotDeployWorkflowBySwitchingNodeType() {
        ActivitiWorkflowServiceIntegrationTest.assertNull((Object)this.workflowService.getDefinitionByName("activiti$testProcess"));
        AuthenticationUtil.setFullyAuthenticatedUser((String)AbstractWorkflowServiceIntegrationTest.USER1);
        NodeRef person = this.serviceRegistry.getPersonService().getPerson(AbstractWorkflowServiceIntegrationTest.USER1);
        NodeRef home = (NodeRef)this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER);
        WorkflowDefinition workflowDef = this.createContentAndSwitchToWorkflow("activiti$testProcess", "alfresco/workflow/test-security.bpmn20.xml", home);
        ActivitiWorkflowServiceIntegrationTest.assertNull((String)"Workflow should not be deployed", (Object)workflowDef);
    }

    @Test
    public void testNonAdminCannotDeployWorkflowBySwitchingNodeTypeEvenInCorrectLocation() {
        ActivitiWorkflowServiceIntegrationTest.assertNull((Object)this.workflowService.getDefinitionByName("activiti$testProcess"));
        AuthenticationUtil.setFullyAuthenticatedUser((String)AbstractWorkflowServiceIntegrationTest.USER1);
        NodeRef workflowParent = this.findWorkflowParent();
        try {
            this.createContentAndSwitchToWorkflow("activiti$testProcess", "alfresco/workflow/test-security.bpmn20.xml", workflowParent);
            ActivitiWorkflowServiceIntegrationTest.fail((String)"User should not be able to create a node in the 'correct location'.");
        }
        catch (AccessDeniedException accessDeniedException) {}
    }

    @Test
    public void testAdminCanDeployBySwitchingContentTypeToWorkflow() {
        ActivitiWorkflowServiceIntegrationTest.assertNull((Object)this.workflowService.getDefinitionByName("activiti$testProcess"));
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        NodeRef workflowParent = this.findWorkflowParent();
        WorkflowDefinition workflowDef = this.createContentAndSwitchToWorkflow("activiti$testProcess", "alfresco/workflow/test-security.bpmn20.xml", workflowParent);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)workflowDef);
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        NodeRef wfPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, wfPackage);
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, new Date());
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, 1);
        NodeRef group = this.groupManager.get(AbstractWorkflowServiceIntegrationTest.GROUP);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)group);
        params.put(WorkflowModel.ASSOC_GROUP_ASSIGNEE, group);
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.getId(), params);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)path);
        ActivitiWorkflowServiceIntegrationTest.assertTrue((boolean)path.isActive());
    }

    @Test
    public void testAdminCannotDeployBySwitchingContentTypeToWorkflowWhenLocationIsNotValid() {
        ActivitiWorkflowServiceIntegrationTest.assertNull((Object)this.workflowService.getDefinitionByName("activiti$testProcess"));
        NodeRef rootNode = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        WorkflowDefinition workflowDef = this.createContentAndSwitchToWorkflow("activiti$testProcess", "alfresco/workflow/test-security.bpmn20.xml", rootNode);
        ActivitiWorkflowServiceIntegrationTest.assertNull((String)"Workflow should not be deployed", (Object)workflowDef);
    }

    @Test
    public void testMNT21638_1() {
        WorkflowDefinition definition = this.deployDefinition("activiti/test-MNT21638-1.bpmn20.xml");
        this.personManager.setUser(AbstractWorkflowServiceIntegrationTest.USER1);
        try {
            this.workflowService.startWorkflow(definition.getId(), null);
            ActivitiWorkflowServiceIntegrationTest.fail((String)"Workflow should not have been executed");
        }
        catch (Exception exception) {}
    }

    @Test
    public void testMNT21638_2() {
        WorkflowDefinition definition = this.deployDefinition("activiti/test-MNT21638-2.bpmn20.xml", "MNT21638", true);
        this.personManager.setUser(AbstractWorkflowServiceIntegrationTest.USER1);
        WorkflowPath path = this.workflowService.startWorkflow(definition.getId(), null);
        String instanceId = path.getInstance().getId();
        ActivitiWorkflowServiceIntegrationTest.assertNotNull((Object)instanceId);
    }

    private NodeRef findWorkflowParent() {
        RepositoryLocation workflowLocation = (RepositoryLocation)this.applicationContext.getBean("customWorkflowDefsRepositoryLocation");
        NodeRef rootNode = this.nodeService.getRootNode(workflowLocation.getStoreRef());
        List workflowParents = this.serviceRegistry.getSearchService().selectNodes(rootNode, workflowLocation.getPath(), null, (NamespacePrefixResolver)this.serviceRegistry.getNamespaceService(), false);
        if (workflowParents.size() == 0) {
            throw new IllegalStateException("Unable to find workflow location: " + workflowLocation.getPath());
        }
        if (workflowParents.size() > 1) {
            throw new IllegalStateException("More than one workflow location? [" + workflowLocation.getPath() + "]");
        }
        return (NodeRef)workflowParents.get(0);
    }

    private WorkflowDefinition createContentAndSwitchToWorkflow(String processName, String resource, NodeRef parent) {
        InputStream input = this.getInputStream(resource);
        ChildAssociationRef childAssoc = this.nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)"test"), ContentModel.TYPE_CONTENT, null);
        NodeRef workflowNode = childAssoc.getChildRef();
        ContentWriter writer = this.serviceRegistry.getContentService().getWriter(workflowNode, ContentModel.PROP_CONTENT, true);
        writer.putContent(input);
        this.nodeService.setType(workflowNode, WorkflowModel.TYPE_WORKFLOW_DEF);
        this.nodeService.setProperty(workflowNode, WorkflowModel.PROP_WORKFLOW_DEF_DEPLOYED, (Serializable)Boolean.valueOf(true));
        return this.workflowService.getDefinitionByName(processName);
    }

    @Override
    protected String getEngine() {
        return "activiti";
    }

    @Override
    protected String getTestDefinitionPath() {
        return ACTIVITI_TEST_TRANSACTION_BPMN20_XML;
    }

    @Override
    protected String getAdhocDefinitionPath() {
        return ALFRESCO_WORKFLOW_ADHOC_BPMN20_XML;
    }

    @Override
    protected String getPooledReviewDefinitionPath() {
        return ALFRESCO_WORKFLOW_REVIEW_POOLED_BPMN20_XML;
    }

    @Override
    protected String getParallelReviewDefinitionPath() {
        return ALFRESCO_WORKFLOW_PARALLEL_REVIEW_BPMN20_XML;
    }

    @Override
    protected String getTestTimerDefinitionPath() {
        return ACTIVITI_TEST_TIMER_BPMN20_XML;
    }

    protected String getAssignmentListenerDefinitionPath() {
        return "activiti/testAssignmentListener.bmn20.xml";
    }

    @Override
    protected QName getAdhocProcessName() {
        return QName.createQName((String)"activitiAdhoc");
    }
}

