/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import java.util.Arrays;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.DbObjectTestBase;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.Table;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={BaseSpringTestsCategory.class})
public class IndexTest
extends DbObjectTestBase<Index> {
    private Table thisTable;
    private Index thisIndex;
    private Table thatTable;
    private Index thatIndex;

    @Before
    public void setUp() {
        this.thisTable = new Table("this_table");
        this.thisIndex = new Index(this.thisTable, "this_index", Arrays.asList("id", "name", "age"));
        this.thatTable = new Table("that_table");
        this.thatIndex = new Index(this.thatTable, "that_index", Arrays.asList("a", "b"));
    }

    @Override
    protected Index getThisObject() {
        return this.thisIndex;
    }

    @Override
    protected Index getThatObject() {
        return this.thatIndex;
    }

    @Override
    protected void doDiffTests() {
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimpleOrderedLists(new DbProperty((DbObject)this.thisIndex, "columnNames"), new DbProperty((DbObject)this.thatIndex, "columnNames"), this.ctx);
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimple(new DbProperty((DbObject)this.thisIndex, "unique"), new DbProperty((DbObject)this.thatIndex, "unique"), this.ctx);
    }

    @Test
    public void sameAs() {
        Assert.assertTrue((String)"Indexes should be logically the same.", (boolean)this.thisIndex.sameAs((DbObject)new Index(this.thisTable, "this_index", Arrays.asList("id", "name", "age"))));
        Assert.assertFalse((String)"Indexes have logically different parents", (boolean)this.thisIndex.sameAs((DbObject)new Index(this.thatTable, "this_index", Arrays.asList("id", "name", "age"))));
        Assert.assertTrue((String)"Indexes should be logically the same, despite different names (as same column order)", (boolean)this.thisIndex.sameAs((DbObject)new Index(this.thisTable, "different_name", Arrays.asList("id", "name", "age"))));
        Assert.assertTrue((String)"Indexes should be identified as the same despite different column order (as same name).", (boolean)this.thisIndex.sameAs((DbObject)new Index(this.thisTable, "this_index", Arrays.asList("name", "id", "age"))));
        Assert.assertFalse((String)"Indexes should be identified different (different name and column order)", (boolean)this.thisIndex.sameAs((DbObject)new Index(this.thisTable, "different_name", Arrays.asList("name", "id", "age"))));
        Assert.assertFalse((String)"Indexes should be identified different (different name & different columns)", (boolean)this.thisIndex.sameAs((DbObject)new Index(this.thisTable, "different_name", Arrays.asList("node_ref", "url"))));
    }

    @Test
    public void acceptVisitor() {
        this.thisIndex.accept(this.visitor);
        ((DbObjectVisitor)Mockito.verify((Object)this.visitor)).visit((DbObject)this.thisIndex);
    }
}

