/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.heartbeat.HBBaseDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class AuthoritiesDataCollector
extends HBBaseDataCollector
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(AuthoritiesDataCollector.class);
    private DescriptorDAO currentRepoDescriptorDAO;
    private AuthorityService authorityService;

    public AuthoritiesDataCollector(String collectorId, String collectorVersion, String cronExpression, HeartBeatJobScheduler hbJobScheduler) {
        super(collectorId, collectorVersion, cronExpression, hbJobScheduler);
    }

    public void setCurrentRepoDescriptorDAO(DescriptorDAO currentRepoDescriptorDAO) {
        this.currentRepoDescriptorDAO = currentRepoDescriptorDAO;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"authorityService", (Object)this.authorityService);
        PropertyCheck.mandatory((Object)this, (String)"currentRepoDescriptorDAO", (Object)this.currentRepoDescriptorDAO);
    }

    @Override
    public List<HBData> collectData() {
        logger.debug((Object)"Preparing repository usage (authorities) data...");
        HashMap<String, Integer> authoritiesUsageValues = new HashMap<String, Integer>();
        authoritiesUsageValues.put("numUsers", new Integer(this.authorityService.getAllAuthoritiesInZone("APP.DEFAULT", AuthorityType.USER).size()));
        authoritiesUsageValues.put("numGroups", new Integer(this.authorityService.getAllAuthoritiesInZone("APP.DEFAULT", AuthorityType.GROUP).size()));
        HBData authoritiesUsageData = new HBData(this.currentRepoDescriptorDAO.getDescriptor().getId(), this.getCollectorId(), this.getCollectorVersion(), new Date(), authoritiesUsageValues);
        return Arrays.asList(authoritiesUsageData);
    }
}

