/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.contentdata;

import java.io.Serializable;
import org.alfresco.repo.domain.CrcHelper;
import org.alfresco.repo.domain.contentdata.ContentUrlKeyEntity;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;

public class ContentUrlEntity
implements Serializable {
    private static final long serialVersionUID = -7697859151521433536L;
    public static final Long CONST_LONG_ZERO = new Long(0L);
    public static final String EMPTY_URL = "empty";
    private Long id;
    private String contentUrl;
    private String contentUrlShort;
    private long contentUrlCrc;
    private long size = 0L;
    private Long orphanTime;
    private ContentUrlKeyEntity contentUrlKey;

    public int hashCode() {
        return this.contentUrl == null ? 0 : this.contentUrl.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ContentUrlEntity) {
            ContentUrlEntity that = (ContentUrlEntity)obj;
            return EqualsHelper.nullSafeEquals((Object)this.contentUrl, (Object)that.contentUrl) && EqualsHelper.nullSafeEquals((Object)this.contentUrlKey, (Object)that.getContentUrlKey());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("ContentUrlEntity").append("[ ID=").append(this.id).append(", contentUrl=").append(this.contentUrl).append(", size=").append(this.size).append(", orphanTime=").append(this.orphanTime).append("]");
        return sb.toString();
    }

    private static Pair<String, Long> getContentUrlCrcPair(String internalContentUrl) {
        return CrcHelper.getStringCrcPair(internalContentUrl, 12, false, true);
    }

    private static String getExternalUrl(String contentUrl) {
        if (contentUrl == null) {
            return null;
        }
        if (contentUrl.equals(EMPTY_URL)) {
            return "";
        }
        return contentUrl;
    }

    public ContentUrlKeyEntity getContentUrlKey() {
        return this.contentUrlKey;
    }

    public static ContentUrlEntity setContentUrlKey(ContentUrlEntity existing, ContentUrlKeyEntity contentUrlKey) {
        ContentUrlEntity ret = new ContentUrlEntity();
        ret.setContentUrl(existing == null ? null : existing.getContentUrl());
        ret.setContentUrlShort(existing == null ? null : existing.getContentUrlShort());
        ret.setContentUrlCrc(existing == null ? null : Long.valueOf(existing.getContentUrlCrc()));
        ret.setContentUrlKey(contentUrlKey);
        ret.setOrphanTime(existing == null ? null : existing.getOrphanTime());
        ret.setSize(existing == null ? null : Long.valueOf(existing.getSize()));
        ret.setId(existing == null ? null : existing.getId());
        return ret;
    }

    public void setContentUrlKey(ContentUrlKeyEntity contentUrlKey) {
        this.contentUrlKey = contentUrlKey;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getContentUrl() {
        return ContentUrlEntity.getExternalUrl(this.contentUrl);
    }

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
        Pair<String, Long> contentUrlPair = ContentUrlEntity.getContentUrlCrcPair(contentUrl);
        this.contentUrlShort = (String)contentUrlPair.getFirst();
        this.contentUrlCrc = (Long)contentUrlPair.getSecond();
    }

    public String getContentUrlShort() {
        return this.contentUrlShort;
    }

    public void setContentUrlShort(String contentUrlShort) {
        this.contentUrlShort = contentUrlShort;
    }

    public long getContentUrlCrc() {
        return this.contentUrlCrc;
    }

    public void setContentUrlCrc(long contentUrlCrc) {
        this.contentUrlCrc = contentUrlCrc;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public Long getOrphanTime() {
        return this.orphanTime;
    }

    public void setOrphanTime(Long orphanTime) {
        this.orphanTime = orphanTime;
    }
}

