/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.Collection;
import java.util.Collections;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.event2.filter.ChildAssociationTypeFilter;
import org.alfresco.repo.event2.filter.EventUserFilter;
import org.alfresco.repo.event2.filter.NodeAspectFilter;
import org.alfresco.repo.event2.filter.NodePropertyFilter;
import org.alfresco.repo.event2.filter.NodeTypeFilter;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.OneToManyHashBiMap;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class EventFilterUnitTest {
    private static NamespaceService namespaceService;
    private static NodePropertyFilter propertyFilter;
    private static NodeTypeFilter typeFilter;
    private static NodeAspectFilter aspectFilter;
    private static ChildAssociationTypeFilter childAssociationTypeFilter;
    private static EventUserFilter caseInsensitive_userFilter;
    private static EventUserFilter caseSensitive_userFilter;

    @BeforeClass
    public static void setUp() {
        DictionaryService dictionaryService = (DictionaryService)Mockito.mock(DictionaryService.class);
        Mockito.when((Object)dictionaryService.getSubTypes((QName)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenAnswer(invocation -> {
            QName name = (QName)invocation.getArgument(0);
            return Collections.singleton(name);
        });
        namespaceService = new MockNamespaceServiceImpl();
        namespaceService.registerNamespace("sys", "http://www.alfresco.org/model/system/1.0");
        namespaceService.registerNamespace("cm", "http://www.alfresco.org/model/content/1.0");
        namespaceService.registerNamespace("fm", "http://www.alfresco.org/model/forum/1.0");
        namespaceService.registerNamespace("rn", "http://www.alfresco.org/model/rendition/1.0");
        propertyFilter = new NodePropertyFilter();
        propertyFilter.setNamespaceService(namespaceService);
        propertyFilter.setDictionaryService(dictionaryService);
        propertyFilter.init();
        typeFilter = new NodeTypeFilter("sys:*, fm:*, cm:thumbnail");
        typeFilter.setNamespaceService(namespaceService);
        typeFilter.setDictionaryService(dictionaryService);
        typeFilter.init();
        aspectFilter = new NodeAspectFilter("cm:workingcopy");
        aspectFilter.setNamespaceService(namespaceService);
        aspectFilter.setDictionaryService(dictionaryService);
        aspectFilter.init();
        childAssociationTypeFilter = new ChildAssociationTypeFilter("rn:rendition");
        childAssociationTypeFilter.setNamespaceService(namespaceService);
        childAssociationTypeFilter.setDictionaryService(dictionaryService);
        childAssociationTypeFilter.init();
        caseInsensitive_userFilter = new EventUserFilter("System, john.doe, null", false);
        caseSensitive_userFilter = new EventUserFilter("System, john.doe, null", true);
    }

    @Test
    public void nodePropertyFilter() {
        Assert.assertTrue((String)"System properties are excluded by default.", (boolean)propertyFilter.isExcluded(ContentModel.PROP_NODE_UUID));
        Assert.assertTrue((String)"System properties are excluded by default.", (boolean)propertyFilter.isExcluded(ContentModel.PROP_NODE_DBID));
        Assert.assertFalse((String)"Property cascadeTx is not excluded", (boolean)propertyFilter.isExcluded(ContentModel.PROP_CASCADE_TX));
        Assert.assertFalse((String)"Property cascadeCRC is not excluded", (boolean)propertyFilter.isExcluded(ContentModel.PROP_CASCADE_CRC));
        Assert.assertFalse((boolean)propertyFilter.isExcluded(ContentModel.PROP_TITLE));
    }

    @Test
    public void nodeTypeFilter() {
        Assert.assertTrue((String)"Thumbnail node type should have been filtered.", (boolean)typeFilter.isExcluded(ContentModel.TYPE_THUMBNAIL));
        Assert.assertTrue((String)"System folder node types are excluded by default.", (boolean)typeFilter.isExcluded(ContentModel.TYPE_SYSTEM_FOLDER));
        Assert.assertTrue((String)"System node type should have been filtered (sys:*).", (boolean)typeFilter.isExcluded(QName.createQName((String)"sys:testSomeSystemType", (NamespacePrefixResolver)namespaceService)));
        Assert.assertTrue((String)"Forum node type should have been filtered (fm:*).", (boolean)typeFilter.isExcluded(ForumModel.TYPE_POST));
        Assert.assertFalse((boolean)typeFilter.isExcluded(ContentModel.TYPE_FOLDER));
    }

    @Test
    public void nodeAspectFilter() {
        Assert.assertTrue((String)"Working copy aspect should have been filtered.", (boolean)aspectFilter.isExcluded(ContentModel.ASPECT_WORKING_COPY));
        Assert.assertFalse((boolean)aspectFilter.isExcluded(ContentModel.ASPECT_TITLED));
    }

    @Test
    public void childAssociationTypeFilter() {
        Assert.assertTrue((String)"Rendition child association type should have been filtered.", (boolean)childAssociationTypeFilter.isExcluded(RenditionModel.ASSOC_RENDITION));
        Assert.assertFalse((boolean)childAssociationTypeFilter.isExcluded(ContentModel.ASSOC_CONTAINS));
    }

    @Test
    public void userFilter_case_insensitive() {
        Assert.assertTrue((String)"System user should have been filtered.", (boolean)caseInsensitive_userFilter.isExcluded("System"));
        Assert.assertTrue((String)"System user should have been filtered (case-insensitive).", (boolean)caseInsensitive_userFilter.isExcluded("SYSTEM"));
        Assert.assertTrue((String)"'null' user should have been filtered.", (boolean)caseInsensitive_userFilter.isExcluded("null"));
        Assert.assertTrue((String)"john.doe user should have been filtered.", (boolean)caseInsensitive_userFilter.isExcluded("John.Doe"));
        Assert.assertFalse((String)"'jane.doe' user should not have been filtered.", (boolean)caseInsensitive_userFilter.isExcluded("jane.doe"));
    }

    @Test
    public void userFilter_case_sensitive() {
        Assert.assertFalse((String)"'system' user should not have been filtered.", (boolean)caseSensitive_userFilter.isExcluded("system"));
        Assert.assertTrue((String)"'System' user should have been filtered.", (boolean)caseSensitive_userFilter.isExcluded("System"));
        Assert.assertFalse((String)"'John.Doe' user should not have been filtered.", (boolean)caseSensitive_userFilter.isExcluded("John.Doe"));
        Assert.assertTrue((String)"'john.doe' user should have been filtered.", (boolean)caseSensitive_userFilter.isExcluded("john.doe"));
        Assert.assertFalse((String)"'jane.doe' user should not have been filtered.", (boolean)caseSensitive_userFilter.isExcluded("jane.doe"));
    }

    public static class MockNamespaceServiceImpl
    implements NamespaceService {
        private final OneToManyHashBiMap<String, String> map = new OneToManyHashBiMap();

        public void registerNamespace(String prefix, String uri) {
            this.map.putSingleValue((Object)uri, (Object)prefix);
        }

        public void unregisterNamespace(String prefix) {
            this.map.removeValue((Object)prefix);
        }

        public String getNamespaceURI(String prefix) throws NamespaceException {
            return (String)this.map.getKey((Object)prefix);
        }

        public Collection<String> getPrefixes(String namespaceURI) throws NamespaceException {
            return this.map.get((Object)namespaceURI);
        }

        public Collection<String> getPrefixes() {
            return this.map.flatValues();
        }

        public Collection<String> getURIs() {
            return this.map.keySet();
        }
    }
}

