/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.archive;

import jakarta.transaction.UserTransaction;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.node.StoreArchiveMap;
import org.alfresco.repo.node.archive.ArchivedNodesCannedQueryBuilder;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.node.archive.RestoreNodeReport;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.ScriptPagingDetails;
import org.alfresco.util.TestWithUserUtils;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class ArchiveAndRestoreTest
extends TestCase {
    private static final String USER_A = "aaaaa";
    private static final String USER_B = "bbbbb";
    private static final String USER_C = "ccccc";
    private static final QName ASPECT_ATTACHABLE = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"attachable");
    private static final QName ASSOC_ATTACHMENTS = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"attachments");
    private static final QName QNAME_A = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"a");
    private static final QName QNAME_B = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"b");
    private static final QName QNAME_AA = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"aa");
    private static final QName QNAME_BB = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"bb");
    private static final QName TYPE_QNAME_TEST_CONTENT = QName.createQName((String)"http://www.alfresco.org/test/nodearchive", (String)"content");
    private ApplicationContext ctx;
    private NodeArchiveService nodeArchiveService;
    private NodeService nodeService;
    private PermissionService permissionService;
    private AuthenticationComponent authenticationComponent;
    private MutableAuthenticationService authenticationService;
    private OwnableService ownableService;
    private TransactionService transactionService;
    private UserTransaction txn;
    private StoreRef workStoreRef;
    private NodeRef workStoreRootNodeRef;
    private StoreRef archiveStoreRef;
    private NodeRef archiveStoreRootNodeRef;
    private NodeRef a;
    private NodeRef b;
    private NodeRef aa;
    private NodeRef bb;
    AssociationRef assocAtoB;
    AssociationRef assocAAtoBB;
    ChildAssociationRef childAssocAtoAA;
    ChildAssociationRef childAssocBtoBB;
    ChildAssociationRef childAssocBtoAA;
    ChildAssociationRef childAssocAtoBB;
    private NodeRef a_;
    private NodeRef b_;
    private NodeRef aa_;
    private NodeRef bb_;
    ChildAssociationRef childAssocAtoAA_;
    ChildAssociationRef childAssocBtoBB_;

    public void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.nodeArchiveService = (NodeArchiveService)this.ctx.getBean("nodeArchiveService");
        this.nodeService = serviceRegistry.getNodeService();
        this.permissionService = serviceRegistry.getPermissionService();
        this.authenticationService = serviceRegistry.getAuthenticationService();
        this.authenticationComponent = (AuthenticationComponent)this.ctx.getBean("authenticationComponent");
        this.ownableService = (OwnableService)this.ctx.getBean("ownableService");
        this.transactionService = serviceRegistry.getTransactionService();
        DictionaryDAO dictionaryDao = (DictionaryDAO)this.ctx.getBean("dictionaryDAO");
        ClassLoader cl = ArchiveAndRestoreTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("org/alfresco/repo/node/archive/archiveTest_model.xml");
        ArchiveAndRestoreTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        IntegrityChecker.setWarnInTransaction();
        try {
            this.authenticationComponent.setSystemUserAsCurrentUser();
            this.workStoreRef = this.nodeService.createStore("workspace", String.valueOf(this.getName()) + System.currentTimeMillis());
            this.workStoreRootNodeRef = this.nodeService.getRootNode(this.workStoreRef);
            this.archiveStoreRef = this.nodeService.createStore("workspace", "archive" + this.getName() + System.currentTimeMillis());
            this.archiveStoreRootNodeRef = this.nodeService.getRootNode(this.archiveStoreRef);
            StoreArchiveMap archiveMap = (StoreArchiveMap)this.ctx.getBean("storeArchiveMap");
            archiveMap.put(this.workStoreRef, this.archiveStoreRef);
            TestWithUserUtils.createUser(USER_A, USER_A, this.workStoreRootNodeRef, this.nodeService, this.authenticationService);
            TestWithUserUtils.createUser(USER_B, USER_B, this.workStoreRootNodeRef, this.nodeService, this.authenticationService);
            TestWithUserUtils.createUser(USER_C, USER_C, this.workStoreRootNodeRef, this.nodeService, this.authenticationService);
            this.permissionService.setPermission(this.workStoreRootNodeRef, USER_A, "All", true);
            this.permissionService.setPermission(this.workStoreRootNodeRef, USER_B, "All", true);
            this.permissionService.setPermission(this.workStoreRootNodeRef, USER_C, "All", false);
        }
        finally {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        this.authenticationService.authenticate(USER_A, USER_A.toCharArray());
        this.createNodeStructure();
    }

    public void tearDown() throws Exception {
        try {
            this.txn.rollback();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    private void createNodeStructure() throws Exception {
        HashMap<QName, Object> properties = new HashMap<QName, Object>(5);
        properties.put(ContentModel.PROP_COUNTER, 50);
        properties.put(ContentModel.PROP_NODE_UUID, "a");
        this.a = this.nodeService.createNode(this.workStoreRootNodeRef, ContentModel.ASSOC_CHILDREN, QNAME_A, ContentModel.TYPE_FOLDER, properties).getChildRef();
        this.nodeService.addAspect(this.a, ASPECT_ATTACHABLE, null);
        properties.put(ContentModel.PROP_NODE_UUID, "aa");
        this.childAssocAtoAA = this.nodeService.createNode(this.a, ContentModel.ASSOC_CONTAINS, QNAME_AA, ContentModel.TYPE_CONTENT, properties);
        this.aa = this.childAssocAtoAA.getChildRef();
        this.nodeService.addAspect(this.aa, ASPECT_ATTACHABLE, null);
        properties.put(ContentModel.PROP_NODE_UUID, "b");
        this.b = this.nodeService.createNode(this.workStoreRootNodeRef, ContentModel.ASSOC_CHILDREN, QNAME_B, ContentModel.TYPE_FOLDER, properties).getChildRef();
        properties.put(ContentModel.PROP_NODE_UUID, "bb");
        this.childAssocBtoBB = this.nodeService.createNode(this.b, ContentModel.ASSOC_CONTAINS, QNAME_BB, ContentModel.TYPE_CONTENT, properties);
        this.bb = this.childAssocBtoBB.getChildRef();
        this.assocAtoB = this.nodeService.createAssociation(this.a, this.b, ASSOC_ATTACHMENTS);
        this.assocAAtoBB = this.nodeService.createAssociation(this.aa, this.bb, ASSOC_ATTACHMENTS);
        this.childAssocBtoAA = this.nodeService.addChild(this.b, this.aa, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"aa"));
        this.childAssocAtoBB = this.nodeService.addChild(this.a, this.bb, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"bb"));
        this.a_ = new NodeRef(this.archiveStoreRef, this.a.getId());
        this.b_ = new NodeRef(this.archiveStoreRef, this.b.getId());
        this.aa_ = new NodeRef(this.archiveStoreRef, this.aa.getId());
        this.bb_ = new NodeRef(this.archiveStoreRef, this.bb.getId());
        this.childAssocAtoAA_ = new ChildAssociationRef(this.childAssocAtoAA.getTypeQName(), this.a_, this.childAssocAtoAA.getQName(), this.aa_);
        this.childAssocBtoBB_ = new ChildAssociationRef(this.childAssocBtoBB.getTypeQName(), this.b_, this.childAssocBtoBB.getQName(), this.bb_);
    }

    private void verifyNodeExistence(NodeRef nodeRef, boolean exists) {
        ArchiveAndRestoreTest.assertEquals((String)("Node should " + (exists ? "" : "not ") + "exist"), (boolean)exists, (boolean)this.nodeService.exists(nodeRef));
    }

    private void verifyChildAssocExistence(ChildAssociationRef childAssocRef, boolean exists) {
        List childAssocs = this.nodeService.getChildAssocs(childAssocRef.getParentRef(), (QNamePattern)childAssocRef.getTypeQName(), (QNamePattern)childAssocRef.getQName());
        if (exists) {
            ArchiveAndRestoreTest.assertEquals((String)("Expected exactly one match for child association: " + childAssocRef), (int)1, (int)childAssocs.size());
        } else {
            ArchiveAndRestoreTest.assertEquals((String)("Expected zero matches for child association: " + childAssocRef), (int)0, (int)childAssocs.size());
        }
    }

    private void verifyTargetAssocExistence(AssociationRef assocRef, boolean exists) {
        List assocs = this.nodeService.getTargetAssocs(assocRef.getSourceRef(), (QNamePattern)assocRef.getTypeQName());
        if (exists) {
            ArchiveAndRestoreTest.assertEquals((String)("Expected exactly one match for target association: " + assocRef), (int)1, (int)assocs.size());
        } else {
            ArchiveAndRestoreTest.assertEquals((String)("Expected zero matches for target association: " + assocRef), (int)0, (int)assocs.size());
        }
    }

    private void verifyPropertyExistence(NodeRef nodeRef, QName propertyQName, boolean exists) {
        ArchiveAndRestoreTest.assertEquals((String)("Property is not present " + nodeRef + " - " + propertyQName), (boolean)exists, (this.nodeService.getProperty(nodeRef, propertyQName) != null ? 1 : 0) != 0);
    }

    private void verifyAspectExistence(NodeRef nodeRef, QName aspectQName, boolean exists) {
        ArchiveAndRestoreTest.assertEquals((String)("Aspect is not present " + nodeRef + " - " + aspectQName), (boolean)exists, (boolean)this.nodeService.hasAspect(nodeRef, aspectQName));
    }

    public void verifyAll() {
        this.verifyNodeExistence(this.a, true);
        this.verifyNodeExistence(this.b, true);
        this.verifyNodeExistence(this.aa, true);
        this.verifyNodeExistence(this.bb, true);
        this.verifyChildAssocExistence(this.childAssocAtoAA, true);
        this.verifyChildAssocExistence(this.childAssocBtoBB, true);
        this.verifyPropertyExistence(this.a, ContentModel.PROP_COUNTER, true);
        this.verifyAspectExistence(this.a, ContentModel.ASPECT_COUNTABLE, true);
        this.verifyPropertyExistence(this.b, ContentModel.PROP_COUNTER, true);
        this.verifyAspectExistence(this.b, ContentModel.ASPECT_COUNTABLE, true);
        this.verifyPropertyExistence(this.aa, ContentModel.PROP_COUNTER, true);
        this.verifyAspectExistence(this.aa, ContentModel.ASPECT_COUNTABLE, true);
        this.verifyPropertyExistence(this.bb, ContentModel.PROP_COUNTER, true);
        this.verifyAspectExistence(this.bb, ContentModel.ASPECT_COUNTABLE, true);
        this.verifyNodeExistence(this.a_, false);
        this.verifyNodeExistence(this.b_, false);
        this.verifyNodeExistence(this.aa_, false);
        this.verifyNodeExistence(this.bb_, false);
    }

    public void testSetUp() throws Exception {
        this.verifyAll();
    }

    public void testGetStoreArchiveNode() throws Exception {
        NodeRef archiveNodeRef = this.nodeService.getStoreArchiveNode(this.workStoreRef);
        ArchiveAndRestoreTest.assertEquals((String)"Mapping of archived store is not correct", (Object)this.archiveStoreRootNodeRef, (Object)archiveNodeRef);
    }

    public void testUserTracking() {
        ArchiveAndRestoreTest.assertEquals((int)1, (int)this.nodeService.getParentAssocs(this.a).size());
        this.nodeService.deleteNode(this.a);
        AuthenticationUtil.RunAsWork<List<ChildAssociationRef>> getAssocsWork = new AuthenticationUtil.RunAsWork<List<ChildAssociationRef>>(){

            public List<ChildAssociationRef> doWork() throws Exception {
                return ArchiveAndRestoreTest.this.nodeService.getChildrenByName(ArchiveAndRestoreTest.this.archiveStoreRootNodeRef, ContentModel.ASSOC_ARCHIVE_USER_LINK, Collections.singletonList(AuthenticationUtil.getFullyAuthenticatedUser()));
            }
        };
        List assocs = (List)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)getAssocsWork);
        ArchiveAndRestoreTest.assertEquals((String)"Expected exactly one child association for current user", (int)1, (int)assocs.size());
        ArchiveAndRestoreTest.assertEquals((int)2, (int)this.nodeService.getParentAssocs(this.a_).size());
        this.nodeService.restoreNode(this.a_, null, null, null);
        ArchiveAndRestoreTest.assertEquals((int)1, (int)this.nodeService.getParentAssocs(this.a).size());
    }

    public void testArchivedAspect() throws Exception {
        this.nodeService.deleteNode(this.a);
        ArchiveAndRestoreTest.assertTrue((String)"Archived aspect not present", (boolean)this.nodeService.hasAspect(this.a_, ContentModel.ASPECT_ARCHIVED));
        Map properties_a = this.nodeService.getProperties(this.a_);
        ArchiveAndRestoreTest.assertNotNull((String)"Original owner property should not be set", properties_a.get(ContentModel.PROP_ARCHIVED_ORIGINAL_OWNER));
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(ContentModel.PROP_OWNER, USER_B);
        this.nodeService.addAspect(this.b, ContentModel.ASPECT_OWNABLE, properties);
        this.nodeService.deleteNode(this.b);
        ArchiveAndRestoreTest.assertTrue((String)"Archived aspect not present", (boolean)this.nodeService.hasAspect(this.b_, ContentModel.ASPECT_ARCHIVED));
        Map properties_b = this.nodeService.getProperties(this.b_);
        ArchiveAndRestoreTest.assertNotNull((String)"Original owner property not present", properties_b.get(ContentModel.PROP_ARCHIVED_ORIGINAL_OWNER));
        ArchiveAndRestoreTest.assertEquals((String)"Original owner property is incorrect", (Object)USER_B, properties_b.get(ContentModel.PROP_ARCHIVED_ORIGINAL_OWNER));
    }

    public void testArchiveAndRestoreNodeBB() throws Exception {
        this.nodeService.deleteNode(this.bb);
        this.verifyNodeExistence(this.b, true);
        this.verifyNodeExistence(this.bb, false);
        this.verifyNodeExistence(this.b_, false);
        this.verifyNodeExistence(this.bb_, true);
        Map bb_Properties = this.nodeService.getProperties(this.bb_);
        ChildAssociationRef bb_originalParent = (ChildAssociationRef)bb_Properties.get(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC);
        ArchiveAndRestoreTest.assertNotNull((String)"Original parent not stored", (Object)bb_originalParent);
        this.nodeService.restoreNode(this.bb_, null, null, null);
        this.verifyAll();
    }

    public void testArchiveAndRestoreNodeB() throws Exception {
        this.nodeService.deleteNode(this.b);
        this.verifyNodeExistence(this.b, false);
        this.verifyNodeExistence(this.bb, false);
        this.verifyNodeExistence(this.b_, true);
        this.verifyNodeExistence(this.bb_, true);
        this.nodeService.restoreNode(this.b_, null, null, null);
        this.verifyAll();
    }

    public void testArchiveAndRestoreAll_B_A() throws Exception {
        this.nodeService.deleteNode(this.b);
        this.nodeService.deleteNode(this.a);
        this.nodeService.restoreNode(this.a_, null, null, null);
        this.nodeService.restoreNode(this.b_, null, null, null);
        this.verifyAll();
    }

    public void testArchiveAndRestoreAll_A_B() throws Exception {
        this.nodeService.deleteNode(this.a);
        this.nodeService.deleteNode(this.b);
        this.nodeService.restoreNode(this.b_, null, null, null);
        this.nodeService.restoreNode(this.a_, null, null, null);
        this.verifyAll();
    }

    public void testArchiveAndRestoreWithMissingAssocTargets() throws Exception {
        this.nodeService.deleteNode(this.a);
        this.nodeService.deleteNode(this.b);
        this.nodeService.restoreNode(this.a_, null, null, null);
        this.nodeService.restoreNode(this.b_, null, null, null);
        this.verifyNodeExistence(this.a, true);
        this.verifyNodeExistence(this.b, true);
        this.verifyNodeExistence(this.aa, true);
        this.verifyNodeExistence(this.bb, true);
        this.verifyChildAssocExistence(this.childAssocAtoAA, true);
        this.verifyChildAssocExistence(this.childAssocBtoBB, true);
        this.verifyNodeExistence(this.a_, false);
        this.verifyNodeExistence(this.b_, false);
        this.verifyNodeExistence(this.aa_, false);
        this.verifyNodeExistence(this.bb_, false);
    }

    public void testTypeDetection() {
        this.nodeService.setType(this.a, ContentModel.TYPE_CONTAINER);
        this.nodeService.deleteNode(this.a);
        this.verifyNodeExistence(this.a, false);
        this.verifyNodeExistence(this.a_, false);
    }

    public void testArchiveVsDeletePerformance() throws Exception {
        int iterations = 100;
        long cumulatedArchiveTimeNs = 0L;
        long cumulatedRestoreTimeNs = 0L;
        int i = 0;
        while (i < iterations) {
            long start = System.nanoTime();
            this.nodeService.deleteNode(this.b);
            long end = System.nanoTime();
            cumulatedArchiveTimeNs += end - start;
            start = System.nanoTime();
            this.nodeService.restoreNode(this.b_, null, null, null);
            end = System.nanoTime();
            cumulatedRestoreTimeNs += end - start;
            ++i;
        }
        double averageArchiveTimeMs = (double)cumulatedArchiveTimeNs / 1000000.0 / (double)iterations;
        double averageRestoreTimeMs = (double)cumulatedRestoreTimeNs / 1000000.0 / (double)iterations;
        System.out.println("Average archive time: " + averageArchiveTimeMs + " ms");
        System.out.println("Average restore time: " + averageRestoreTimeMs + " ms");
        StoreArchiveMap archiveMap = (StoreArchiveMap)this.ctx.getBean("storeArchiveMap");
        archiveMap.clear();
        long cumulatedDeleteTimeNs = 0L;
        long cumulatedCreateTimeNs = 0L;
        int i2 = 0;
        while (i2 < iterations) {
            long start = System.nanoTime();
            this.nodeService.deleteNode(this.b);
            long end = System.nanoTime();
            cumulatedDeleteTimeNs += end - start;
            this.nodeService.deleteNode(this.a);
            start = System.nanoTime();
            this.createNodeStructure();
            end = System.nanoTime();
            cumulatedCreateTimeNs += end - start;
            ++i2;
        }
        double averageDeleteTimeMs = (double)cumulatedDeleteTimeNs / 1000000.0 / (double)iterations;
        double averageCreateTimeMs = (double)cumulatedCreateTimeNs / 1000000.0 / (double)iterations;
        System.out.println("Average delete time: " + averageDeleteTimeMs + " ms");
        System.out.println("Average create time: " + averageCreateTimeMs + " ms");
    }

    public void testInTransactionRestore() throws Exception {
        RestoreNodeReport report = this.nodeArchiveService.restoreArchivedNode(this.a_);
        ArchiveAndRestoreTest.assertEquals((String)"Expected failure", (Object)RestoreNodeReport.RestoreStatus.FAILURE_INVALID_ARCHIVE_NODE, (Object)report.getStatus());
        ArchiveAndRestoreTest.assertEquals((String)"Transaction should still be valid", (int)0, (int)this.txn.getStatus());
    }

    public void testInTransactionPurge() throws Exception {
        this.nodeArchiveService.purgeArchivedNode(this.a_);
        ArchiveAndRestoreTest.assertEquals((String)"Transaction should still be valid", (int)0, (int)this.txn.getStatus());
    }

    private void commitAndBeginNewTransaction() throws Exception {
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
    }

    public void testSimple_Create_Commit_Delete_Commit() throws Exception {
        this.commitAndBeginNewTransaction();
        this.nodeService.deleteNode(this.a);
        this.commitAndBeginNewTransaction();
    }

    public void testSimple_Create_Delete_Commit() throws Exception {
        this.nodeService.deleteNode(this.a);
        this.commitAndBeginNewTransaction();
    }

    public void testRestoreToMissingParent() throws Exception {
        this.nodeService.deleteNode(this.a);
        this.nodeService.deleteNode(this.b);
        this.commitAndBeginNewTransaction();
        RestoreNodeReport report = this.nodeArchiveService.restoreArchivedNode(this.b_, this.a, null, null);
        ArchiveAndRestoreTest.assertEquals((String)"Incorrect report status", (Object)RestoreNodeReport.RestoreStatus.FAILURE_INVALID_PARENT, (Object)report.getStatus());
    }

    public void testMassRestore() throws Exception {
        this.nodeService.deleteNode(this.a);
        this.nodeService.deleteNode(this.b);
        this.commitAndBeginNewTransaction();
        ArrayList<NodeRef> nodesToRestore = new ArrayList<NodeRef>();
        nodesToRestore.add(this.a_);
        nodesToRestore.add(this.b_);
        List reports = this.nodeArchiveService.restoreArchivedNodes(nodesToRestore);
        ArchiveAndRestoreTest.assertEquals((String)"Incorrect number of node reports", (int)2, (int)reports.size());
        this.commitAndBeginNewTransaction();
        this.verifyNodeExistence(this.a, true);
        this.verifyNodeExistence(this.b, true);
        this.verifyNodeExistence(this.aa, true);
        this.verifyNodeExistence(this.bb, true);
        this.verifyNodeExistence(this.a_, false);
        this.verifyNodeExistence(this.b_, false);
        this.verifyNodeExistence(this.aa_, false);
        this.verifyNodeExistence(this.bb_, false);
    }

    public void testMassPurge() throws Exception {
        this.nodeService.deleteNode(this.a);
        this.nodeService.deleteNode(this.b);
        this.commitAndBeginNewTransaction();
        this.verifyNodeExistence(this.a_, true);
        this.verifyNodeExistence(this.b_, true);
        this.nodeArchiveService.purgeAllArchivedNodes(this.workStoreRef);
        this.commitAndBeginNewTransaction();
        this.verifyNodeExistence(this.a, false);
        this.verifyNodeExistence(this.b, false);
        this.verifyNodeExistence(this.aa, false);
        this.verifyNodeExistence(this.bb, false);
        this.verifyNodeExistence(this.a_, false);
        this.verifyNodeExistence(this.b_, false);
        this.verifyNodeExistence(this.aa_, false);
        this.verifyNodeExistence(this.bb_, false);
    }

    public void testDeletedOwnership() throws Exception {
        String bOwner = this.ownableService.getOwner(this.b);
        ArchiveAndRestoreTest.assertEquals((String)"User A must own 'b'", (String)USER_A, (String)bOwner);
        this.authenticationService.authenticate(USER_B, USER_B.toCharArray());
        this.nodeService.deleteNode(this.b);
        String b_Owner = this.ownableService.getOwner(this.b_);
        ArchiveAndRestoreTest.assertEquals((String)"User B must own 'b_'", (String)USER_B, (String)b_Owner);
    }

    public void testMNT8916RestoreWithoutPermissionsSet() throws Exception {
        this.permissionService.setInheritParentPermissions(this.a, false);
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.commitAndBeginNewTransaction();
        this.nodeService.deleteNode(this.a);
        this.verifyNodeExistence(this.a, false);
        this.nodeService.restoreNode(this.a_, null, null, null);
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        ArchiveAndRestoreTest.assertTrue((String)"Restored node shouldn't have any permissions set", (boolean)this.permissionService.getAllSetPermissions(this.a).isEmpty());
        ArchiveAndRestoreTest.assertFalse((String)"Restored node shouldn't inherit parent permissions", (boolean)this.permissionService.getInheritParentPermissions(this.a));
    }

    public void testPermissionsForRestore() throws Exception {
        this.authenticationService.authenticate(USER_A, USER_A.toCharArray());
        this.nodeService.deleteNode(this.a);
        this.authenticationService.authenticate(USER_B, USER_B.toCharArray());
        this.nodeService.deleteNode(this.b);
        this.commitAndBeginNewTransaction();
        ArrayList<NodeRef> nodesToRestore = new ArrayList<NodeRef>();
        nodesToRestore.add(this.a_);
        nodesToRestore.add(this.b_);
        List restoredByB = this.nodeArchiveService.restoreArchivedNodes(nodesToRestore);
        for (RestoreNodeReport restoreNodeReport : restoredByB) {
            if (restoreNodeReport.getArchivedNodeRef().equals((Object)this.a_)) {
                ArchiveAndRestoreTest.assertEquals((String)"A user's node should not be restorable by B", (Object)RestoreNodeReport.RestoreStatus.FAILURE_PERMISSION, (Object)restoreNodeReport.getStatus());
                continue;
            }
            if (!restoreNodeReport.getArchivedNodeRef().equals((Object)this.b_)) continue;
            ArchiveAndRestoreTest.assertEquals((String)"B user's node should have been restored by B", (Object)RestoreNodeReport.RestoreStatus.SUCCESS, (Object)restoreNodeReport.getStatus());
        }
    }

    public void testPermissionsLackingOnDestination() throws Exception {
        this.nodeService.deleteNode(this.b);
        this.permissionService.setPermission(this.workStoreRootNodeRef, USER_B, "AddChildren", false);
        this.commitAndBeginNewTransaction();
        this.authenticationService.authenticate(USER_B, USER_B.toCharArray());
        RestoreNodeReport report = this.nodeArchiveService.restoreArchivedNode(this.b_);
        ArchiveAndRestoreTest.assertEquals((String)"Expected permission denied status", (Object)RestoreNodeReport.RestoreStatus.FAILURE_PERMISSION, (Object)report.getStatus());
    }

    public void testAR1519ArchiveCleansDuplicateUuid() throws Exception {
        this.nodeService.deleteNode(this.b);
        this.verifyNodeExistence(this.b_, true);
        this.nodeService.deleteNode(this.a);
        this.verifyNodeExistence(this.a_, true);
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NODE_UUID, this.a.getId());
        NodeRef aRecreated = this.nodeService.createNode(this.workStoreRootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, props).getChildRef();
        ArchiveAndRestoreTest.assertEquals((String)"NodeRef for recreated node should be the same as the original", (Object)this.a, (Object)aRecreated);
        props.put(ContentModel.PROP_NODE_UUID, this.b.getId());
        NodeRef bRecreated = this.nodeService.createNode(this.a, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, props).getChildRef();
        ArchiveAndRestoreTest.assertEquals((String)"NodeRef for recreated node should be the same as the original", (Object)this.b, (Object)bRecreated);
        this.verifyNodeExistence(this.a, true);
        this.verifyNodeExistence(this.b, true);
        this.verifyNodeExistence(this.a_, true);
        this.verifyNodeExistence(this.b_, true);
        this.nodeService.deleteNode(this.a);
        this.verifyNodeExistence(this.a, false);
        this.verifyNodeExistence(this.b, false);
        this.verifyNodeExistence(this.a_, true);
        this.verifyNodeExistence(this.b_, true);
    }

    public synchronized void testAR7889ArchiveAndRestoreMustNotModifyAuditable() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_A);
        this.nodeService.addAspect(this.b, ContentModel.ASPECT_AUDITABLE, null);
        ((Object)((Object)this)).wait(2000L);
        String modifierOriginal = (String)((Object)this.nodeService.getProperty(this.b, ContentModel.PROP_MODIFIER));
        Date modifiedOriginal = (Date)this.nodeService.getProperty(this.b, ContentModel.PROP_MODIFIED);
        this.verifyAspectExistence(this.b, ContentModel.ASPECT_AUDITABLE, true);
        this.nodeService.deleteNode(this.b);
        this.verifyNodeExistence(this.b_, true);
        String modifierArchived = (String)((Object)this.nodeService.getProperty(this.b_, ContentModel.PROP_MODIFIER));
        Date modifiedArchived = (Date)this.nodeService.getProperty(this.b_, ContentModel.PROP_MODIFIED);
        ArchiveAndRestoreTest.assertEquals((String)"cm:modifier should not have changed", (String)modifierOriginal, (String)modifierArchived);
        ArchiveAndRestoreTest.assertEquals((String)"cm:modified should not have changed", (Object)modifiedOriginal, (Object)modifiedArchived);
        this.commitAndBeginNewTransaction();
        RestoreNodeReport report = this.nodeArchiveService.restoreArchivedNode(this.b_);
        ArchiveAndRestoreTest.assertEquals((String)"Restore failed", (Object)RestoreNodeReport.RestoreStatus.SUCCESS, (Object)report.getStatus());
        String modifierRestored = (String)((Object)this.nodeService.getProperty(this.b, ContentModel.PROP_MODIFIER));
        Date modifiedRestored = (Date)this.nodeService.getProperty(this.b, ContentModel.PROP_MODIFIED);
        ArchiveAndRestoreTest.assertEquals((String)"cm:modifier should not have changed", (String)modifierOriginal, (String)modifierRestored);
        ArchiveAndRestoreTest.assertEquals((String)"cm:modified should not have changed", (Object)modifiedOriginal, (Object)modifiedRestored);
        this.verifyAspectExistence(this.b, ContentModel.ASPECT_AUDITABLE, true);
    }

    public synchronized void testMNT15211ArchiveAndRestoreNotAuditable() throws Exception {
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(ContentModel.PROP_NODE_UUID, "r");
        NodeRef r = this.nodeService.createNode(this.workStoreRootNodeRef, ContentModel.ASSOC_CHILDREN, QNAME_A, TYPE_QNAME_TEST_CONTENT, properties).getChildRef();
        NodeRef r_ = new NodeRef(this.archiveStoreRef, r.getId());
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.verifyAspectExistence(r, ContentModel.ASPECT_AUDITABLE, false);
        this.nodeService.deleteNode(r);
        this.verifyNodeExistence(r, false);
        this.verifyNodeExistence(r_, true);
        this.commitAndBeginNewTransaction();
        RestoreNodeReport report = this.nodeArchiveService.restoreArchivedNode(r_);
        ArchiveAndRestoreTest.assertEquals((String)"Restore failed", (Object)RestoreNodeReport.RestoreStatus.SUCCESS, (Object)report.getStatus());
        this.commitAndBeginNewTransaction();
        this.verifyNodeExistence(r, true);
        this.verifyAspectExistence(r, ContentModel.ASPECT_AUDITABLE, false);
        this.nodeService.deleteNode(r);
    }

    public void testALF17554ArchiveAndRestoreCheckPermission() throws Exception {
        this.permissionService.setInheritParentPermissions(this.a, false);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_C);
        ArchiveAndRestoreTest.assertTrue((String)"The user should not have the permission set on the node yet.", (this.permissionService.hasPermission(this.a, "Coordinator") == AccessStatus.DENIED ? 1 : 0) != 0);
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.permissionService.setPermission(this.a, USER_C, "Coordinator", true);
        ArchiveAndRestoreTest.assertTrue((String)"The user should have the permission set on the node.", (this.permissionService.hasPermission(this.a, "Coordinator") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.commitAndBeginNewTransaction();
        this.nodeService.deleteNode(this.a);
        this.verifyNodeExistence(this.a, false);
        this.nodeService.restoreNode(this.a_, null, null, null);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_C);
        ArchiveAndRestoreTest.assertTrue((String)"The user should have the same permission after restoring the node.", (this.permissionService.hasPermission(this.a, "Coordinator") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        ArchiveAndRestoreTest.assertFalse((String)"The node should have InheritParentPermissions set to false.", (boolean)this.permissionService.getInheritParentPermissions(this.a));
    }

    public void testMNT2715ArchiveAndRestoreWithOwnableAndWithout() throws Exception {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.nodeService.removeAspect(this.a, ContentModel.ASPECT_OWNABLE);
        this.nodeService.removeAspect(this.b, ContentModel.ASPECT_OWNABLE);
        this.commitAndBeginNewTransaction();
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_B);
        this.nodeService.deleteNode(this.b);
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.verifyNodeExistence(this.b, false);
        this.commitAndBeginNewTransaction();
        this.nodeService.restoreNode(this.b_, null, null, null);
        ArchiveAndRestoreTest.assertNull((String)"The node should'n have the ownable aspect if it didn't has it before deleting/restoring", (Object)this.nodeService.getProperty(this.b, ContentModel.PROP_OWNER));
        this.commitAndBeginNewTransaction();
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_A);
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(ContentModel.PROP_OWNER, AuthenticationUtil.getFullyAuthenticatedUser());
        this.nodeService.addAspect(this.a, ContentModel.ASPECT_OWNABLE, properties);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_B);
        this.nodeService.deleteNode(this.a);
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.verifyNodeExistence(this.a, false);
        this.commitAndBeginNewTransaction();
        this.nodeService.restoreNode(this.a_, null, null, null);
        ArchiveAndRestoreTest.assertTrue((String)"The node should have the same owner after restoring as before deleting", (boolean)this.nodeService.getProperty(this.a, ContentModel.PROP_OWNER).equals(USER_A));
    }

    public void testListArchivedNodesPermissions() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_B);
        ScriptPagingDetails paging = new ScriptPagingDetails(2, 0);
        ArchivedNodesCannedQueryBuilder queryBuilder = new ArchivedNodesCannedQueryBuilder.Builder(this.archiveStoreRootNodeRef, (PagingRequest)paging).build();
        PagingResults result = this.runListArchivedNodesAsAdmin(queryBuilder);
        ArchiveAndRestoreTest.assertEquals((String)"USER_B hasn't deleted anything yet.", (int)0, (int)result.getPage().size());
        this.nodeService.deleteNode(this.bb);
        result = this.nodeArchiveService.listArchivedNodes(queryBuilder);
        ArchiveAndRestoreTest.assertEquals((String)"USER_B deleted 1 item and USER_B can see it.", (int)1, (int)result.getPage().size());
        result = this.runListArchivedNodesAsAdmin(queryBuilder);
        ArchiveAndRestoreTest.assertEquals((String)"USER_B deleted only 1 item.", (int)1, (int)result.getPage().size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_A);
        this.nodeService.deleteNode(this.aa);
        queryBuilder = new ArchivedNodesCannedQueryBuilder.Builder(this.archiveStoreRootNodeRef, (PagingRequest)paging).build();
        result = this.nodeArchiveService.listArchivedNodes(queryBuilder);
        ArchiveAndRestoreTest.assertEquals((String)"USER_A deleted 1 item and USER_A can see it.", (int)1, (int)result.getPage().size());
        result = this.runListArchivedNodesAsAdmin(queryBuilder);
        ArchiveAndRestoreTest.assertEquals((String)"USER_A deleted only 1 item.", (int)1, (int)result.getPage().size());
        ArchiveAndRestoreTest.assertEquals((Object)QNAME_AA.getLocalName(), (Object)this.nodeService.getProperty((NodeRef)result.getPage().get(0), ContentModel.PROP_NAME));
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        queryBuilder = new ArchivedNodesCannedQueryBuilder.Builder(this.archiveStoreRootNodeRef, (PagingRequest)paging).build();
        result = this.nodeArchiveService.listArchivedNodes(queryBuilder);
        ArchiveAndRestoreTest.assertEquals((String)"Admin can retrieve all users' deleted nodes.", (int)2, (int)result.getPage().size());
    }

    private PagingResults<NodeRef> runListArchivedNodesAsAdmin(final ArchivedNodesCannedQueryBuilder queryBuilder) {
        return (PagingResults)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<PagingResults<NodeRef>>(){

            public PagingResults<NodeRef> doWork() throws Exception {
                return ArchiveAndRestoreTest.this.nodeArchiveService.listArchivedNodes(queryBuilder);
            }
        }, (String)AuthenticationUtil.getAdminUserName());
    }

    public void testListArchivedNodesSort() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(ContentModel.PROP_NAME, "testDoc.txt");
        NodeRef testDoc = this.nodeService.createNode(this.a, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTENT, properties).getChildRef();
        this.nodeService.deleteNode(this.aa);
        this.nodeService.deleteNode(testDoc);
        this.nodeService.deleteNode(this.bb);
        HashSet<QName> inclusiveAspects = new HashSet<QName>(1);
        inclusiveAspects.add(ContentModel.ASPECT_ARCHIVED);
        ScriptPagingDetails paging = new ScriptPagingDetails(3, 0);
        ArchivedNodesCannedQueryBuilder queryBuilder = new ArchivedNodesCannedQueryBuilder.Builder(this.archiveStoreRootNodeRef, (PagingRequest)paging).sortOrderAscending(false).build();
        PagingResults result = this.nodeArchiveService.listArchivedNodes(queryBuilder);
        ArchiveAndRestoreTest.assertEquals((String)"There are 3 nodes deleted by the Admin.", (int)3, (int)result.getPage().size());
        ArchiveAndRestoreTest.assertEquals((Object)QNAME_BB.getLocalName(), (Object)this.nodeService.getProperty((NodeRef)result.getPage().get(0), ContentModel.PROP_NAME));
        ArchiveAndRestoreTest.assertEquals((Object)"testDoc.txt", (Object)this.nodeService.getProperty((NodeRef)result.getPage().get(1), ContentModel.PROP_NAME));
        ArchiveAndRestoreTest.assertEquals((Object)QNAME_AA.getLocalName(), (Object)this.nodeService.getProperty((NodeRef)result.getPage().get(2), ContentModel.PROP_NAME));
    }

    public void testListArchivedNodesFilter() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(ContentModel.PROP_NAME, "pictureOneTest.jpg");
        NodeRef pic1 = this.nodeService.createNode(this.a, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTENT, properties).getChildRef();
        properties = new HashMap(1);
        properties.put(ContentModel.PROP_NAME, "pictureTwoTest.jpg");
        NodeRef pic2 = this.nodeService.createNode(this.a, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTENT, properties).getChildRef();
        properties = new HashMap(1);
        properties.put(ContentModel.PROP_NAME, "pictureThreeTest.png");
        NodeRef pic3 = this.nodeService.createNode(this.a, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTENT, properties).getChildRef();
        this.nodeService.deleteNode(this.aa);
        this.nodeService.deleteNode(this.bb);
        this.nodeService.deleteNode(pic1);
        this.nodeService.deleteNode(pic2);
        this.nodeService.deleteNode(pic3);
        ScriptPagingDetails paging = new ScriptPagingDetails(5, 0);
        String filter = "picture*";
        ArchivedNodesCannedQueryBuilder queryBuilder = new ArchivedNodesCannedQueryBuilder.Builder(this.archiveStoreRootNodeRef, (PagingRequest)paging).filter(filter).sortOrderAscending(false).build();
        PagingResults result = this.nodeArchiveService.listArchivedNodes(queryBuilder);
        ArchiveAndRestoreTest.assertEquals((String)"There are 3 nodes that match 'picture*' pattern.", (int)3, (int)result.getPage().size());
        ArchiveAndRestoreTest.assertEquals((Object)"pictureThreeTest.png", (Object)this.nodeService.getProperty((NodeRef)result.getPage().get(0), ContentModel.PROP_NAME));
        ArchiveAndRestoreTest.assertEquals((Object)"pictureTwoTest.jpg", (Object)this.nodeService.getProperty((NodeRef)result.getPage().get(1), ContentModel.PROP_NAME));
        ArchiveAndRestoreTest.assertEquals((Object)"pictureOneTest.jpg", (Object)this.nodeService.getProperty((NodeRef)result.getPage().get(2), ContentModel.PROP_NAME));
        filter = "pictureT*.jpg";
        queryBuilder = new ArchivedNodesCannedQueryBuilder.Builder(this.archiveStoreRootNodeRef, (PagingRequest)paging).filter(filter).sortOrderAscending(false).build();
        result = this.nodeArchiveService.listArchivedNodes(queryBuilder);
        ArchiveAndRestoreTest.assertEquals((String)"There is only 1 node that matches 'pictureT*.jpg' pattern.", (int)1, (int)result.getPage().size());
        ArchiveAndRestoreTest.assertEquals((Object)"pictureTwoTest.jpg", (Object)this.nodeService.getProperty((NodeRef)result.getPage().get(0), ContentModel.PROP_NAME));
        filter = "*Test.jpg";
        queryBuilder = new ArchivedNodesCannedQueryBuilder.Builder(this.archiveStoreRootNodeRef, (PagingRequest)paging).filter(filter).sortOrderAscending(false).build();
        result = this.nodeArchiveService.listArchivedNodes(queryBuilder);
        ArchiveAndRestoreTest.assertEquals((String)"There are 2 nodes that match '*Test.jpg' pattern.", (int)2, (int)result.getPage().size());
        ArchiveAndRestoreTest.assertEquals((Object)"pictureTwoTest.jpg", (Object)this.nodeService.getProperty((NodeRef)result.getPage().get(0), ContentModel.PROP_NAME));
        ArchiveAndRestoreTest.assertEquals((Object)"pictureOneTest.jpg", (Object)this.nodeService.getProperty((NodeRef)result.getPage().get(1), ContentModel.PROP_NAME));
        filter = "*test.jpg";
        queryBuilder = new ArchivedNodesCannedQueryBuilder.Builder(this.archiveStoreRootNodeRef, (PagingRequest)paging).filter(filter).sortOrderAscending(false).build();
        result = this.nodeArchiveService.listArchivedNodes(queryBuilder);
        ArchiveAndRestoreTest.assertEquals((String)"There are 2 nodes that matches '*test.jpg' pattern.", (int)2, (int)result.getPage().size());
    }
}

