/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacadeFactoryBean;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;

public class IdentityServiceFacadeFactoryBeanTest {
    private static final String EXPECTED_ISSUER = "expected-issuer";
    private static final String EXPECTED_AUDIENCE = "expected-audience";

    @Test
    public void shouldCreateJwtDecoderWithoutIDSWhenPublicKeyIsProvided() {
        IdentityServiceConfig config = (IdentityServiceConfig)Mockito.mock(IdentityServiceConfig.class);
        Mockito.when((Object)config.getRealmKey()).thenReturn((Object)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAve3MabX/rp3LbE7/zNqKxuid8WT7y4qSXsNaiPvl/OVbNWW/cu5td1VndItYhH6/gL7Z5W/r4MOeTlz/fOdXfjrRJou2f3UiPQwLV9RdOH3oS4/BUe+sviD8Q3eRfWBWWz3yw8f2YNtD4bMztIMMjqthvwdEEb9S9jbxxD0o71Bsrz/FwPi7HhSDA+Z/p01Hct8m4wx13ZlKRd4YjyC12FBmi9MSgsrFuWzyQHhHTeBDoALpfuiut3rhVxUtFmVTpy6p9vil7C5J5pok4MXPH0dJCyDNQz05ww5+fD+tfksIEpFeokRpN226F+P21oQVFUWwYIaXaFlG/hfvwmnlfQIDAQAB");
        Mockito.when((Object)config.isClientIdValidationDisabled()).thenReturn((Object)true);
        ClientRegistration.ProviderDetails providerDetails = (ClientRegistration.ProviderDetails)Mockito.mock(ClientRegistration.ProviderDetails.class);
        Mockito.when((Object)providerDetails.getIssuerUri()).thenReturn((Object)"https://my.issuer");
        IdentityServiceFacadeFactoryBean.JwtDecoderProvider provider = new IdentityServiceFacadeFactoryBean.JwtDecoderProvider(config);
        JwtDecoder decoder = provider.createJwtDecoder(null, providerDetails);
        Jwt decodedToken = decoder.decode("eyJhbGciOiJSUzI1NiJ9.eyJleHAiOjIxNDc0ODM2NDcsImp0aSI6IjEyMzQiLCJpc3MiOiJodHRwczovL215Lmlzc3VlciIsInN1YiI6ImFiYzEyMyIsInR5cCI6IkJlYXJlciIsInByZWZlcnJlZF91c2VybmFtZSI6InBpb3RyZWsifQ.k_KaOrLLh3QsT8mKphkcz2vKpulgxp92UoEDccpHJ1mxE3Pa3gFXPKTj4goUBKXieGPZRMvBDhfWNxMvRYZPiQr2NXJKapkh0bTd0qoaSWz9ICe9Nu3eg7_VA_nwUVPz_35wwmrxgVk0_kpUYQN_VtaO7ZgFE2sJzFjbkVls5aqfAMnEjEgQl837hqZvmlW2ZRWebtxXfQxAjtp0gcTg-xtAHKIINYo_1_uAtt_H9L8KqFaioxrVAEDDIlcKnb-Ks3Y62CrZauaGUJeN_aNj2gdOpdkhvCw79yJyZSGZ7okjGbidCNSAf7Bo2Y6h3dP1Gga7kRmD648ftZESrNvbyg");
        Assertions.assertThat((Object)decodedToken).isNotNull();
        Map claims = decodedToken.getClaims();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)claims).isNotNull()).isNotEmpty()).containsEntry((Object)"preferred_username", (Object)"piotrek");
    }

    @Test
    public void shouldFailWithNotMatchingIssuerURIs() {
        IdentityServiceFacadeFactoryBean.JwtIssuerValidator issuerValidator = new IdentityServiceFacadeFactoryBean.JwtIssuerValidator(EXPECTED_ISSUER);
        OAuth2TokenValidatorResult validationResult = issuerValidator.validate(this.tokenWithIssuer("different-issuer"));
        Assertions.assertThat((Object)validationResult).isNotNull();
        Assertions.assertThat((boolean)validationResult.hasErrors()).isTrue();
        Assertions.assertThat((Collection)validationResult.getErrors()).hasSize(1);
        OAuth2Error error = (OAuth2Error)validationResult.getErrors().iterator().next();
        Assertions.assertThat((Object)error).isNotNull();
        Assertions.assertThat((String)error.getDescription()).contains(new CharSequence[]{EXPECTED_ISSUER, "different-issuer"});
    }

    @Test
    public void shouldFailWithNullIssuerURI() {
        IdentityServiceFacadeFactoryBean.JwtIssuerValidator issuerValidator = new IdentityServiceFacadeFactoryBean.JwtIssuerValidator(EXPECTED_ISSUER);
        OAuth2TokenValidatorResult validationResult = issuerValidator.validate(this.tokenWithIssuer(null));
        Assertions.assertThat((Object)validationResult).isNotNull();
        Assertions.assertThat((boolean)validationResult.hasErrors()).isTrue();
        Assertions.assertThat((Collection)validationResult.getErrors()).hasSize(1);
        OAuth2Error error = (OAuth2Error)validationResult.getErrors().iterator().next();
        Assertions.assertThat((Object)error).isNotNull();
        Assertions.assertThat((String)error.getDescription()).contains(new CharSequence[]{EXPECTED_ISSUER, "null"});
    }

    @Test
    public void shouldSucceedWithMatchingIssuerURI() {
        IdentityServiceFacadeFactoryBean.JwtIssuerValidator issuerValidator = new IdentityServiceFacadeFactoryBean.JwtIssuerValidator(EXPECTED_ISSUER);
        OAuth2TokenValidatorResult validationResult = issuerValidator.validate(this.tokenWithIssuer(EXPECTED_ISSUER));
        Assertions.assertThat((Object)validationResult).isNotNull();
        Assertions.assertThat((boolean)validationResult.hasErrors()).isFalse();
        Assertions.assertThat((Collection)validationResult.getErrors()).isEmpty();
    }

    @Test
    public void shouldFailWithNotMatchingAudienceList() {
        IdentityServiceFacadeFactoryBean.JwtAudienceValidator audienceValidator = new IdentityServiceFacadeFactoryBean.JwtAudienceValidator(EXPECTED_AUDIENCE);
        OAuth2TokenValidatorResult validationResult = audienceValidator.validate(this.tokenWithAudience(List.of("different-audience")));
        Assertions.assertThat((Object)validationResult).isNotNull();
        Assertions.assertThat((boolean)validationResult.hasErrors()).isTrue();
        Assertions.assertThat((Collection)validationResult.getErrors()).hasSize(1);
        OAuth2Error error = (OAuth2Error)validationResult.getErrors().iterator().next();
        Assertions.assertThat((Object)error).isNotNull();
        Assertions.assertThat((String)error.getDescription()).contains(new CharSequence[]{EXPECTED_AUDIENCE});
    }

    @Test
    public void shouldFailWithNullAudience() {
        IdentityServiceFacadeFactoryBean.JwtAudienceValidator audienceValidator = new IdentityServiceFacadeFactoryBean.JwtAudienceValidator(EXPECTED_AUDIENCE);
        OAuth2TokenValidatorResult validationResult = audienceValidator.validate(this.tokenWithAudience(null));
        Assertions.assertThat((Object)validationResult).isNotNull();
        Assertions.assertThat((boolean)validationResult.hasErrors()).isTrue();
        Assertions.assertThat((Collection)validationResult.getErrors()).hasSize(1);
        OAuth2Error error = (OAuth2Error)validationResult.getErrors().iterator().next();
        Assertions.assertThat((Object)error).isNotNull();
        Assertions.assertThat((String)error.getDescription()).contains(new CharSequence[]{EXPECTED_AUDIENCE});
    }

    @Test
    public void shouldSucceedWithMatchingAudienceList() {
        IdentityServiceFacadeFactoryBean.JwtAudienceValidator audienceValidator = new IdentityServiceFacadeFactoryBean.JwtAudienceValidator(EXPECTED_AUDIENCE);
        OAuth2TokenValidatorResult validationResult = audienceValidator.validate(this.tokenWithAudience(List.of(EXPECTED_AUDIENCE)));
        Assertions.assertThat((Object)validationResult).isNotNull();
        Assertions.assertThat((boolean)validationResult.hasErrors()).isFalse();
        Assertions.assertThat((Collection)validationResult.getErrors()).isEmpty();
    }

    @Test
    public void shouldSucceedWithMatchingSingleAudience() {
        IdentityServiceFacadeFactoryBean.JwtAudienceValidator audienceValidator = new IdentityServiceFacadeFactoryBean.JwtAudienceValidator(EXPECTED_AUDIENCE);
        Jwt token = Jwt.withTokenValue((String)UUID.randomUUID().toString()).claim("aud", (Object)EXPECTED_AUDIENCE).header("JUST", (Object)"FOR TESTING").build();
        OAuth2TokenValidatorResult validationResult = audienceValidator.validate(token);
        Assertions.assertThat((Object)validationResult).isNotNull();
        Assertions.assertThat((boolean)validationResult.hasErrors()).isFalse();
        Assertions.assertThat((Collection)validationResult.getErrors()).isEmpty();
    }

    private Jwt tokenWithIssuer(String issuer) {
        return Jwt.withTokenValue((String)UUID.randomUUID().toString()).issuer(issuer).header("JUST", (Object)"FOR TESTING").build();
    }

    private Jwt tokenWithAudience(Collection<String> audience) {
        return Jwt.withTokenValue((String)UUID.randomUUID().toString()).audience(audience).header("JUST", (Object)"FOR TESTING").build();
    }
}

