/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import org.alfresco.repo.model.Repository;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.EmailHelper;
import org.alfresco.util.GUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.extensions.surf.util.I18NUtil;

public class EmailHelperTest {
    private static final String FALLBACK_TEMPLATE_PATH = "alfresco/templates/email-templates/test-email-template.ftl";
    private static final String CLIENT_NAME = "test-client";
    @Mock
    private ServiceRegistry serviceRegistryMock;
    @Mock
    private NodeService nodeServiceMock;
    @Mock
    private SearchService searchServiceMock;
    @Mock
    private NamespaceService namespaceServiceMock;
    @Mock
    private FileFolderService fileFolderServiceMock;
    @Mock
    private PersonService personServiceMock;
    @Mock
    private PreferenceService preferenceServiceMock;
    @Mock
    private Repository repositoryHelperMock;
    @Mock
    private TemplateLoader templateLoaderMock;
    private EmailHelper emailHelper;
    private NodeRef dummyTemplateNodeRef;

    @Before
    public void setup() throws Exception {
        this.dummyTemplateNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate());
        this.serviceRegistryMock = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        this.nodeServiceMock = (NodeService)Mockito.mock(NodeService.class);
        this.searchServiceMock = (SearchService)Mockito.mock(SearchService.class);
        this.namespaceServiceMock = (NamespaceService)Mockito.mock(NamespaceService.class);
        this.fileFolderServiceMock = (FileFolderService)Mockito.mock(FileFolderService.class);
        this.personServiceMock = (PersonService)Mockito.mock(PersonService.class);
        this.preferenceServiceMock = (PreferenceService)Mockito.mock(PreferenceService.class);
        this.repositoryHelperMock = (Repository)Mockito.mock(Repository.class);
        this.templateLoaderMock = (TemplateLoader)Mockito.mock(TemplateLoader.class);
        Mockito.when((Object)this.serviceRegistryMock.getNodeService()).thenReturn((Object)this.nodeServiceMock);
        Mockito.when((Object)this.serviceRegistryMock.getSearchService()).thenReturn((Object)this.searchServiceMock);
        Mockito.when((Object)this.serviceRegistryMock.getNamespaceService()).thenReturn((Object)this.namespaceServiceMock);
        Mockito.when((Object)this.serviceRegistryMock.getFileFolderService()).thenReturn((Object)this.fileFolderServiceMock);
        Mockito.when((Object)this.serviceRegistryMock.getPersonService()).thenReturn((Object)this.personServiceMock);
        Mockito.when((Object)this.serviceRegistryMock.getContentService()).thenReturn((Object)((ContentService)Mockito.mock(ContentService.class)));
        Mockito.when((Object)this.repositoryHelperMock.getRootHome()).thenReturn((Object)new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate()));
        Mockito.when((Object)this.fileFolderServiceMock.getLocalizedSibling(this.dummyTemplateNodeRef)).thenReturn((Object)this.dummyTemplateNodeRef);
        this.emailHelper = new EmailHelper();
        this.emailHelper.setServiceRegistry(this.serviceRegistryMock);
        this.emailHelper.setPreferenceService(this.preferenceServiceMock);
        this.emailHelper.setRepositoryHelper(this.repositoryHelperMock);
        this.emailHelper.setCompanyHomeChildName("app:company_home");
        this.emailHelper.init();
        this.emailHelper.setTemplateLoader(this.templateLoaderMock);
    }

    @Test
    public void testGetEmailTemplate() throws Exception {
        String result = this.emailHelper.getEmailTemplate(CLIENT_NAME, null, FALLBACK_TEMPLATE_PATH);
        Assert.assertEquals((String)"The given template path is null, so the fallback template should be returned.", (Object)result, (Object)FALLBACK_TEMPLATE_PATH);
        Mockito.when((Object)this.searchServiceMock.selectNodes(this.repositoryHelperMock.getRootHome(), "app:company_home/app:dictionary/app:email_templates/example-email.ftl", null, (NamespacePrefixResolver)this.namespaceServiceMock, false)).thenReturn(Collections.emptyList());
        result = this.emailHelper.getEmailTemplate(CLIENT_NAME, "app:company_home/app:dictionary/app:email_templates/example-email.ftl", FALLBACK_TEMPLATE_PATH);
        Assert.assertEquals((String)"Couldn't find email template with the given XPath, so the fallback template should be returned.", (Object)result, (Object)FALLBACK_TEMPLATE_PATH);
        Mockito.when((Object)this.searchServiceMock.selectNodes(this.repositoryHelperMock.getRootHome(), "app:company_home/app:dictionary/app:email_templates/example-email.ftl", null, (NamespacePrefixResolver)this.namespaceServiceMock, false)).thenReturn(Collections.singletonList(this.dummyTemplateNodeRef));
        result = this.emailHelper.getEmailTemplate(CLIENT_NAME, "app:company_home/app:dictionary/app:email_templates/example-email.ftl", FALLBACK_TEMPLATE_PATH);
        Assert.assertEquals((Object)result, (Object)this.dummyTemplateNodeRef.toString());
        String xpath = "/app:company_home/app:dictionary/app:email_templates/example-email.ftl";
        result = this.emailHelper.getEmailTemplate(CLIENT_NAME, xpath, FALLBACK_TEMPLATE_PATH);
        Assert.assertEquals((Object)result, (Object)this.dummyTemplateNodeRef.toString());
        Mockito.when((Object)this.searchServiceMock.selectNodes(this.repositoryHelperMock.getRootHome(), "app:company_home/app:dictionary/app:email_templates/example-email.ftl", null, (NamespacePrefixResolver)this.namespaceServiceMock, false)).thenReturn(Arrays.asList(this.dummyTemplateNodeRef, new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate()), new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate())));
        result = this.emailHelper.getEmailTemplate(CLIENT_NAME, "app:company_home/app:dictionary/app:email_templates/example-email.ftl", FALLBACK_TEMPLATE_PATH);
        Assert.assertEquals((Object)result, (Object)this.dummyTemplateNodeRef.toString());
        Mockito.when((Object)this.nodeServiceMock.exists(this.dummyTemplateNodeRef)).thenReturn((Object)false);
        result = this.emailHelper.getEmailTemplate(CLIENT_NAME, this.dummyTemplateNodeRef.toString(), FALLBACK_TEMPLATE_PATH);
        Assert.assertEquals((String)"Couldn't find email template with the given NodeRef, so the fallback template should be returned.", (Object)result, (Object)FALLBACK_TEMPLATE_PATH);
        Mockito.when((Object)this.nodeServiceMock.exists(this.dummyTemplateNodeRef)).thenReturn((Object)true);
        result = this.emailHelper.getEmailTemplate(CLIENT_NAME, this.dummyTemplateNodeRef.toString(), FALLBACK_TEMPLATE_PATH);
        Assert.assertEquals((Object)result, (Object)this.dummyTemplateNodeRef.toString());
        String classPathTemplate = "alfresco/templates/email-templates/new-template.html";
        Mockito.when((Object)this.templateLoaderMock.findTemplateSource(classPathTemplate)).thenReturn(null);
        result = this.emailHelper.getEmailTemplate(CLIENT_NAME, classPathTemplate, FALLBACK_TEMPLATE_PATH);
        Assert.assertEquals((String)"Couldn't find email template with the given class path, so the fallback template should be returned.", (Object)result, (Object)FALLBACK_TEMPLATE_PATH);
        Mockito.when((Object)this.templateLoaderMock.findTemplateSource(classPathTemplate)).thenReturn(new Object());
        result = this.emailHelper.getEmailTemplate(CLIENT_NAME, classPathTemplate, FALLBACK_TEMPLATE_PATH);
        Assert.assertEquals((Object)result, (Object)classPathTemplate);
        Mockito.when((Object)this.templateLoaderMock.findTemplateSource(classPathTemplate)).thenThrow(new Throwable[]{new IOException()});
        result = this.emailHelper.getEmailTemplate(CLIENT_NAME, classPathTemplate, FALLBACK_TEMPLATE_PATH);
        Assert.assertEquals((String)"Error occurred while finding the email template with the class path, so the fallback template should be returned.", (Object)result, (Object)FALLBACK_TEMPLATE_PATH);
        NodeRef nodeRef = this.emailHelper.getLocalizedEmailTemplateNodeRef(null);
        Assert.assertNull((Object)nodeRef);
        nodeRef = this.emailHelper.getLocalizedEmailTemplateNodeRef("");
        Assert.assertNull((Object)nodeRef);
    }

    @Test
    public void testGetUserLocaleOrDefault() throws Exception {
        String userId = "testUser";
        Locale locale = this.emailHelper.getUserLocaleOrDefault(null);
        Assert.assertEquals((Object)I18NUtil.getLocale(), (Object)locale);
        Mockito.when((Object)this.personServiceMock.personExists(userId)).thenReturn((Object)false);
        locale = this.emailHelper.getUserLocaleOrDefault(userId);
        Assert.assertEquals((Object)I18NUtil.getLocale(), (Object)locale);
        Mockito.when((Object)this.personServiceMock.personExists(userId)).thenReturn((Object)true);
        Mockito.when((Object)this.preferenceServiceMock.getPreference(userId, "locale")).thenReturn(null);
        locale = this.emailHelper.getUserLocaleOrDefault(userId);
        Assert.assertEquals((Object)I18NUtil.getLocale(), (Object)locale);
        Mockito.when((Object)this.preferenceServiceMock.getPreference(userId, "locale")).thenReturn((Object)"fr-FR");
        locale = this.emailHelper.getUserLocaleOrDefault(userId);
        Assert.assertEquals((Object)Locale.FRANCE, (Object)locale);
    }
}

