/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.OIDCUserInfo;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.lang3.StringUtils;

public class IdentityServiceJITProvisioningHandler {
    private final IdentityServiceConfig identityServiceConfig;
    private final IdentityServiceFacade identityServiceFacade;
    private final PersonService personService;
    private final TransactionService transactionService;
    private final BiFunction<IdentityServiceFacade.DecodedAccessToken, String, Optional<? extends OIDCUserInfo>> mapTokenToUserInfoResponse = (token, usernameMappingClaim) -> {
        Optional<String> firstName = Optional.ofNullable(token).map(jwtToken -> jwtToken.getClaim("given_name")).filter(String.class::isInstance).map(String.class::cast);
        Optional<String> lastName = Optional.ofNullable(token).map(jwtToken -> jwtToken.getClaim("family_name")).filter(String.class::isInstance).map(String.class::cast);
        Optional<String> email = Optional.ofNullable(token).map(jwtToken -> jwtToken.getClaim("email")).filter(String.class::isInstance).map(String.class::cast);
        return Optional.ofNullable(token.getClaim(Optional.ofNullable(usernameMappingClaim).filter(StringUtils::isNotBlank).orElse("preferred_username"))).filter(String.class::isInstance).map(String.class::cast).map(this::normalizeUserId).map(username -> new OIDCUserInfo((String)username, firstName.orElse(""), lastName.orElse(""), email.orElse("")));
    };

    public IdentityServiceJITProvisioningHandler(IdentityServiceFacade identityServiceFacade, PersonService personService, TransactionService transactionService, IdentityServiceConfig identityServiceConfig) {
        this.identityServiceFacade = identityServiceFacade;
        this.personService = personService;
        this.transactionService = transactionService;
        this.identityServiceConfig = identityServiceConfig;
    }

    public Optional<OIDCUserInfo> extractUserInfoAndCreateUserIfNeeded(final String bearerToken) {
        final Optional<OIDCUserInfo> userInfoResponse = Optional.ofNullable(bearerToken).filter(Predicate.not(String::isEmpty)).flatMap(token -> this.extractUserInfoResponseFromAccessToken((String)token).filter(userInfo -> StringUtils.isNotEmpty((CharSequence)userInfo.username())).or(() -> this.extractUserInfoResponseFromEndpoint((String)token)));
        if (this.transactionService.isReadOnly() || userInfoResponse.isEmpty()) {
            return userInfoResponse;
        }
        return (Optional)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Optional<OIDCUserInfo>>(){

            public Optional<OIDCUserInfo> doWork() throws Exception {
                return userInfoResponse.map(userInfo -> {
                    if (userInfo.username() != null && IdentityServiceJITProvisioningHandler.this.personService.createMissingPeople() && !IdentityServiceJITProvisioningHandler.this.personService.personExists(userInfo.username())) {
                        if (!userInfo.allFieldsNotEmpty()) {
                            userInfo = IdentityServiceJITProvisioningHandler.this.extractUserInfoResponseFromEndpoint(bearerToken).orElse(userInfo);
                        }
                        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
                        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userInfo.username()));
                        properties.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)userInfo.firstName()));
                        properties.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)userInfo.lastName()));
                        properties.put(ContentModel.PROP_EMAIL, (Serializable)((Object)userInfo.email()));
                        properties.put(ContentModel.PROP_ORGID, (Serializable)((Object)""));
                        properties.put(ContentModel.PROP_HOME_FOLDER_PROVIDER, null);
                        properties.put(ContentModel.PROP_SIZE_CURRENT, Long.valueOf(0L));
                        properties.put(ContentModel.PROP_SIZE_QUOTA, Long.valueOf(-1L));
                        IdentityServiceJITProvisioningHandler.this.personService.createPerson(properties);
                    }
                    return userInfo;
                });
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private Optional<OIDCUserInfo> extractUserInfoResponseFromAccessToken(String bearerToken) {
        return Optional.ofNullable(bearerToken).map(this.identityServiceFacade::decodeToken).flatMap(decodedToken -> this.mapTokenToUserInfoResponse.apply((IdentityServiceFacade.DecodedAccessToken)decodedToken, this.identityServiceConfig.getPrincipalAttribute()));
    }

    private Optional<OIDCUserInfo> extractUserInfoResponseFromEndpoint(String bearerToken) {
        return this.identityServiceFacade.getUserInfo(bearerToken, StringUtils.isNotBlank((CharSequence)this.identityServiceConfig.getPrincipalAttribute()) ? this.identityServiceConfig.getPrincipalAttribute() : "preferred_username").filter(userInfo -> userInfo.username() != null && !userInfo.username().isEmpty()).map(userInfo -> new OIDCUserInfo(this.normalizeUserId(userInfo.username()), Optional.ofNullable(userInfo.firstName()).orElse(""), Optional.ofNullable(userInfo.lastName()).orElse(""), Optional.ofNullable(userInfo.email()).orElse("")));
    }

    private String normalizeUserId(final String userId) {
        if (userId == null) {
            return null;
        }
        String normalized = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return IdentityServiceJITProvisioningHandler.this.personService.getUserIdentifier(userId);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        return normalized == null ? userId : normalized;
    }
}

