/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache.lookup;

import java.io.Serializable;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.alfresco.repo.cache.MemoryCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.control.ControlDAO;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.mockito.Mockito;
import org.springframework.dao.DuplicateKeyException;

public class EntityLookupCacheTest
extends TestCase
implements EntityLookupCache.EntityLookupCallbackDAO<Long, Object, String> {
    SimpleCache<Long, Object> cache;
    private EntityLookupCache<Long, Object, String> entityLookupCacheA;
    private EntityLookupCache<Long, Object, String> entityLookupCacheB;
    private TreeMap<Long, String> database;
    private ControlDAO controlDAO;

    protected void setUp() throws Exception {
        this.cache = new MemoryCache();
        this.entityLookupCacheA = new EntityLookupCache(this.cache, "A", (EntityLookupCache.EntityLookupCallbackDAO)this);
        this.entityLookupCacheB = new EntityLookupCache(this.cache, "B", (EntityLookupCache.EntityLookupCallbackDAO)this);
        this.database = new TreeMap();
        this.controlDAO = (ControlDAO)Mockito.mock(ControlDAO.class);
        Mockito.when((Object)this.controlDAO.createSavepoint(Mockito.anyString())).thenReturn((Object)((Savepoint)Mockito.mock(Savepoint.class)));
    }

    public void testLookupsUsingIncorrectValue() throws Exception {
        try {
            this.entityLookupCacheA.getByValue((Object)this);
        }
        catch (AssertionFailedError assertionFailedError) {}
    }

    public void testLookupAgainstEmpty() throws Exception {
        TestValue value = new TestValue("AAA");
        Pair entityPair = this.entityLookupCacheA.getByValue((Object)value);
        EntityLookupCacheTest.assertNull((Object)entityPair);
        EntityLookupCacheTest.assertTrue((boolean)this.database.isEmpty());
        entityPair = this.entityLookupCacheA.getOrCreateByValue((Object)value);
        EntityLookupCacheTest.assertNotNull((String)"Expected a value to be found", (Object)entityPair);
        Long entityId = (Long)entityPair.getFirst();
        EntityLookupCacheTest.assertTrue((String)"Database ID should have been created", (boolean)this.database.containsKey(entityId));
        EntityLookupCacheTest.assertEquals((String)"Database value incorrect", (String)value.val, (String)this.database.get(entityId));
        entityPair = this.entityLookupCacheA.getOrCreateByValue((Object)value);
        EntityLookupCacheTest.assertNotNull((String)"Expected a value to be found", (Object)entityPair);
        EntityLookupCacheTest.assertEquals((String)"Expected same entity ID", (Object)entityId, (Object)entityPair.getFirst());
        entityPair = this.entityLookupCacheA.getByValue((Object)value);
        EntityLookupCacheTest.assertNotNull((String)"Lookup after create should work", (Object)entityPair);
        entityPair = this.entityLookupCacheA.getByKey((Serializable)entityId);
        EntityLookupCacheTest.assertNotNull((String)"Lookup by key should work after create", (Object)entityPair);
        EntityLookupCacheTest.assertTrue((String)"Looked-up type incorrect", (boolean)(entityPair.getSecond() instanceof TestValue));
        EntityLookupCacheTest.assertEquals((String)"Looked-up type value incorrect", (Object)value, (Object)entityPair.getSecond());
    }

    public void testLookupAgainstExisting() throws Exception {
        this.createValue(new TestValue("AAA"));
        this.createValue(new TestValue("BBB"));
        this.createValue(new TestValue("CCC"));
        Pair entityPair = this.entityLookupCacheA.getByValue((Object)new TestValue("AAA"));
        EntityLookupCacheTest.assertNotNull((String)"Expected value to be found", (Object)entityPair);
        EntityLookupCacheTest.assertEquals((String)"ID is incorrect", (Object)1L, (Object)entityPair.getFirst());
        entityPair = this.entityLookupCacheA.getByKey((Serializable)Long.valueOf(2L));
        EntityLookupCacheTest.assertNotNull((String)"Expected value to be found", (Object)entityPair);
        entityPair = this.entityLookupCacheA.getByValue((Object)new TestValue("CCC"));
        EntityLookupCacheTest.assertNotNull((String)"Expected value to be found", (Object)entityPair);
        EntityLookupCacheTest.assertEquals((String)"ID is incorrect", (Object)3L, (Object)entityPair.getFirst());
    }

    public void testRegions() throws Exception {
        TestValue valueAAA = new TestValue("AAA");
        Pair entityPairAAA = this.entityLookupCacheA.getOrCreateByValue((Object)valueAAA);
        EntityLookupCacheTest.assertNotNull((Object)entityPairAAA);
        EntityLookupCacheTest.assertEquals((String)"AAA", (String)this.database.get(entityPairAAA.getFirst()));
        EntityLookupCacheTest.assertEquals((int)2, (int)this.cache.getKeys().size());
        TestValue valueBBB = new TestValue("BBB");
        Pair entityPairBBB = this.entityLookupCacheB.getOrCreateByValue((Object)valueBBB);
        EntityLookupCacheTest.assertNotNull((Object)entityPairBBB);
        EntityLookupCacheTest.assertEquals((String)"BBB", (String)this.database.get(entityPairBBB.getFirst()));
        EntityLookupCacheTest.assertEquals((int)4, (int)this.cache.getKeys().size());
        entityPairBBB = this.entityLookupCacheA.getByValue((Object)valueBBB);
        EntityLookupCacheTest.assertEquals((int)6, (int)this.cache.getKeys().size());
        entityPairBBB = this.entityLookupCacheB.getByValue((Object)valueAAA);
        EntityLookupCacheTest.assertEquals((int)8, (int)this.cache.getKeys().size());
    }

    public void testNullLookups() throws Exception {
        Object valueNull = null;
        Pair entityPairNull = this.entityLookupCacheA.getOrCreateByValue(valueNull);
        EntityLookupCacheTest.assertNotNull((Object)entityPairNull);
        EntityLookupCacheTest.assertTrue((boolean)this.database.containsKey(entityPairNull.getFirst()));
        EntityLookupCacheTest.assertNull((Object)this.database.get(entityPairNull.getFirst()));
        EntityLookupCacheTest.assertEquals((int)2, (int)this.cache.getKeys().size());
        Pair entityPairCheck = this.entityLookupCacheA.getOrCreateByValue(valueNull);
        EntityLookupCacheTest.assertNotNull((Object)entityPairNull);
        EntityLookupCacheTest.assertTrue((boolean)this.database.containsKey(entityPairNull.getFirst()));
        EntityLookupCacheTest.assertNull((Object)this.database.get(entityPairNull.getFirst()));
        EntityLookupCacheTest.assertEquals((Object)entityPairNull, (Object)entityPairCheck);
    }

    public void testGetOrCreate() throws Exception {
        TestValue valueOne = new TestValue(String.valueOf(this.getName()) + "-ONE");
        Pair entityPairOne = this.entityLookupCacheA.getOrCreateByValue((Object)valueOne);
        EntityLookupCacheTest.assertNotNull((Object)entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        EntityLookupCacheTest.assertEquals((String)valueOne.val, (String)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)2, (int)this.cache.getKeys().size());
        Pair entityPairOneCheck = this.entityLookupCacheA.getOrCreateByValue((Object)valueOne);
        EntityLookupCacheTest.assertNotNull((Object)entityPairOneCheck);
        EntityLookupCacheTest.assertEquals((Object)id, (Object)entityPairOneCheck.getFirst());
    }

    public void testCreateOrGet() throws Exception {
        TestValue valueOne = new TestValue(String.valueOf(this.getName()) + "-ONE");
        Pair entityPairOne = this.entityLookupCacheA.createOrGetByValue((Object)valueOne, this.controlDAO);
        EntityLookupCacheTest.assertNotNull((Object)entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        EntityLookupCacheTest.assertEquals((String)valueOne.val, (String)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)1, (int)this.cache.getKeys().size());
        Pair entityPairOneCheck = this.entityLookupCacheA.createOrGetByValue((Object)valueOne, this.controlDAO);
        EntityLookupCacheTest.assertNotNull((Object)entityPairOneCheck);
        EntityLookupCacheTest.assertEquals((Object)id, (Object)entityPairOneCheck.getFirst());
    }

    public void testUpdate() throws Exception {
        TestValue valueOne = new TestValue(String.valueOf(this.getName()) + "-ONE");
        TestValue valueTwo = new TestValue(String.valueOf(this.getName()) + "-TWO");
        Pair entityPairOne = this.entityLookupCacheA.getOrCreateByValue((Object)valueOne);
        EntityLookupCacheTest.assertNotNull((Object)entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        EntityLookupCacheTest.assertEquals((String)valueOne.val, (String)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)2, (int)this.cache.getKeys().size());
        int updateCount = this.entityLookupCacheA.updateValue((Serializable)id, (Object)valueTwo);
        EntityLookupCacheTest.assertEquals((String)"Update count was incorrect.", (int)1, (int)updateCount);
        EntityLookupCacheTest.assertEquals((String)valueTwo.val, (String)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)2, (int)this.cache.getKeys().size());
    }

    public void testDeleteByKey() throws Exception {
        TestValue valueOne = new TestValue(String.valueOf(this.getName()) + "-ONE");
        Pair entityPairOne = this.entityLookupCacheA.getOrCreateByValue((Object)valueOne);
        EntityLookupCacheTest.assertNotNull((Object)entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        EntityLookupCacheTest.assertEquals((String)valueOne.val, (String)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)2, (int)this.cache.getKeys().size());
        int deleteCount = this.entityLookupCacheA.deleteByKey((Serializable)id);
        EntityLookupCacheTest.assertEquals((String)"Delete count was incorrect.", (int)1, (int)deleteCount);
        EntityLookupCacheTest.assertNull((Object)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)0, (int)this.cache.getKeys().size());
    }

    public void testDeleteByValue() throws Exception {
        TestValue valueOne = new TestValue(String.valueOf(this.getName()) + "-ONE");
        Pair entityPairOne = this.entityLookupCacheA.getOrCreateByValue((Object)valueOne);
        EntityLookupCacheTest.assertNotNull((Object)entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        EntityLookupCacheTest.assertEquals((String)valueOne.val, (String)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)2, (int)this.cache.getKeys().size());
        int deleteCount = this.entityLookupCacheA.deleteByValue((Object)valueOne);
        EntityLookupCacheTest.assertEquals((String)"Delete count was incorrect.", (int)1, (int)deleteCount);
        EntityLookupCacheTest.assertNull((Object)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)0, (int)this.cache.getKeys().size());
    }

    public void testClear() throws Exception {
        TestValue valueOne = new TestValue(String.valueOf(this.getName()) + "-ONE");
        Pair entityPairOne = this.entityLookupCacheA.getOrCreateByValue((Object)valueOne);
        EntityLookupCacheTest.assertNotNull((Object)entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        EntityLookupCacheTest.assertEquals((String)valueOne.val, (String)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)2, (int)this.cache.getKeys().size());
        this.entityLookupCacheA.clear();
        EntityLookupCacheTest.assertEquals((String)valueOne.val, (String)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)0, (int)this.cache.getKeys().size());
    }

    public void testFindByValuesNotFound() {
        this.createValue(new TestValue("AAA"));
        this.createValue(new TestValue("BBB"));
        this.createValue(new TestValue("CCC"));
        ArrayList<Object> valuesToFind = new ArrayList<Object>(3);
        valuesToFind.add(new TestValue("ZZZ"));
        valuesToFind.add(new TestValue("AAA"));
        valuesToFind.add(new TestValue("BBB"));
        List<Pair<Long, Object>> results = this.findByValues(valuesToFind);
        EntityLookupCacheTest.assertNotNull(results);
        EntityLookupCacheTest.assertEquals((int)2, (int)results.size());
    }

    public String getValueKey(Object value) {
        EntityLookupCacheTest.assertNotNull((Object)value);
        EntityLookupCacheTest.assertTrue((boolean)(value instanceof TestValue));
        String dbValue = ((TestValue)value).val;
        return dbValue;
    }

    public List<String> getValueKeys(List<Object> values) {
        ArrayList<String> keys = new ArrayList<String>(values.size());
        for (Object value : values) {
            keys.add(this.getValueKey(value));
        }
        return keys;
    }

    public Pair<Long, Object> findByKey(Long key) {
        EntityLookupCacheTest.assertNotNull((Object)key);
        String dbValue = this.database.get(key);
        if (dbValue == null) {
            return null;
        }
        TestValue value = new TestValue(dbValue);
        return new Pair((Object)key, (Object)value);
    }

    public List<Pair<Long, Object>> findByKeys(List<Long> key) {
        throw new UnsupportedOperationException("Batch lookup not supported in test DAO.");
    }

    public Pair<Long, Object> findByValue(Object value) {
        EntityLookupCacheTest.assertTrue((value == null || value instanceof TestValue ? 1 : 0) != 0);
        String dbValue = value == null ? null : ((TestValue)value).val;
        for (Map.Entry<Long, String> entry : this.database.entrySet()) {
            if (!EqualsHelper.nullSafeEquals((Object)entry.getValue(), (Object)dbValue)) continue;
            return new Pair((Object)entry.getKey(), (Object)entry.getValue());
        }
        return null;
    }

    public List<Pair<Long, Object>> findByValues(List<Object> values) {
        EntityLookupCacheTest.assertNotNull(values);
        EntityLookupCacheTest.assertFalse((boolean)values.isEmpty());
        ArrayList<Pair<Long, Object>> results = new ArrayList<Pair<Long, Object>>(values.size());
        block0: for (Object value : values) {
            String dbValue = value == null ? null : ((TestValue)value).val;
            for (Map.Entry<Long, String> entry : this.database.entrySet()) {
                if (!EqualsHelper.nullSafeEquals((Object)entry.getValue(), (Object)dbValue)) continue;
                results.add((Pair<Long, Object>)new Pair((Object)entry.getKey(), (Object)entry.getValue()));
                continue block0;
            }
        }
        return results;
    }

    public Pair<Long, Object> createValue(Object value) {
        String dbValue;
        EntityLookupCacheTest.assertTrue((value == null || value instanceof TestValue ? 1 : 0) != 0);
        String string = dbValue = value == null ? null : ((TestValue)value).val;
        if (this.database.containsValue(dbValue)) {
            throw new DuplicateKeyException("Value is duplicated: " + value);
        }
        Long lastKey = this.database.isEmpty() ? null : this.database.lastKey();
        Long newKey = null;
        newKey = lastKey == null ? Long.valueOf(1L) : Long.valueOf(lastKey + 1L);
        this.database.put(newKey, dbValue);
        return new Pair((Object)newKey, value);
    }

    public int updateValue(Long key, Object value) {
        EntityLookupCacheTest.assertNotNull((Object)key);
        EntityLookupCacheTest.assertTrue((value == null || value instanceof TestValue ? 1 : 0) != 0);
        Pair<Long, Object> entityPair = this.findByKey(key);
        if (entityPair == null) {
            return 0;
        }
        this.database.put(key, ((TestValue)value).val);
        return 1;
    }

    public int deleteByKey(Long key) {
        EntityLookupCacheTest.assertNotNull((Object)key);
        if (this.database.containsKey(key)) {
            this.database.remove(key);
            return 1;
        }
        return 0;
    }

    public int deleteByValue(Object value) {
        EntityLookupCacheTest.assertTrue((value == null || value instanceof TestValue ? 1 : 0) != 0);
        Pair<Long, Object> entityPair = this.findByValue(value);
        if (entityPair == null) {
            return 0;
        }
        this.database.remove(entityPair.getFirst());
        return 1;
    }

    private static class TestValue {
        private final String val;

        private TestValue(String val) {
            this.val = val;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof TestValue)) {
                return false;
            }
            return this.val.equals(((TestValue)obj).val);
        }

        public int hashCode() {
            return this.val.hashCode();
        }
    }
}

