/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.util.test.junitrules.RetryAtMostRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.model.Statement;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RetryAtMostRuleTest {
    private static final String ANNOTATION_WITH_NEGATIVE_VALUE = "annotationRetryAtMostNegativeTimes";
    private static final String ANNOTATION_RETRY_AT_MOST_THRICE = "annotationRetryAtMostThrice";
    private static final AtomicInteger EXECUTION_COUNT = new AtomicInteger(0);
    @Rule
    public RetryAtMostRule retryAtMostRule = new RetryAtMostRule();
    @Rule
    public TestName testNameRule = new TestName();
    @Mock
    private Statement statementMock;

    @Test
    public void testSucceedOnFirstAttempt() throws Throwable {
        Description description = Description.createTestDescription((String)RetryAtMostRuleTest.class.getSimpleName(), (String)this.testNameRule.getMethodName(), (Annotation[])new Annotation[]{this.getAnnotationByMethodName(ANNOTATION_RETRY_AT_MOST_THRICE)});
        Statement statement = this.retryAtMostRule.apply(this.statementMock, description);
        statement.evaluate();
        ((Statement)Mockito.verify((Object)this.statementMock, (VerificationMode)Mockito.times((int)1))).evaluate();
    }

    @Test
    public void testSucceedOnSecondAttempt() throws Throwable {
        ((Statement)Mockito.doThrow((Throwable[])new Throwable[]{new AssertionError((Object)"First execution should fail")}).doNothing().when((Object)this.statementMock)).evaluate();
        Description description = Description.createTestDescription((String)RetryAtMostRuleTest.class.getSimpleName(), (String)this.testNameRule.getMethodName(), (Annotation[])new Annotation[]{this.getAnnotationByMethodName(ANNOTATION_RETRY_AT_MOST_THRICE)});
        Statement statement = this.retryAtMostRule.apply(this.statementMock, description);
        statement.evaluate();
        ((Statement)Mockito.verify((Object)this.statementMock, (VerificationMode)Mockito.times((int)2))).evaluate();
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testSucceedOnThirdAttempt() {
        int currentExecution = EXECUTION_COUNT.incrementAndGet();
        Assert.assertSame((String)"This test should be executed 3 times", (Object)3, (Object)currentExecution);
    }

    @Test(expected=AssertionError.class)
    public void testFailAfterMaxAttempts() throws Throwable {
        ((Statement)Mockito.doThrow((Throwable[])new Throwable[]{new AssertionError((Object)"All executions should fail")}).when((Object)this.statementMock)).evaluate();
        Description description = Description.createTestDescription((String)RetryAtMostRuleTest.class.getSimpleName(), (String)this.testNameRule.getMethodName(), (Annotation[])new Annotation[]{this.getAnnotationByMethodName(ANNOTATION_RETRY_AT_MOST_THRICE)});
        Statement statement = this.retryAtMostRule.apply(this.statementMock, description);
        statement.evaluate();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRetryAtMostTimes() throws Throwable {
        Description description = Description.createTestDescription((String)RetryAtMostRuleTest.class.getSimpleName(), (String)this.testNameRule.getMethodName(), (Annotation[])new Annotation[]{this.getAnnotationByMethodName(ANNOTATION_WITH_NEGATIVE_VALUE)});
        Statement statement = this.retryAtMostRule.apply(this.statementMock, description);
        statement.evaluate();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.statementMock});
    }

    private Annotation getAnnotationByMethodName(String methodName) throws NoSuchMethodException {
        return this.getClass().getMethod(methodName, new Class[0]).getAnnotation(RetryAtMostRule.RetryAtMost.class);
    }

    @RetryAtMostRule.RetryAtMost(value=-1)
    public void annotationRetryAtMostNegativeTimes() {
    }

    @RetryAtMostRule.RetryAtMost(value=3)
    public void annotationRetryAtMostThrice() {
    }
}

