/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.forms.FieldDefinition;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.FormNotFoundException;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.processor.node.ContentModelFormProcessor;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeFormProcessor
extends ContentModelFormProcessor<NodeRef, NodeRef> {
    private static Log logger = LogFactory.getLog(NodeFormProcessor.class);

    @Override
    protected Log getLogger() {
        return logger;
    }

    @Override
    protected NodeRef getTypedItem(Item item) {
        NodeRef nodeRef;
        block7: {
            nodeRef = null;
            if (NodeRef.isNodeRef((String)item.getId())) {
                nodeRef = new NodeRef(item.getId());
            } else {
                String[] parts = item.getId().split("/");
                if (parts.length == 3) {
                    try {
                        nodeRef = new NodeRef(parts[0], parts[1], parts[2]);
                    }
                    catch (IllegalArgumentException iae) {
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug((Object)("NodeRef creation failed for: " + item.getId()), (Throwable)iae);
                    }
                }
            }
        }
        if (nodeRef == null) {
            throw new FormNotFoundException(item, new IllegalArgumentException(item.getId()));
        }
        if (!this.nodeService.exists(nodeRef)) {
            throw new FormNotFoundException(item, new InvalidNodeRefException("Node does not exist: " + nodeRef, nodeRef));
        }
        return nodeRef;
    }

    @Override
    protected String getItemType(NodeRef item) {
        QName type = this.nodeService.getType(item);
        return type.toPrefixString((NamespacePrefixResolver)this.namespaceService);
    }

    @Override
    protected String getItemURI(NodeRef item) {
        StringBuilder builder = new StringBuilder("/api/node/");
        builder.append(item.getStoreRef().getProtocol()).append("/");
        builder.append(item.getStoreRef().getIdentifier()).append("/");
        builder.append(item.getId());
        return builder.toString();
    }

    @Override
    protected Map<QName, Serializable> getPropertyValues(NodeRef nodeRef) {
        return this.nodeService.getProperties(nodeRef);
    }

    @Override
    protected Map<QName, Serializable> getAssociationValues(NodeRef item) {
        NodeRef target;
        QName name;
        HashMap<QName, Serializable> assocs = new HashMap<QName, Serializable>();
        List targetAssocs = this.nodeService.getTargetAssocs(item, RegexQNamePattern.MATCH_ALL);
        List childAssocs = this.nodeService.getChildAssocs(item);
        for (ChildAssociationRef childAssoc : childAssocs) {
            name = childAssoc.getTypeQName();
            target = childAssoc.getChildRef();
            this.addAssocToMap(name, target, assocs);
        }
        for (AssociationRef associationRef : targetAssocs) {
            name = associationRef.getTypeQName();
            target = associationRef.getTargetRef();
            if (!this.nodeService.exists(target) || this.permissionService.hasPermission(target, "Read") != AccessStatus.ALLOWED) continue;
            this.addAssocToMap(name, target, assocs);
        }
        return assocs;
    }

    private void addAssocToMap(QName name, NodeRef target, HashMap<QName, Serializable> assocs) {
        Serializable value = assocs.get(name);
        if (value == null) {
            LinkedHashSet<NodeRef> values = new LinkedHashSet<NodeRef>();
            values.add(target);
            assocs.put(name, values);
        } else if (value instanceof Set) {
            ((Set)((Object)value)).add(target);
        }
    }

    @Override
    protected Map<String, Object> getTransientValues(NodeRef item) {
        HashMap<String, Object> values = new HashMap<String, Object>(3);
        ContentData contentData = this.getContentData(item);
        if (contentData != null) {
            values.put("encoding", contentData.getEncoding());
            values.put("mimetype", contentData.getMimetype());
            values.put("size", contentData.getSize());
        }
        return values;
    }

    @Override
    protected Set<QName> getAspectNames(NodeRef nodeRef) {
        return this.nodeService.getAspects(nodeRef);
    }

    @Override
    protected TypeDefinition getBaseType(NodeRef nodeRef) {
        QName typeName = this.nodeService.getType(nodeRef);
        return this.dictionaryService.getType(typeName);
    }

    private ContentData getContentData(NodeRef nodeRef) {
        QName type = this.nodeService.getType(nodeRef);
        ContentData content = null;
        if (this.dictionaryService.isSubClass(type, ContentModel.TYPE_CONTENT)) {
            content = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
        }
        return content;
    }

    protected void processWorkingCopy(NodeRef nodeRef, Form form) {
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            for (FieldDefinition fieldDef : form.getFieldDefinitions()) {
                if (!fieldDef.getName().equals(ContentModel.PROP_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService))) continue;
                fieldDef.setProtectedField(true);
                if (!this.getLogger().isDebugEnabled()) break;
                this.getLogger().debug((Object)("Set " + ContentModel.PROP_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService) + "field to protected as it is a working copy"));
                break;
            }
        }
    }

    @Override
    protected void internalGenerate(NodeRef item, List<String> fields, List<String> forcedFields, Form form, Map<String, Object> context) {
        super.internalGenerate(item, fields, forcedFields, form, context);
        this.processWorkingCopy(item, form);
    }

    @Override
    protected NodeRef internalPersist(NodeRef item, FormData data) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Persisting form for: " + item));
        }
        this.persistNode(item, data);
        return item;
    }
}

