/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.search.impl.JSONAPIResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJSONAPIResult
implements JSONAPIResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJSONAPIResult.class);
    protected Long status;
    protected Long queryTime;
    protected List<String> cores;
    protected Map<String, Map<String, Object>> coresInfo;

    @Override
    public Long getQueryTime() {
        return this.queryTime;
    }

    @Override
    public Long getStatus() {
        return this.status;
    }

    @Override
    public List<String> getCores() {
        return this.cores == null ? null : Collections.unmodifiableList(this.cores);
    }

    @Override
    public Map<String, Map<String, Object>> getCoresInfo() {
        return this.coresInfo == null ? null : Collections.unmodifiableMap(this.coresInfo);
    }

    protected void processJson(JSONObject json) throws JSONException {
        LOGGER.debug("JSON response: {}", (Object)json);
        JSONObject responseHeader = json.getJSONObject("responseHeader");
        this.status = responseHeader.getLong("status");
        this.queryTime = responseHeader.getLong("QTime");
        this.processCoresInfoJson(json);
    }

    protected Map<String, Object> getPropertyValueMap(JSONObject json) throws JSONException {
        HashMap<String, Object> propertyValueMap = new HashMap<String, Object>();
        JSONArray nodesPropertyNameList = json.names();
        int j = 0;
        while (j < nodesPropertyNameList.length()) {
            String propertyName = String.valueOf(nodesPropertyNameList.get(j));
            Object propertyValue = json.get(propertyName);
            if (propertyValue != JSONObject.NULL) {
                if (propertyValue instanceof Integer) {
                    propertyValue = (long)((Integer)propertyValue).intValue();
                }
                propertyValueMap.put(propertyName, propertyValue);
            }
            ++j;
        }
        return propertyValueMap;
    }

    protected abstract void processCoresInfoJson(JSONObject var1) throws JSONException;
}

