/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr.facet;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.impl.solr.facet.FacetQNameUtils;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetProperties;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.surf.util.ParameterCheck;

public class SolrFacetConfig
extends AbstractLifecycleBean {
    private static final Log logger = LogFactory.getLog(SolrFacetConfig.class);
    private static final String KEY_EXTRA_INFO = ".EXTRA-PROP.";
    private static final int KEY_EXTRA_INFO_LENGTH = ".EXTRA-PROP.".length();
    private final Properties rawProperties;
    private final Set<String> propInheritanceOrder;
    private Map<String, SolrFacetProperties> defaultFacets;
    private NamespaceService namespaceService;

    public SolrFacetConfig(Properties rawProperties, String inheritanceOrder) {
        ParameterCheck.mandatory((String)"rawProperties", (Object)rawProperties);
        ParameterCheck.mandatory((String)"inheritanceOrder", (Object)inheritanceOrder);
        this.rawProperties = rawProperties;
        String[] order = inheritanceOrder.split(",");
        this.propInheritanceOrder = new LinkedHashSet<String>(order.length);
        String[] stringArray = order;
        int n = order.length;
        int n2 = 0;
        while (n2 < n) {
            String ord = stringArray[n2];
            if (ord.length() > 0) {
                this.propInheritanceOrder.add(ord);
            }
            ++n2;
        }
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public synchronized Map<String, SolrFacetProperties> getDefaultFacets() {
        if (this.defaultFacets == null) {
            throw new IllegalStateException("SolrFacetConfig has not been started.");
        }
        return this.defaultFacets;
    }

    protected void onBootstrap(ApplicationEvent event) {
        PropertyCheck.mandatory((Object)((Object)this), (String)"namespaceService", (Object)this.namespaceService);
        this.defaultFacets = ConfigHelper.getFacetPropertiesMap(this.rawProperties, this.propInheritanceOrder, this.namespaceService);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("All bootstrapped facets: " + this.defaultFacets));
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public static class ConfigHelper {
        public static Map<String, SolrFacetProperties> getFacetPropertiesMap(Properties properties, Set<String> inheritanceOrder, NamespaceService namespaceService) {
            HashSet<String> allPropNames = new HashSet<String>(100);
            HashSet<String> propOrderControl = new HashSet<String>(2);
            ConfigHelper.getPropertyAndPropOderControl(properties, allPropNames, propOrderControl);
            Set<String> inheritance = ConfigHelper.getInheritanceOrder(inheritanceOrder, propOrderControl);
            HashMap<String, String> propValues = new HashMap<String, String>(allPropNames.size());
            for (String order : inheritance) {
                for (String string : allPropNames) {
                    String value = properties.getProperty(String.valueOf(order) + '.' + string);
                    if (value == null) continue;
                    propValues.put(string, value);
                }
            }
            HashMap facetFields = new HashMap();
            for (String key : propValues.keySet()) {
                String facetQName = null;
                Set<String> extraProp = null;
                int index = key.indexOf(SolrFacetConfig.KEY_EXTRA_INFO);
                if (index > 0) {
                    String extraInfo = key.substring(index + KEY_EXTRA_INFO_LENGTH);
                    facetQName = key.substring(0, index);
                    extraProp = (Set)facetFields.get(facetQName);
                    if (extraProp == null) {
                        extraProp = new HashSet<String>();
                    }
                    if (extraInfo.length() > 0) {
                        extraProp.add(extraInfo);
                    }
                } else {
                    index = key.lastIndexOf(46);
                    facetQName = key.substring(0, index);
                    extraProp = (HashSet<String>)facetFields.get(facetQName);
                }
                facetFields.put(facetQName, extraProp);
            }
            HashMap<String, SolrFacetProperties> facetProperties = new HashMap<String, SolrFacetProperties>(100);
            for (String string : facetFields.keySet()) {
                QName fieldQName = ConfigHelper.resolveToQName(namespaceService, string);
                String filterID = (String)propValues.get(ValueName.PROP_FILTER_ID.getPropValueName(string));
                String displayName = (String)propValues.get(ValueName.PROP_DISPLAY_NAME.getPropValueName(string));
                String displayControl = (String)propValues.get(ValueName.PROP_DISPLAY_CONTROL.getPropValueName(string));
                int maxFilters = ConfigHelper.getIntegerValue((String)propValues.get(ValueName.PROP_MAX_FILTERS.getPropValueName(string)));
                int hitThreshold = ConfigHelper.getIntegerValue((String)propValues.get(ValueName.PROP_HIT_THRESHOLD.getPropValueName(string)));
                int minFilterValueLength = ConfigHelper.getIntegerValue((String)propValues.get(ValueName.PROP_MIN_FILTER_VALUE_LENGTH.getPropValueName(string)));
                String sortBy = (String)propValues.get(ValueName.PROP_SORTBY.getPropValueName(string));
                String scope = (String)propValues.get(ValueName.PROP_SCOPE.getPropValueName(string));
                Set<String> scopedSites = ConfigHelper.getScopedSites((String)propValues.get(ValueName.PROP_SCOPED_SITES.getPropValueName(string)));
                Boolean isEnabled = Boolean.valueOf((String)propValues.get(ValueName.PROP_IS_ENABLED.getPropValueName(string)));
                Set<SolrFacetProperties.CustomProperties> customProps = ConfigHelper.getCustomProps((Set)facetFields.get(string), string, propValues);
                SolrFacetProperties fp = new SolrFacetProperties.Builder().filterID(filterID).facetQName(fieldQName).displayName(displayName).displayControl(displayControl).maxFilters(maxFilters).hitThreshold(hitThreshold).minFilterValueLength(minFilterValueLength).sortBy(sortBy).scope(scope).isEnabled(isEnabled).isDefault(true).scopedSites(scopedSites).customProperties(customProps).build();
                facetProperties.put(filterID, fp);
            }
            return facetProperties;
        }

        private static Set<String> getInheritanceOrder(Set<String> definedOrder, Set<String> foundOrder) {
            if (foundOrder.size() == 1) {
                return foundOrder;
            }
            boolean result = definedOrder.addAll(foundOrder);
            if (result) {
                logger.warn((Object)("The property inheritance order has not been explicitly defined.  Orders are: " + definedOrder));
            }
            return definedOrder;
        }

        private static void getPropertyAndPropOderControl(Properties properties, Set<String> propNames, Set<String> propOrderControl) {
            for (Object propKeyObj : properties.keySet()) {
                String propKey = (String)propKeyObj;
                int propOrderControlEndDot = propKey.indexOf(46);
                if (propOrderControlEndDot < 1) {
                    logger.debug((Object)("Ignoring property: " + propKey));
                    continue;
                }
                int propKeyLength = propKey.length();
                int propNameLength = propKeyLength - propOrderControlEndDot - 1;
                if (propNameLength < 1) {
                    logger.debug((Object)("Ignoring property: " + propKey));
                    continue;
                }
                String orderControl = propKey.substring(0, propOrderControlEndDot);
                String propName = propKey.substring(propOrderControlEndDot + 1);
                propOrderControl.add(orderControl);
                propNames.add(propName);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("All property order controls: " + propOrderControl));
                logger.debug((Object)("All properties: " + propNames));
            }
        }

        private static Set<String> getScopedSites(String propValue) {
            if (propValue == null) {
                return Collections.emptySet();
            }
            String[] sites = propValue.split(",");
            LinkedHashSet<String> set = new LinkedHashSet<String>(sites.length);
            String[] stringArray = sites;
            int n = sites.length;
            int n2 = 0;
            while (n2 < n) {
                String site = stringArray[n2];
                if (site.length() > 0) {
                    set.add(site);
                }
                ++n2;
            }
            return set;
        }

        private static Set<SolrFacetProperties.CustomProperties> getCustomProps(Set<String> additionalProps, String field, Map<String, String> propValues) {
            if (additionalProps == null) {
                return null;
            }
            HashSet<SolrFacetProperties.CustomProperties> customProps = new HashSet<SolrFacetProperties.CustomProperties>();
            for (String extraInfo : additionalProps) {
                String value = propValues.get(String.valueOf(field) + SolrFacetConfig.KEY_EXTRA_INFO + extraInfo);
                if (value == null) continue;
                QName qName = QName.createQName((String)"http://www.alfresco.org/model/solrfacetcustomproperty/1.0", (String)extraInfo);
                String[] extra = value.split(",");
                if (extra.length == 1) {
                    customProps.add(new SolrFacetProperties.CustomProperties(qName, (Serializable)((Object)extra[0])));
                    continue;
                }
                List<String> list = Arrays.asList(extra);
                customProps.add(new SolrFacetProperties.CustomProperties(qName, (Serializable)((Object)list)));
            }
            return customProps;
        }

        private static int getIntegerValue(String propValue) {
            try {
                return Integer.parseInt(propValue);
            }
            catch (NumberFormatException ne) {
                throw new AlfrescoRuntimeException("Invalid property value. Cannot convert [" + propValue + " ] into an Integer.", (Throwable)ne);
            }
        }

        private static QName resolveToQName(NamespaceService namespaceService, String qnameStr) {
            QName typeQName = FacetQNameUtils.createQName(qnameStr, (NamespacePrefixResolver)namespaceService);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resolved facet field [" + qnameStr + "] into [" + typeQName + "]"));
            }
            return typeQName;
        }
    }

    public static enum ValueName {
        PROP_FILTER_ID("filterID"),
        PROP_DISPLAY_NAME("displayName"),
        PROP_MAX_FILTERS("maxFilters"),
        PROP_HIT_THRESHOLD("hitThreshold"),
        PROP_MIN_FILTER_VALUE_LENGTH("minFilterValueLength"),
        PROP_SORTBY("sortBy"),
        PROP_SCOPE("scope"),
        PROP_SCOPED_SITES("scopedSites"),
        PROP_IS_ENABLED("isEnabled"),
        PROP_DISPLAY_CONTROL("displayControl");

        private String propValueName;

        private ValueName(String propValueName) {
            this.propValueName = propValueName;
        }

        public String getPropValueName(String facetField) {
            return String.valueOf(facetField) + '.' + this.propValueName;
        }
    }
}

