/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.Serializable;
import java.io.Writer;
import java.nio.channels.Channels;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transfer.TransferDestinationReportWriter;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.TransferSummaryReport;
import org.alfresco.repo.transfer.reportd.XMLTransferDestinationReportWriter;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransferSummaryReportImpl
implements TransferSummaryReport {
    public static final String _SIMPLE_REPORT = "_simple_report";
    private static final String _SIMPLE_REPORT_XML = "_simple_report.xml";
    private static final String MSG_INBOUND_TRANSFER_FOLDER_NOT_FOUND = "receiver.record_folder_not_found_for_summary_report";
    private static final Log log = LogFactory.getLog(TransferSummaryReportImpl.class);
    private NodeService nodeService;
    private ContentService contentService;
    private SearchService searchService;
    private FileFolderService fileFolderService;
    private NodeRef reportFile;
    private TransferDestinationReportWriter destinationWriter;
    private NamespaceService namespaceService;
    private String transferSummaryReportLocation;
    private String transferId;

    public TransferSummaryReportImpl(String transferId) {
        this.transferId = transferId;
    }

    @Override
    public void logSummaryCreated(NodeRef sourceNode, NodeRef destNode, NodeRef newParent, String newPath, boolean orphan) {
        TransferDestinationReportWriter writer = this.getLogWriter(this.transferId);
        writer.writeCreated(sourceNode, destNode, newParent, newPath);
    }

    @Override
    public void logSummaryUpdated(NodeRef sourceNode, NodeRef destNode, String path) {
        TransferDestinationReportWriter writer = this.getLogWriter(this.transferId);
        writer.writeUpdated(sourceNode, destNode, path);
    }

    @Override
    public void logSummaryDeleted(NodeRef sourceNode, NodeRef destNode, String oldPath) {
        TransferDestinationReportWriter writer = this.getLogWriter(this.transferId);
        writer.writeDeleted(sourceNode, destNode, oldPath);
    }

    @Override
    public void logSummaryMoved(NodeRef sourceNodeRef, NodeRef destNodeRef, String oldPath, NodeRef newParent, String newPath) {
        TransferDestinationReportWriter writer = this.getLogWriter(this.transferId);
        writer.writeMoved(sourceNodeRef, destNodeRef, oldPath, newParent, newPath);
    }

    @Override
    public void logSummaryComment(Object obj) throws TransferException {
        TransferDestinationReportWriter writer = this.getLogWriter(this.transferId);
        writer.writeComment(obj.toString());
    }

    @Override
    public void logSummaryException(Object obj, Throwable ex) throws TransferException {
        TransferDestinationReportWriter writer = this.getLogWriter(this.transferId);
        writer.writeComment(obj.toString());
        if (ex != null) {
            writer.writeException(ex);
        }
    }

    @Override
    public void logSummaryUpdateStatus(TransferProgress.Status status) throws TransferException {
        TransferDestinationReportWriter writer = this.getLogWriter(this.transferId);
        writer.writeChangeState(status.toString());
        writer.endTransferReport();
    }

    @Override
    public void finishSummaryReport() {
        try {
            TransferDestinationReportWriter writer = this.getLogWriter(this.transferId);
            writer.writeChangeState("finished");
            log.debug((Object)"closing destination transfer summary report");
            writer.endTransferReport();
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private TransferDestinationReportWriter getLogWriter(String transferId) {
        if (this.destinationWriter == null) {
            this.destinationWriter = new XMLTransferDestinationReportWriter();
            Writer createUnderlyingLogWriter = this.createUnderlyingLogWriter(transferId);
            this.destinationWriter.startTransferReport("UTF-8", createUnderlyingLogWriter);
        }
        return this.destinationWriter;
    }

    protected Writer createUnderlyingLogWriter(String transferId) {
        if (this.reportFile == null) {
            this.reportFile = this.createTransferRecord(transferId);
        }
        ContentWriter contentWriter = this.contentService.getWriter(this.reportFile, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/xml");
        contentWriter.setEncoding("UTF-8");
        return Channels.newWriter(contentWriter.getWritableChannel(), "UTF-8");
    }

    private NodeRef createTransferRecord(String transferId) {
        log.debug((Object)"TransferSummaryReport createTransferRecord");
        NodeRef reportParentFolder = this.getParentFolder();
        String name = this.getReportFileName(reportParentFolder);
        QName recordName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)name);
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(ContentModel.PROP_NAME, name);
        props.put(TransferModel.PROP_PROGRESS_POSITION, 0);
        props.put(TransferModel.PROP_PROGRESS_ENDPOINT, 1);
        props.put(TransferModel.PROP_TRANSFER_STATUS, TransferProgress.Status.PRE_COMMIT.toString());
        log.debug((Object)("Creating transfer summary report with name: " + name));
        ChildAssociationRef assoc = this.nodeService.createNode(reportParentFolder, ContentModel.ASSOC_CONTAINS, recordName, TransferModel.TYPE_TRANSFER_RECORD, props);
        log.debug((Object)("<-createTransferSummartReportRecord: " + assoc.getChildRef()));
        return assoc.getChildRef();
    }

    private String getReportBaseName(NodeRef reportParentFolder) {
        String prefixName = null;
        List<FileInfo> list = this.fileFolderService.list(reportParentFolder);
        for (FileInfo file : list) {
            String fileName;
            if (!file.getNodeRef().toString().contains(this.transferId)) continue;
            Serializable name = this.nodeService.getProperty(file.getNodeRef(), ContentModel.PROP_NAME);
            if (!(name instanceof String) || (fileName = (String)((Object)name)).lastIndexOf(".") <= 0) break;
            prefixName = fileName.substring(0, fileName.lastIndexOf("."));
            break;
        }
        return prefixName;
    }

    private String getReportFileName(NodeRef reportParentFolder) {
        String prefixName = this.getReportBaseName(reportParentFolder);
        if (prefixName == null || prefixName.isEmpty()) {
            String timeNow;
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSSZ");
            prefixName = timeNow = format.format(new Date());
        }
        String name = String.valueOf(prefixName) + _SIMPLE_REPORT_XML;
        return name;
    }

    private NodeRef getParentFolder() {
        NodeRef reportParentFolder = null;
        log.debug((Object)("Trying to find transfer summary report records folder: " + this.transferSummaryReportLocation));
        List refs = this.searchService.selectNodes(this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE), this.transferSummaryReportLocation, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (refs.size() <= 0) {
            throw new TransferException(MSG_INBOUND_TRANSFER_FOLDER_NOT_FOUND, new Object[]{this.transferSummaryReportLocation});
        }
        reportParentFolder = (NodeRef)refs.get(0);
        log.debug((Object)("Found transfer summary report records folder: " + reportParentFolder));
        return reportParentFolder;
    }

    public void setTransferSummaryReportLocation(String transferSummaryReportLocation) {
        this.transferSummaryReportLocation = transferSummaryReportLocation;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }
}

