/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Date;
import org.alfresco.repo.content.transform.TransformerLogger;

class DebugEntry {
    final String requestId;
    private final StringBuilder sb = new StringBuilder();
    boolean complete = false;

    DebugEntry(String requestId, String message) {
        this.requestId = requestId;
        this.sb.append(requestId);
        this.sb.append("             ");
        this.sb.append(TransformerLogger.DATE_FORMAT.format(new Date()));
        this.addLine(message);
    }

    void addLine(String message) {
        this.sb.append('\n');
        this.sb.append(message);
        this.complete = message.contains("Finished in");
    }

    public String toString() {
        String string;
        if (this.complete) {
            string = this.sb.toString();
        } else {
            int length = this.sb.length();
            this.sb.append("\n             <<-- INCOMPLETE -->>");
            string = this.sb.toString();
            this.sb.setLength(length);
        }
        return string;
    }
}

