/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock.mem;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.lock.LockUtils;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.lock.mem.LockState;
import org.alfresco.repo.lock.mem.LockStore;
import org.alfresco.repo.lock.mem.LockableAspectInterceptor$AjcClosure1;
import org.alfresco.repo.lock.traitextender.LockableAspectInterceptorExtension;
import org.alfresco.repo.lock.traitextender.LockableAspectInterceptorTrait;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.traitextender.AJExtender;
import org.alfresco.traitextender.Extend;
import org.alfresco.traitextender.ExtendedTrait;
import org.alfresco.traitextender.Extensible;
import org.alfresco.traitextender.RouteExtensions;
import org.alfresco.traitextender.Trait;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class LockableAspectInterceptor
implements MethodInterceptor,
Extensible {
    private LockStore lockStore;
    private AuthenticationService authenticationService;
    private NodeService nodeService;
    private LockService lockService;
    private Set<String> methodsToCheck = new HashSet<String>();
    private final ThreadLocal<Boolean> threadEnabled = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    private final ExtendedTrait<LockableAspectInterceptorTrait> lockableAspectInterceptorTrait = new ExtendedTrait<LockableAspectInterceptorTrait>(this.createTrait());
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;

    public void init() {
        this.methodsToCheck.add("addAspect");
        this.methodsToCheck.add("addProperties");
        this.methodsToCheck.add("removeAspect");
        this.methodsToCheck.add("removeProperty");
        this.methodsToCheck.add("setProperties");
        this.methodsToCheck.add("setProperty");
        this.methodsToCheck.add("setType");
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!this.threadEnabled.get().booleanValue()) {
            return invocation.proceed();
        }
        String methodName = invocation.getMethod().getName();
        Object[] args = invocation.getArguments();
        if (methodName.equals("hasAspect")) {
            NodeRef nodeRef = (NodeRef)args[0];
            QName aspectTypeQName = (QName)args[1];
            LockState lockState = this.getLockState(nodeRef);
            if (ContentModel.ASPECT_LOCKABLE.equals((Object)aspectTypeQName) && this.isEphemeralLock(lockState)) {
                return true;
            }
            return invocation.proceed();
        }
        if (methodName.equals("getAspects")) {
            NodeRef nodeRef = (NodeRef)args[0];
            Set aspects = (Set)invocation.proceed();
            LockState lockState = this.getLockState(nodeRef);
            if (this.isEphemeralLock(lockState) && !aspects.contains(ContentModel.ASPECT_LOCKABLE)) {
                aspects.add(ContentModel.ASPECT_LOCKABLE);
            }
            return aspects;
        }
        if (methodName.equals("getProperties")) {
            NodeRef nodeRef = (NodeRef)args[0];
            Map properties = (Map)invocation.proceed();
            LockState lockState = this.getLockState(nodeRef);
            if (this.isEphemeralLock(lockState)) {
                String userName = lockState.getOwner();
                properties.put(ContentModel.PROP_LOCK_OWNER, userName);
                properties.put(ContentModel.PROP_LOCK_TYPE, lockState.getLockType().toString());
                properties.put(ContentModel.PROP_EXPIRY_DATE, lockState.getExpires());
                properties.put(ContentModel.PROP_LOCK_LIFETIME, Lifetime.EPHEMERAL.toString());
            } else if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE) && !properties.containsKey(ContentModel.PROP_LOCK_LIFETIME)) {
                properties.put(ContentModel.PROP_LOCK_LIFETIME, Lifetime.PERSISTENT.toString());
            }
            return properties;
        }
        if (methodName.equals("getPropertiesForNodeRefs")) {
            List cfr_ignored_0 = (List)args[0];
            Map propertyMap = (Map)invocation.proceed();
            for (Map.Entry entry : propertyMap.entrySet()) {
                NodeRef nodeRef = (NodeRef)entry.getKey();
                Map properties = (Map)entry.getValue();
                LockState lockState = this.getLockState(nodeRef);
                if (this.isEphemeralLock(lockState)) {
                    String userName = lockState.getOwner();
                    properties.put(ContentModel.PROP_LOCK_OWNER, userName);
                    properties.put(ContentModel.PROP_LOCK_TYPE, lockState.getLockType().toString());
                    properties.put(ContentModel.PROP_EXPIRY_DATE, lockState.getExpires());
                    properties.put(ContentModel.PROP_LOCK_LIFETIME, Lifetime.EPHEMERAL.toString());
                    continue;
                }
                if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE) || properties.containsKey(ContentModel.PROP_LOCK_LIFETIME)) continue;
                properties.put(ContentModel.PROP_LOCK_LIFETIME, Lifetime.PERSISTENT.toString());
            }
            return propertyMap;
        }
        if (methodName.equals("getProperty")) {
            NodeRef nodeRef = (NodeRef)args[0];
            QName propQName = (QName)args[1];
            if (this.isLockProperty(propQName)) {
                LockState lockState = this.getLockState(nodeRef);
                if (this.isEphemeralLock(lockState)) {
                    if (ContentModel.PROP_LOCK_OWNER.equals((Object)propQName)) {
                        return lockState.getOwner();
                    }
                    if (ContentModel.PROP_LOCK_TYPE.equals((Object)propQName)) {
                        return lockState.getLockType().toString();
                    }
                    if (ContentModel.PROP_EXPIRY_DATE.equals((Object)propQName)) {
                        return lockState.getExpires();
                    }
                    if (ContentModel.PROP_LOCK_LIFETIME.equals((Object)propQName)) {
                        return lockState.getLifetime().toString();
                    }
                } else if (ContentModel.PROP_LOCK_LIFETIME.equals((Object)propQName) && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
                    return Lifetime.PERSISTENT.toString();
                }
            }
            return invocation.proceed();
        }
        if (methodName.equals("setProperties")) {
            NodeRef nodeRef = (NodeRef)args[0];
            Map newProperties = (Map)args[1];
            this.checkForLockIfEphemeral(nodeRef);
            if (Lifetime.EPHEMERAL.toString().equals(newProperties.get(ContentModel.PROP_LOCK_LIFETIME))) {
                Map<QName, Serializable> convertedProperties = this.filterLockProperties(newProperties);
                this.nodeService.setProperties(nodeRef, convertedProperties);
                return null;
            }
            if (newProperties.containsKey(ContentModel.PROP_LOCK_LIFETIME)) {
                newProperties.remove(ContentModel.PROP_LOCK_LIFETIME);
                this.nodeService.setProperties(nodeRef, newProperties);
                return null;
            }
            return invocation.proceed();
        }
        if (this.methodsToCheck.contains(methodName)) {
            NodeRef nodeRef = (NodeRef)args[0];
            this.checkForLockIfEphemeral(nodeRef);
            return invocation.proceed();
        }
        return invocation.proceed();
    }

    public void enableForThread() {
        this.threadEnabled.set(Boolean.TRUE);
    }

    public void disableForThread() {
        this.threadEnabled.set(Boolean.FALSE);
    }

    private Map<QName, Serializable> filterLockProperties(Map<QName, Serializable> properties) {
        HashMap<QName, Serializable> filteredProps = new HashMap<QName, Serializable>(properties.size() * 2);
        for (QName propQName : properties.keySet()) {
            if (this.isLockProperty(propQName)) continue;
            filteredProps.put(propQName, properties.get(propQName));
        }
        return filteredProps;
    }

    private boolean isLockProperty(QName propQName) {
        boolean isLockProp = propQName.equals((Object)ContentModel.PROP_LOCK_OWNER) || propQName.equals((Object)ContentModel.PROP_LOCK_TYPE) || propQName.equals((Object)ContentModel.PROP_LOCK_LIFETIME) || propQName.equals((Object)ContentModel.PROP_EXPIRY_DATE);
        return isLockProp;
    }

    private boolean isEphemeralLock(LockState lockState) {
        boolean ephemeral = lockState != null && lockState.isLockInfo() && lockState.getLifetime() == Lifetime.EPHEMERAL;
        return ephemeral;
    }

    private void checkForLockIfEphemeral(NodeRef nodeRef) {
        LockState lockState = this.getLockState(nodeRef);
        if (this.isEphemeralLock(lockState)) {
            this.lockService.checkForLock(nodeRef);
        }
    }

    public void setLockStore(LockStore lockStore) {
        this.lockStore = lockStore;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    @Extend(traitAPI=LockableAspectInterceptorTrait.class, extensionAPI=LockableAspectInterceptorExtension.class)
    private LockState getLockState(NodeRef nodeRef) {
        NodeRef nodeRef2 = nodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)nodeRef2);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef2, joinPoint};
        LockableAspectInterceptor$AjcClosure1 lockableAspectInterceptor$AjcClosure1 = new LockableAspectInterceptor$AjcClosure1(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = lockableAspectInterceptor$AjcClosure1.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = LockableAspectInterceptor.class.getDeclaredMethod("getLockState", NodeRef.class).getAnnotation(Extend.class);
        }
        return (LockState)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    private LockableAspectInterceptorTrait createTrait() {
        return new LockableAspectInterceptorTrait(){

            @Override
            public LockState traitImplOf_getLockState(final NodeRef nodeRef) {
                return AJExtender.run(new AJExtender.ExtensionBypass<LockState>(){

                    @Override
                    public LockState run() {
                        return LockableAspectInterceptor.this.getLockState(nodeRef);
                    }
                });
            }
        };
    }

    @Override
    public <T extends Trait> ExtendedTrait<T> getTrait(Class<? extends T> traitAPI) {
        return this.lockableAspectInterceptorTrait;
    }

    static {
        LockableAspectInterceptor.ajc$preClinit();
    }

    static final /* synthetic */ LockState getLockState_aroundBody0(LockableAspectInterceptor ajc$this, NodeRef nodeRef, JoinPoint joinPoint) {
        Date expiryDate;
        String lockOwner;
        LockStatus status;
        LockState lockState = ajc$this.lockStore.get(nodeRef);
        if (lockState != null && (status = LockUtils.lockStatus(lockOwner = lockState.getOwner(), lockOwner, expiryDate = lockState.getExpires())).equals((Object)LockStatus.LOCK_EXPIRED)) {
            lockState = null;
        }
        return lockState;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LockableAspectInterceptor.java", LockableAspectInterceptor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getLockState", "org.alfresco.repo.lock.mem.LockableAspectInterceptor", "org.alfresco.service.cmr.repository.NodeRef", "nodeRef", "", "org.alfresco.repo.lock.mem.LockState"), 365);
    }
}

