/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import org.alfresco.opencmis.AlfrescoCmisExceptionInterceptor;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.coci.CheckOutCheckInServiceException;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.model.FileExistsException;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AlfrescoCmisExceptionInterceptorTest {
    private AlfrescoCmisExceptionInterceptor interceptor = new AlfrescoCmisExceptionInterceptor();

    private void doMockCall(Exception toThrow, Class<?> toCatch) throws Throwable {
        MethodInvocation mi = (MethodInvocation)Mockito.mock(MethodInvocation.class);
        Mockito.when((Object)mi.proceed()).thenThrow(new Throwable[]{toThrow});
        try {
            this.interceptor.invoke(mi);
            Assert.fail((String)"Expected an exception to be thrown here.");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Incorrect exception thrown: ", toCatch, e.getClass());
        }
    }

    @Test
    public void testNoException() throws Throwable {
        MethodInvocation mi = (MethodInvocation)Mockito.mock(MethodInvocation.class);
        Mockito.when((Object)mi.proceed()).thenReturn((Object)"BOB");
        this.interceptor.invoke(mi);
    }

    @Test
    public void testAuthenticationException() throws Throwable {
        AuthenticationException e = new AuthenticationException("x");
        Class<CmisPermissionDeniedException> toCatch = CmisPermissionDeniedException.class;
        this.doMockCall((Exception)e, toCatch);
        this.doMockCall(new RuntimeException(new RuntimeException((Throwable)e)), toCatch);
    }

    @Test
    public void testCheckOutCheckInServiceException() throws Throwable {
        CheckOutCheckInServiceException e = new CheckOutCheckInServiceException("x");
        Class<CmisVersioningException> toCatch = CmisVersioningException.class;
        this.doMockCall((Exception)e, toCatch);
        this.doMockCall(new RuntimeException(new RuntimeException((Throwable)e)), toCatch);
    }

    @Test
    public void testFileExistsException() throws Throwable {
        FileExistsException e = new FileExistsException(null, null);
        Class<CmisContentAlreadyExistsException> toCatch = CmisContentAlreadyExistsException.class;
        this.doMockCall((Exception)e, toCatch);
        this.doMockCall(new RuntimeException(new RuntimeException((Throwable)e)), toCatch);
    }

    @Test
    public void testIntegrityException() throws Throwable {
        IntegrityException e = new IntegrityException(null);
        Class<CmisConstraintException> toCatch = CmisConstraintException.class;
        this.doMockCall((Exception)e, toCatch);
        this.doMockCall(new RuntimeException(new RuntimeException((Throwable)e)), toCatch);
    }

    @Test
    public void testAccessDeniedException() throws Throwable {
        AccessDeniedException e = new AccessDeniedException("x");
        Class<CmisPermissionDeniedException> toCatch = CmisPermissionDeniedException.class;
        this.doMockCall((Exception)e, toCatch);
        this.doMockCall(new RuntimeException(new RuntimeException((Throwable)e)), toCatch);
    }

    @Test
    public void testNodeLockedException() throws Throwable {
        NodeLockedException e = new NodeLockedException();
        Class<CmisUpdateConflictException> toCatch = CmisUpdateConflictException.class;
        this.doMockCall((Exception)e, toCatch);
        this.doMockCall(new RuntimeException(new RuntimeException((Throwable)e)), toCatch);
    }
}

