/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.math.BigInteger;
import org.alfresco.repo.virtual.ref.HashStore;
import org.alfresco.repo.virtual.ref.HashStoreConfiguration;
import org.alfresco.repo.virtual.ref.NodeRefHasher;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.Pair;
import org.apache.commons.lang3.StringUtils;

public class NodeRefRadixHasher
implements NodeRefHasher {
    public static final NodeRefRadixHasher RADIX_36_HASHER = new NodeRefRadixHasher(36);
    private HashStore storeProtocolStore;
    private HashStore storeIdStore;
    private int radix;

    public NodeRefRadixHasher() {
        this(16);
    }

    public NodeRefRadixHasher(int radix) {
        this.radix = radix;
        this.storeProtocolStore = HashStoreConfiguration.getInstance().getStoreProtocolStore();
        this.storeIdStore = HashStoreConfiguration.getInstance().getStoreIdStore();
    }

    @Override
    public Pair<String, String> hash(NodeRef nodeRef) {
        String uuid = nodeRef.getId();
        if (uuid.length() != 36) {
            throw new RuntimeException("Invalid noderf id length " + uuid);
        }
        String bigInt16String = uuid.replaceAll("-", "");
        if (bigInt16String.length() != 32) {
            throw new RuntimeException("Invalid noderf id format " + uuid);
        }
        BigInteger bigIntId = new BigInteger(bigInt16String, 16);
        StoreRef storeRef = nodeRef.getStoreRef();
        String storeProtocolHash = this.storeProtocolStore.hash(storeRef.getProtocol());
        String storeIdHash = this.storeIdStore.hash(storeRef.getIdentifier());
        if (storeProtocolHash == null || storeIdHash == null) {
            throw new RuntimeException("Missing hash for " + storeRef);
        }
        String storeHash = String.valueOf(storeProtocolHash) + storeIdHash;
        return new Pair((Object)storeHash, (Object)bigIntId.toString(this.radix));
    }

    @Override
    public NodeRef lookup(Pair<String, String> hash) {
        String storeHash = (String)hash.getFirst();
        String storeProtocolHash = storeHash.substring(0, 1);
        String storeIdHash = storeHash.substring(1, 2);
        String storeProtocol = this.storeProtocolStore.lookup(storeProtocolHash);
        String storeId = this.storeIdStore.lookup(storeIdHash);
        if (storeProtocol == null || storeId == null) {
            throw new RuntimeException("Lookup found no protocol or id for " + storeHash);
        }
        BigInteger nodeId = new BigInteger((String)hash.getSecond(), this.radix);
        String nodeIdHexa = nodeId.toString(16);
        nodeIdHexa = StringUtils.leftPad((String)nodeIdHexa, (int)32, (String)"0");
        int leadZeros = 32 - nodeIdHexa.length();
        String[] groups = new String[]{nodeIdHexa.substring(0, 8), nodeIdHexa.substring(8, 12), nodeIdHexa.substring(12, 16), nodeIdHexa.substring(16, 20), nodeIdHexa.substring(20, 32)};
        StringBuilder idBuilder = new StringBuilder(groups[0]);
        int i = 1;
        while (i < groups.length) {
            idBuilder.append("-");
            idBuilder.append(groups[i]);
            ++i;
        }
        return new NodeRef(storeProtocol, storeId, idBuilder.toString());
    }
}

