/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.copy;

import java.util.Locale;
import org.alfresco.repo.copy.CopyServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.extensions.surf.util.I18NUtil;

public class CopyServiceImplUnitTest {
    private static final String FILE_NAME = "Test File";
    private static final String FILE_EXTENSION = ".txt";
    private static final String COPY_OF_LABEL = "copy_service.copy_of_label";
    private CopyServiceImpl copyServiceImpl;
    private Locale preservedLocale;
    private String copyOfLabelTranslated;

    @Before
    public void setup() {
        I18NUtil.registerResourceBundle((String)"alfresco/messages/copy-service");
        this.preservedLocale = I18NUtil.getLocale();
        this.copyServiceImpl = new CopyServiceImpl();
    }

    @Test
    public void testBuildNewName_FileWithExtension() {
        this.switchLocale(Locale.ENGLISH);
        Assert.assertEquals((Object)(String.valueOf(this.copyOfLabelTranslated) + FILE_NAME + FILE_EXTENSION), (Object)this.copyServiceImpl.buildNewName("Test File.txt"));
        this.restoreLocale();
    }

    @Test
    public void testBuildNewName_FileWithExtensionAndCopyOf() {
        this.switchLocale(Locale.ENGLISH);
        String fileNameOfCopy = String.valueOf(this.copyOfLabelTranslated) + FILE_NAME + FILE_EXTENSION;
        Assert.assertEquals((Object)(String.valueOf(this.copyOfLabelTranslated) + fileNameOfCopy), (Object)this.copyServiceImpl.buildNewName(fileNameOfCopy));
        this.restoreLocale();
    }

    @Test
    public void testBuildNewName_FileWithoutExtension() {
        this.switchLocale(Locale.ENGLISH);
        Assert.assertEquals((Object)(String.valueOf(this.copyOfLabelTranslated) + FILE_NAME), (Object)this.copyServiceImpl.buildNewName(FILE_NAME));
        this.restoreLocale();
    }

    @Test
    public void testBuildNewName_FileWithExtension_JapaneseLocale() {
        this.switchLocale(Locale.JAPANESE);
        Assert.assertEquals((Object)(FILE_NAME + this.copyOfLabelTranslated + FILE_EXTENSION), (Object)this.copyServiceImpl.buildNewName("Test File.txt"));
        this.restoreLocale();
    }

    @Test
    public void testBuildNewName_FileWithExtensionAndCopyOf_JapaneseLocale() {
        this.switchLocale(Locale.JAPANESE);
        String fileNameOfCopy = FILE_NAME + this.copyOfLabelTranslated;
        Assert.assertEquals((Object)(String.valueOf(fileNameOfCopy) + this.copyOfLabelTranslated + FILE_EXTENSION), (Object)this.copyServiceImpl.buildNewName(String.valueOf(fileNameOfCopy) + FILE_EXTENSION));
        this.restoreLocale();
    }

    @Test
    public void testBuildNewName_FileWithoutExtension_JapaneseLocale() {
        this.switchLocale(Locale.JAPANESE);
        Assert.assertEquals((Object)(FILE_NAME + this.copyOfLabelTranslated), (Object)this.copyServiceImpl.buildNewName(FILE_NAME));
        this.restoreLocale();
    }

    private void switchLocale(Locale newLocale) {
        I18NUtil.setLocale((Locale)newLocale);
        this.copyOfLabelTranslated = I18NUtil.getMessage((String)COPY_OF_LABEL, (Object[])new Object[]{""});
    }

    private void restoreLocale() {
        I18NUtil.setLocale((Locale)this.preservedLocale);
        this.copyOfLabelTranslated = I18NUtil.getMessage((String)COPY_OF_LABEL, (Object[])new Object[]{""});
    }
}

