/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.schema.script;

import java.io.File;
import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.MySQLInnoDBDialect;
import org.alfresco.repo.domain.schema.script.DeleteNotExistsExecutor;
import org.alfresco.repo.domain.schema.script.MySQLDeleteNotExistsExecutor;
import org.alfresco.repo.domain.schema.script.ScriptExecutor;
import org.alfresco.repo.domain.schema.script.ScriptExecutorImpl;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.DBTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;

@Category(value={DBTests.class})
public class DeleteNotExistsExecutorTest {
    private static ApplicationContext ctx;
    private ScriptExecutor scriptExecutor;
    private DataSource dataSource;
    private Dialect dialect;
    private JdbcTemplate jdbcTmpl;

    @BeforeClass
    public static void setUpBeforeClass() {
        String[] config = new String[]{"classpath:alfresco/application-context.xml", "classpath:scriptexec/script-exec-test.xml"};
        ctx = ApplicationContextHelper.getApplicationContext((String[])config);
    }

    @Before
    public void setUp() throws Exception {
        this.scriptExecutor = (ScriptExecutor)ctx.getBean("simpleScriptExecutor", ScriptExecutorImpl.class);
        this.dataSource = (DataSource)ctx.getBean("dataSource", DataSource.class);
        this.dialect = (Dialect)ctx.getBean("dialect", Dialect.class);
        this.jdbcTmpl = new JdbcTemplate(this.dataSource);
    }

    private DeleteNotExistsExecutor createDeleteNotExistsExecutor(Connection connection, String sql, int line, File scriptFile, Properties properties) {
        if (this.dialect instanceof MySQLInnoDBDialect) {
            return new MySQLDeleteNotExistsExecutor(connection, sql, line, scriptFile, properties, this.dataSource);
        }
        return new DeleteNotExistsExecutor(connection, sql, line, scriptFile, properties);
    }

    @Test
    public void testDefaultBehaviour() throws Exception {
        this.scriptExecutor.executeScriptUrl("scriptexec/${db.script.dialect}/delete-not-exists/test-data1.sql");
        String sql = "--DELETE_NOT_EXISTS temp_tst_tbl_1.id,temp_tst_tbl_2.tbl_2_id,temp_tst_tbl_3.tbl_3_id,temp_tst_tbl_4.tbl_4_id system.delete_not_exists.batchsize";
        int line = 1;
        File scriptFile = (File)Mockito.mock(File.class);
        Properties properties = (Properties)Mockito.mock(Properties.class);
        String select = "select id from temp_tst_tbl_1 order by id ASC";
        Throwable throwable = null;
        Object var7_8 = null;
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(true);
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.read_only")).thenReturn((Object)"true");
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.timeout_seconds")).thenReturn((Object)"-1");
            DeleteNotExistsExecutor deleteNotExistsExecutor = this.createDeleteNotExistsExecutor(connection, sql, line, scriptFile, properties);
            deleteNotExistsExecutor.execute();
            List res = this.jdbcTmpl.queryForList(select, String.class);
            Assert.assertEquals((long)7L, (long)res.size());
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.read_only")).thenReturn((Object)"false");
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.timeout_seconds")).thenReturn((Object)"-1");
            deleteNotExistsExecutor = this.createDeleteNotExistsExecutor(connection, sql, line, scriptFile, properties);
            deleteNotExistsExecutor.execute();
            res = this.jdbcTmpl.queryForList(select, String.class);
            Assert.assertEquals((long)5L, (long)res.size());
            Assert.assertEquals((Object)"1", res.get(0));
            Assert.assertEquals((Object)"2", res.get(1));
            Assert.assertEquals((Object)"4", res.get(2));
            Assert.assertEquals((Object)"10", res.get(3));
            Assert.assertEquals((Object)"11", res.get(4));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testDeleteBatch() throws Exception {
        this.scriptExecutor.executeScriptUrl("scriptexec/${db.script.dialect}/delete-not-exists/test-data1.sql");
        String sql = "--DELETE_NOT_EXISTS temp_tst_tbl_1.id,temp_tst_tbl_2.tbl_2_id,temp_tst_tbl_3.tbl_3_id,temp_tst_tbl_4.tbl_4_id system.delete_not_exists.batchsize";
        int line = 1;
        File scriptFile = (File)Mockito.mock(File.class);
        Properties properties = (Properties)Mockito.mock(Properties.class);
        String select = "select id from temp_tst_tbl_1 order by id ASC";
        Throwable throwable = null;
        Object var7_8 = null;
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(true);
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.delete_batchsize")).thenReturn((Object)"1");
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.read_only")).thenReturn((Object)"false");
            DeleteNotExistsExecutor deleteNotExistsExecutor = this.createDeleteNotExistsExecutor(connection, sql, line, scriptFile, properties);
            deleteNotExistsExecutor.execute();
            List res = this.jdbcTmpl.queryForList(select, String.class);
            Assert.assertEquals((long)5L, (long)res.size());
            Assert.assertEquals((Object)"1", res.get(0));
            Assert.assertEquals((Object)"2", res.get(1));
            Assert.assertEquals((Object)"4", res.get(2));
            Assert.assertEquals((Object)"10", res.get(3));
            Assert.assertEquals((Object)"11", res.get(4));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testBatchExecute() throws Exception {
        this.scriptExecutor.executeScriptUrl("scriptexec/${db.script.dialect}/delete-not-exists/test-data1.sql");
        String sql = "--DELETE_NOT_EXISTS temp_tst_tbl_1.id,temp_tst_tbl_2.tbl_2_id,temp_tst_tbl_3.tbl_3_id,temp_tst_tbl_4.tbl_4_id system.delete_not_exists.batchsize";
        int line = 1;
        File scriptFile = (File)Mockito.mock(File.class);
        Properties properties = (Properties)Mockito.mock(Properties.class);
        String select = "select id from temp_tst_tbl_1 order by id ASC";
        Throwable throwable = null;
        Object var7_8 = null;
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(true);
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.batchsize")).thenReturn((Object)"2");
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.read_only")).thenReturn((Object)"false");
            Mockito.when((Object)properties.getProperty("system.delete_not_exists.timeout_seconds")).thenReturn((Object)"-1");
            DeleteNotExistsExecutor deleteNotExistsExecutor = this.createDeleteNotExistsExecutor(connection, sql, line, scriptFile, properties);
            deleteNotExistsExecutor.execute();
            List res = this.jdbcTmpl.queryForList(select, String.class);
            Assert.assertEquals((long)5L, (long)res.size());
            Assert.assertEquals((Object)"1", res.get(0));
            Assert.assertEquals((Object)"2", res.get(1));
            Assert.assertEquals((Object)"4", res.get(2));
            Assert.assertEquals((Object)"10", res.get(3));
            Assert.assertEquals((Object)"11", res.get(4));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

