/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.alfresco.repo.content.transform.swf.SWFTransformationOptions;
import org.alfresco.repo.rendition.RenditionServiceImpl;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.RenditionDefinitionRegistry2;
import org.alfresco.repo.rendition2.TransformationOptionsConverter;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.repo.thumbnail.ThumbnailRenditionConvertor;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.repository.PagedSourceOptions;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.repository.TransformationSourceOptions;
import org.alfresco.util.BaseSpringTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@Deprecated
public class RenditionDefinitionTest
extends BaseSpringTest {
    private RenditionServiceImpl renditionService;
    private RenditionDefinitionRegistry2 renditionDefinitionRegistry2;
    private TransformationOptionsConverter transformationOptionsConverter;
    private AuthenticationComponent authenticationComponent;

    @Before
    public void setUp() throws Exception {
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("AuthenticationComponent");
        this.renditionService = (RenditionServiceImpl)this.applicationContext.getBean("renditionService");
        this.renditionDefinitionRegistry2 = (RenditionDefinitionRegistry2)this.applicationContext.getBean("renditionDefinitionRegistry2");
        this.transformationOptionsConverter = (TransformationOptionsConverter)this.applicationContext.getBean("transformOptionsConverter");
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private RenditionDefinition getRenditionDefinition(List<RenditionDefinition> renditionDefinitions, String renditionName) {
        for (RenditionDefinition renditionDefinition : renditionDefinitions) {
            String name = renditionDefinition.getRenditionName().getLocalName();
            if (!name.equals(renditionName)) continue;
            return renditionDefinition;
        }
        return null;
    }

    @Test
    public void testGetRenderingEngineDefinition() throws Exception {
        ThumbnailRenditionConvertor converter = new ThumbnailRenditionConvertor();
        ArrayList<RenditionDefinition> renditionDefinitions = new ArrayList<RenditionDefinition>(this.renditionService.loadRenditionDefinitions());
        Set renditionNames = this.renditionDefinitionRegistry2.getRenditionNames();
        for (String renditionName : renditionNames) {
            System.out.println("renditionName=" + renditionName);
            RenditionDefinition definition = this.getRenditionDefinition(renditionDefinitions, renditionName);
            RenditionDefinitionTest.assertNotNull((String)("There is no RenditionDefinition for " + renditionName), (Object)definition);
            renditionDefinitions.remove(definition);
            ThumbnailDefinition thumbnailDefinition = converter.convert(definition);
            TransformationOptions transformationOptions = thumbnailDefinition.getTransformationOptions();
            RenditionDefinition2 definition2 = this.renditionDefinitionRegistry2.getRenditionDefinition(renditionName);
            Map options = definition2.getTransformOptions();
            TransformationOptions transformationOptions2 = this.transformationOptionsConverter.getTransformationOptions(renditionName, options);
            Map options2 = this.transformationOptionsConverter.getOptions(transformationOptions2, null, null);
            transformationOptions2.setUse(null);
            if (!renditionName.equals("pdf") && !renditionName.equals("webpreview")) {
                PagedSourceOptions pagedSourceOptions;
                TransformationSourceOptions sourceOptions;
                Collection sourceOptionsList = transformationOptions2.getSourceOptionsList();
                if (sourceOptionsList != null && sourceOptionsList.size() == 1 && (sourceOptions = (TransformationSourceOptions)sourceOptionsList.iterator().next()) instanceof PagedSourceOptions && (pagedSourceOptions = (PagedSourceOptions)sourceOptions).getStartPageNumber() == 1 && pagedSourceOptions.getEndPageNumber() == 1 && transformationOptions.getSourceOptionsList() == null) {
                    transformationOptions.setSourceOptionsList(sourceOptionsList);
                }
                RenditionDefinitionTest.assertEquals((String)("The TransformationOptions used in transforms for " + renditionName + " should be the same"), (String)transformationOptions.toStringAll(), (String)transformationOptions2.toStringAll());
                RenditionDefinitionTest.assertEquals((String)("The transformationOptionsConverter back to the newer format was not the same for " + renditionName), (Object)options, (Object)options2);
                continue;
            }
            RenditionDefinitionTest.assertEquals((String)("The converted class for " + renditionName + " should be the same as before"), transformationOptions.getClass(), transformationOptions2.getClass());
            RenditionDefinitionTest.assertEquals((String)("The converted class for " + renditionName + " should be SWFTransformationOptions"), SWFTransformationOptions.class, transformationOptions2.getClass());
        }
        if (!renditionDefinitions.isEmpty()) {
            StringJoiner sj = new StringJoiner(", ");
            for (RenditionDefinition renditionDefinition : renditionDefinitions) {
                String name = renditionDefinition.getRenditionName().getLocalName();
                sj.add(name);
            }
            RenditionDefinitionTest.fail((String)("There is no RenditionDefinition2 for existing RenditionDefinitions " + sj));
        }
    }
}

