/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit.extractor;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.audit.extractor.AbstractDataExtractor;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.PropertyCheck;

public class NodeNameDataExtractor
extends AbstractDataExtractor {
    private NodeService nodeService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
    }

    @Override
    public boolean isSupported(Serializable data) {
        return data != null && data instanceof NodeRef;
    }

    @Override
    public Serializable extractData(Serializable in) throws Throwable {
        NodeRef nodeRef = (NodeRef)in;
        String nodeName = null;
        if (!this.nodeService.exists(nodeRef)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Extractor can't pull value from non-existent node: " + nodeRef));
            }
        } else {
            nodeName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
        }
        return nodeName;
    }
}

