/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringJoiner;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.HttpClient4Factory;
import org.alfresco.httpclient.HttpClientConfig;
import org.alfresco.repo.content.transform.UnimportantTransformException;
import org.alfresco.repo.content.transform.UnsupportedTransformationException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.Pair;
import org.alfresco.util.exec.RuntimeExec;
import org.apache.commons.logging.Log;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class RemoteTransformerClient {
    private final HttpClientConfig httpClientConfig;
    private final String name;
    private final String baseUrl;
    private long startupRetryPeriod = 15000L;
    private long checkAvailabilityAfter = 0L;
    private Pair<Boolean, String> checkResult = new Pair(null, null);

    public RemoteTransformerClient(String name, String baseUrl, HttpClientConfig httpClientConfig) {
        this.name = name;
        this.baseUrl = baseUrl == null || baseUrl.trim().isEmpty() ? null : baseUrl.trim();
        this.httpClientConfig = httpClientConfig;
    }

    public void setStartupRetryPeriodSeconds(int startupRetryPeriodSeconds) {
        this.startupRetryPeriod = startupRetryPeriodSeconds * 1000;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void request(ContentReader reader, ContentWriter writer, String sourceMimetype, String sourceExtension, String targetExtension, long timeoutMs, Log logger, String ... args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("There should be a value for each request property");
        }
        StringJoiner sj = new StringJoiner(" ");
        try {
            Throwable throwable = null;
            Object var12_13 = null;
            try (InputStream contentStream = reader.getContentInputStream();){
                HttpEntity reqEntity = this.getRequestEntity(contentStream, sourceMimetype, sourceExtension, targetExtension, timeoutMs, args, sj);
                this.request(logger, sourceExtension, targetExtension, reqEntity, writer, sj.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to read content from reader", (Throwable)e);
        }
    }

    HttpEntity getRequestEntity(ContentReader reader, String sourceMimetype, String sourceExtension, String targetExtension, long timeoutMs, String[] args, StringJoiner sj) {
        return this.getRequestEntity(reader.getContentInputStream(), sourceMimetype, sourceExtension, targetExtension, timeoutMs, args, sj);
    }

    void request(Log logger, String sourceExtension, String targetExtension, HttpEntity reqEntity, ContentWriter writer, String args) {
        block34: {
            String url = String.valueOf(this.baseUrl) + (this.baseUrl.endsWith("/") ? "" : "/") + "transform";
            HttpPost httppost = new HttpPost(url);
            httppost.setEntity(reqEntity);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(String.valueOf(this.name) + ' ' + sourceExtension + ' ' + targetExtension + ' ' + url + ' ' + args));
            }
            try {
                try {
                    Throwable throwable = null;
                    Object var10_13 = null;
                    try (CloseableHttpClient httpclient = HttpClient4Factory.createHttpClient((HttpClientConfig)this.httpClientConfig);){
                        try {
                            Throwable throwable2 = null;
                            Object var13_19 = null;
                            try (CloseableHttpResponse response = this.execute(httpclient, httppost);){
                                StatusLine statusLine = response.getStatusLine();
                                if (statusLine == null) {
                                    throw new AlfrescoRuntimeException(String.valueOf(this.name) + " returned no status " + url + ' ' + args);
                                }
                                HttpEntity resEntity = response.getEntity();
                                if (resEntity != null) {
                                    int statusCode = statusLine.getStatusCode();
                                    if (statusCode == 200) {
                                        try {
                                            if (logger.isDebugEnabled()) {
                                                long responseContentLength = resEntity.getContentLength();
                                                Header responseContentEncoding = resEntity.getContentEncoding();
                                                Header responseContentType = resEntity.getContentType();
                                                logger.debug((Object)(String.valueOf(this.name) + ' ' + sourceExtension + ' ' + targetExtension + " returned. length=" + responseContentLength + " type=" + responseContentType + " encoding=" + responseContentEncoding));
                                            }
                                            writer.putContent(resEntity.getContent());
                                            EntityUtils.consume((HttpEntity)resEntity);
                                            break block34;
                                        }
                                        catch (IOException e) {
                                            throw new AlfrescoRuntimeException(String.valueOf(this.name) + " failed to read the returned content", (Throwable)e);
                                        }
                                    }
                                    String message = this.getErrorMessage(resEntity);
                                    String msg = (String.valueOf(this.name) + " returned a " + statusCode + " status " + message + ' ' + url + ' ' + args).trim();
                                    if (statusCode == 401) {
                                        throw new UnsupportedTransformationException(msg);
                                    }
                                    if (statusCode == 402) {
                                        throw new UnimportantTransformException(msg);
                                    }
                                    throw new AlfrescoRuntimeException(msg);
                                }
                                throw new AlfrescoRuntimeException(String.valueOf(this.name) + " did not return an entity " + url);
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (IOException e) {
                            this.connectionFailed();
                            this.logHttpClientTimeoutException(e, logger);
                            throw new AlfrescoRuntimeException(String.valueOf(this.name) + " failed to connect or to read the response", (Throwable)e);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new AlfrescoRuntimeException(String.valueOf(this.name) + " failed to create an HttpClient", (Throwable)e);
                }
            }
            catch (AlfrescoRuntimeException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)e.getMessage());
                }
                throw e;
            }
        }
    }

    private void logHttpClientTimeoutException(IOException e, Log logger) {
        if (e instanceof ConnectTimeoutException) {
            logger.error((Object)e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public Pair<Boolean, String> check(Log logger) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK], 11[CATCHBLOCK]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    CloseableHttpResponse execute(CloseableHttpClient httpclient, HttpPost httppost) throws IOException {
        return httpclient.execute((HttpUriRequest)httppost);
    }

    CloseableHttpResponse execute(CloseableHttpClient httpclient, HttpGet httpGet) throws IOException {
        return httpclient.execute((HttpUriRequest)httpGet);
    }

    private HttpEntity getRequestEntity(InputStream contentStream, String sourceMimetype, String sourceExtension, String targetExtension, long timeoutMs, String[] args, StringJoiner sj) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        ContentType contentType = ContentType.create((String)sourceMimetype);
        builder.addBinaryBody("file", contentStream, contentType, "tmp." + sourceExtension);
        builder.addTextBody("targetExtension", targetExtension);
        sj.add("targetExtension=" + targetExtension);
        int i = 0;
        while (i < args.length) {
            if (args[i + 1] != null) {
                builder.addTextBody(args[i], args[i + 1]);
                sj.add(String.valueOf(args[i]) + '=' + args[i + 1]);
            }
            i += 2;
        }
        if (timeoutMs > 0L) {
            String timeoutMsString = Long.toString(timeoutMs);
            builder.addTextBody("timeout", timeoutMsString);
            sj.add("timeout=" + timeoutMsString);
        }
        return builder.build();
    }

    private String getErrorMessage(HttpEntity resEntity) throws IOException {
        int j;
        String message = "";
        String content = this.getContent(resEntity);
        int i = content.indexOf("\"message\":\"");
        if (i != -1 && (j = content.indexOf("\",\"path\":", i)) != -1) {
            message = content.substring(i + 11, j);
        }
        return message;
    }

    String getContent(HttpEntity resEntity) throws IOException {
        return EntityUtils.toString((HttpEntity)resEntity);
    }

    public static Pair<Boolean, String> check(RuntimeExec checkCommand) {
        RuntimeExec.ExecutionResult result = checkCommand.execute();
        Boolean success = result.getSuccess();
        String output = success != false ? result.getStdOut().trim() : result.toString();
        return new Pair((Object)success, (Object)output);
    }

    synchronized void connectionFailed() {
        this.checkAvailabilityAfter = System.currentTimeMillis() + this.startupRetryPeriod;
    }

    synchronized void connectionSuccess() {
        this.checkAvailabilityAfter = Long.MAX_VALUE;
    }

    private synchronized boolean isTimeToCheckAvailability() {
        return System.currentTimeMillis() > this.checkAvailabilityAfter;
    }

    public synchronized boolean isAvailable() {
        return this.checkAvailabilityAfter == Long.MAX_VALUE;
    }

    private synchronized Pair<Boolean, String> getCheckResult() {
        return this.checkResult;
    }

    private synchronized void setCheckResult(Pair<Boolean, String> checkResult) {
        this.checkResult = checkResult;
    }
}

