/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.core.PriorityOrdered;

public class LegacyConfigPostProcessor
implements BeanFactoryPostProcessor,
PriorityOrdered {
    private static final String BEAN_NAME_GLOBAL_PROPERTIES = "global-properties";
    private static final String BEAN_NAME_REPOSITORY_PROPERTIES = "repository-properties";
    private static final String BEAN_NAME_HIBERNATE_PROPERTIES = "hibernateConfigProperties";
    private static final String PROPERTY_LOCATIONS = "locations";
    private static final String PROPERTY_PROPERTIES = "properties";
    private static Log logger = LogFactory.getLog(LegacyConfigPostProcessor.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        try {
            Object globalPropertyLocations;
            Object value;
            MutablePropertyValues globalProperties = beanFactory.getBeanDefinition(BEAN_NAME_GLOBAL_PROPERTIES).getPropertyValues();
            PropertyValue pv = globalProperties.getPropertyValue(PROPERTY_LOCATIONS);
            if (pv != null && (value = pv.getValue()) != null && value instanceof Collection) {
                globalPropertyLocations = (Collection)value;
            } else {
                globalPropertyLocations = new ManagedList(10);
                globalProperties.addPropertyValue(PROPERTY_LOCATIONS, globalPropertyLocations);
            }
            MutablePropertyValues repositoryProperties = this.processLocations(beanFactory, (Collection<Object>)globalPropertyLocations, BEAN_NAME_REPOSITORY_PROPERTIES, new String[]{"classpath:alfresco/version.properties"});
            repositoryProperties.addPropertyValue("ignoreUnresolvablePlaceholders", (Object)Boolean.TRUE);
            repositoryProperties.addPropertyValue("localOverride", (Object)Boolean.FALSE);
            repositoryProperties.addPropertyValue("valueSeparator", null);
            repositoryProperties.addPropertyValue("systemPropertiesModeName", (Object)"SYSTEM_PROPERTIES_MODE_NEVER");
            MutablePropertyValues hibernateProperties = this.processLocations(beanFactory, (Collection<Object>)globalPropertyLocations, BEAN_NAME_HIBERNATE_PROPERTIES, new String[]{"classpath:alfresco/domain/hibernate-cfg.properties", "classpath*:alfresco/enterprise/cache/hibernate-cfg.properties"});
            hibernateProperties.addPropertyValue("localOverride", (Object)Boolean.TRUE);
            PropertyPlaceholderConfigurer repositoryConfigurer = (PropertyPlaceholderConfigurer)beanFactory.getSingleton(BEAN_NAME_REPOSITORY_PROPERTIES);
            if (repositoryConfigurer != null) {
                repositoryConfigurer.setLocations(null);
                ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(BEAN_NAME_REPOSITORY_PROPERTIES, beanFactory.getBeanDefinition(BEAN_NAME_REPOSITORY_PROPERTIES));
                beanFactory.configureBean((Object)repositoryConfigurer, BEAN_NAME_REPOSITORY_PROPERTIES);
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
    }

    private MutablePropertyValues processLocations(ConfigurableListableBeanFactory beanFactory, Collection<Object> globalPropertyLocations, String beanName, String[] newLocations) {
        Object value;
        MutablePropertyValues beanProperties = beanFactory.getBeanDefinition(beanName).getPropertyValues();
        PropertyValue pv = beanProperties.getPropertyValue(PROPERTY_PROPERTIES);
        if (pv == null || (value = pv.getValue()) == null || !(value instanceof BeanReference) || ((BeanReference)value).getBeanName().equals(BEAN_NAME_GLOBAL_PROPERTIES)) {
            ManagedList newLocationList = new ManagedList(newLocations.length);
            if (newLocations != null && newLocations.length > 0) {
                String[] stringArray = newLocations;
                int n = newLocations.length;
                int n2 = 0;
                while (n2 < n) {
                    String preserveLocation = stringArray[n2];
                    newLocationList.add(new TypedStringValue(preserveLocation));
                    ++n2;
                }
            }
            if ((pv = beanProperties.getPropertyValue(PROPERTY_LOCATIONS)) != null && (value = pv.getValue()) != null && value instanceof Collection) {
                Collection locations = (Collection)value;
                LinkedHashSet addedLocations = new LinkedHashSet(locations);
                addedLocations.removeAll(globalPropertyLocations);
                addedLocations.removeAll((Collection<?>)newLocationList);
                for (Object location : addedLocations) {
                    logger.warn((Object)("Legacy configuration detected: adding " + (location instanceof TypedStringValue ? ((TypedStringValue)location).getValue() : location.toString()) + " to global-properties definition"));
                    globalPropertyLocations.add(location);
                }
            }
            beanProperties.addPropertyValue(PROPERTY_PROPERTIES, (Object)new RuntimeBeanReference(BEAN_NAME_GLOBAL_PROPERTIES));
            if (newLocationList.size() > 0) {
                beanProperties.addPropertyValue(PROPERTY_LOCATIONS, (Object)newLocationList);
            } else {
                beanProperties.removePropertyValue(PROPERTY_LOCATIONS);
            }
        }
        return beanProperties;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

