/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.alfresco.service.cmr.search.SuggesterResult;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SolrSuggesterResult
implements SuggesterResult {
    private static final Log logger = LogFactory.getLog(SolrSuggesterResult.class);
    private Long numberFound;
    private List<Pair<String, Integer>> suggestions = new ArrayList<Pair<String, Integer>>();

    public SolrSuggesterResult() {
    }

    public SolrSuggesterResult(JSONObject jsonObject) {
        try {
            this.processJson(jsonObject);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
        }
    }

    protected void processJson(JSONObject json) throws JSONException {
        ParameterCheck.mandatory((String)"json", (Object)json);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Suggester JSON response: " + json));
        }
        JSONObject suggest = json.getJSONObject("suggest");
        Iterator suggestIterator = suggest.keys();
        while (suggestIterator.hasNext()) {
            String dictionary = (String)suggestIterator.next();
            JSONObject dictionaryJsonObject = suggest.getJSONObject(dictionary);
            Iterator dicIterator = dictionaryJsonObject.keys();
            while (dicIterator.hasNext()) {
                String termStr = (String)dicIterator.next();
                JSONObject termJsonObject = dictionaryJsonObject.getJSONObject(termStr);
                this.numberFound = termJsonObject.getLong("numFound");
                JSONArray suggestion = termJsonObject.getJSONArray("suggestions");
                int i = 0;
                int length = suggestion.length();
                while (i < length) {
                    JSONObject data = suggestion.getJSONObject(i);
                    this.suggestions.add((Pair<String, Integer>)new Pair((Object)data.getString("term"), (Object)data.getInt("weight")));
                    ++i;
                }
            }
        }
    }

    @Override
    public long getNumberFound() {
        return this.numberFound;
    }

    @Override
    public List<Pair<String, Integer>> getSuggestions() {
        return this.suggestions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(250);
        builder.append("SolrSuggesterResult [numberFound=").append(this.numberFound).append(", suggestions=").append(this.suggestions).append("]");
        return builder.toString();
    }
}

