/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.template;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.VirtualContext;
import org.alfresco.repo.virtual.ref.AbstractProtocolMethod;
import org.alfresco.repo.virtual.ref.GetActualNodeRefMethod;
import org.alfresco.repo.virtual.ref.GetTemplatePathMethod;
import org.alfresco.repo.virtual.ref.GetVanillaScriptInputStreamMethod;
import org.alfresco.repo.virtual.ref.NodeProtocol;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceProcessingError;
import org.alfresco.repo.virtual.ref.VanillaProtocol;
import org.alfresco.repo.virtual.ref.VirtualProtocol;
import org.alfresco.repo.virtual.template.NodeFilingRule;
import org.alfresco.repo.virtual.template.TemplateResourceProcessor;
import org.alfresco.repo.virtual.template.VirtualFolderDefinition;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplyTemplateMethod
extends AbstractProtocolMethod<VirtualFolderDefinition> {
    public static final String VANILLA_JSON_PARAM_NAME = "vanillaJSON";
    private ActualEnvironment environment;
    private static Log logger = LogFactory.getLog(ApplyTemplateMethod.class);

    public ApplyTemplateMethod(ActualEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public VirtualFolderDefinition execute(VirtualProtocol virtualProtocol, Reference reference) throws ProtocolMethodException {
        VirtualContext context = this.createVirtualContext(reference);
        return this.execute(virtualProtocol, reference, context);
    }

    private VirtualContext createVirtualContext(Reference reference) throws ProtocolMethodException {
        return new VirtualContext(this.environment, reference.execute(new GetActualNodeRefMethod(this.environment)));
    }

    public VirtualFolderDefinition execute(VirtualProtocol virtualProtocol, Reference reference, VirtualContext context) throws ProtocolMethodException {
        Resource resource = reference.getResource();
        try {
            VirtualFolderDefinition theStructure = resource.processWith(new TemplateResourceProcessor(context));
            String path = reference.execute(new GetTemplatePathMethod());
            if (!path.isEmpty()) {
                int startIndex;
                String[] pathElements = path.split("/");
                int i = startIndex = path.startsWith("/") ? 1 : 0;
                while (i < pathElements.length) {
                    if ((theStructure = theStructure.findChildById(pathElements[i])) == null) {
                        throw new ProtocolMethodException("Invalid template path in " + reference.toString());
                    }
                    ++i;
                }
            }
            return theStructure;
        }
        catch (ResourceProcessingError e) {
            throw new ProtocolMethodException(e);
        }
    }

    @Override
    public VirtualFolderDefinition execute(VanillaProtocol vanillaProtocol, Reference reference) throws ProtocolMethodException {
        InputStream vanillaIS = reference.execute(new GetVanillaScriptInputStreamMethod(this.environment));
        try {
            String vanillaJSON = IOUtils.toString((InputStream)vanillaIS, (Charset)StandardCharsets.UTF_8);
            VirtualContext context = this.createVirtualContext(reference);
            context.setParameter(VANILLA_JSON_PARAM_NAME, vanillaJSON);
            VirtualFolderDefinition virtualFolderDefinition = this.execute(vanillaProtocol, reference, context);
            return virtualFolderDefinition;
        }
        catch (IOException e) {
            throw new ProtocolMethodException(e);
        }
        finally {
            try {
                if (vanillaIS != null) {
                    vanillaIS.close();
                }
            }
            catch (IOException ioe) {
                logger.warn((Object)("Failed to close input stream : " + ioe));
            }
        }
    }

    @Override
    public VirtualFolderDefinition execute(NodeProtocol protocol, Reference reference) throws ProtocolMethodException {
        VirtualFolderDefinition virtualStructure = new VirtualFolderDefinition();
        virtualStructure.setFilingRule(new NodeFilingRule(this.environment));
        return virtualStructure;
    }
}

