/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management;

import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.alfresco.repo.management.JmxDumpUtil;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.Assert;
import org.junit.Test;

public class JmxDumpUtilTest
extends TestCase {
    public void testUpdateOSNameAttribute() throws Exception {
        ApplicationContextHelper.getApplicationContext();
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().startsWith("linux")) {
            String attr = JmxDumpUtil.updateOSNameAttributeForLinux((String)osName);
            JmxDumpUtilTest.assertTrue((boolean)attr.toLowerCase().startsWith("linux ("));
        }
    }

    @Test
    public void testCleanPasswordsFromInputArgument() throws Exception {
        Pattern pattern = Pattern.compile("(?i)(.*(password=|pwd=|token=))((?<=password=|pwd=|token=).*+)");
        String passwordArg = "-Ddb.password=I should be stars \"\u00a3$%^&*()@";
        String expected = "-Ddb.password=********";
        String actual = JmxDumpUtil.cleanPasswordFromInputArgument((String)passwordArg, (Pattern)pattern);
        JmxDumpUtilTest.assertEquals((String)("Expectected output: " + expected + " Actual output: " + actual), (String)expected, (String)actual);
        passwordArg = "-Ddb.paSsword=@";
        expected = "-Ddb.paSsword=********";
        actual = JmxDumpUtil.cleanPasswordFromInputArgument((String)passwordArg, (Pattern)pattern);
        JmxDumpUtilTest.assertEquals((String)("Expectected output: " + expected + " Actual output: " + actual), (String)expected, (String)actual);
        passwordArg = "somePrefix.token=\"If i'm not replaced, something has gone very wrong\"";
        expected = "somePrefix.token=********";
        actual = JmxDumpUtil.cleanPasswordFromInputArgument((String)passwordArg, (Pattern)pattern);
        JmxDumpUtilTest.assertEquals((String)("Expectected output: " + expected + " Actual output: " + actual), (String)expected, (String)actual);
        passwordArg = "yetanotherpwd=";
        expected = "yetanotherpwd=********";
        actual = JmxDumpUtil.cleanPasswordFromInputArgument((String)passwordArg, (Pattern)pattern);
        JmxDumpUtilTest.assertEquals((String)("Expectected output: " + expected + " Actual output: " + actual), (String)expected, (String)actual);
        passwordArg = "AnyOtherArgument=\"I should still be here\"";
        expected = "AnyOtherArgument=\"I should still be here\"";
        actual = JmxDumpUtil.cleanPasswordFromInputArgument((String)passwordArg, (Pattern)pattern);
        JmxDumpUtilTest.assertEquals((String)("Expectected output :" + expected + " Actual output :" + actual), (String)expected, (String)actual);
    }

    @Test
    public void testCleanPasswordsFromInputArguments() throws Exception {
        String[] argEndingsTypical = new String[]{"password", "token", "pwd"};
        String[] args = new String[]{"-Ddb.password=alfresco", "-Ddb.user=alfresco", "-DtestToken=asdoij3ifiej22244ojpgkmkfpsi3j55643pojpdjoismvi4563625mposvsd"};
        Object[] expectedArray = new String[]{"-Ddb.password=********", "-Ddb.user=alfresco", "-DtestToken=********"};
        Object[] actualArray = JmxDumpUtil.cleanPasswordsFromInputArguments((String[])args, (String[])argEndingsTypical);
        Assert.assertArrayEquals((String)("Expectected output:" + expectedArray + " Actual output:" + actualArray), (Object[])expectedArray, (Object[])actualArray);
        args = new String[]{"-Ddb.port=1234", "-Ddb.user=alfresco", "-DtestArg=Test1234password"};
        expectedArray = new String[]{"-Ddb.port=1234", "-Ddb.user=alfresco", "-DtestArg=Test1234password"};
        actualArray = JmxDumpUtil.cleanPasswordsFromInputArguments((String[])args, (String[])argEndingsTypical);
        Assert.assertArrayEquals((String)("Expectected output:" + expectedArray + " Actual output:" + actualArray), (Object[])expectedArray, (Object[])actualArray);
    }

    @Test
    public void testCreatePasswordFindRegexString() throws Exception {
        String[] argEndings = new String[]{"password", "any old ending :D", "token"};
        String expected = "(?i)(.*(password=|any old ending :D=|token=))((?<=password=|any old ending :D=|token=).*+)";
        String actual = JmxDumpUtil.createPasswordFindRegexString((String[])argEndings);
        JmxDumpUtilTest.assertEquals((String)("Expectected output :" + expected + " Actual output :" + actual), (String)expected, (String)actual);
        String[] argEndings2 = new String[]{"?", "\"\u00a3$%^&*"};
        expected = "(?i)(.*(\\?=|\"\u00a3$%^&\\*=))((?<=\\?=|\"\u00a3$%^&\\*=).*+)";
        actual = JmxDumpUtil.createPasswordFindRegexString((String[])argEndings2);
        JmxDumpUtilTest.assertEquals((String)("Expectected output :" + expected + " Actual output :" + actual), (String)expected, (String)actual);
        String[] emptyArgs = new String[]{};
        try {
            JmxDumpUtil.createPasswordFindRegexString((String[])emptyArgs);
            JmxDumpUtilTest.fail((String)"expected exception was not occured.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testEscapeRegexMetaChars() {
        String input = "|?*+.";
        String expected = "\\|\\?\\*\\+\\.";
        String actual = JmxDumpUtil.escapeRegexMetaChars((String)input);
        JmxDumpUtilTest.assertEquals((String)("Expectected output :" + expected + " Actual output :" + actual), (String)expected, (String)actual);
        input = "Let's.Add++,*complexity?!\"";
        expected = "Let's\\.Add\\+\\+,\\*complexity\\?!\"";
        actual = JmxDumpUtil.escapeRegexMetaChars((String)input);
        JmxDumpUtilTest.assertEquals((String)("Expectected output :" + expected + " Actual output :" + actual), (String)expected, (String)actual);
    }
}

