/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import net.sf.acegisecurity.AuthenticationCredentialsNotFoundException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.filefolder.FileFolderLoader;
import org.alfresco.repo.node.MLPropertyInterceptor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class FileFolderLoaderTest
extends TestCase {
    private static final ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private FileFolderLoader fileFolderLoader;
    private FileFolderService fileFolderService;
    private PermissionService permissionService;
    private TransactionService transactionService;
    private NodeService nodeService;
    private String sharedHomePath;
    private NodeRef hiddenFolderNodeRef;
    private String hiddenFolderPath;
    private NodeRef readOnlyFolderNodeRef;
    private String readOnlyFolderPath;
    private NodeRef writeFolderNodeRef;
    private String writeFolderPath;

    public void setUp() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.RunAsWork<Void> setUpWork = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                FileFolderLoaderTest.this.fileFolderLoader = (FileFolderLoader)ctx.getBean("FileFolderLoader");
                FileFolderLoaderTest.this.fileFolderService = (FileFolderService)ctx.getBean("FileFolderService");
                FileFolderLoaderTest.this.permissionService = (PermissionService)ctx.getBean("PermissionService");
                FileFolderLoaderTest.this.transactionService = (TransactionService)ctx.getBean("TransactionService");
                FileFolderLoaderTest.this.nodeService = (NodeService)ctx.getBean("nodeService");
                NodeRef companyHomeNodeRef = FileFolderLoaderTest.this.fileFolderLoader.getRepository().getCompanyHome();
                NodeRef sharedHomeNodeRef = FileFolderLoaderTest.this.fileFolderLoader.getRepository().getSharedHome();
                List sharedHomeFileInfos = FileFolderLoaderTest.this.fileFolderService.getNamePath(companyHomeNodeRef, sharedHomeNodeRef);
                FileFolderLoaderTest.this.sharedHomePath = "/" + ((FileInfo)sharedHomeFileInfos.get(0)).getName();
                FileInfo hiddenFolderInfo = FileFolderLoaderTest.this.fileFolderService.create(sharedHomeNodeRef, "HideThis", ContentModel.TYPE_FOLDER);
                FileFolderLoaderTest.this.hiddenFolderNodeRef = hiddenFolderInfo.getNodeRef();
                FileFolderLoaderTest.this.hiddenFolderPath = String.valueOf(FileFolderLoaderTest.this.sharedHomePath) + "/HideThis";
                FileFolderLoaderTest.this.permissionService.setInheritParentPermissions(FileFolderLoaderTest.this.hiddenFolderNodeRef, false);
                FileInfo readOnlyFolderInfo = FileFolderLoaderTest.this.fileFolderService.create(sharedHomeNodeRef, "ReadOnlyThis", ContentModel.TYPE_FOLDER);
                FileFolderLoaderTest.this.readOnlyFolderNodeRef = readOnlyFolderInfo.getNodeRef();
                FileFolderLoaderTest.this.readOnlyFolderPath = String.valueOf(FileFolderLoaderTest.this.sharedHomePath) + "/ReadOnlyThis";
                FileFolderLoaderTest.this.permissionService.setInheritParentPermissions(FileFolderLoaderTest.this.readOnlyFolderNodeRef, false);
                FileFolderLoaderTest.this.permissionService.setPermission(FileFolderLoaderTest.this.readOnlyFolderNodeRef, "GROUP_EVERYONE", "Read", true);
                FileInfo writeFolderInfo = FileFolderLoaderTest.this.fileFolderService.create(sharedHomeNodeRef, "WriteThis", ContentModel.TYPE_FOLDER);
                FileFolderLoaderTest.this.writeFolderNodeRef = writeFolderInfo.getNodeRef();
                FileFolderLoaderTest.this.writeFolderPath = String.valueOf(FileFolderLoaderTest.this.sharedHomePath) + "/WriteThis";
                return null;
            }
        };
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)setUpWork);
    }

    public void tearDown() throws Exception {
        AuthenticationUtil.RunAsWork<Void> tearDownWork = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                FileFolderLoaderTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
                    FileFolderLoaderTest.this.fileFolderService.delete(FileFolderLoaderTest.this.hiddenFolderNodeRef);
                    FileFolderLoaderTest.this.fileFolderService.delete(FileFolderLoaderTest.this.readOnlyFolderNodeRef);
                    FileFolderLoaderTest.this.fileFolderService.delete(FileFolderLoaderTest.this.writeFolderNodeRef);
                    return null;
                });
                return null;
            }
        };
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)tearDownWork);
        AuthenticationUtil.popAuthentication();
    }

    @Test
    public void testBasic() {
        FileFolderLoaderTest.assertNotNull((Object)this.fileFolderLoader);
        FileFolderLoaderTest.assertNotNull((Object)this.sharedHomePath);
    }

    @Test
    public void testIllegalArgs_MinMax() throws Exception {
        try {
            this.fileFolderLoader.createFiles(this.sharedHomePath, 1, 256, 100L, 10L, Long.MAX_VALUE, false, 10, 256L);
            FileFolderLoaderTest.fail((String)"Should detect min/max size issue.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testIllegalArgs_DescriptionCount() throws Exception {
        try {
            this.fileFolderLoader.createFiles(this.sharedHomePath, 1, 256, 1024L, 10L, Long.MAX_VALUE, false, Integer.MAX_VALUE, 256L);
            FileFolderLoaderTest.fail((String)"Should detect description count issue.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testIllegalArgs_DescriptionSize() throws Exception {
        try {
            this.fileFolderLoader.createFiles(this.sharedHomePath, 1, 256, 1024L, 10L, Long.MAX_VALUE, false, 10, Long.MAX_VALUE);
            FileFolderLoaderTest.fail((String)"Should detect description size issue.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testNoPermissionsAtAll() throws Exception {
        try {
            this.fileFolderLoader.createFiles(this.sharedHomePath, 0, 256, 1024L, 1024L, Long.MAX_VALUE, false, 10, 256L);
            FileFolderLoaderTest.fail((String)"No permissions to see folder.");
        }
        catch (AuthenticationCredentialsNotFoundException authenticationCredentialsNotFoundException) {}
    }

    @Test
    public void testNoPermissionsToFindFolder() throws Exception {
        try {
            try {
                AuthenticationUtil.pushAuthentication();
                AuthenticationUtil.setFullyAuthenticatedUser((String)"BOB-1");
                this.fileFolderLoader.createFiles(this.hiddenFolderPath, 0, 256, 1024L, 1024L, Long.MAX_VALUE, false, 10, 256L);
                FileFolderLoaderTest.fail((String)"No permissions to see folder.");
            }
            catch (AccessDeniedException accessDeniedException) {
                AuthenticationUtil.popAuthentication();
            }
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testFolderMissing() throws Exception {
        try {
            try {
                AuthenticationUtil.pushAuthentication();
                AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
                this.fileFolderLoader.createFiles(String.valueOf(this.sharedHomePath) + "/Missing", 0, 256, 1024L, 1024L, Long.MAX_VALUE, false, 10, 256L);
                FileFolderLoaderTest.fail((String)"Folder does not exist");
            }
            catch (AlfrescoRuntimeException e) {
                FileFolderLoaderTest.assertTrue((boolean)(e.getCause() instanceof FileNotFoundException));
                AuthenticationUtil.popAuthentication();
            }
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testNoPermissionsToWriteToFolder() throws Exception {
        try {
            try {
                AuthenticationUtil.pushAuthentication();
                AuthenticationUtil.setFullyAuthenticatedUser((String)"BOB-1");
                this.fileFolderLoader.createFiles(this.readOnlyFolderPath, 1, 256, 1024L, 1024L, Long.MAX_VALUE, false, 10, 256L);
                FileFolderLoaderTest.fail((String)"Folder is read only.  Should not be able to write to it.");
            }
            catch (AccessDeniedException accessDeniedException) {
                AuthenticationUtil.popAuthentication();
            }
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testLoad_ZeroFiles() throws Exception {
        try {
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
            int created = this.fileFolderLoader.createFiles(this.writeFolderPath, 0, 256, 1024L, 1024L, Long.MAX_VALUE, false, 10, 256L);
            FileFolderLoaderTest.assertEquals((String)"Incorrect number of files generated.", (int)0, (int)created);
            FileFolderLoaderTest.assertEquals((int)0, (int)this.nodeService.countChildAssocs(this.writeFolderNodeRef, true));
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testLoad_OneFile() throws Exception {
        try {
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
            int created = this.fileFolderLoader.createFiles(this.writeFolderPath, 1, 256, 1024L, 1024L, Long.MAX_VALUE, false, 10, 256L);
            FileFolderLoaderTest.assertEquals((String)"Incorrect number of files generated.", (int)1, (int)created);
            RetryingTransactionHelper.RetryingTransactionCallback<Void> checkCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    MLPropertyInterceptor.setMLAware((boolean)true);
                    List childAssocs = FileFolderLoaderTest.this.nodeService.getChildAssocs(FileFolderLoaderTest.this.writeFolderNodeRef);
                    FileFolderLoaderTest.assertEquals((int)1, (int)childAssocs.size());
                    NodeRef fileNodeRef = ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
                    MLText descriptions = (MLText)FileFolderLoaderTest.this.nodeService.getProperty(fileNodeRef, ContentModel.PROP_DESCRIPTION);
                    FileFolderLoaderTest.assertNotNull((String)"No descriptions added", (Object)descriptions);
                    FileFolderLoaderTest.assertEquals((String)"Incorrect number of unique descriptions added: ", (int)10, (int)descriptions.size());
                    FileFolderLoaderTest.assertTrue((String)"Expect the default language to be present. ", (boolean)descriptions.containsKey((Object)new Locale(Locale.getDefault().getLanguage())));
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)checkCallback, true);
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testLoad_02() throws Exception {
        try {
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
            int created = this.fileFolderLoader.createFiles(this.writeFolderPath, 100, 10, 1024L, 1024L, Long.MAX_VALUE, false, 10, 256L);
            FileFolderLoaderTest.assertEquals((String)"Incorrect number of files generated.", (int)100, (int)created);
            FileFolderLoaderTest.assertEquals((int)100, (int)this.nodeService.countChildAssocs(this.writeFolderNodeRef, true));
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testLoad_03() throws Exception {
        try {
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
            int created = this.fileFolderLoader.createFiles(this.writeFolderPath, 15, 10, 1024L, 1024L, Long.MAX_VALUE, false, 10, 256L);
            FileFolderLoaderTest.assertEquals((String)"Incorrect number of files generated.", (int)15, (int)created);
            FileFolderLoaderTest.assertEquals((int)15, (int)this.nodeService.countChildAssocs(this.writeFolderNodeRef, true));
            List fileInfos = this.fileFolderService.listFiles(this.writeFolderNodeRef);
            String lastText = null;
            String lastDescr = null;
            String lastUrl = null;
            for (FileInfo fileInfo : fileInfos) {
                NodeRef fileNodeRef = fileInfo.getNodeRef();
                ContentReader reader = this.fileFolderService.getReader(fileNodeRef);
                FileFolderLoaderTest.assertEquals((String)"UTF-8", (String)reader.getEncoding());
                FileFolderLoaderTest.assertEquals((String)"text/plain", (String)reader.getMimetype());
                FileFolderLoaderTest.assertEquals((long)1024L, (long)reader.getSize());
                if (lastUrl == null) {
                    lastUrl = reader.getContentUrl();
                } else {
                    Assert.assertNotEquals((String)"We expect different URLs: ", (Object)lastUrl, (Object)reader.getContentUrl());
                    lastUrl = reader.getContentUrl();
                }
                if (lastText == null) {
                    lastText = reader.getContentString();
                } else {
                    String currentStr = reader.getContentString();
                    Assert.assertNotEquals((String)"All text must differ due to varying seed. ", (Object)lastText, (Object)currentStr);
                    lastText = currentStr;
                }
                if (lastDescr == null) {
                    lastDescr = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(fileNodeRef, ContentModel.PROP_DESCRIPTION));
                    FileFolderLoaderTest.assertEquals((String)"cm:description length is incorrect. ", (int)256, (int)lastDescr.getBytes().length);
                    continue;
                }
                String currentDescr = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(fileNodeRef, ContentModel.PROP_DESCRIPTION));
                Assert.assertNotEquals((String)"All descriptions must differ due to varying seed. ", (Object)lastDescr, (Object)currentDescr);
                lastDescr = currentDescr;
            }
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testLoad_04() throws Exception {
        try {
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
            int created = this.fileFolderLoader.createFiles(this.writeFolderPath, 10, 10, 1024L, 1024L, 1L, true, 10, 256L);
            FileFolderLoaderTest.assertEquals((String)"Incorrect number of files generated.", (int)10, (int)created);
            FileFolderLoaderTest.assertEquals((int)10, (int)this.nodeService.countChildAssocs(this.writeFolderNodeRef, true));
            List fileInfos = this.fileFolderService.listFiles(this.writeFolderNodeRef);
            String lastText = null;
            String lastDescr = null;
            String lastUrl = null;
            for (FileInfo fileInfo : fileInfos) {
                NodeRef fileNodeRef = fileInfo.getNodeRef();
                ContentReader reader = this.fileFolderService.getReader(fileNodeRef);
                FileFolderLoaderTest.assertEquals((String)"UTF-8", (String)reader.getEncoding());
                FileFolderLoaderTest.assertEquals((String)"text/plain", (String)reader.getMimetype());
                FileFolderLoaderTest.assertEquals((long)1024L, (long)reader.getSize());
                if (lastUrl == null) {
                    lastUrl = reader.getContentUrl();
                } else {
                    Assert.assertNotEquals((String)"We expect unique URLs: ", (Object)lastUrl, (Object)reader.getContentUrl());
                    lastUrl = reader.getContentUrl();
                }
                if (lastText == null) {
                    lastText = reader.getContentString();
                } else {
                    String currentStr = reader.getContentString();
                    FileFolderLoaderTest.assertEquals((String)"All text must be identical due to same seed. ", (String)lastText, (String)currentStr);
                    lastText = currentStr;
                }
                if (lastDescr == null) {
                    lastDescr = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(fileNodeRef, ContentModel.PROP_DESCRIPTION));
                    FileFolderLoaderTest.assertEquals((String)"cm:description length is incorrect. ", (int)256, (int)lastDescr.getBytes().length);
                    continue;
                }
                String currentDescr = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(fileNodeRef, ContentModel.PROP_DESCRIPTION));
                FileFolderLoaderTest.assertEquals((String)"All descriptions must be identical due to varying seed. ", (String)lastDescr, (String)currentDescr);
                lastDescr = currentDescr;
            }
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }
}

