/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.alfresco.service.cmr.action.ParameterizedItem;

public abstract class ParameterizedItemImpl
implements ParameterizedItem,
Serializable {
    private static final long serialVersionUID = 3578052215076397741L;
    private String id;
    private Map<String, Serializable> parameterValues = new HashMap<String, Serializable>();

    public ParameterizedItemImpl(String id) {
        this(id, null);
    }

    public ParameterizedItemImpl(String id, Map<String, Serializable> parameterValues) {
        this.id = id;
        if (parameterValues != null) {
            this.parameterValues = parameterValues;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Map<String, Serializable> getParameterValues() {
        Map<String, Serializable> result = this.parameterValues;
        if (result == null) {
            result = new HashMap<String, Serializable>();
        }
        return result;
    }

    @Override
    public Serializable getParameterValue(String name) {
        return this.parameterValues.get(name);
    }

    @Override
    public void setParameterValues(Map<String, Serializable> parameterValues) {
        if (parameterValues != null) {
            this.parameterValues = parameterValues;
        }
    }

    @Override
    public void setParameterValue(String name, Serializable value) {
        this.parameterValues.put(name, value);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ParameterizedItemImpl) {
            ParameterizedItemImpl that = (ParameterizedItemImpl)obj;
            return this.id.equals(that.id);
        }
        return false;
    }
}

