/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.ContentStore;

public class ContentExistsException
extends AlfrescoRuntimeException {
    private static final long serialVersionUID = 5154068664249490612L;
    private ContentStore contentStore;
    private String contentUrl;

    public ContentExistsException(ContentStore contentStore, String contentUrl) {
        this(contentStore, contentUrl, "Content with the given URL already exists in the store: \n   Store:       " + contentStore.getClass().getName() + "\n" + "   Content URL: " + contentUrl);
    }

    public ContentExistsException(ContentStore contentStore, String contentUrl, String msg) {
        super(msg);
        this.contentStore = contentStore;
        this.contentUrl = contentUrl;
    }

    public ContentStore getContentStore() {
        return this.contentStore;
    }

    public String getContentUrl() {
        return this.contentUrl;
    }
}

