/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import org.alfresco.repo.forms.processor.FieldProcessor;
import org.alfresco.repo.forms.processor.node.AssociationFieldProcessor;
import org.alfresco.repo.forms.processor.node.ContentModelFieldProcessorRegistry;
import org.alfresco.repo.forms.processor.node.DefaultFieldProcessor;
import org.alfresco.repo.forms.processor.node.EncodingFieldProcessor;
import org.alfresco.repo.forms.processor.node.MimetypeFieldProcessor;
import org.alfresco.repo.forms.processor.node.PropertyFieldProcessor;
import org.alfresco.repo.forms.processor.node.SizeFieldProcessor;
import org.alfresco.repo.forms.processor.workflow.MessageFieldProcessor;
import org.alfresco.repo.forms.processor.workflow.PackageItemsFieldProcessor;
import org.alfresco.repo.forms.processor.workflow.TaskOwnerFieldProcessor;
import org.alfresco.repo.forms.processor.workflow.TransitionFieldProcessor;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespaceService;

public class MockFieldProcessorRegistry
extends ContentModelFieldProcessorRegistry {
    public MockFieldProcessorRegistry(NamespaceService namespaceService, DictionaryService dictionaryService) {
        this.register("prop", this.makePropertyFieldProcessor(namespaceService, dictionaryService));
        this.register("assoc", this.makeAssociationFieldProcessor(namespaceService, dictionaryService));
        this.register("encoding", this.makeEncodingFieldProcessor());
        this.register("mimetype", this.makeMimetypeFieldProcessor());
        this.register("size", this.makeSizeFieldProcessor());
        this.register("transitions", this.makeTransitionFieldProcessor());
        this.register("packageItems", this.makePackageItemFieldProcessor());
        this.register("message", this.makeMessageFieldProcessor());
        this.register("taskOwner", this.makeTaskOwnerFieldProcessor());
        this.setDefaultProcessor(this.makeDefaultFieldProcessor(namespaceService, dictionaryService));
    }

    private FieldProcessor makePackageItemFieldProcessor() {
        return new PackageItemsFieldProcessor();
    }

    private FieldProcessor makeTransitionFieldProcessor() {
        return new TransitionFieldProcessor();
    }

    private FieldProcessor makeMessageFieldProcessor() {
        return new MessageFieldProcessor();
    }

    private FieldProcessor makeTaskOwnerFieldProcessor() {
        return new TaskOwnerFieldProcessor();
    }

    private FieldProcessor makeDefaultFieldProcessor(NamespaceService namespaceService, DictionaryService dictionaryService) {
        DefaultFieldProcessor processor = new DefaultFieldProcessor();
        processor.setDictionaryService(dictionaryService);
        processor.setNamespaceService(namespaceService);
        try {
            processor.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return processor;
    }

    private EncodingFieldProcessor makeEncodingFieldProcessor() {
        return new EncodingFieldProcessor();
    }

    private MimetypeFieldProcessor makeMimetypeFieldProcessor() {
        return new MimetypeFieldProcessor();
    }

    private SizeFieldProcessor makeSizeFieldProcessor() {
        return new SizeFieldProcessor();
    }

    private PropertyFieldProcessor makePropertyFieldProcessor(NamespaceService namespaceService, DictionaryService dictionaryService) {
        PropertyFieldProcessor processor = new PropertyFieldProcessor();
        processor.setDictionaryService(dictionaryService);
        processor.setNamespaceService(namespaceService);
        return processor;
    }

    private AssociationFieldProcessor makeAssociationFieldProcessor(NamespaceService namespaceService, DictionaryService dictionaryService) {
        AssociationFieldProcessor processor = new AssociationFieldProcessor();
        processor.setDictionaryService(dictionaryService);
        processor.setNamespaceService(namespaceService);
        return processor;
    }
}

