/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.copy.AbstractBaseCopyService;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl$AjcClosure1;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl$AjcClosure11;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl$AjcClosure13;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl$AjcClosure3;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl$AjcClosure5;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl$AjcClosure7;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl$AjcClosure9;
import org.alfresco.repo.model.filefolder.FileInfoImpl;
import org.alfresco.repo.model.filefolder.GetChildrenCannedQueryFactory;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.model.filefolder.traitextender.FileFolderServiceExtension;
import org.alfresco.repo.model.filefolder.traitextender.FileFolderServiceTrait;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.PermissionCheckedCollection;
import org.alfresco.repo.security.permissions.PermissionCheckedValue;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderServiceType;
import org.alfresco.service.cmr.model.FileFolderUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.model.SubFolderFilter;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.traitextender.AJProxyTrait;
import org.alfresco.traitextender.Extend;
import org.alfresco.traitextender.ExtendedTrait;
import org.alfresco.traitextender.Extensible;
import org.alfresco.traitextender.RouteExtensions;
import org.alfresco.traitextender.Trait;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.SearchLanguageConversion;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.extensions.surf.util.I18NUtil;

public class FileFolderServiceImpl
extends AbstractBaseCopyService
implements FileFolderService,
Extensible {
    private static final String CANNED_QUERY_FILEFOLDER_LIST = "fileFolderGetChildrenCannedQueryFactory";
    private static final String XPATH_QUERY_SHALLOW_ALL;
    private static final String XPATH_QUERY_DEEP_ALL;
    private static final String XPATH_QUERY_DEEP_FOLDERS;
    private static final String XPATH_QUERY_DEEP_FILES;
    private static Log logger;
    private HiddenAspect hiddenAspect;
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private CopyService copyService;
    private SearchService searchService;
    private ContentService contentService;
    private MimetypeService mimetypeService;
    private BehaviourFilter behaviourFilter;
    private NamedObjectRegistry<CannedQueryFactory<NodeRef>> cannedQueryRegistry;
    private boolean preserveAuditableData = true;
    private List<String> systemPaths;
    private int defaultListMaxResults = 5000;
    private final ExtendedTrait<FileFolderServiceTrait> fileFolderTrait = new ExtendedTrait<FileFolderServiceTrait>(AJProxyTrait.create(this.createFileFolderTrait(), FileFolderServiceTrait.class));
    private static final String LUCENE_MULTI_CHAR_WILDCARD = "*";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;

    static {
        FileFolderServiceImpl.ajc$preClinit();
        XPATH_QUERY_SHALLOW_ALL = "./*[like(@cm:name, $cm:name, false) and not (subtypeOf('" + ContentModel.TYPE_SYSTEM_FOLDER + "'))" + " and (subtypeOf('" + ContentModel.TYPE_FOLDER + "') or subtypeOf('" + ContentModel.TYPE_CONTENT + "')" + " or subtypeOf('" + ContentModel.TYPE_LINK + "'))]";
        XPATH_QUERY_DEEP_ALL = ".//*[like(@cm:name, $cm:name, false) and not (subtypeOf('" + ContentModel.TYPE_SYSTEM_FOLDER + "'))" + " and (subtypeOf('" + ContentModel.TYPE_FOLDER + "') or subtypeOf('" + ContentModel.TYPE_CONTENT + "')" + " or subtypeOf('" + ContentModel.TYPE_LINK + "'))]";
        XPATH_QUERY_DEEP_FOLDERS = ".//*[like(@cm:name, $cm:name, false) and not (subtypeOf('" + ContentModel.TYPE_SYSTEM_FOLDER + "'))" + " and (subtypeOf('" + ContentModel.TYPE_FOLDER + "'))]";
        XPATH_QUERY_DEEP_FILES = ".//*[like(@cm:name, $cm:name, false) and not (subtypeOf('" + ContentModel.TYPE_SYSTEM_FOLDER + "'))" + " and (subtypeOf('" + ContentModel.TYPE_CONTENT + "')" + " or subtypeOf('" + ContentModel.TYPE_LINK + "'))]";
        logger = LogFactory.getLog(FileFolderServiceImpl.class);
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCopyService(CopyService copyService) {
        this.copyService = copyService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.hiddenAspect = hiddenAspect;
    }

    public void setCannedQueryRegistry(NamedObjectRegistry<CannedQueryFactory<NodeRef>> cannedQueryRegistry) {
        this.cannedQueryRegistry = cannedQueryRegistry;
    }

    public void setSystemPaths(List<String> systemPaths) {
        this.systemPaths = systemPaths;
    }

    public void setDefaultListMaxResults(int defaultListMaxResults) {
        this.defaultListMaxResults = defaultListMaxResults;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setPreserveAuditableData(boolean preserveAuditableData) {
        this.preserveAuditableData = preserveAuditableData;
    }

    public boolean isPreserveAuditableData() {
        return this.preserveAuditableData;
    }

    public void init() {
    }

    private List<FileInfo> toFileInfo(List<NodeRef> nodeRefs) throws InvalidTypeException {
        ArrayList<FileInfo> results = new ArrayList<FileInfo>(nodeRefs.size());
        for (NodeRef nodeRef : nodeRefs) {
            try {
                FileInfo fileInfo = this.toFileInfo(nodeRef, true);
                results.add(fileInfo);
            }
            catch (InvalidNodeRefException inre) {
                logger.warn((Object)("toFileInfo: " + (Object)((Object)inre)));
            }
        }
        return results;
    }

    private FileInfo toFileInfo(NodeRef nodeRef, boolean addTranslations) throws InvalidTypeException {
        Map properties = this.nodeService.getProperties(nodeRef);
        QName typeQName = this.nodeService.getType(nodeRef);
        FileFolderServiceType type = this.getType(typeQName);
        boolean isFolder = type.equals((Object)FileFolderServiceType.FOLDER);
        boolean isHidden = false;
        FileFilterMode.Client client = FileFilterMode.getClient();
        if (this.hiddenAspect.getVisibility(client, nodeRef) == HiddenAspect.Visibility.HiddenAttribute) {
            isHidden = true;
        }
        FileInfoImpl fileInfo = new FileInfoImpl(nodeRef, typeQName, isFolder, isHidden, properties);
        return fileInfo;
    }

    @Override
    public List<FileInfo> toFileInfoList(List<NodeRef> nodeRefs) {
        LinkedList<FileInfo> fileInfos = new LinkedList<FileInfo>();
        for (NodeRef nodeRef : nodeRefs) {
            FileInfo fileInfo = this.getFileInfo(nodeRef);
            if (fileInfo == null) continue;
            fileInfos.add(fileInfo);
        }
        return fileInfos;
    }

    @Override
    public boolean exists(NodeRef nodeRef) {
        return this.nodeService.exists(nodeRef);
    }

    @Override
    public FileFolderServiceType getType(QName typeQName) {
        if (this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_FOLDER)) {
            if (this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_SYSTEM_FOLDER)) {
                return FileFolderServiceType.SYSTEM_FOLDER;
            }
            return FileFolderServiceType.FOLDER;
        }
        if (this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_CONTENT) || this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_LINK)) {
            return FileFolderServiceType.FILE;
        }
        return FileFolderServiceType.INVALID;
    }

    @Override
    @Extend(traitAPI=FileFolderServiceTrait.class, extensionAPI=FileFolderServiceExtension.class)
    public List<FileInfo> list(NodeRef contextNodeRef) {
        NodeRef nodeRef = contextNodeRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)nodeRef);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef, joinPoint};
        FileFolderServiceImpl$AjcClosure1 fileFolderServiceImpl$AjcClosure1 = new FileFolderServiceImpl$AjcClosure1(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = fileFolderServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = FileFolderServiceImpl.class.getDeclaredMethod("list", NodeRef.class).getAnnotation(Extend.class);
        }
        return (List)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    private PagingResults<FileInfo> getPagingResults(PagingRequest pagingRequest, final CannedQueryResults<NodeRef> results) {
        List nodeRefs = null;
        nodeRefs = results.getPageCount() > 0 ? (List)results.getPages().get(0) : Collections.emptyList();
        final Pair totalCount = pagingRequest.getRequestTotalCountMax() > 0 ? results.getTotalResultCount() : null;
        final ArrayList<FileInfo> nodeInfos = new ArrayList<FileInfo>(nodeRefs.size());
        for (NodeRef nodeRef : nodeRefs) {
            nodeInfos.add(this.toFileInfo(nodeRef, true));
        }
        PermissionCheckedCollection.PermissionCheckedCollectionMixin.create(nodeInfos, nodeRefs);
        return new PagingResults<FileInfo>(){

            public String getQueryExecutionId() {
                return results.getQueryExecutionId();
            }

            public List<FileInfo> getPage() {
                return nodeInfos;
            }

            public boolean hasMoreItems() {
                return results.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return totalCount;
            }
        };
    }

    @Override
    @Auditable(parameters={"contextNodeRef", "files", "folders", "ignoreQNames", "sortProps", "pagingRequest"})
    @Extend(traitAPI=FileFolderServiceTrait.class, extensionAPI=FileFolderServiceExtension.class)
    public PagingResults<FileInfo> list(NodeRef contextNodeRef, boolean files, boolean folders, Set<QName> ignoreQNames, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        NodeRef nodeRef = contextNodeRef;
        boolean bl = files;
        boolean bl2 = folders;
        Set<QName> set = ignoreQNames;
        List<Pair<QName, Boolean>> list = sortProps;
        PagingRequest pagingRequest2 = pagingRequest;
        Object[] objectArray = new Object[]{nodeRef, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2), set, list, pagingRequest2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2), set, list, pagingRequest2, joinPoint};
        FileFolderServiceImpl$AjcClosure3 fileFolderServiceImpl$AjcClosure3 = new FileFolderServiceImpl$AjcClosure3(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = fileFolderServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = FileFolderServiceImpl.class.getDeclaredMethod("list", NodeRef.class, Boolean.TYPE, Boolean.TYPE, Set.class, List.class, PagingRequest.class).getAnnotation(Extend.class);
        }
        return (PagingResults)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=FileFolderServiceTrait.class, extensionAPI=FileFolderServiceExtension.class)
    public PagingResults<FileInfo> list(NodeRef contextNodeRef, boolean files, boolean folders, String pattern, Set<QName> ignoreQNames, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        NodeRef nodeRef = contextNodeRef;
        boolean bl = files;
        boolean bl2 = folders;
        String string = pattern;
        Set<QName> set = ignoreQNames;
        List<Pair<QName, Boolean>> list = sortProps;
        PagingRequest pagingRequest2 = pagingRequest;
        Object[] objectArray = new Object[]{nodeRef, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2), string, set, list, pagingRequest2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2), string, set, list, pagingRequest2, joinPoint};
        FileFolderServiceImpl$AjcClosure5 fileFolderServiceImpl$AjcClosure5 = new FileFolderServiceImpl$AjcClosure5(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = fileFolderServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = FileFolderServiceImpl.class.getDeclaredMethod("list", NodeRef.class, Boolean.TYPE, Boolean.TYPE, String.class, Set.class, List.class, PagingRequest.class).getAnnotation(Extend.class);
        }
        return (PagingResults)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=FileFolderServiceTrait.class, extensionAPI=FileFolderServiceExtension.class)
    public PagingResults<FileInfo> list(NodeRef rootNodeRef, Set<QName> searchTypeQNames, Set<QName> ignoreAspectQNames, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        NodeRef nodeRef = rootNodeRef;
        Set<QName> set = searchTypeQNames;
        Set<QName> set2 = ignoreAspectQNames;
        List<Pair<QName, Boolean>> list = sortProps;
        PagingRequest pagingRequest2 = pagingRequest;
        Object[] objectArray = new Object[]{nodeRef, set, set2, list, pagingRequest2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef, set, set2, list, pagingRequest2, joinPoint};
        FileFolderServiceImpl$AjcClosure7 fileFolderServiceImpl$AjcClosure7 = new FileFolderServiceImpl$AjcClosure7(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = fileFolderServiceImpl$AjcClosure7.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = FileFolderServiceImpl.class.getDeclaredMethod("list", NodeRef.class, Set.class, Set.class, List.class, PagingRequest.class).getAnnotation(Extend.class);
        }
        return (PagingResults)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    public PagingResults<FileInfo> list(NodeRef rootNodeRef, Set<QName> assocTypeQNames, Set<QName> searchTypeQNames, Set<QName> ignoreAspectQNames, List<Pair<QName, Boolean>> sortProps, List<FilterProp> filterProps, PagingRequest pagingRequest) {
        CannedQueryResults<NodeRef> results = this.listImpl(rootNodeRef, null, assocTypeQNames, searchTypeQNames, ignoreAspectQNames, sortProps, filterProps, pagingRequest);
        return this.getPagingResults(pagingRequest, results);
    }

    private CannedQueryResults<NodeRef> listImpl(NodeRef contextNodeRef, boolean files, boolean folders) {
        Set searchTypeQNames = (Set)this.buildSearchTypesAndIgnoreAspects(files, folders, null).getFirst();
        return this.listImpl(contextNodeRef, searchTypeQNames);
    }

    private CannedQueryResults<NodeRef> listImpl(NodeRef contextNodeRef, Set<QName> searchTypeQNames) {
        return this.listImpl(contextNodeRef, null, searchTypeQNames, null, null, new PagingRequest(this.defaultListMaxResults, null));
    }

    private CannedQueryResults<NodeRef> listImpl(NodeRef contextNodeRef, String pattern, Set<QName> searchTypeQNames, Set<QName> ignoreAspectQNames, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        return this.listImpl(contextNodeRef, pattern, Collections.singleton(ContentModel.ASSOC_CONTAINS), searchTypeQNames, ignoreAspectQNames, sortProps, null, pagingRequest);
    }

    private CannedQueryResults<NodeRef> listImpl(NodeRef contextNodeRef, String pattern, Set<QName> assocTypeQNames, Set<QName> searchTypeQNames, Set<QName> ignoreAspectQNames, List<Pair<QName, Boolean>> sortProps, List<FilterProp> filterProps, PagingRequest pagingRequest) {
        Long start = logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        GetChildrenCannedQueryFactory getChildrenCannedQueryFactory = (GetChildrenCannedQueryFactory)((Object)this.cannedQueryRegistry.getNamedObject(CANNED_QUERY_FILEFOLDER_LIST));
        GetChildrenCannedQuery cq = (GetChildrenCannedQuery)getChildrenCannedQueryFactory.getCannedQuery(contextNodeRef, pattern, assocTypeQNames, searchTypeQNames, ignoreAspectQNames, filterProps, sortProps, pagingRequest);
        CannedQueryResults results = cq.execute();
        if (start != null) {
            int cnt = results.getPagedResultCount();
            int skipCount = pagingRequest.getSkipCount();
            int maxItems = pagingRequest.getMaxItems();
            boolean hasMoreItems = results.hasMoreItems();
            Pair totalCount = pagingRequest.getRequestTotalCountMax() > 0 ? results.getTotalResultCount() : null;
            int pageNum = skipCount / maxItems + 1;
            logger.debug((Object)("List: " + cnt + " items in " + (System.currentTimeMillis() - start) + " msecs [pageNum=" + pageNum + ",skip=" + skipCount + ",max=" + maxItems + ",hasMorePages=" + hasMoreItems + ",totalCount=" + totalCount + ",parentNodeRef=" + contextNodeRef + "]"));
        }
        return results;
    }

    @Override
    public List<FileInfo> listFiles(NodeRef contextNodeRef) {
        List<FileInfo> results = this.listSimple(contextNodeRef, true, false);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("List files: \n   context: " + contextNodeRef + "\n" + "   results: " + results));
        }
        return results;
    }

    @Override
    public List<FileInfo> listFolders(NodeRef contextNodeRef) {
        List<FileInfo> results = this.listSimple(contextNodeRef, false, true);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("List for folders: \n   context: " + contextNodeRef + "\n" + "   results: " + results));
        }
        return results;
    }

    @Override
    public List<FileInfo> listDeepFolders(NodeRef contextNodeRef, SubFolderFilter filter) {
        List<NodeRef> nodeRefs = this.listSimpleDeep(contextNodeRef, false, true, filter);
        List<FileInfo> results = this.toFileInfo(nodeRefs);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Deep search for files: \n   context: " + contextNodeRef + "\n" + "   results: " + results.size()));
        }
        return results;
    }

    @Override
    public NodeRef getLocalizedSibling(NodeRef nodeRef) {
        Locale userLocale = I18NUtil.getLocale();
        String name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
        NodeRef parentNodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
        Pair<String, String> split = this.getExtension(name, false);
        String base = (String)split.getFirst();
        String ext = (String)split.getSecond();
        NodeRef resultNodeRef = nodeRef;
        ResourceBundle.Control resourceHelper = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT);
        List<Locale> candidateLocales = resourceHelper.getCandidateLocales(base, userLocale);
        for (Locale candidateLocale : candidateLocales) {
            String filename = String.valueOf(resourceHelper.toBundleName(base, candidateLocale)) + "." + ext;
            NodeRef foundNodeRef = this.searchSimple(parentNodeRef, filename);
            if (foundNodeRef == null) continue;
            resultNodeRef = foundNodeRef;
            break;
        }
        return resultNodeRef;
    }

    @Override
    public NodeRef searchSimple(NodeRef contextNodeRef, String name) {
        ParameterCheck.mandatory((String)"name", (Object)name);
        ParameterCheck.mandatory((String)"contextNodeRef", (Object)contextNodeRef);
        NodeRef childNodeRef = this.nodeService.getChildByName(contextNodeRef, ContentModel.ASSOC_CONTAINS, name);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Simple name search results: \n   parent: " + contextNodeRef + "\n" + "   name: " + name + "\n" + "   result: " + childNodeRef));
        }
        return childNodeRef;
    }

    @Override
    @Extend(traitAPI=FileFolderServiceTrait.class, extensionAPI=FileFolderServiceExtension.class)
    public List<FileInfo> search(NodeRef contextNodeRef, String namePattern, boolean includeSubFolders) {
        NodeRef nodeRef = contextNodeRef;
        String string = namePattern;
        boolean bl = includeSubFolders;
        Object[] objectArray = new Object[]{nodeRef, string, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef, string, Conversions.booleanObject((boolean)bl), joinPoint};
        FileFolderServiceImpl$AjcClosure9 fileFolderServiceImpl$AjcClosure9 = new FileFolderServiceImpl$AjcClosure9(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = fileFolderServiceImpl$AjcClosure9.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = FileFolderServiceImpl.class.getDeclaredMethod("search", NodeRef.class, String.class, Boolean.TYPE).getAnnotation(Extend.class);
        }
        return (List)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    @Extend(traitAPI=FileFolderServiceTrait.class, extensionAPI=FileFolderServiceExtension.class)
    public List<FileInfo> search(NodeRef contextNodeRef, String namePattern, boolean fileSearch, boolean folderSearch, boolean includeSubFolders) {
        NodeRef nodeRef = contextNodeRef;
        String string = namePattern;
        boolean bl = fileSearch;
        boolean bl2 = folderSearch;
        boolean bl3 = includeSubFolders;
        Object[] objectArray = new Object[]{nodeRef, string, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2), Conversions.booleanObject((boolean)bl3)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray2 = new Object[]{this, nodeRef, string, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2), Conversions.booleanObject((boolean)bl3), joinPoint};
        FileFolderServiceImpl$AjcClosure11 fileFolderServiceImpl$AjcClosure11 = new FileFolderServiceImpl$AjcClosure11(objectArray2);
        ProceedingJoinPoint proceedingJoinPoint = fileFolderServiceImpl$AjcClosure11.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = FileFolderServiceImpl.class.getDeclaredMethod("search", NodeRef.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE).getAnnotation(Extend.class);
        }
        return (List)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    private List<NodeRef> searchInternal(NodeRef contextNodeRef, String namePattern, boolean fileSearch, boolean folderSearch, boolean includeSubFolders) {
        if (!fileSearch && !folderSearch) {
            return Collections.emptyList();
        }
        if (namePattern == null) {
            namePattern = LUCENE_MULTI_CHAR_WILDCARD;
        }
        boolean anyName = namePattern.equals(LUCENE_MULTI_CHAR_WILDCARD);
        List nodeRefs = null;
        if (anyName) {
            nodeRefs = includeSubFolders ? this.listSimpleDeep(contextNodeRef, fileSearch, folderSearch, null) : this.listImpl(contextNodeRef, fileSearch, folderSearch).getPage();
        } else {
            QueryParameterDefinition[] params = null;
            if (namePattern != null) {
                namePattern = SearchLanguageConversion.convert((SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_LUCENE, (SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_XPATH_LIKE, (String)namePattern);
                params = new QueryParameterDefinition[]{new QueryParameterDefImpl(ContentModel.PROP_NAME, this.dictionaryService.getDataType(DataTypeDefinition.TEXT), true, namePattern)};
            }
            String query = null;
            query = includeSubFolders ? (!fileSearch && folderSearch ? XPATH_QUERY_DEEP_FOLDERS : (fileSearch && !folderSearch ? XPATH_QUERY_DEEP_FILES : XPATH_QUERY_DEEP_ALL)) : XPATH_QUERY_SHALLOW_ALL;
            nodeRefs = this.searchService.selectNodes(contextNodeRef, query, params, (NamespacePrefixResolver)this.namespaceService, false);
        }
        return nodeRefs;
    }

    private List<FileInfo> listSimple(NodeRef contextNodeRef, boolean files, boolean folders) throws InvalidTypeException {
        CannedQueryResults<NodeRef> cq = this.listImpl(contextNodeRef, files, folders);
        List nodeRefs = cq.getPage();
        List<FileInfo> results = this.toFileInfo(nodeRefs);
        return PermissionCheckedValue.PermissionCheckedValueMixin.create(results);
    }

    private Pair<Set<QName>, Set<QName>> buildSearchTypesAndIgnoreAspects(boolean files, boolean folders, Set<QName> ignoreQNameTypes) {
        HashSet<QName> searchTypeQNames = new HashSet<QName>(100);
        Set<QName> ignoreAspectQNames = null;
        if (folders) {
            searchTypeQNames.addAll(this.buildFolderTypes());
        }
        if (files) {
            searchTypeQNames.addAll(this.buildFileTypes());
        }
        if (ignoreQNameTypes != null) {
            HashSet<QName> ignoreQNamesNotSearchTypes = new HashSet<QName>(ignoreQNameTypes);
            ignoreQNamesNotSearchTypes.removeAll(searchTypeQNames);
            ignoreQNamesNotSearchTypes.remove(ContentModel.TYPE_SYSTEM_FOLDER);
            if (ignoreQNamesNotSearchTypes.size() > 0) {
                ignoreAspectQNames = this.getAspectsToIgnore(ignoreQNamesNotSearchTypes);
            }
            searchTypeQNames.removeAll(ignoreQNameTypes);
        }
        return new Pair(searchTypeQNames, ignoreAspectQNames);
    }

    private Set<QName> getAspectsToIgnore(Set<QName> ignoreQNames) {
        HashSet<QName> ignoreQNameAspects = new HashSet<QName>(ignoreQNames.size());
        for (QName qname : ignoreQNames) {
            if (this.dictionaryService.getAspect(qname) == null) continue;
            ignoreQNameAspects.add(qname);
        }
        return ignoreQNameAspects;
    }

    private Set<QName> buildFolderTypes() {
        HashSet<QName> folderTypeQNames = new HashSet<QName>(50);
        Collection qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_FOLDER, true);
        folderTypeQNames.addAll(qnames);
        folderTypeQNames.add(ContentModel.TYPE_FOLDER);
        qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_SYSTEM_FOLDER, true);
        folderTypeQNames.removeAll(qnames);
        folderTypeQNames.remove(ContentModel.TYPE_SYSTEM_FOLDER);
        return folderTypeQNames;
    }

    private Set<QName> buildFileTypes() {
        HashSet<QName> fileTypeQNames = new HashSet<QName>(50);
        Collection qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_CONTENT, true);
        fileTypeQNames.addAll(qnames);
        fileTypeQNames.add(ContentModel.TYPE_CONTENT);
        qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_LINK, true);
        fileTypeQNames.addAll(qnames);
        fileTypeQNames.add(ContentModel.TYPE_LINK);
        return fileTypeQNames;
    }

    private List<NodeRef> listSimpleDeep(NodeRef contextNodeRef, boolean files, boolean folders, SubFolderFilter folderFilter) {
        HashSet fileTypeQNames;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("searchSimpleDeep contextNodeRef:" + contextNodeRef));
        }
        ArrayList<NodeRef> result = new ArrayList<NodeRef>();
        Set<QName> folderTypeQNames = this.buildFolderTypes();
        HashSet hashSet = fileTypeQNames = files ? this.buildFileTypes() : new HashSet(0);
        if (!folders && !files) {
            return Collections.emptyList();
        }
        if (folderTypeQNames.size() == 0) {
            return Collections.emptyList();
        }
        Stack<NodeRef> toSearch = new Stack<NodeRef>();
        toSearch.push(contextNodeRef);
        while (!toSearch.empty()) {
            NodeRef currentDir = (NodeRef)toSearch.pop();
            List folderAssocRefs = this.nodeService.getChildAssocs(currentDir, folderTypeQNames);
            for (ChildAssociationRef folderRef : folderAssocRefs) {
                boolean include = true;
                if (folderFilter != null) {
                    include = folderFilter.isEnterSubfolder(folderRef);
                    if (include) {
                        toSearch.push(folderRef.getChildRef());
                    }
                } else {
                    toSearch.push(folderRef.getChildRef());
                }
                if (!folders || !include) continue;
                result.add(folderRef.getChildRef());
            }
            if (!files) continue;
            List fileAssocRefs = this.nodeService.getChildAssocs(currentDir, fileTypeQNames);
            for (ChildAssociationRef fileRef : fileAssocRefs) {
                result.add(fileRef.getChildRef());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("searchSimpleDeep finished size:" + result.size()));
        }
        return result;
    }

    @Override
    @Extend(traitAPI=FileFolderServiceTrait.class, extensionAPI=FileFolderServiceExtension.class)
    public FileInfo rename(NodeRef sourceNodeRef, String newName) throws FileExistsException, FileNotFoundException {
        NodeRef nodeRef = sourceNodeRef;
        String string = newName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)nodeRef, (Object)string);
        RouteExtensions routeExtensions = RouteExtensions.aspectOf();
        Object[] objectArray = new Object[]{this, nodeRef, string, joinPoint};
        FileFolderServiceImpl$AjcClosure13 fileFolderServiceImpl$AjcClosure13 = new FileFolderServiceImpl$AjcClosure13(objectArray);
        ProceedingJoinPoint proceedingJoinPoint = fileFolderServiceImpl$AjcClosure13.linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = FileFolderServiceImpl.class.getDeclaredMethod("rename", NodeRef.class, String.class).getAnnotation(Extend.class);
        }
        return (FileInfo)routeExtensions.intercept(proceedingJoinPoint, (Extend)annotation);
    }

    @Override
    public FileInfo move(NodeRef sourceNodeRef, NodeRef targetParentRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.moveOrCopy(sourceNodeRef, null, targetParentRef, newName, true);
    }

    @Override
    public FileInfo moveFrom(NodeRef sourceNodeRef, NodeRef sourceParentRef, NodeRef targetParentRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.moveOrCopy(sourceNodeRef, sourceParentRef, targetParentRef, newName, true);
    }

    @Override
    public FileInfo move(NodeRef sourceNodeRef, NodeRef sourceParentRef, NodeRef targetParentRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.moveOrCopy(sourceNodeRef, sourceParentRef, targetParentRef, newName, true);
    }

    @Override
    public FileInfo copy(NodeRef sourceNodeRef, NodeRef targetParentRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.moveOrCopy(sourceNodeRef, null, targetParentRef, newName, false);
    }

    private FileInfo moveOrCopy(NodeRef sourceNodeRef, NodeRef sourceParentRef, NodeRef targetParentRef, String newName, boolean move) throws FileExistsException, FileNotFoundException {
        boolean changedParent;
        FileInfo beforeFileInfo = this.toFileInfo(sourceNodeRef, true);
        if (newName == null) {
            newName = beforeFileInfo.getName();
        }
        boolean nameChanged = !newName.equals(beforeFileInfo.getName());
        AbstractBaseCopyService.AssociationCopyInfo targetInfo = this.getAssociationCopyInfo(this.nodeService, sourceNodeRef, sourceParentRef, newName, nameChanged);
        QName qname = targetInfo.getTargetAssocQName();
        boolean isPrimaryParent = targetInfo.getSourceParentAssoc().isPrimary();
        ChildAssociationRef assocRef = targetInfo.getSourceParentAssoc();
        if (targetParentRef == null) {
            targetParentRef = assocRef.getParentRef();
        }
        boolean bl = changedParent = !targetParentRef.equals((Object)assocRef.getParentRef());
        if (!nameChanged && !changedParent) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Doing nothing - neither filename or parent has changed: \n   parent: " + targetParentRef + "\n" + "   before: " + beforeFileInfo + "\n" + "   new name: " + newName));
            }
            return beforeFileInfo;
        }
        QName targetParentType = this.nodeService.getType(targetParentRef);
        QName assocTypeQname = null;
        if (nameChanged && move) {
            assocTypeQname = assocRef.getTypeQName();
        } else if (this.dictionaryService.isSubClass(targetParentType, ContentModel.TYPE_FOLDER)) {
            assocTypeQname = ContentModel.ASSOC_CONTAINS;
        } else if (this.dictionaryService.isSubClass(targetParentType, ContentModel.TYPE_CONTAINER)) {
            assocTypeQname = ContentModel.ASSOC_CHILDREN;
        } else {
            throw new InvalidTypeException("Unexpected type (" + targetParentType + ") for target parent: " + targetParentRef);
        }
        NodeRef targetNodeRef = null;
        if (move) {
            if (!this.isSystemPath(sourceNodeRef)) {
                if (nameChanged) {
                    this.nodeService.setProperty(sourceNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)GUID.generate()));
                }
                try {
                    ChildAssociationRef newAssocRef = null;
                    if (isPrimaryParent) {
                        boolean auditableBehaviorWasDisabled;
                        boolean bl2 = auditableBehaviorWasDisabled = this.preserveAuditableData && this.behaviourFilter.isEnabled(ContentModel.ASPECT_AUDITABLE);
                        if (auditableBehaviorWasDisabled) {
                            this.behaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
                        }
                        try {
                            newAssocRef = this.nodeService.moveNode(sourceNodeRef, targetParentRef, assocTypeQname, qname);
                        }
                        finally {
                            if (auditableBehaviorWasDisabled) {
                                this.behaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
                            }
                        }
                    } else {
                        this.nodeService.removeChild(sourceParentRef, sourceNodeRef);
                        newAssocRef = this.nodeService.addChild(targetParentRef, sourceNodeRef, assocRef.getTypeQName(), assocRef.getQName());
                    }
                    targetNodeRef = newAssocRef.getChildRef();
                }
                catch (DuplicateChildNodeNameException duplicateChildNodeNameException) {
                    throw new FileExistsException(targetParentRef, newName);
                }
            } else {
                targetNodeRef = sourceNodeRef;
            }
        } else {
            String newNameAfterCopy = this.copyService.getTopLevelNodeNewName(sourceNodeRef, targetParentRef, assocTypeQname, qname);
            if (newNameAfterCopy != null && !newNameAfterCopy.equals(newName)) {
                newName = newNameAfterCopy;
                qname = QName.createQName((String)assocRef.getQName().getNamespaceURI(), (String)QName.createValidLocalName((String)newNameAfterCopy));
            }
            try {
                targetNodeRef = this.copyService.copy(sourceNodeRef, targetParentRef, assocTypeQname, qname, true);
            }
            catch (DuplicateChildNodeNameException duplicateChildNodeNameException) {
                throw new FileExistsException(targetParentRef, newName);
            }
        }
        String currentName = (String)((Object)this.nodeService.getProperty(targetNodeRef, ContentModel.PROP_NAME));
        if (!(currentName.equals(newName) || !move && this.nodeService.hasAspect(sourceNodeRef, ContentModel.ASPECT_WORKING_COPY))) {
            try {
                ContentReader reader;
                String newMimetype;
                String targetMimetype;
                this.nodeService.setProperty(targetNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)newName));
                ContentData contentData = (ContentData)this.nodeService.getProperty(targetNodeRef, ContentModel.PROP_CONTENT);
                String oldExt = (String)this.getExtension(beforeFileInfo.getName(), true).getSecond();
                String newExt = (String)this.getExtension(newName, true).getSecond();
                if (!(contentData == null || newExt.length() == 0 || "tmp".equalsIgnoreCase(newExt) || newExt.equalsIgnoreCase(oldExt) || (targetMimetype = contentData.getMimetype()).equalsIgnoreCase(newMimetype = this.mimetypeService.guessMimetype(newName, reader = this.contentService.getReader(targetNodeRef, ContentModel.PROP_CONTENT))))) {
                    contentData = ContentData.setMimetype((ContentData)contentData, (String)newMimetype);
                    this.nodeService.setProperty(targetNodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
                }
            }
            catch (DuplicateChildNodeNameException duplicateChildNodeNameException) {
                throw new FileExistsException(targetParentRef, newName);
            }
        }
        FileInfo afterFileInfo = this.toFileInfo(targetNodeRef, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)((move ? "Moved" : "Copied") + " node: \n" + "   parent: " + targetParentRef + "\n" + "   before: " + beforeFileInfo + "\n" + "   after: " + afterFileInfo));
        }
        return afterFileInfo;
    }

    private boolean isSystemPath(NodeRef nodeRef) {
        Path path = this.nodeService.getPath(nodeRef);
        String prefixedPath = path.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        return this.systemPaths.contains(prefixedPath);
    }

    @Override
    public FileInfo create(NodeRef parentNodeRef, String name, QName typeQName) throws FileExistsException {
        return this.createImpl(parentNodeRef, name, typeQName, null);
    }

    @Override
    public FileInfo create(NodeRef parentNodeRef, String name, QName typeQName, QName assocQName) throws FileExistsException {
        return this.createImpl(parentNodeRef, name, typeQName, assocQName);
    }

    private FileInfo createImpl(NodeRef parentNodeRef, String name, QName typeQName, QName assocQName) throws FileExistsException {
        HashMap<QName, String> properties = new HashMap<QName, String>(11);
        properties.put(ContentModel.PROP_NAME, name);
        FileFolderServiceType type = this.getType(typeQName);
        switch (type) {
            case SYSTEM_FOLDER: {
                throw new InvalidTypeException("System Folders are not handled by this service :" + typeQName);
            }
            case INVALID: {
                throw new InvalidTypeException("Type is not handled by this service: " + typeQName);
            }
        }
        if (assocQName == null) {
            assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)name));
        }
        ChildAssociationRef assocRef = null;
        try {
            assocRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, assocQName, typeQName, properties);
        }
        catch (DuplicateChildNodeNameException duplicateChildNodeNameException) {
            throw new FileExistsException(parentNodeRef, name);
        }
        NodeRef nodeRef = assocRef.getChildRef();
        FileInfo fileInfo = this.toFileInfo(nodeRef, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created: \n   parent: " + parentNodeRef + "\n" + "   created: " + fileInfo));
        }
        return fileInfo;
    }

    @Override
    public void delete(NodeRef nodeRef) {
        this.nodeService.deleteNode(nodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted: \n   node: " + nodeRef));
        }
    }

    public FileInfo makeFolders(NodeRef parentNodeRef, List<String> pathElements, QName folderTypeQName) {
        return FileFolderUtil.makeFolders(this, parentNodeRef, pathElements, folderTypeQName);
    }

    public static FileInfo makeFolders(FileFolderService service, NodeRef parentNodeRef, List<String> pathElements, QName folderTypeQName) {
        return FileFolderUtil.makeFolders(service, parentNodeRef, pathElements, folderTypeQName);
    }

    @Override
    public List<FileInfo> getNamePath(NodeRef rootNodeRef, NodeRef nodeRef) throws FileNotFoundException {
        if (rootNodeRef == null) {
            rootNodeRef = this.nodeService.getRootNode(nodeRef.getStoreRef());
        }
        try {
            ArrayList<FileInfo> results = new ArrayList<FileInfo>(10);
            Path path = this.nodeService.getPath(nodeRef);
            boolean foundRoot = false;
            for (Path.Element element : path) {
                Path.ChildAssocElement assocElement = (Path.ChildAssocElement)element;
                final NodeRef childNodeRef = assocElement.getRef().getChildRef();
                if (childNodeRef.equals((Object)rootNodeRef)) {
                    foundRoot = true;
                    continue;
                }
                if (!foundRoot) continue;
                FileInfo pathInfo = (FileInfo)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<FileInfo>(){

                    public FileInfo doWork() throws Exception {
                        return FileFolderServiceImpl.this.toFileInfo(childNodeRef, true);
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
                if (!results.isEmpty() && !results.get(results.size() - 1).isFolder()) {
                    throw new InvalidTypeException("File is not the last element in path: files cannot contain other files.");
                }
                results.add(pathInfo);
            }
            if (!foundRoot) {
                throw new FileNotFoundException(nodeRef);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Built name path for node: \n   root: " + rootNodeRef + "\n" + "   node: " + nodeRef + "\n" + "   path: " + results));
            }
            return results;
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            throw new FileNotFoundException(nodeRef);
        }
    }

    @Override
    public List<String> getNameOnlyPath(NodeRef rootNodeRef, final NodeRef nodeRef) throws FileNotFoundException {
        if (rootNodeRef == null) {
            rootNodeRef = this.nodeService.getRootNode(nodeRef.getStoreRef());
        }
        try {
            final NodeRef rNodeRef = rootNodeRef;
            final ArrayList<String> results = new ArrayList<String>(10);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    Path path = FileFolderServiceImpl.this.nodeService.getPath(nodeRef);
                    boolean foundRoot = false;
                    for (Path.Element element : path) {
                        Path.ChildAssocElement assocElement = (Path.ChildAssocElement)element;
                        NodeRef childNodeRef = assocElement.getRef().getChildRef();
                        if (childNodeRef.equals((Object)rNodeRef)) {
                            foundRoot = true;
                            continue;
                        }
                        if (!foundRoot) continue;
                        results.add(FileFolderServiceImpl.this.nodeService.getProperty(childNodeRef, ContentModel.PROP_NAME).toString());
                    }
                    if (!foundRoot) {
                        throw new FileNotFoundException(nodeRef);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Built name path for node: \n   root: " + rNodeRef + "\n" + "   node: " + nodeRef + "\n" + "   path: " + results));
                    }
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            return results;
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            throw new FileNotFoundException(nodeRef);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public FileInfo resolveNamePath(NodeRef rootNodeRef, List<String> pathElements) throws FileNotFoundException {
        return this.resolveNamePath(rootNodeRef, pathElements, true);
    }

    @Override
    public FileInfo resolveNamePath(NodeRef rootNodeRef, List<String> pathElements, boolean mustExist) throws FileNotFoundException {
        if (pathElements.size() == 0) {
            throw new IllegalArgumentException("Path elements list is empty");
        }
        NodeRef parentNodeRef = rootNodeRef;
        StringBuilder currentPath = new StringBuilder(pathElements.size() << 4);
        int folderCount = pathElements.size() - 1;
        int i = 0;
        while (i < folderCount) {
            String pathElement = pathElements.get(i);
            currentPath.append("/").append(pathElement);
            NodeRef folderNodeRef = this.searchSimple(parentNodeRef, pathElement);
            if (folderNodeRef == null) {
                if (mustExist) {
                    throw new FileNotFoundException("Folder not found: " + currentPath + " (in " + rootNodeRef + ")");
                }
                return null;
            }
            parentNodeRef = folderNodeRef;
            ++i;
        }
        String pathElement = pathElements.get(pathElements.size() - 1);
        currentPath.append("/").append(pathElement);
        NodeRef fileNodeRef = this.searchSimple(parentNodeRef, pathElement);
        if (fileNodeRef == null) {
            if (mustExist) {
                throw new FileNotFoundException("File not found: " + currentPath + " (in " + rootNodeRef + ")");
            }
            return null;
        }
        FileInfo result = this.getFileInfo(fileNodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resoved path element: \n   root: " + rootNodeRef + "\n" + "   path: " + currentPath + "\n" + "   node: " + result));
        }
        return result;
    }

    @Override
    public FileInfo getFileInfo(NodeRef nodeRef) {
        try {
            return this.toFileInfo(nodeRef, true);
        }
        catch (InvalidTypeException invalidTypeException) {
            return null;
        }
    }

    @Override
    public ContentReader getReader(NodeRef nodeRef) {
        FileInfo fileInfo = this.toFileInfo(nodeRef, false);
        if (fileInfo.isFolder()) {
            throw new InvalidTypeException("Unable to get a content reader for a folder: " + fileInfo);
        }
        return this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
    }

    @Override
    public ContentWriter getWriter(NodeRef nodeRef) {
        FileInfo fileInfo = this.toFileInfo(nodeRef, false);
        if (fileInfo.isFolder()) {
            throw new InvalidTypeException("Unable to get a content writer for a folder: " + fileInfo);
        }
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        if (writer.getMimetype() == null) {
            String name = fileInfo.getName();
            writer.guessMimetype(name);
        }
        return writer;
    }

    private Pair<String, String> getExtension(String name, boolean useLastDot) {
        String ext = "";
        String base = name;
        if (name != null) {
            int index;
            name = name.trim();
            int n = index = useLastDot ? name.lastIndexOf(46) : name.indexOf(46);
            if (index > -1 && index < name.length() - 1) {
                base = name.substring(0, index);
                ext = name.substring(index + 1);
            }
        }
        return new Pair((Object)base, (Object)ext);
    }

    @Override
    public void setHidden(NodeRef nodeRef, boolean isHidden) {
        int mask = 0;
        boolean allVisible = true;
        HiddenAspect.Visibility webDavVisibility = isHidden ? HiddenAspect.Visibility.NotVisible : HiddenAspect.Visibility.Visible;
        FileFilterMode.Client[] clientArray = this.hiddenAspect.getClients();
        int n = clientArray.length;
        int n2 = 0;
        while (n2 < n) {
            HiddenAspect.Visibility clientVisibility;
            FileFilterMode.Client client = clientArray[n2];
            HiddenAspect.Visibility visibility = clientVisibility = client == FileFilterMode.getClient() ? webDavVisibility : this.hiddenAspect.getVisibility(client, nodeRef);
            if (clientVisibility != HiddenAspect.Visibility.Visible) {
                allVisible = false;
            }
            mask |= this.hiddenAspect.getClientVisibilityMask(client, clientVisibility);
            ++n2;
        }
        if (allVisible) {
            this.hiddenAspect.showNode(nodeRef, true);
        } else {
            this.hiddenAspect.hideNode(nodeRef, mask, true, true, false);
        }
    }

    @Override
    public boolean isHidden(NodeRef nodeRef) {
        return this.hiddenAspect.getVisibility(FileFilterMode.getClient(), nodeRef) != HiddenAspect.Visibility.Visible;
    }

    public <M extends Trait> ExtendedTrait<M> getTrait(Class<? extends M> traitAPI) {
        return this.fileFolderTrait;
    }

    private FileFolderServiceTrait createFileFolderTrait() {
        return new FileFolderServiceTraitImpl(this);
    }

    static final /* synthetic */ List list_aroundBody0(FileFolderServiceImpl ajc$this, NodeRef contextNodeRef, JoinPoint joinPoint) {
        List<FileInfo> results = ajc$this.listSimple(contextNodeRef, true, true);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("List files and folders: \n   context: " + contextNodeRef + "\n" + "   results: " + results));
        }
        return results;
    }

    static final /* synthetic */ PagingResults list_aroundBody2(FileFolderServiceImpl ajc$this, NodeRef contextNodeRef, boolean files, boolean folders, Set ignoreQNames, List sortProps, PagingRequest pagingRequest, JoinPoint joinPoint) {
        ParameterCheck.mandatory((String)"contextNodeRef", (Object)contextNodeRef);
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        Pair<Set<QName>, Set<QName>> pair = ajc$this.buildSearchTypesAndIgnoreAspects(files, folders, ignoreQNames);
        Set searchTypeQNames = (Set)pair.getFirst();
        Set ignoreAspectQNames = (Set)pair.getSecond();
        CannedQueryResults<NodeRef> results = ajc$this.listImpl(contextNodeRef, null, searchTypeQNames, ignoreAspectQNames, sortProps, pagingRequest);
        return ajc$this.getPagingResults(pagingRequest, results);
    }

    static final /* synthetic */ PagingResults list_aroundBody4(FileFolderServiceImpl ajc$this, NodeRef contextNodeRef, boolean files, boolean folders, String pattern, Set ignoreQNames, List sortProps, PagingRequest pagingRequest, JoinPoint joinPoint) {
        ParameterCheck.mandatory((String)"contextNodeRef", (Object)contextNodeRef);
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        Pair<Set<QName>, Set<QName>> pair = ajc$this.buildSearchTypesAndIgnoreAspects(files, folders, ignoreQNames);
        Set searchTypeQNames = (Set)pair.getFirst();
        Set ignoreAspectQNames = (Set)pair.getSecond();
        CannedQueryResults<NodeRef> results = ajc$this.listImpl(contextNodeRef, pattern, searchTypeQNames, ignoreAspectQNames, sortProps, pagingRequest);
        return ajc$this.getPagingResults(pagingRequest, results);
    }

    static final /* synthetic */ PagingResults list_aroundBody6(FileFolderServiceImpl ajc$this, NodeRef rootNodeRef, Set searchTypeQNames, Set ignoreAspectQNames, List sortProps, PagingRequest pagingRequest, JoinPoint joinPoint) {
        CannedQueryResults<NodeRef> results = ajc$this.listImpl(rootNodeRef, null, searchTypeQNames, ignoreAspectQNames, sortProps, pagingRequest);
        return ajc$this.getPagingResults(pagingRequest, results);
    }

    static final /* synthetic */ List search_aroundBody8(FileFolderServiceImpl ajc$this, NodeRef contextNodeRef, String namePattern, boolean includeSubFolders, JoinPoint joinPoint) {
        return ajc$this.search(contextNodeRef, namePattern, true, true, includeSubFolders);
    }

    static final /* synthetic */ List search_aroundBody10(FileFolderServiceImpl ajc$this, NodeRef contextNodeRef, String namePattern, boolean fileSearch, boolean folderSearch, boolean includeSubFolders, JoinPoint joinPoint) {
        List<NodeRef> nodeRefs = ajc$this.searchInternal(contextNodeRef, namePattern, fileSearch, folderSearch, includeSubFolders);
        List<FileInfo> results = ajc$this.toFileInfo(nodeRefs);
        Iterator<FileInfo> iterator = results.iterator();
        while (iterator.hasNext()) {
            FileInfo file = iterator.next();
            if (file.isFolder() && !folderSearch) {
                iterator.remove();
                continue;
            }
            if (file.isFolder() || fileSearch) continue;
            iterator.remove();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Deep search: \n   context: " + contextNodeRef + "\n" + "   pattern: " + namePattern + "\n" + "   files: " + fileSearch + "\n" + "   folders: " + folderSearch + "\n" + "   deep: " + includeSubFolders + "\n" + "   results: " + results));
        }
        return results;
    }

    static final /* synthetic */ FileInfo rename_aroundBody12(FileFolderServiceImpl ajc$this, NodeRef sourceNodeRef, String newName, JoinPoint joinPoint) {
        return ajc$this.moveOrCopy(sourceNodeRef, null, null, newName, true);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FileFolderServiceImpl.java", FileFolderServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "list", "org.alfresco.repo.model.filefolder.FileFolderServiceImpl", "org.alfresco.service.cmr.repository.NodeRef", "contextNodeRef", "", "java.util.List"), 373);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "list", "org.alfresco.repo.model.filefolder.FileFolderServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:boolean:boolean:java.util.Set:java.util.List:org.alfresco.query.PagingRequest", "contextNodeRef:files:folders:ignoreQNames:sortProps:pagingRequest", "", "org.alfresco.query.PagingResults"), 448);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "list", "org.alfresco.repo.model.filefolder.FileFolderServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:boolean:boolean:java.lang.String:java.util.Set:java.util.List:org.alfresco.query.PagingRequest", "contextNodeRef:files:folders:pattern:ignoreQNames:sortProps:pagingRequest", "", "org.alfresco.query.PagingResults"), 469);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "list", "org.alfresco.repo.model.filefolder.FileFolderServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.util.Set:java.util.Set:java.util.List:org.alfresco.query.PagingRequest", "rootNodeRef:searchTypeQNames:ignoreAspectQNames:sortProps:pagingRequest", "", "org.alfresco.query.PagingResults"), 486);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "search", "org.alfresco.repo.model.filefolder.FileFolderServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.lang.String:boolean", "contextNodeRef:namePattern:includeSubFolders", "", "java.util.List"), 663);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "search", "org.alfresco.repo.model.filefolder.FileFolderServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.lang.String:boolean:boolean:boolean", "contextNodeRef:namePattern:fileSearch:folderSearch:includeSubFolders", "", "java.util.List"), 675);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rename", "org.alfresco.repo.model.filefolder.FileFolderServiceImpl", "org.alfresco.service.cmr.repository.NodeRef:java.lang.String", "sourceNodeRef:newName", "org.alfresco.service.cmr.model.FileExistsException:org.alfresco.service.cmr.model.FileNotFoundException", "org.alfresco.service.cmr.model.FileInfo"), 1004);
    }

    public static class FileFolderServiceTraitImpl
    implements FileFolderServiceTrait {
        private FileFolderServiceImpl thisService;

        public FileFolderServiceTraitImpl(FileFolderServiceImpl fileFolderServiceImpl) {
            this.thisService = fileFolderServiceImpl;
        }

        @Override
        public Pair<Set<QName>, Set<QName>> buildSearchTypesAndIgnoreAspects(boolean files, boolean folders, Set<QName> ignoreQNameTypes) {
            return this.thisService.buildSearchTypesAndIgnoreAspects(files, folders, ignoreQNameTypes);
        }

        @Override
        public FileInfo createFileInfo(NodeRef nodeRef, QName typeQName, boolean isFolder, boolean isHidden, Map<QName, Serializable> properties) {
            return new FileInfoImpl(nodeRef, typeQName, isFolder, isHidden, properties);
        }

        @Override
        public FileFolderServiceType getType(QName typeQName) {
            return this.thisService.getType(typeQName);
        }

        @Override
        public List<FileInfo> list(NodeRef contextNodeRef) {
            return this.thisService.list(contextNodeRef);
        }

        @Override
        public PagingResults<FileInfo> list(NodeRef contextNodeRef, boolean files, boolean folders, String pattern, Set<QName> ignoreQNames, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
            return this.thisService.list(contextNodeRef, files, folders, pattern, ignoreQNames, sortProps, pagingRequest);
        }

        @Override
        public PagingResults<FileInfo> list(NodeRef rootNodeRef, Set<QName> searchTypeQNames, Set<QName> ignoreAspectQNames, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
            return this.thisService.list(rootNodeRef, searchTypeQNames, ignoreAspectQNames, sortProps, pagingRequest);
        }

        @Override
        public List<FileInfo> search(NodeRef contextNodeRef, String namePattern, boolean fileSearch, boolean folderSearch, boolean includeSubFolders) {
            return this.thisService.search(contextNodeRef, namePattern, fileSearch, folderSearch, includeSubFolders);
        }

        @Override
        public FileInfo rename(NodeRef sourceNodeRef, String newName) throws FileExistsException, FileNotFoundException {
            return this.thisService.rename(sourceNodeRef, newName);
        }

        @Override
        public PagingResults<FileInfo> list(NodeRef contextNodeRef, boolean files, boolean folders, Set<QName> ignoreQNames, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
            return this.thisService.list(contextNodeRef, files, folders, ignoreQNames, sortProps, pagingRequest);
        }
    }

    public static class InvalidTypeException
    extends RuntimeException {
        private static final long serialVersionUID = -310101369475434280L;

        public InvalidTypeException(String msg) {
            super(msg);
        }
    }
}

