/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.TransactionalCache;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.person.GetPeopleCannedQuery;
import org.alfresco.repo.security.person.GetPeopleCannedQueryFactory;
import org.alfresco.repo.security.person.HomeFolderManager;
import org.alfresco.repo.security.person.PermissionsManager;
import org.alfresco.repo.security.person.PersonException;
import org.alfresco.repo.security.person.UserNameMatcher;
import org.alfresco.repo.tenant.TenantDomainMismatchException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.invitation.InvitationException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.sync.events.types.Event;
import org.alfresco.sync.events.types.UserManagementEvent;
import org.alfresco.sync.repo.events.EventPreparator;
import org.alfresco.sync.repo.events.EventPublisher;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.ModelUtil;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersonServiceImpl
extends TransactionListenerAdapter
implements PersonService,
NodeServicePolicies.BeforeCreateNodePolicy,
NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy {
    private static Log logger = LogFactory.getLog(PersonServiceImpl.class);
    static final String CANNED_QUERY_PEOPLE_LIST = "getPeopleCannedQueryFactory";
    private static final String DELETE = "DELETE";
    private static final String SPLIT = "SPLIT";
    private static final String LEAVE = "LEAVE";
    public static final String SYSTEM_FOLDER_SHORT_QNAME = "sys:system";
    public static final String PEOPLE_FOLDER_SHORT_QNAME = "sys:people";
    private static final String KEY_POST_TXN_DUPLICATES = "PersonServiceImpl.KEY_POST_TXN_DUPLICATES";
    public static final String KEY_ALLOW_UID_UPDATE = "PersonServiceImpl.KEY_ALLOW_UID_UPDATE";
    private static final String KEY_USERS_CREATED = "PersonServiceImpl.KEY_USERS_CREATED";
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'/', '\\', '\r', '\n', '\"'};
    private StoreRef storeRef;
    private TransactionService transactionService;
    private NodeService nodeService;
    private TenantService tenantService;
    private SearchService searchService;
    private AuthorityService authorityService;
    private MutableAuthenticationService authenticationService;
    private DictionaryService dictionaryService;
    private PermissionServiceSPI permissionServiceSPI;
    private NamespacePrefixResolver namespacePrefixResolver;
    private HomeFolderManager homeFolderManager;
    private PolicyComponent policyComponent;
    private AclDAO aclDao;
    private PermissionsManager permissionsManager;
    private RepoAdminService repoAdminService;
    private ServiceRegistry serviceRegistry;
    private boolean createMissingPeople;
    private static Set<QName> mutableProperties;
    private String defaultHomeFolderProvider;
    private boolean processDuplicates = true;
    private String duplicateMode = "LEAVE";
    private boolean lastIsBest = true;
    private boolean includeAutoCreated = false;
    private EventPublisher eventPublisher;
    private NamedObjectRegistry<CannedQueryFactory<NodeRef>> cannedQueryRegistry;
    private SimpleCache<String, Set<NodeRef>> personCache;
    private SimpleCache<String, Object> singletonCache;
    private final String KEY_PEOPLECONTAINER_NODEREF = "key.peoplecontainer.noderef";
    private UserNameMatcher userNameMatcher;
    private JavaBehaviour beforeCreateNodeValidationBehaviour;
    private JavaBehaviour beforeDeleteNodeValidationBehaviour;
    private boolean homeFolderCreationEager;
    private boolean homeFolderCreationDisabled = false;

    static {
        HashSet<QName> props = new HashSet<QName>();
        props.add(ContentModel.PROP_HOMEFOLDER);
        props.add(ContentModel.PROP_FIRSTNAME);
        props.add(ContentModel.PROP_LASTNAME);
        props.add(ContentModel.PROP_EMAIL);
        props.add(ContentModel.PROP_ORGID);
        mutableProperties = Collections.unmodifiableSet(props);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return 1;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"storeUrl", (Object)this.storeRef);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"permissionServiceSPI", (Object)this.permissionServiceSPI);
        PropertyCheck.mandatory((Object)this, (String)"authorityService", (Object)this.authorityService);
        PropertyCheck.mandatory((Object)this, (String)"authenticationService", (Object)this.authenticationService);
        PropertyCheck.mandatory((Object)this, (String)"namespacePrefixResolver", (Object)this.namespacePrefixResolver);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"personCache", this.personCache);
        PropertyCheck.mandatory((Object)this, (String)"aclDao", (Object)this.aclDao);
        PropertyCheck.mandatory((Object)this, (String)"homeFolderManager", (Object)this.homeFolderManager);
        PropertyCheck.mandatory((Object)this, (String)"repoAdminService", (Object)this.repoAdminService);
        this.beforeCreateNodeValidationBehaviour = new JavaBehaviour(this, "beforeCreateNodeValidation");
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeCreateNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)this.beforeCreateNodeValidationBehaviour);
        this.beforeDeleteNodeValidationBehaviour = new JavaBehaviour(this, "beforeDeleteNodeValidation");
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)this.beforeDeleteNodeValidationBehaviour);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_USER, (Behaviour)new JavaBehaviour(this, "onUpdatePropertiesUser"));
    }

    @Override
    public void setCreateMissingPeople(boolean createMissingPeople) {
        this.createMissingPeople = createMissingPeople;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPermissionServiceSPI(PermissionServiceSPI permissionServiceSPI) {
        this.permissionServiceSPI = permissionServiceSPI;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setSingletonCache(SimpleCache<String, Object> singletonCache) {
        this.singletonCache = singletonCache;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setRepoAdminService(RepoAdminService repoAdminService) {
        this.repoAdminService = repoAdminService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setStoreUrl(String storeUrl) {
        this.storeRef = new StoreRef(storeUrl);
    }

    public void setUserNameMatcher(UserNameMatcher userNameMatcher) {
        this.userNameMatcher = userNameMatcher;
    }

    void setDefaultHomeFolderProvider(String defaultHomeFolderProvider) {
        this.defaultHomeFolderProvider = defaultHomeFolderProvider;
    }

    public void setDuplicateMode(String duplicateMode) {
        this.duplicateMode = duplicateMode;
    }

    public void setIncludeAutoCreated(boolean includeAutoCreated) {
        this.includeAutoCreated = includeAutoCreated;
    }

    public void setLastIsBest(boolean lastIsBest) {
        this.lastIsBest = lastIsBest;
    }

    public void setProcessDuplicates(boolean processDuplicates) {
        this.processDuplicates = processDuplicates;
    }

    public void setHomeFolderManager(HomeFolderManager homeFolderManager) {
        this.homeFolderManager = homeFolderManager;
    }

    public void setHomeFolderCreationEager(boolean homeFolderCreationEager) {
        this.homeFolderCreationEager = homeFolderCreationEager;
    }

    public void setHomeFolderCreationDisabled(boolean homeFolderCreationDisabled) {
        this.homeFolderCreationDisabled = homeFolderCreationDisabled;
    }

    public void setAclDAO(AclDAO aclDao) {
        this.aclDao = aclDao;
    }

    public void setPermissionsManager(PermissionsManager permissionsManager) {
        this.permissionsManager = permissionsManager;
    }

    public void setCannedQueryRegistry(NamedObjectRegistry<CannedQueryFactory<NodeRef>> cannedQueryRegistry) {
        this.cannedQueryRegistry = cannedQueryRegistry;
    }

    public void setPersonCache(SimpleCache<String, Set<NodeRef>> personCache) {
        this.personCache = personCache;
    }

    private FileFolderService getFileFolderService() {
        return this.serviceRegistry.getFileFolderService();
    }

    private NamespaceService getNamespaceService() {
        return this.serviceRegistry.getNamespaceService();
    }

    private ActionService getActionService() {
        return this.serviceRegistry.getActionService();
    }

    @Override
    public NodeRef getPerson(String userName) {
        return this.getPerson(userName, true);
    }

    @Override
    public PersonService.PersonInfo getPerson(NodeRef personRef) throws NoSuchPersonException {
        Map props = null;
        try {
            props = this.nodeService.getProperties(personRef);
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            throw new NoSuchPersonException(personRef.toString());
        }
        String username = (String)props.get(ContentModel.PROP_USERNAME);
        if (username == null) {
            throw new NoSuchPersonException(personRef.toString());
        }
        return new PersonService.PersonInfo(personRef, username, (String)props.get(ContentModel.PROP_FIRSTNAME), (String)props.get(ContentModel.PROP_LASTNAME));
    }

    @Override
    public NodeRef getPersonOrNull(String userName) {
        return this.getPersonImpl(userName, false, false);
    }

    @Override
    public NodeRef getPerson(String userName, boolean autoCreateHomeFolderAndMissingPersonIfAllowed) {
        return this.getPersonImpl(userName, autoCreateHomeFolderAndMissingPersonIfAllowed, true);
    }

    private NodeRef getPersonImpl(String userName, boolean autoCreateHomeFolderAndMissingPersonIfAllowed, boolean exceptionOrNull) {
        if (userName == null || userName.length() == 0) {
            return null;
        }
        if (this.isSystemUserName(userName)) {
            if (exceptionOrNull) {
                throw new NoSuchPersonException(userName);
            }
            return null;
        }
        NodeRef personNode = this.getPersonOrNullImpl(userName);
        if (personNode == null) {
            AlfrescoTransactionSupport.TxnReadState txnReadState = AlfrescoTransactionSupport.getTransactionReadState();
            if (autoCreateHomeFolderAndMissingPersonIfAllowed && this.createMissingPeople() && txnReadState == AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE) {
                return this.createMissingPersonAsSystem(userName, true);
            }
            if (exceptionOrNull) {
                throw new NoSuchPersonException(userName);
            }
        } else if (autoCreateHomeFolderAndMissingPersonIfAllowed) {
            this.makeHomeFolderIfRequired(personNode);
        }
        return personNode;
    }

    @Override
    public boolean personExists(String caseSensitiveUserName) {
        if (this.isSystemUserName(caseSensitiveUserName)) {
            return false;
        }
        NodeRef person = this.getPersonOrNullImpl(caseSensitiveUserName);
        if (person != null) {
            return this.permissionServiceSPI.hasPermission(person, "Read") == AccessStatus.ALLOWED;
        }
        return false;
    }

    private NodeRef getPersonOrNullImpl(String searchUserName) {
        Set<NodeRef> allRefs = this.getFromCache(searchUserName);
        boolean addToCache = false;
        if (allRefs == null) {
            NodeRef peopleContainer = null;
            try {
                peopleContainer = this.getPeopleContainer();
            }
            catch (InvalidStoreRefException invalidStoreRefException) {
                return null;
            }
            List childRefs = this.nodeService.getChildAssocs(peopleContainer, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)this.getChildNameLower(searchUserName), false);
            allRefs = new LinkedHashSet<NodeRef>(childRefs.size() * 2);
            for (ChildAssociationRef childRef : childRefs) {
                NodeRef nodeRef = childRef.getChildRef();
                allRefs.add(nodeRef);
            }
            addToCache = true;
        }
        ArrayList<NodeRef> refs = new ArrayList<NodeRef>(allRefs.size());
        HashSet<NodeRef> nodesToRemoveFromCache = new HashSet<NodeRef>();
        for (NodeRef nodeRef : allRefs) {
            if (this.nodeService.exists(nodeRef)) {
                Serializable value = this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME);
                String realUserName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
                if (!this.userNameMatcher.matches(searchUserName, realUserName)) continue;
                refs.add(nodeRef);
                continue;
            }
            nodesToRemoveFromCache.add(nodeRef);
        }
        if (!nodesToRemoveFromCache.isEmpty()) {
            allRefs.removeAll(nodesToRemoveFromCache);
        }
        NodeRef returnRef = null;
        if (refs.size() > 1) {
            returnRef = this.handleDuplicates(refs, searchUserName);
        } else if (refs.size() == 1) {
            returnRef = (NodeRef)refs.get(0);
            if (addToCache) {
                this.putToCache(searchUserName, allRefs, false);
            }
        }
        return returnRef;
    }

    private NodeRef handleDuplicates(List<NodeRef> refs, String searchUserName) {
        if (this.processDuplicates) {
            NodeRef best = this.findBest(refs);
            HashSet<NodeRef> toHandle = new HashSet<NodeRef>();
            toHandle.addAll(refs);
            toHandle.remove(best);
            this.addDuplicateNodeRefsToHandle(toHandle);
            return best;
        }
        String userNameSensitivity = " (user name is case-" + (this.userNameMatcher.getUserNamesAreCaseSensitive() ? "sensitive" : "insensitive") + ")";
        String domainNameSensitivity = "";
        if (!this.userNameMatcher.getDomainSeparator().equals("")) {
            domainNameSensitivity = " (domain name is case-" + (this.userNameMatcher.getDomainNamesAreCaseSensitive() ? "sensitive" : "insensitive") + ")";
        }
        throw new AlfrescoRuntimeException("Found more than one user for " + searchUserName + userNameSensitivity + domainNameSensitivity);
    }

    private Set<NodeRef> getPostTxnDuplicates() {
        HashSet postTxnDuplicates = (HashSet)AlfrescoTransactionSupport.getResource((Object)KEY_POST_TXN_DUPLICATES);
        if (postTxnDuplicates == null) {
            postTxnDuplicates = new HashSet();
            AlfrescoTransactionSupport.bindResource((Object)KEY_POST_TXN_DUPLICATES, postTxnDuplicates);
        }
        return postTxnDuplicates;
    }

    private void addDuplicateNodeRefsToHandle(Set<NodeRef> refs) {
        AlfrescoTransactionSupport.bindListener(this);
        Set<NodeRef> postTxnDuplicates = this.getPostTxnDuplicates();
        postTxnDuplicates.addAll(refs);
    }

    @Override
    public void afterCommit() {
        final Set<NodeRef> postTxnDuplicates = this.getPostTxnDuplicates();
        if (postTxnDuplicates.size() == 0) {
            return;
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Object> processDuplicateWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                if (PersonServiceImpl.this.duplicateMode.equalsIgnoreCase(PersonServiceImpl.SPLIT)) {
                    logger.info((Object)("Splitting " + postTxnDuplicates.size() + " duplicate person objects."));
                    AlfrescoTransactionSupport.bindResource((Object)PersonServiceImpl.KEY_ALLOW_UID_UPDATE, (Object)Boolean.TRUE);
                    PersonServiceImpl.this.split(postTxnDuplicates);
                    logger.info((Object)("Split " + postTxnDuplicates.size() + " duplicate person objects."));
                } else if (PersonServiceImpl.this.duplicateMode.equalsIgnoreCase(PersonServiceImpl.DELETE)) {
                    PersonServiceImpl.this.delete(postTxnDuplicates);
                    logger.info((Object)"Deleted duplicate person objects");
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Duplicate person objects exist");
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(processDuplicateWork, false, true);
    }

    private void delete(Set<NodeRef> toDelete) {
        for (NodeRef nodeRef : toDelete) {
            this.deletePerson(nodeRef);
        }
    }

    private void split(Set<NodeRef> toSplit) {
        for (NodeRef nodeRef : toSplit) {
            String userName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
            String newUserName = String.valueOf(userName) + GUID.generate();
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_USERNAME, (Serializable)((Object)(String.valueOf(userName) + GUID.generate())));
            logger.info((Object)("   New person object: " + newUserName));
        }
    }

    private NodeRef findBest(List<NodeRef> refs) {
        if (this.lastIsBest) {
            Collections.sort(refs, new NodeIdComparator(this.nodeService, false));
        } else {
            Collections.sort(refs, new NodeIdComparator(this.nodeService, true));
        }
        NodeRef fallBack = null;
        for (NodeRef nodeRef : refs) {
            if (fallBack == null) {
                fallBack = nodeRef;
            }
            if (!this.includeAutoCreated && this.wasAutoCreated(nodeRef)) continue;
            return nodeRef;
        }
        return fallBack;
    }

    private boolean wasAutoCreated(NodeRef nodeRef) {
        String userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
        String testString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_FIRSTNAME));
        if (testString == null || !testString.equals(userName)) {
            return false;
        }
        testString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LASTNAME));
        if (testString == null || !testString.equals("")) {
            return false;
        }
        testString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_EMAIL));
        if (testString == null || !testString.equals("")) {
            return false;
        }
        testString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_ORGID));
        if (testString == null || !testString.equals("")) {
            return false;
        }
        testString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_HOME_FOLDER_PROVIDER));
        return testString != null && testString.equals(this.defaultHomeFolderProvider);
    }

    @Override
    public boolean createMissingPeople() {
        return this.createMissingPeople;
    }

    @Override
    public Set<QName> getMutableProperties() {
        return mutableProperties;
    }

    @Override
    public void setPersonProperties(String userName, Map<QName, Serializable> properties) {
        this.setPersonProperties(userName, properties, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setPersonProperties(String userName, Map<QName, Serializable> properties, boolean autoCreateHomeFolder) {
        NodeRef personNode = this.getPersonOrNullImpl(userName);
        if (personNode == null) {
            if (!this.createMissingPeople()) throw new PersonException("No person found for user name " + userName);
            personNode = this.createMissingPersonAsSystem(userName, autoCreateHomeFolder);
        } else {
            String suggestedUserName;
            if (autoCreateHomeFolder) {
                this.makeHomeFolderIfRequired(personNode);
            }
            String realUserName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(personNode, ContentModel.PROP_USERNAME));
            if (this.getUserNamesAreCaseSensitive() || (suggestedUserName = (String)((Object)properties.get(ContentModel.PROP_USERNAME))) == null || !suggestedUserName.equalsIgnoreCase(realUserName)) {
                properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)realUserName));
            }
        }
        this.checkIfPersonShouldBeDisabledAndSetAspect(personNode, properties);
        Map update = this.nodeService.getProperties(personNode);
        update.putAll(properties);
        this.nodeService.setProperties(personNode, update);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    private NodeRef createMissingPersonAsSystem(final String userName, final boolean autoCreateHomeFolder) {
        return (NodeRef)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                HashMap properties = PersonServiceImpl.this.getDefaultProperties(userName);
                NodeRef person = PersonServiceImpl.this.createPerson(properties);
                if (autoCreateHomeFolder && !PersonServiceImpl.this.homeFolderCreationEager) {
                    PersonServiceImpl.this.makeHomeFolderIfRequired(person);
                }
                return person;
            }
        });
    }

    private void makeHomeFolderIfRequired(NodeRef person) {
        NodeRef homeFolder;
        if (person != null && !this.homeFolderCreationDisabled && (homeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER))) == null) {
            final ChildAssociationRef ref = this.nodeService.getPrimaryParent(person);
            RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
            txnHelper.setForceWritable(true);
            boolean requiresNew = false;
            if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE) {
                requiresNew = true;
            }
            txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Throwable {
                    PersonServiceImpl.this.makeHomeFolderAsSystem(ref);
                    return null;
                }
            }, false, requiresNew);
        }
    }

    private void makeHomeFolderAsSystem(final ChildAssociationRef childAssocRef) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                PersonServiceImpl.this.homeFolderManager.makeHomeFolder(childAssocRef);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private HashMap<QName, Serializable> getDefaultProperties(String userName) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        properties.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)this.tenantService.getBaseNameUser(userName)));
        properties.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)""));
        properties.put(ContentModel.PROP_EMAIL, (Serializable)((Object)""));
        properties.put(ContentModel.PROP_ORGID, (Serializable)((Object)""));
        properties.put(ContentModel.PROP_HOME_FOLDER_PROVIDER, (Serializable)((Object)this.defaultHomeFolderProvider));
        properties.put(ContentModel.PROP_SIZE_CURRENT, Long.valueOf(0L));
        properties.put(ContentModel.PROP_SIZE_QUOTA, Long.valueOf(-1L));
        return properties;
    }

    @Override
    public NodeRef createPerson(Map<QName, Serializable> properties) {
        return this.createPerson(properties, this.authorityService.getDefaultZones());
    }

    @Override
    public NodeRef createPerson(Map<QName, Serializable> properties, Set<String> zones) {
        ParameterCheck.mandatory((String)"properties", properties);
        String userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_USERNAME));
        if (userName == null) {
            throw new IllegalArgumentException("No username specified when creating the person.");
        }
        if (EqualsHelper.nullSafeEquals((Object)userName, (Object)AuthenticationUtil.getSystemUserName())) {
            throw new AlfrescoRuntimeException("The built-in authority '" + AuthenticationUtil.getSystemUserName() + "' is a user, but not a Person (i.e. it does not have a profile).");
        }
        AuthorityType authorityType = AuthorityType.getAuthorityType((String)userName);
        if (authorityType != AuthorityType.USER) {
            throw new AlfrescoRuntimeException("Attempt to create person for an authority which is not a user");
        }
        this.tenantService.checkDomainUser(userName);
        if (this.personExists(userName)) {
            throw new AlfrescoRuntimeException("Person '" + userName + "' already exists.");
        }
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        properties.put(ContentModel.PROP_SIZE_CURRENT, Long.valueOf(0L));
        NodeRef personRef = null;
        try {
            this.beforeCreateNodeValidationBehaviour.disable();
            personRef = this.nodeService.createNode(this.getPeopleContainer(), ContentModel.ASSOC_CHILDREN, this.getChildNameLower(userName), ContentModel.TYPE_PERSON, properties).getChildRef();
        }
        finally {
            this.beforeCreateNodeValidationBehaviour.enable();
        }
        this.checkIfPersonShouldBeDisabledAndSetAspect(personRef, properties);
        if (zones != null) {
            for (String zone : zones) {
                this.nodeService.addChild(this.authorityService.getOrCreateZone(zone), personRef, ContentModel.ASSOC_IN_ZONE, QName.createQName((String)"cm", (String)userName, (NamespacePrefixResolver)this.namespacePrefixResolver));
            }
        }
        this.removeFromCache(userName, false);
        this.publishEvent("user.create", this.nodeService.getProperties(personRef));
        return personRef;
    }

    private void checkIfPersonShouldBeDisabledAndSetAspect(NodeRef person, Map<QName, Serializable> properties) {
        if (properties.get(ContentModel.PROP_ENABLED) != null) {
            boolean isEnabled = Boolean.parseBoolean(properties.get(ContentModel.PROP_ENABLED).toString());
            if (isEnabled) {
                if (this.nodeService.hasAspect(person, ContentModel.ASPECT_PERSON_DISABLED)) {
                    this.nodeService.removeAspect(person, ContentModel.ASPECT_PERSON_DISABLED);
                }
            } else {
                this.nodeService.addAspect(person, ContentModel.ASPECT_PERSON_DISABLED, null);
            }
        }
    }

    @Override
    public void notifyPerson(String userName, String password) {
        NodeRef noderef = this.getPerson(userName, false);
        Map userProps = this.nodeService.getProperties(noderef);
        String email = null;
        if (userProps.containsKey(ContentModel.PROP_EMAIL)) {
            email = (String)userProps.get(ContentModel.PROP_EMAIL);
        }
        if (email == null || email.length() == 0) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Not sending new user notification to " + userName + " as no email address found"));
            }
            return;
        }
        Map<String, Serializable> model = this.buildEmailTemplateModel(userProps);
        model.put("password", (Serializable)((Object)password));
        NodeRef creatorNR = this.getPerson(AuthenticationUtil.getFullyAuthenticatedUser());
        Map creatorProps = this.nodeService.getProperties(creatorNR);
        Map<String, Serializable> creator = this.buildEmailTemplateModel(creatorProps);
        model.put("creator", (Serializable)((Object)creator));
        String productName = ModelUtil.getProductName(this.repoAdminService);
        model.put("productName", (Serializable)((Object)productName));
        HashMap<String, Serializable> actionParams = new HashMap<String, Serializable>();
        actionParams.put("template_model", (Serializable)((Object)model));
        actionParams.put("to", (Serializable)((Object)email));
        actionParams.put("from", (Serializable)creatorProps.get(ContentModel.PROP_EMAIL));
        actionParams.put("subject", (Serializable)((Object)"invitation.notification.person.email.subject"));
        actionParams.put("subjectParams", (Serializable)new Object[]{productName});
        actionParams.put("template", (Serializable)this.getNotifyEmailTemplateNodeRef());
        Action mailAction = this.getActionService().createAction("mail", actionParams);
        this.getActionService().executeAction(mailAction, noderef, false, true);
    }

    private NodeRef getNotifyEmailTemplateNodeRef() {
        String xpath = "app:company_home/app:dictionary/app:email_templates/cm:invite/cm:new-user-email.html.ftl";
        try {
            NodeRef rootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
            List<NodeRef> nodeRefs = this.searchService.selectNodes(rootNodeRef, xpath, null, (NamespacePrefixResolver)this.getNamespaceService(), false);
            if (nodeRefs.size() > 1) {
                logger.error((Object)("Found too many email templates using: " + xpath));
                nodeRefs = Collections.singletonList((NodeRef)nodeRefs.get(0));
            } else if (nodeRefs.size() == 0) {
                throw new InvitationException("Cannot find the email template using " + xpath, new Object[0]);
            }
            NodeRef base = (NodeRef)nodeRefs.get(0);
            NodeRef local = this.getFileFolderService().getLocalizedSibling(base);
            return local;
        }
        catch (SearcherException e) {
            throw new InvitationException("Cannot find the email template!", e);
        }
    }

    private Map<String, Serializable> buildEmailTemplateModel(Map<QName, Serializable> props) {
        HashMap<String, Serializable> model = new HashMap<String, Serializable>((int)((double)props.size() * 1.5));
        for (QName qname : props.keySet()) {
            model.put(qname.getLocalName(), props.get(qname));
            model.put(qname.getLocalName().toLowerCase(), props.get(qname));
        }
        return model;
    }

    @Override
    public NodeRef getPeopleContainer() {
        NodeRef peopleNodeRef = (NodeRef)this.singletonCache.get((Serializable)((Object)"key.peoplecontainer.noderef"));
        if (peopleNodeRef == null) {
            NodeRef rootNodeRef = this.nodeService.getRootNode(this.storeRef);
            List children = this.nodeService.getChildAssocs(rootNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)SYSTEM_FOLDER_SHORT_QNAME, (NamespacePrefixResolver)this.namespacePrefixResolver), false);
            if (children.size() == 0) {
                throw new AlfrescoRuntimeException("Required people system path not found: sys:system");
            }
            NodeRef systemNodeRef = ((ChildAssociationRef)children.get(0)).getChildRef();
            if ((children = this.nodeService.getChildAssocs(systemNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)PEOPLE_FOLDER_SHORT_QNAME, (NamespacePrefixResolver)this.namespacePrefixResolver), false)).size() == 0) {
                throw new AlfrescoRuntimeException("Required people system path not found: sys:people");
            }
            peopleNodeRef = ((ChildAssociationRef)children.get(0)).getChildRef();
            this.singletonCache.put((Serializable)((Object)"key.peoplecontainer.noderef"), (Object)peopleNodeRef);
        }
        return peopleNodeRef;
    }

    @Override
    public void deletePerson(String userName) {
        if ((userName = this.getUserIdentifier(userName)) == null) {
            return;
        }
        NodeRef personRef = this.getPersonOrNullImpl(userName);
        this.deletePersonAndAuthenticationImpl(userName, personRef);
    }

    @Override
    public void deletePerson(NodeRef personRef) {
        QName typeQName = this.nodeService.getType(personRef);
        if (!typeQName.equals((Object)ContentModel.TYPE_PERSON)) {
            throw new AlfrescoRuntimeException("deletePerson: invalid type of node " + personRef + " (actual=" + typeQName + ", expected=" + ContentModel.TYPE_PERSON + ")");
        }
        String userName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_USERNAME));
        this.deletePersonAndAuthenticationImpl(userName, personRef);
    }

    @Override
    public void deletePerson(NodeRef personRef, boolean deleteAuthentication) {
        QName typeQName = this.nodeService.getType(personRef);
        if (typeQName.equals((Object)ContentModel.TYPE_PERSON)) {
            if (deleteAuthentication) {
                String userName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_USERNAME));
                this.deletePersonAndAuthenticationImpl(userName, personRef);
            } else {
                this.deletePersonImpl(personRef);
            }
        } else {
            throw new AlfrescoRuntimeException("deletePerson: invalid type of node " + personRef + " (actual=" + typeQName + ", expected=" + ContentModel.TYPE_PERSON + ")");
        }
    }

    private void deletePersonAndAuthenticationImpl(String userName, NodeRef personRef) {
        if (userName != null) {
            try {
                this.authenticationService.deleteAuthentication(userName);
            }
            catch (AuthenticationException authenticationException) {}
            try {
                this.authenticationService.invalidateUserSession(userName);
            }
            catch (AuthenticationException authenticationException) {}
            this.permissionServiceSPI.deletePermissions(userName);
        }
        this.deletePersonImpl(personRef);
    }

    private void deletePersonImpl(NodeRef personRef) {
        if (personRef != null) {
            try {
                this.beforeDeleteNodeValidationBehaviour.disable();
                this.nodeService.deleteNode(personRef);
            }
            finally {
                this.beforeDeleteNodeValidationBehaviour.enable();
            }
        }
    }

    @Override
    public Set<NodeRef> getAllPeople() {
        List personInfos = this.getPeople(null, null, null, new PagingRequest(Integer.MAX_VALUE, null)).getPage();
        HashSet<NodeRef> refs = new HashSet<NodeRef>(personInfos.size());
        for (PersonService.PersonInfo personInfo : personInfos) {
            refs.add(personInfo.getNodeRef());
        }
        return refs;
    }

    @Override
    public PagingResults<PersonService.PersonInfo> getPeople(String pattern, List<QName> filterStringProps, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        return this.getPeople(pattern, filterStringProps, null, null, true, sortProps, pagingRequest);
    }

    @Override
    public PagingResults<PersonService.PersonInfo> getPeople(String pattern, List<QName> filterStringProps, Set<QName> inclusiveAspects, Set<QName> exclusiveAspects, boolean includeAdministraotrs, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        List nodeRefs;
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        Long start = logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        CannedQueryResults cqResults = null;
        NodeRef contextNodeRef = this.getPeopleContainer();
        GetPeopleCannedQueryFactory getPeopleCannedQueryFactory = (GetPeopleCannedQueryFactory)((Object)this.cannedQueryRegistry.getNamedObject(CANNED_QUERY_PEOPLE_LIST));
        GetPeopleCannedQuery cq = (GetPeopleCannedQuery)getPeopleCannedQueryFactory.getCannedQuery(contextNodeRef, pattern, filterStringProps, inclusiveAspects, exclusiveAspects, includeAdministraotrs, sortProps, pagingRequest);
        final CannedQueryResults results = cqResults = cq.execute();
        boolean nonFinalHasMoreItems = results.hasMoreItems();
        if (results.getPageCount() > 0) {
            nodeRefs = (List)results.getPages().get(0);
            if (nodeRefs.size() > pagingRequest.getMaxItems()) {
                nodeRefs = nodeRefs.subList(0, pagingRequest.getMaxItems());
                nonFinalHasMoreItems = true;
            }
        } else {
            nodeRefs = Collections.emptyList();
        }
        final boolean hasMoreItems = nonFinalHasMoreItems;
        final Pair totalCount = pagingRequest.getRequestTotalCountMax() > 0 ? results.getTotalResultCount() : null;
        if (start != null) {
            int cnt = nodeRefs.size();
            int skipCount = pagingRequest.getSkipCount();
            int maxItems = pagingRequest.getMaxItems();
            int pageNum = skipCount / maxItems + 1;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getPeople: " + cnt + " items in " + (System.currentTimeMillis() - start) + " msecs " + "[pageNum=" + pageNum + ",skip=" + skipCount + ",max=" + maxItems + ",hasMorePages=" + hasMoreItems + ",totalCount=" + totalCount + ",pattern=" + pattern + ",filterStringProps=" + filterStringProps + ",sortProps=" + sortProps + "]"));
            }
        }
        final ArrayList<PersonService.PersonInfo> personInfos = new ArrayList<PersonService.PersonInfo>(nodeRefs.size());
        for (NodeRef nodeRef : nodeRefs) {
            if (!this.nodeService.exists(nodeRef)) continue;
            Map props = this.nodeService.getProperties(nodeRef);
            personInfos.add(new PersonService.PersonInfo(nodeRef, (String)props.get(ContentModel.PROP_USERNAME), (String)props.get(ContentModel.PROP_FIRSTNAME), (String)props.get(ContentModel.PROP_LASTNAME)));
        }
        return new PagingResults<PersonService.PersonInfo>(){

            public String getQueryExecutionId() {
                return results.getQueryExecutionId();
            }

            public List<PersonService.PersonInfo> getPage() {
                return personInfos;
            }

            public boolean hasMoreItems() {
                return hasMoreItems;
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return totalCount;
            }
        };
    }

    @Override
    public PagingResults<PersonService.PersonInfo> getPeople(List<Pair<QName, String>> stringPropFilters, boolean filterIgnoreCase, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        if (stringPropFilters == null) {
            return this.getPeople(null, null, sortProps, pagingRequest);
        }
        String firstName = "";
        String lastName = "";
        String userName = "";
        for (Pair<QName, String> item : stringPropFilters) {
            if (ContentModel.PROP_FIRSTNAME.equals(item.getFirst())) {
                firstName = ((String)item.getSecond()).trim();
            }
            if (ContentModel.PROP_LASTNAME.equals(item.getFirst())) {
                lastName = ((String)item.getSecond()).trim();
            }
            if (!ContentModel.PROP_USERNAME.equals(item.getFirst())) continue;
            userName = ((String)item.getSecond()).trim();
        }
        String searchStr = "";
        boolean useCQ = false;
        if (userName.length() == 0) {
            if (firstName.equalsIgnoreCase(lastName)) {
                searchStr = firstName;
                useCQ = true;
            } else {
                searchStr = String.valueOf(firstName) + " " + lastName;
            }
        } else {
            searchStr = userName;
            useCQ = searchStr.split(" ").length == 1;
        }
        PagingResults<PersonService.PersonInfo> result = null;
        if (useCQ) {
            ArrayList<QName> filterProps = new ArrayList<QName>(3);
            filterProps.add(ContentModel.PROP_FIRSTNAME);
            filterProps.add(ContentModel.PROP_LASTNAME);
            filterProps.add(ContentModel.PROP_USERNAME);
            sortProps = sortProps == null ? new ArrayList<Pair<QName, Boolean>>(1) : new ArrayList<Pair<QName, Boolean>>(sortProps);
            sortProps.add((Pair<QName, Boolean>)new Pair((Object)ContentModel.PROP_USERNAME, (Object)true));
            result = this.getPeople(searchStr, filterProps, sortProps, pagingRequest);
            if (result.getPage().size() == 0) {
                result = null;
            }
        }
        if (result == null) {
            result = this.getPeopleFts(searchStr, pagingRequest);
        }
        return result;
    }

    private PagingResults<PersonService.PersonInfo> getPeopleFts(String pattern, PagingRequest pagingRequest) {
        Pair totalCount;
        List<Object> nodeRefs;
        Long start = logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        List<NodeRef> people = null;
        try {
            people = this.getPeopleFtsList(pattern, pagingRequest);
        }
        catch (Throwable throwable) {}
        boolean nonFinalHasMoreItems = false;
        if (people != null && people.size() > 0) {
            nodeRefs = people;
            if (nodeRefs.size() > pagingRequest.getMaxItems()) {
                nodeRefs = nodeRefs.subList(0, pagingRequest.getMaxItems());
                nonFinalHasMoreItems = true;
            }
        } else {
            nodeRefs = Collections.emptyList();
        }
        if (people == null || people.size() == 0) {
            nodeRefs = Collections.emptyList();
        }
        final boolean hasMoreItems = nonFinalHasMoreItems;
        if (pagingRequest.getRequestTotalCountMax() > 0) {
            int size = people != null ? people.size() : 0;
            totalCount = new Pair((Object)size, (Object)size);
        } else {
            totalCount = null;
        }
        if (start != null) {
            int cnt = nodeRefs.size();
            int n = pagingRequest.getSkipCount();
            int maxItems = pagingRequest.getMaxItems();
            int pageNum = n / maxItems + 1;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getPeople: " + cnt + " items in " + (System.currentTimeMillis() - start) + " msecs " + "[pageNum=" + pageNum + ",skip=" + n + ",max=" + maxItems + ",hasMorePages=" + hasMoreItems + ",totalCount=" + totalCount + ",pattern=" + pattern + "]"));
            }
        }
        final ArrayList<PersonService.PersonInfo> personInfos = new ArrayList<PersonService.PersonInfo>(nodeRefs.size());
        for (NodeRef nodeRef : nodeRefs) {
            try {
                Map props = this.nodeService.getProperties(nodeRef);
                personInfos.add(new PersonService.PersonInfo(nodeRef, (String)props.get(ContentModel.PROP_USERNAME), (String)props.get(ContentModel.PROP_FIRSTNAME), (String)props.get(ContentModel.PROP_LASTNAME)));
            }
            catch (InvalidNodeRefException e) {
                logger.warn((Object)"Stale search result", (Throwable)e);
            }
        }
        return new PagingResults<PersonService.PersonInfo>(){

            public String getQueryExecutionId() {
                return null;
            }

            public List<PersonService.PersonInfo> getPage() {
                return personInfos;
            }

            public boolean hasMoreItems() {
                return hasMoreItems;
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return totalCount;
            }
        };
    }

    private List<NodeRef> getPeopleFtsList(String pattern, PagingRequest pagingRequest) throws Throwable {
        List people = null;
        SearchParameters params = new SearchParameters();
        params.addQueryTemplate("_PERSON", "|%firstName OR |%lastName OR |%userName");
        params.setDefaultFieldName("_PERSON");
        StringBuilder query = new StringBuilder(256);
        query.append("TYPE:\"").append(ContentModel.TYPE_PERSON).append("\" AND (");
        StringTokenizer t = new StringTokenizer(pattern, " ");
        if (t.countTokens() == 1) {
            query.append('\"').append(pattern).append("*\"");
        } else {
            params.setDefaultOperator(SearchParameters.Operator.AND);
            StringBuilder multiPartNames = new StringBuilder(pattern.length());
            int numOfTokens = t.countTokens();
            int counter = 1;
            String term = null;
            while (t.hasMoreTokens()) {
                term = t.nextToken();
                if (term.endsWith("*")) {
                    term = term.substring(0, term.lastIndexOf("*"));
                }
                multiPartNames.append("\"");
                multiPartNames.append(term);
                multiPartNames.append("*\"");
                if (numOfTokens > counter) {
                    multiPartNames.append(' ');
                }
                ++counter;
            }
            if (multiPartNames.length() > 0) {
                query.append("firstName:");
                query.append((CharSequence)multiPartNames);
                query.append(" OR lastName:");
                query.append((CharSequence)multiPartNames);
            }
        }
        query.append(")");
        params.setLanguage("fts-alfresco");
        params.addStore(this.storeRef);
        params.setQuery(query.toString());
        if (pagingRequest.getMaxItems() > 0) {
            params.setLimitBy(LimitBy.FINAL_SIZE);
            params.setLimit(pagingRequest.getMaxItems());
        }
        try (ResultSet results = null;){
            try {
                results = this.searchService.query(params);
                people = results.getNodeRefs();
            }
            catch (Throwable err) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Failed to execute people search: " + query.toString()), err);
                }
                throw err;
            }
        }
        return people;
    }

    @Override
    public Set<NodeRef> getPeopleFilteredByProperty(QName propertyKey, Serializable propertyValue, int count) {
        if (count > 1000) {
            throw new IllegalArgumentException("Only 1000 results are allowed but got a request for " + count + ". Use getPeople.");
        }
        if (this.dictionaryService.getProperty(ContentModel.TYPE_PERSON, propertyKey) == null) {
            throw new AlfrescoRuntimeException("Property '" + propertyKey + "' is not defined " + "for content model type cm:person");
        }
        if (!(propertyKey.equals((Object)ContentModel.PROP_FIRSTNAME) || propertyKey.equals((Object)ContentModel.PROP_LASTNAME) || propertyKey.equals((Object)ContentModel.PROP_USERNAME))) {
            logger.warn((Object)("PersonService.getPeopleFilteredByProperty() is being called to find people by " + propertyKey + ". Only PROP_FIRSTNAME, PROP_LASTNAME, PROP_USERNAME are now used in the search, so fewer nodes may " + "be returned than expected of there are more than " + count + " users in total."));
        }
        ArrayList<Pair<QName, String>> filterProps = new ArrayList<Pair<QName, String>>(1);
        filterProps.add(new Pair((Object)propertyKey, (Object)((String)((Object)propertyValue))));
        PagingRequest pagingRequest = new PagingRequest(count, null);
        List personInfos = this.getPeople(filterProps, true, null, pagingRequest).getPage();
        HashSet<NodeRef> refs = new HashSet<NodeRef>(personInfos.size());
        for (PersonService.PersonInfo personInfo : personInfos) {
            NodeRef nodeRef = personInfo.getNodeRef();
            String value = (String)((Object)this.nodeService.getProperty(nodeRef, propertyKey));
            if (!EqualsHelper.nullSafeEquals((Object)value, (Object)propertyValue)) continue;
            refs.add(nodeRef);
        }
        return refs;
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        NodeRef personRef = childAssocRef.getChildRef();
        String userName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_USERNAME));
        if (this.getPeopleContainer().equals((Object)childAssocRef.getParentRef())) {
            if (userName != null) {
                char[] cArray = ILLEGAL_CHARACTERS;
                int n = ILLEGAL_CHARACTERS.length;
                int n2 = 0;
                while (n2 < n) {
                    char illegalCharacter = cArray[n2];
                    if (userName.indexOf(illegalCharacter) != -1) {
                        throw new IllegalArgumentException("Person name contains characters that are not permitted: " + userName.charAt(userName.indexOf(illegalCharacter)));
                    }
                    ++n2;
                }
            }
            this.removeFromCache(userName, false);
        }
        this.permissionsManager.setPermissions(personRef, userName, userName);
        if (this.homeFolderCreationEager && !this.homeFolderCreationDisabled) {
            this.makeHomeFolderAsSystem(childAssocRef);
        }
    }

    private QName getChildNameLower(String userName) {
        return QName.createQName((String)"cm", (String)userName.toLowerCase(), (NamespacePrefixResolver)this.namespacePrefixResolver);
    }

    @Override
    public void beforeCreateNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName) {
    }

    public void beforeCreateNodeValidation(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName) {
        if (this.getPeopleContainer().equals((Object)parentRef)) {
            throw new AlfrescoRuntimeException("beforeCreateNode: use PersonService to create person");
        }
        logger.info((Object)("Person node is not being created under the people container (actual=" + parentRef + ", expected=" + this.getPeopleContainer() + ")"));
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        String userName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
        if (this.authorityService.isGuestAuthority(userName) && !this.tenantService.isTenantUser(userName)) {
            throw new AlfrescoRuntimeException("The " + userName + " user cannot be deleted.");
        }
        NodeRef parentRef = null;
        ChildAssociationRef parentAssocRef = this.nodeService.getPrimaryParent(nodeRef);
        if (parentAssocRef != null) {
            parentRef = parentAssocRef.getParentRef();
            if (this.getPeopleContainer().equals((Object)parentRef)) {
                this.removeFromCache(userName, true);
            }
        }
    }

    public void beforeDeleteNodeValidation(NodeRef nodeRef) {
        NodeRef parentRef = null;
        ChildAssociationRef parentAssocRef = this.nodeService.getPrimaryParent(nodeRef);
        if (parentAssocRef != null) {
            parentRef = parentAssocRef.getParentRef();
        }
        if (this.getPeopleContainer().equals((Object)parentRef)) {
            throw new AlfrescoRuntimeException("beforeDeleteNode: use PersonService to delete person");
        }
        logger.info((Object)("Person node that is being deleted is not under the parent people container (actual=" + parentRef + ", expected=" + this.getPeopleContainer() + ")"));
    }

    private Set<NodeRef> getFromCache(String userName) {
        return (Set)this.personCache.get((Serializable)((Object)userName.toLowerCase()));
    }

    private void putToCache(String userName, Set<NodeRef> refs, boolean lock) {
        String key = userName.toLowerCase();
        this.personCache.put((Serializable)((Object)key), refs);
        if (lock && this.personCache instanceof TransactionalCache) {
            TransactionalCache personCacheTxn = (TransactionalCache)this.personCache;
            personCacheTxn.lockValue(key);
        }
    }

    private void removeFromCache(String userName, boolean lock) {
        String key = userName.toLowerCase();
        this.personCache.remove((Serializable)((Object)key));
        if (lock && this.personCache instanceof TransactionalCache) {
            TransactionalCache personCacheTxn = (TransactionalCache)this.personCache;
            personCacheTxn.lockValue(key);
        }
    }

    @Override
    public String getUserIdentifier(String caseSensitiveUserName) {
        NodeRef nodeRef = this.getPersonOrNullImpl(caseSensitiveUserName);
        if (nodeRef != null && this.nodeService.exists(nodeRef)) {
            String realUserName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
            return realUserName;
        }
        return null;
    }

    @Override
    public boolean getUserNamesAreCaseSensitive() {
        return this.userNameMatcher.getUserNamesAreCaseSensitive();
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        String uidBefore = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)before.get(ContentModel.PROP_USERNAME));
        if (uidBefore == null) {
            return;
        }
        String uidAfter = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)after.get(ContentModel.PROP_USERNAME));
        if (!EqualsHelper.nullSafeEquals((Object)uidBefore, (Object)uidAfter)) {
            if (AlfrescoTransactionSupport.getResource((Object)KEY_ALLOW_UID_UPDATE) != null || uidBefore.equalsIgnoreCase(uidAfter)) {
                if (uidBefore != null) {
                    this.aclDao.renameAuthority(uidBefore, uidAfter);
                }
                QName newAssocQName = this.getChildNameLower(uidAfter);
                ChildAssociationRef assoc = this.nodeService.getPrimaryParent(nodeRef);
                this.nodeService.moveNode(nodeRef, assoc.getParentRef(), assoc.getTypeQName(), newAssocQName);
                QName oldAssocQName = QName.createQName((String)"cm", (String)uidBefore, (NamespacePrefixResolver)this.namespacePrefixResolver);
                newAssocQName = QName.createQName((String)"cm", (String)uidAfter, (NamespacePrefixResolver)this.namespacePrefixResolver);
                for (ChildAssociationRef parent : this.nodeService.getParentAssocs(nodeRef)) {
                    if (parent.isPrimary() || !parent.getQName().equals((Object)oldAssocQName)) continue;
                    this.nodeService.removeChildAssociation(parent);
                    this.nodeService.addChild(parent.getParentRef(), parent.getChildRef(), parent.getTypeQName(), newAssocQName);
                }
                this.removeFromCache(uidBefore, true);
            } else {
                throw new UnsupportedOperationException("The user name on a person can not be changed");
            }
        }
        if (this.validUserUpdateEvent(before, after)) {
            this.publishEvent("user.update", after);
        }
    }

    private boolean validUserUpdateEvent(Map<QName, Serializable> before, Map<QName, Serializable> after) {
        boolean updatedLastName;
        String firstnameBefore = (String)((Object)before.get(ContentModel.PROP_FIRSTNAME));
        String lastnameBefore = (String)((Object)before.get(ContentModel.PROP_LASTNAME));
        String firstnameAfter = (String)((Object)after.get(ContentModel.PROP_FIRSTNAME));
        String lastnameAfter = (String)((Object)after.get(ContentModel.PROP_LASTNAME));
        boolean updatedFirstName = !EqualsHelper.nullSafeEquals((Object)firstnameBefore, (Object)firstnameAfter);
        boolean bl = updatedLastName = !EqualsHelper.nullSafeEquals((Object)lastnameBefore, (Object)lastnameAfter);
        return updatedFirstName || updatedLastName;
    }

    private void publishEvent(String eventType, Map<QName, Serializable> properties) {
        if (properties == null) {
            return;
        }
        final String managedUsername = (String)((Object)properties.get(ContentModel.PROP_USERNAME));
        final String managedFirstname = (String)((Object)properties.get(ContentModel.PROP_FIRSTNAME));
        final String managedLastname = (String)((Object)properties.get(ContentModel.PROP_LASTNAME));
        final String eventTType = eventType;
        this.eventPublisher.publishEvent(new EventPreparator(){

            public Event prepareEvent(String user, String networkId, String transactionId) {
                return new UserManagementEvent(eventTType, transactionId, networkId, new Date().getTime(), user, managedUsername, managedFirstname, managedLastname);
            }
        });
    }

    public void onUpdatePropertiesUser(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        String userName = (String)((Object)after.get(ContentModel.PROP_USER_USERNAME));
        if (userName == null) {
            return;
        }
        NodeRef personNodeRef = this.getPersonOrNullImpl(userName);
        if (personNodeRef == null) {
            return;
        }
        Boolean enabled = (Boolean)after.get(ContentModel.PROP_ENABLED);
        if (enabled == null || enabled.booleanValue()) {
            this.nodeService.removeAspect(personNodeRef, ContentModel.ASPECT_PERSON_DISABLED);
        } else {
            this.nodeService.addAspect(personNodeRef, ContentModel.ASPECT_PERSON_DISABLED, null);
        }
        Set usersCreated = TransactionalResourceHelper.getSet(KEY_USERS_CREATED);
        usersCreated.add(userName);
        AlfrescoTransactionSupport.bindListener(this);
    }

    @Override
    public int countPeople() {
        NodeRef peopleContainer = this.getPeopleContainer();
        return this.nodeService.countChildAssocs(peopleContainer, true);
    }

    public static String updateUsernameForTenancy(String username, TenantService tenantService) throws TenantDomainMismatchException {
        if (!tenantService.isEnabled()) {
            return username;
        }
        String currentDomain = tenantService.getCurrentUserDomain();
        if (!currentDomain.equals("")) {
            if (!tenantService.isTenantUser(username)) {
                username = tenantService.getDomainUser(username, currentDomain);
                logger.warn((Object)("Added domain to username: " + username));
            } else {
                tenantService.checkDomainUser(username);
            }
        }
        return username;
    }

    @Override
    public boolean isEnabled(String userName) {
        NodeRef noderef = this.getPerson(userName, false);
        for (QName aspectName : this.nodeService.getAspects(noderef)) {
            if (!ContentModel.ASPECT_PERSON_DISABLED.isMatch(aspectName)) continue;
            return false;
        }
        return true;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    private boolean isSystemUserName(String userName) {
        return EqualsHelper.nullSafeEquals((String)userName, (String)AuthenticationUtil.getSystemUserName(), (boolean)true);
    }

    public static class NodeIdComparator
    implements Comparator<NodeRef> {
        private NodeService nodeService;
        boolean ascending;

        NodeIdComparator(NodeService nodeService, boolean ascending) {
            this.nodeService = nodeService;
            this.ascending = ascending;
        }

        @Override
        public int compare(NodeRef first, NodeRef second) {
            Long firstId = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)this.nodeService.getProperty(first, ContentModel.PROP_NODE_DBID));
            Long secondId = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)this.nodeService.getProperty(second, ContentModel.PROP_NODE_DBID));
            if (firstId != null) {
                if (secondId != null) {
                    return firstId.compareTo(secondId) * (this.ascending ? 1 : -1);
                }
                return this.ascending ? -1 : 1;
            }
            if (secondId != null) {
                return this.ascending ? 1 : -1;
            }
            return 0;
        }
    }
}

