/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.alfresco.repo.transfer.TransferEventImpl;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.transfer.TransferCallback;
import org.alfresco.service.cmr.transfer.TransferEndEvent;
import org.alfresco.service.cmr.transfer.TransferEvent;
import org.alfresco.service.cmr.transfer.TransferEventBegin;
import org.alfresco.service.cmr.transfer.TransferEventCommittingStatus;
import org.alfresco.service.cmr.transfer.TransferEventEndState;
import org.alfresco.service.cmr.transfer.TransferEventEnterState;
import org.alfresco.service.cmr.transfer.TransferEventReport;
import org.alfresco.service.cmr.transfer.TransferEventSendingContent;
import org.alfresco.service.cmr.transfer.TransferEventSendingSnapshot;

public class TransferEventProcessor {
    public Set<TransferCallback> observers = new HashSet<TransferCallback>();
    LinkedBlockingQueue<TransferEvent> queue = new LinkedBlockingQueue();
    private TransferEvent.TransferState currentState;

    public void addObserver(TransferCallback observer) {
        this.observers.add(observer);
    }

    public void deleteObserver(TransferCallback observer) {
        this.observers.remove(observer);
    }

    public void begin(String transferId) {
        this.setState(TransferEvent.TransferState.START);
        TransferEventBegin event = new TransferEventBegin();
        event.setTransferState(TransferEvent.TransferState.START);
        event.setMessage("begin transferId:" + transferId);
        this.queue.add(event);
        event.setTransferId(transferId);
        this.notifyObservers();
    }

    public void start() {
        this.setState(TransferEvent.TransferState.START);
        this.notifyObservers();
    }

    public void end(TransferEndEvent endEvent) {
        this.setState(endEvent.getTransferState());
        this.queue.add(endEvent);
        this.notifyObservers();
    }

    public void sendContent(ContentData data, long range, long position) {
        this.setState(TransferEvent.TransferState.SENDING_CONTENT);
        TransferEventSendingContent event = new TransferEventSendingContent();
        event.setTransferState(TransferEvent.TransferState.SENDING_CONTENT);
        event.setRange(range);
        event.setPosition(position);
        event.setSize(data.getSize());
        event.setMessage("sending content " + position + " of " + range + ", size: " + event.getSize());
        this.queue.add(event);
        this.notifyObservers();
    }

    public void sendSnapshot(long range, long position) {
        this.setState(TransferEvent.TransferState.SENDING_SNAPSHOT);
        TransferEventSendingSnapshot event = new TransferEventSendingSnapshot();
        event.setTransferState(TransferEvent.TransferState.SENDING_SNAPSHOT);
        event.setRange(range);
        event.setPosition(position);
        event.setMessage("sending snapshot");
        this.queue.add(event);
        this.notifyObservers();
    }

    public void prepare() {
        this.setState(TransferEvent.TransferState.PREPARING);
        this.notifyObservers();
    }

    public void commit() {
        this.setState(TransferEvent.TransferState.COMMITTING);
        this.notifyObservers();
    }

    public void writeReport(NodeRef nodeRef, TransferEventReport.ReportType reportType, TransferEvent.TransferState state) {
        this.setState(state);
        TransferEventReport event = new TransferEventReport();
        event.setTransferState(state);
        event.setNodeRef(nodeRef);
        event.setReportType(reportType);
        event.setMessage("report nodeRef:" + nodeRef + ", reportType :" + (Object)((Object)reportType));
        this.queue.add(event);
        this.notifyObservers();
    }

    public void committing(long range, long position) {
        this.setState(TransferEvent.TransferState.COMMITTING);
        TransferEventCommittingStatus event = new TransferEventCommittingStatus();
        event.setTransferState(TransferEvent.TransferState.COMMITTING);
        event.setRange(range);
        event.setPosition(position);
        event.setMessage("committing " + position + " of " + range);
        this.queue.add(event);
        this.notifyObservers();
    }

    private void setState(TransferEvent.TransferState state) {
        if (this.currentState != state) {
            TransferEventImpl event;
            if (this.currentState != null) {
                event = new TransferEventEndState();
                event.setMessage("End State: " + (Object)((Object)this.currentState));
                event.setTransferState(this.currentState);
                this.queue.add(event);
            }
            event = new TransferEventEnterState();
            event.setMessage("Enter State: " + (Object)((Object)state));
            event.setTransferState(state);
            this.queue.add(event);
            this.currentState = state;
        }
    }

    private void notifyObservers() {
        TransferEvent event = this.queue.poll();
        while (event != null) {
            for (TransferCallback callback : this.observers) {
                callback.processEvent(event);
            }
            event = this.queue.poll();
        }
    }
}

