/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.store;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.QName;

public class VirtualUserPermissions {
    private Set<String> allowSmartNodes = Collections.emptySet();
    private Set<String> allowSmartNodesFull = Collections.emptySet();
    private Set<String> denySmartNodes = Collections.emptySet();
    private Set<String> denySmartNodesFull = Collections.emptySet();
    private Set<String> denyReadonlySmartNodes = Collections.emptySet();
    private Set<String> denyReadonlySmartNodesFull = Collections.emptySet();
    private Set<String> allowQueryNodes = Collections.emptySet();
    private Set<String> allowQueryNodesFull = Collections.emptySet();
    private Set<String> denyQueryNodes = Collections.emptySet();
    private Set<String> denyQueryNodesFull = Collections.emptySet();
    private QName permissionTypeQName = ContentModel.TYPE_BASE;

    public VirtualUserPermissions() {
    }

    public VirtualUserPermissions(VirtualUserPermissions userPermissions) {
        this.allowSmartNodes = new HashSet<String>(userPermissions.allowSmartNodes);
        this.denySmartNodes = new HashSet<String>(userPermissions.denySmartNodes);
        this.allowQueryNodes = new HashSet<String>(userPermissions.allowQueryNodes);
        this.denyQueryNodes = new HashSet<String>(userPermissions.denyQueryNodes);
        this.denyReadonlySmartNodes = new HashSet<String>(userPermissions.denyReadonlySmartNodes);
        this.init();
    }

    private Set<String> asFullNamePermissions(Set<String> permissions) {
        HashSet<String> fullPermissions = new HashSet<String>();
        for (String s : permissions) {
            fullPermissions.add(this.permissionTypeQName + "." + s);
        }
        return fullPermissions;
    }

    public void init() {
        this.allowQueryNodesFull = this.asFullNamePermissions(this.allowQueryNodes);
        this.allowSmartNodesFull = this.asFullNamePermissions(this.allowSmartNodes);
        this.denyQueryNodesFull = this.asFullNamePermissions(this.denyQueryNodes);
        this.denySmartNodesFull = this.asFullNamePermissions(this.denySmartNodes);
        this.denyReadonlySmartNodesFull = this.asFullNamePermissions(this.denyReadonlySmartNodes);
    }

    public QName getPermissionTypeQName() {
        return this.permissionTypeQName;
    }

    public AccessStatus hasVirtualNodePermission(String permission, boolean readonly) {
        if (readonly && (this.denyReadonlySmartNodesFull.contains(permission) || this.denyReadonlySmartNodes.contains(permission))) {
            return AccessStatus.DENIED;
        }
        if (this.denySmartNodesFull.contains(permission) || this.denySmartNodes.contains(permission)) {
            return AccessStatus.DENIED;
        }
        if (this.allowSmartNodesFull.contains(permission) || this.allowSmartNodes.contains(permission)) {
            return AccessStatus.ALLOWED;
        }
        return AccessStatus.UNDETERMINED;
    }

    public AccessStatus hasQueryNodePermission(String permission) {
        if (this.denyQueryNodesFull.contains(permission) || this.denyQueryNodes.contains(permission)) {
            return AccessStatus.DENIED;
        }
        if (this.allowQueryNodesFull.contains(permission) || this.allowQueryNodes.contains(permission)) {
            return AccessStatus.ALLOWED;
        }
        return AccessStatus.UNDETERMINED;
    }

    public Set<String> getAllowSmartNodes() {
        return this.allowSmartNodes;
    }

    public void setAllowSmartNodes(Set<String> allowFolders) {
        this.allowSmartNodes = allowFolders;
    }

    public Set<String> getDenySmartNodes() {
        return this.denySmartNodes;
    }

    public void setDenySmartNodes(Set<String> denyFolders) {
        this.denySmartNodes = denyFolders;
    }

    public void setDenyReadonlySmartNodes(Set<String> denyReadonlySmartNodes) {
        this.denyReadonlySmartNodes = denyReadonlySmartNodes;
    }

    public Set<String> getDenyReadonlySmartNodes() {
        return this.denyReadonlySmartNodes;
    }

    public Set<String> getAllowQueryNodes() {
        return this.allowQueryNodes;
    }

    public void setAllowQueryNodes(Set<String> allowDocuments) {
        this.allowQueryNodes = allowDocuments;
    }

    public Set<String> getDenyQueryNodes() {
        return this.denyQueryNodes;
    }

    public void setDenyQueryNodes(Set<String> denyDocuments) {
        this.denyQueryNodes = denyDocuments;
    }
}

