/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.AlfrescoCmisServiceFactory;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.repo.audit.AuditComponentImpl;
import org.alfresco.repo.audit.AuditServiceImpl;
import org.alfresco.repo.audit.UserAuditFilter;
import org.alfresco.repo.audit.model.AuditModelRegistryImpl;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.domain.audit.AuditDAO;
import org.alfresco.repo.domain.node.ContentDataWithId;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.workflow.WorkflowDeployer;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.cmr.workflow.WorkflowAdminService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.testing.category.FrequentlyFailingTests;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CmisExtensionElementImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ExtensionDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.GUID;

@Category(value={LuceneTests.class})
public class CMISTest {
    private static final QName TEST_START_TASK = QName.createQName((String)"http://www.alfresco.org/model/workflow/test/1.0", (String)"startTaskVarScriptAssign");
    private static final QName TEST_WORKFLOW_TASK = QName.createQName((String)"http://www.alfresco.org/model/workflow/test/1.0", (String)"assignVarTask");
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext((String[])new String[]{ApplicationContextHelper.CONFIG_LOCATIONS[0], "classpath:test-cmisinteger_modell-context.xml"});
    private FileFolderService fileFolderService;
    private TransactionService transactionService;
    private NodeService nodeService;
    private ContentService contentService;
    private Repository repositoryHelper;
    private VersionService versionService;
    private LockService lockService;
    private TaggingService taggingService;
    private NamespaceService namespaceService;
    private AuthorityService authorityService;
    private AuditModelRegistryImpl auditSubsystem;
    private PermissionService permissionService;
    private DictionaryDAO dictionaryDAO;
    private CMISDictionaryService cmisDictionaryService;
    private AuditDAO auditDAO;
    private ActionService actionService;
    private RuleService ruleService;
    private NodeArchiveService nodeArchiveService;
    private DictionaryService dictionaryService;
    private WorkflowService workflowService;
    private WorkflowAdminService workflowAdminService;
    private AuthenticationContext authenticationContext;
    private TenantAdminService tenantAdminService;
    private TenantService tenantService;
    private SearchService searchService;
    private java.util.Properties globalProperties;
    private AuditComponentImpl auditComponent;
    private PersonService personService;
    private SiteService siteService;
    private MutableAuthenticationService authenticationService;
    private AlfrescoCmisServiceFactory factory;
    private CMISConnector cmisConnector;
    private NodeDAO nodeDAO;

    @Before
    public void before() {
        this.actionService = (ActionService)ctx.getBean("actionService");
        this.ruleService = (RuleService)ctx.getBean("ruleService");
        this.fileFolderService = (FileFolderService)ctx.getBean("FileFolderService");
        this.transactionService = (TransactionService)ctx.getBean("transactionService");
        this.nodeService = (NodeService)ctx.getBean("NodeService");
        this.contentService = (ContentService)ctx.getBean("ContentService");
        this.versionService = (VersionService)ctx.getBean("versionService");
        this.lockService = (LockService)ctx.getBean("lockService");
        this.taggingService = (TaggingService)ctx.getBean("TaggingService");
        this.namespaceService = (NamespaceService)ctx.getBean("namespaceService");
        this.repositoryHelper = (Repository)ctx.getBean("repositoryHelper");
        this.factory = (AlfrescoCmisServiceFactory)ctx.getBean("CMISServiceFactory");
        this.versionService = (VersionService)ctx.getBean("versionService");
        this.cmisConnector = (CMISConnector)ctx.getBean("CMISConnector");
        this.nodeDAO = (NodeDAO)ctx.getBean("nodeDAO");
        this.authorityService = (AuthorityService)ctx.getBean("AuthorityService");
        this.auditSubsystem = (AuditModelRegistryImpl)ctx.getBean("Audit");
        this.permissionService = (PermissionService)ctx.getBean("permissionService");
        this.dictionaryDAO = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        this.cmisDictionaryService = (CMISDictionaryService)ctx.getBean("OpenCMISDictionaryService1.1");
        this.auditDAO = (AuditDAO)ctx.getBean("auditDAO");
        this.nodeArchiveService = (NodeArchiveService)ctx.getBean("nodeArchiveService");
        this.dictionaryService = (DictionaryService)ctx.getBean("dictionaryService");
        this.workflowService = (WorkflowService)ctx.getBean("WorkflowService");
        this.workflowAdminService = (WorkflowAdminService)ctx.getBean("workflowAdminService");
        this.authenticationContext = (AuthenticationContext)ctx.getBean("authenticationContext");
        this.tenantAdminService = (TenantAdminService)ctx.getBean("tenantAdminService");
        this.tenantService = (TenantService)ctx.getBean("tenantService");
        this.searchService = (SearchService)ctx.getBean("SearchService");
        this.auditComponent = (AuditComponentImpl)ctx.getBean("auditComponent");
        this.personService = (PersonService)ctx.getBean("personService");
        this.siteService = (SiteService)ctx.getBean("siteService");
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("AuthenticationService");
        this.globalProperties = (java.util.Properties)ctx.getBean("global-properties");
        this.globalProperties.setProperty("version.store.enableAutoVersionOnUpdateProps", "true");
    }

    @After
    public void after() {
        this.globalProperties.setProperty("version.store.enableAutoVersionOnUpdateProps", "false");
    }

    @Test
    public void testIsLatestMajorVersionMNT10868() {
        SimpleCallContext context = new SimpleCallContext("admin", "admin", CmisVersion.CMIS_1_0);
        String repositoryId = null;
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try (CmisService cmisService = this.factory.getService((CallContext)context);){
            List repositories = cmisService.getRepositoryInfos(null);
            Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
            RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
            repositoryId = repo.getId();
            final String folderName = "testfolder" + GUID.generate();
            final String docName = "testdoc.txt" + GUID.generate();
            final FileInfo fileInfo = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

                public FileInfo execute() throws Throwable {
                    NodeRef companyHomeNodeRef = CMISTest.this.repositoryHelper.getCompanyHome();
                    FileInfo folderInfo = CMISTest.this.fileFolderService.create(companyHomeNodeRef, folderName, ContentModel.TYPE_FOLDER);
                    CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)folderName));
                    FileInfo fileInfo = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), docName, ContentModel.TYPE_CONTENT);
                    CMISTest.this.nodeService.setProperty(fileInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)docName));
                    CMISTest.this.nodeService.addAspect(fileInfo.getNodeRef(), ContentModel.ASPECT_VERSIONABLE, null);
                    return fileInfo;
                }
            });
            ObjectData objectData = cmisService.getObjectByPath(repositoryId, "/" + folderName + "/" + docName, null, Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(true), null);
            PropertyData<?> pd = this.getPropIsLatestMajorVersion(objectData);
            if (pd != null) {
                Assert.assertTrue((String)"The CMISDictionaryModel.PROP_IS_LATEST_MAJOR_VERSION should be true as major version was created", (boolean)((Boolean)pd.getValues().get(0)));
            }
            this.nodeService.setProperty(fileInfo.getNodeRef(), ContentModel.PROP_TITLE, (Serializable)((Object)docName));
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    ContentWriter writer = CMISTest.this.contentService.getWriter(fileInfo.getNodeRef(), ContentModel.PROP_CONTENT, true);
                    writer.setMimetype("text/plain");
                    writer.putContent("New Version");
                    return null;
                }
            });
            objectData = cmisService.getObjectByPath(repositoryId, "/" + folderName + "/" + docName, null, Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(true), null);
            pd = this.getPropIsLatestMajorVersion(objectData);
            if (pd != null) {
                Assert.assertFalse((String)"The CMISDictionaryModel.PROP_IS_LATEST_MAJOR_VERSION should be false as minor version was created", (boolean)((Boolean)pd.getValues().get(0)));
            }
        }
    }

    private PropertyData<?> getPropIsLatestMajorVersion(ObjectData objectData) {
        List properties = objectData.getProperties().getPropertyList();
        boolean found = false;
        PropertyData propIsLatestMajorVersion = null;
        for (PropertyData property : properties) {
            if (!property.getId().equals("cmis:isLatestMajorVersion")) continue;
            found = true;
            propIsLatestMajorVersion = property;
            break;
        }
        Assert.assertTrue((String)"The PropertyIds.IS_LATEST_MAJOR_VERSION property was not found", (boolean)found);
        if (found) {
            return propIsLatestMajorVersion;
        }
        return null;
    }

    @Test
    public void testCheckIn() {
        String repositoryId = null;
        ObjectData objectData = null;
        Holder objectId = null;
        SimpleCallContext context = new SimpleCallContext("admin", "admin", CmisVersion.CMIS_1_0);
        final String folderName = "testfolder." + GUID.generate();
        final String docName = "testdoc.txt." + GUID.generate();
        final QName testCustomTypeQName = QName.createQName((String)"cmistest.model", (String)"sop");
        final QName authorisedByQname = QName.createQName((String)"cmistest.model", (String)"authorisedBy");
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            FileInfo fileInfo = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

                public FileInfo execute() throws Throwable {
                    NodeRef companyHomeNodeRef = CMISTest.this.repositoryHelper.getCompanyHome();
                    FileInfo folderInfo = CMISTest.this.fileFolderService.create(companyHomeNodeRef, folderName, ContentModel.TYPE_FOLDER);
                    CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)folderName));
                    FileInfo fileInfo = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), docName, testCustomTypeQName);
                    HashMap<QName, String> customProperties = new HashMap<QName, String>();
                    customProperties.put(authorisedByQname, "customPropertyString");
                    customProperties.put(ContentModel.PROP_NAME, docName);
                    CMISTest.this.nodeService.setProperties(fileInfo.getNodeRef(), customProperties);
                    return fileInfo;
                }
            });
            try (CmisService service = this.factory.getService((CallContext)context);){
                List repositories = service.getRepositoryInfos(null);
                Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                repositoryId = repo.getId();
                objectData = service.getObjectByPath(repositoryId, "/" + folderName + "/" + docName, null, Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(true), null);
                objectId = new Holder((Object)objectData.getId());
                service.checkOut(repositoryId, objectId, null, new Holder((Object)true));
            }
            try {
                service = this.factory.getService((CallContext)context);
                PropertyStringImpl prop = new PropertyStringImpl();
                prop.setId("abc:" + authorisedByQname.toPrefixString());
                prop.setValue(null);
                ArrayList<PropertyStringImpl> propsList = new ArrayList<PropertyStringImpl>();
                propsList.add(prop);
                PropertiesImpl properties = new PropertiesImpl(propsList);
                service.checkIn(repositoryId, objectId, Boolean.valueOf(false), (Properties)properties, null, null, null, null, null, null);
            }
            finally {
                service.close();
            }
            Assert.assertTrue((this.nodeService.getProperty(fileInfo.getNodeRef(), authorisedByQname) == null ? 1 : 0) != 0);
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testModelAvailability() throws Exception {
        final WorkflowDeployer testWorkflowDeployer = new WorkflowDeployer();
        testWorkflowDeployer.setTransactionService(this.transactionService);
        testWorkflowDeployer.setWorkflowService(this.workflowService);
        testWorkflowDeployer.setWorkflowAdminService(this.workflowAdminService);
        testWorkflowDeployer.setAuthenticationContext(this.authenticationContext);
        testWorkflowDeployer.setDictionaryDAO(this.dictionaryDAO);
        testWorkflowDeployer.setTenantAdminService(this.tenantAdminService);
        testWorkflowDeployer.setTenantService(this.tenantService);
        testWorkflowDeployer.setNodeService(this.nodeService);
        testWorkflowDeployer.setNamespaceService(this.namespaceService);
        testWorkflowDeployer.setSearchService(this.searchService);
        java.util.Properties props = new java.util.Properties();
        props.setProperty("engineId", "activiti");
        props.setProperty("location", "activiti/testCustomActiviti.bpmn20.xml");
        props.setProperty("mimetype", "text/xml");
        props.setProperty("redeploy", Boolean.FALSE.toString());
        ArrayList<java.util.Properties> definitions = new ArrayList<java.util.Properties>(1);
        definitions.add(props);
        testWorkflowDeployer.setWorkflowDefinitions(definitions);
        ArrayList<String> models = new ArrayList<String>(1);
        models.add("activiti/testWorkflowModel.xml");
        testWorkflowDeployer.setModels(models);
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        txnHelper.setForceWritable(true);
        txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                return AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() {
                        testWorkflowDeployer.init();
                        return null;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
            }
        }, false, true);
        TypeDefinition startTaskTypeDefinition = this.dictionaryService.getType(TEST_START_TASK);
        TypeDefinition workflowTaskTypeDefinition = this.dictionaryService.getType(TEST_WORKFLOW_TASK);
        Assert.assertNotNull((Object)startTaskTypeDefinition);
        Assert.assertNotNull((Object)workflowTaskTypeDefinition);
        Thread.sleep(5000L);
        SimpleCallContext context = new SimpleCallContext("admin", "admin", CmisVersion.CMIS_1_1);
        try (CmisService service = this.factory.getService((CallContext)context);){
            List repositories = service.getRepositoryInfos(null);
            Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
            List container = service.getTypeDescendants(((RepositoryInfo)repositories.get(0)).getId(), null, new BigInteger("-1"), Boolean.valueOf(true), null);
            Assert.assertTrue((String)"Workflow model haven't been loaded", (boolean)container.toString().contains("testwf:startTaskVarScriptAssign"));
        }
    }

    private FileInfo createContent(String folderName, String docName, boolean isRule) {
        return this.createContent(null, folderName, docName, isRule);
    }

    private FileInfo createContent(final FileInfo parentFolder, final String folderName, final String docName, final boolean isRule) {
        FileInfo folderInfo = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

            public FileInfo execute() throws Throwable {
                NodeRef nodeRef = parentFolder != null ? parentFolder.getNodeRef() : CMISTest.this.repositoryHelper.getCompanyHome();
                FileInfo folderInfo = CMISTest.this.fileFolderService.create(nodeRef, folderName, ContentModel.TYPE_FOLDER);
                CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)folderName));
                Assert.assertNotNull((Object)folderInfo);
                if (docName != null) {
                    FileInfo fileInfo = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), docName, ContentModel.TYPE_CONTENT);
                    CMISTest.this.nodeService.setProperty(fileInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)docName));
                    Assert.assertNotNull((Object)fileInfo);
                }
                if (isRule) {
                    Rule rule = CMISTest.this.addRule(true, folderName);
                    Assert.assertNotNull((Object)rule);
                    CMISTest.this.ruleService.saveRule(folderInfo.getNodeRef(), rule);
                    Assert.assertTrue((CMISTest.this.ruleService.getRules(folderInfo.getNodeRef()).size() > 0 ? 1 : 0) != 0);
                }
                return folderInfo;
            }
        });
        return folderInfo;
    }

    private Rule addRule(boolean isAppliedToChildren, String title) {
        HashMap<String, String> conditionProps = new HashMap<String, String>();
        conditionProps.put("value", ".txt");
        HashMap<String, QName> actionProps = new HashMap<String, QName>();
        actionProps.put("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        ArrayList<String> ruleTypes = new ArrayList<String>(1);
        ruleTypes.add("inbound");
        Action action = this.actionService.createAction(title);
        action.setParameterValues(conditionProps);
        ActionCondition actionCondition = this.actionService.createActionCondition("compare-property-value");
        actionCondition.setParameterValues(conditionProps);
        action.addActionCondition(actionCondition);
        Rule rule = new Rule();
        rule.setRuleTypes(ruleTypes);
        rule.setTitle(title);
        rule.setDescription("description");
        rule.applyToChildren(isAppliedToChildren);
        rule.setAction(action);
        return rule;
    }

    private <T> T withCmisService(CmisServiceCallback<T> callback) {
        return this.withCmisService(callback, CmisVersion.CMIS_1_0);
    }

    private <T> T withCmisService(CmisServiceCallback<T> callback, CmisVersion cmisVersion) {
        return this.withCmisService("admin", "admin", callback, cmisVersion);
    }

    private <T> T withCmisService(String username, String password, CmisServiceCallback<T> callback, CmisVersion cmisVersion) {
        try (CmisService cmisService = null;){
            T ret;
            SimpleCallContext context = new SimpleCallContext(username, password, cmisVersion);
            cmisService = this.factory.getService((CallContext)context);
            T t = ret = callback.execute(cmisService);
            return t;
        }
    }

    @Category(value={FrequentlyFailingTests.class})
    @Test
    public void testContentMimeTypeDetection() {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        FileFolderService ffs = serviceRegistry.getFileFolderService();
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        List<RepositoryInfo> repositories = this.withCmisService(new CmisServiceCallback<List<RepositoryInfo>>(){

            @Override
            public List<RepositoryInfo> execute(CmisService cmisService) {
                List repositories = cmisService.getRepositoryInfos(null);
                return repositories;
            }
        });
        Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
        RepositoryInfo repo = repositories.get(0);
        final String repositoryId = repo.getId();
        final PropertiesImpl properties = new PropertiesImpl();
        String objectTypeId = "cmis:document";
        properties.addProperty((PropertyData)new PropertyIdImpl("cmis:objectTypeId", objectTypeId));
        String fileName = "textFile" + GUID.generate();
        properties.addProperty((PropertyData)new PropertyStringImpl("cmis:name", fileName));
        final ContentStreamImpl contentStream = new ContentStreamImpl(fileName, "text/plain", "Simple text plain document");
        String objectId = this.withCmisService(new CmisServiceCallback<String>(){

            @Override
            public String execute(CmisService cmisService) {
                String objectId = cmisService.create(repositoryId, (Properties)properties, CMISTest.this.repositoryHelper.getCompanyHome().getId(), (ContentStream)contentStream, VersioningState.MAJOR, null, null);
                return objectId;
            }
        });
        final Holder objectIdHolder = new Holder((Object)objectId);
        final String path = "/" + fileName;
        final ContentStreamImpl contentStreamHTML = new ContentStreamImpl(null, null, "<html><head><title> Hello </title></head><body><p> Test html</p></body></html></body></html>");
        this.withCmisService(new CmisServiceCallback<Void>(){

            @Override
            public Void execute(CmisService cmisService) {
                cmisService.setContentStream(repositoryId, objectIdHolder, Boolean.valueOf(true), null, (ContentStream)contentStreamHTML, null);
                return null;
            }
        });
        ObjectData objectData = this.withCmisService(new CmisServiceCallback<ObjectData>(){

            @Override
            public ObjectData execute(CmisService cmisService) {
                return cmisService.getObjectByPath(repositoryId, path, null, Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(false), null);
            }
        });
        final String objectId1 = objectData.getId();
        String contentType = this.withCmisService(new CmisServiceCallback<String>(){

            @Override
            public String execute(CmisService cmisService) {
                String contentType = cmisService.getObjectInfo(repositoryId, objectId1).getContentType();
                return contentType;
            }
        });
        Assert.assertEquals((String)"Mimetype is not defined correctly.", (Object)"text/html", (Object)contentType);
        this.checkEncoding(ffs, authenticationComponent, objectData, "UTF-8");
        String mimeType = "text/plain; charset=ISO-8859-1";
        final ContentStreamImpl contentStreamHTML2 = new ContentStreamImpl(null, mimeType, "<html><head><title> Hello </title></head><body><p> Test html</p></body></html></body></html>");
        this.withCmisService(new CmisServiceCallback<Void>(){

            @Override
            public Void execute(CmisService cmisService) {
                Holder latestObjectIdHolder = CMISTest.this.getHolderOfObjectOfLatestVersion(cmisService, repositoryId, (Holder<String>)objectIdHolder);
                cmisService.setContentStream(repositoryId, latestObjectIdHolder, Boolean.valueOf(true), null, (ContentStream)contentStreamHTML2, null);
                return null;
            }
        });
        final ObjectData objectData2 = this.withCmisService(new CmisServiceCallback<ObjectData>(){

            @Override
            public ObjectData execute(CmisService cmisService) {
                ObjectData objectData = cmisService.getObjectByPath(repositoryId, path, null, Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(false), null);
                return objectData;
            }
        });
        contentType = this.withCmisService(new CmisServiceCallback<String>(){

            @Override
            public String execute(CmisService cmisService) {
                String contentType = cmisService.getObjectInfo(repositoryId, objectData2.getId()).getContentType();
                return contentType;
            }
        });
        Assert.assertEquals((String)"Mimetype is not defined correctly.", (Object)"text/plain", (Object)contentType);
        this.checkEncoding(ffs, authenticationComponent, objectData2, "UTF-8");
        mimeType = "text/plain; charset=UTF-8";
        String content = "<html><head><title>aegif Mind Share Leader Generating New Paradigms by aegif corporation</title></head><body><p> Test html</p></body></html></body></html>";
        byte[] buf = null;
        try {
            buf = content.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ByteArrayInputStream input = new ByteArrayInputStream(buf);
        ContentStreamImpl contentStreamHTML3 = new ContentStreamImpl(null, BigInteger.valueOf(buf.length), mimeType, (InputStream)input);
        this.withCmisService(new CmisServiceCallback<Void>((ContentStream)contentStreamHTML3){
            private final /* synthetic */ ContentStream val$contentStreamHTML;
            {
                this.val$contentStreamHTML = contentStream;
            }

            @Override
            public Void execute(CmisService cmisService) {
                Holder latestObjectIdHolder = CMISTest.this.getHolderOfObjectOfLatestVersion(cmisService, repositoryId, (Holder<String>)objectIdHolder);
                cmisService.setContentStream(repositoryId, latestObjectIdHolder, Boolean.valueOf(true), null, this.val$contentStreamHTML, null);
                return null;
            }
        });
        final ObjectData objectData3 = this.withCmisService(new CmisServiceCallback<ObjectData>(){

            @Override
            public ObjectData execute(CmisService cmisService) {
                ObjectData objectData = cmisService.getObjectByPath(repositoryId, path, null, Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(false), null);
                return objectData;
            }
        });
        String contentType2 = this.withCmisService(new CmisServiceCallback<String>(){

            @Override
            public String execute(CmisService cmisService) {
                String contentType = cmisService.getObjectInfo(repositoryId, objectData3.getId()).getContentType();
                return contentType;
            }
        });
        Assert.assertEquals((String)"Mimetype is not defined correctly.", (Object)"text/plain", (Object)contentType2);
        this.checkEncoding(ffs, authenticationComponent, objectData3, "ISO-8859-1");
        ObjectData objectDa = this.withCmisService(new CmisServiceCallback<ObjectData>(){

            @Override
            public ObjectData execute(CmisService cmisService) {
                return cmisService.getObjectByPath(repositoryId, path, null, Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(false), null);
            }
        });
        objectIdHolder.setValue((Object)objectDa.getId());
        this.withCmisService(new CmisServiceCallback<Void>(){

            @Override
            public Void execute(CmisService cmisService) {
                cmisService.checkOut(repositoryId, objectIdHolder, null, new Holder());
                return null;
            }
        });
        String mimeType2 = "text/html; charset=UTF-8";
        final ContentStreamImpl contentStreamHTML4 = new ContentStreamImpl(null, mimeType2, "<html><head><title> Hello </title></head><body><p> Test html</p></body></html></body></html>");
        this.withCmisService(new CmisServiceCallback<Void>(){

            @Override
            public Void execute(CmisService cmisService) {
                cmisService.checkIn(repositoryId, objectIdHolder, Boolean.valueOf(false), null, (ContentStream)contentStreamHTML4, "checkin", null, null, null, null);
                return null;
            }
        });
        final ObjectData objectData4 = this.withCmisService(new CmisServiceCallback<ObjectData>(){

            @Override
            public ObjectData execute(CmisService cmisService) {
                ObjectData objectData = cmisService.getObjectByPath(repositoryId, path, null, Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(false), null);
                return objectData;
            }
        });
        String contentType3 = this.withCmisService(new CmisServiceCallback<String>(){

            @Override
            public String execute(CmisService cmisService) {
                String contentType = cmisService.getObjectInfo(repositoryId, objectData4.getId()).getContentType();
                return contentType;
            }
        });
        Assert.assertEquals((String)"Mimetype is not defined correctly.", (Object)"text/html", (Object)contentType3);
        this.checkEncoding(ffs, authenticationComponent, objectData4, "UTF-8");
    }

    protected void checkEncoding(FileFolderService ffs, AuthenticationComponent authenticationComponent, ObjectData objectData, String expectedEncoding) {
        authenticationComponent.setSystemUserAsCurrentUser();
        try {
            NodeRef doc1NodeRef = this.cmisIdToNodeRef(objectData.getId());
            doc1NodeRef.getId();
            FileInfo fileInfo = ffs.getFileInfo(doc1NodeRef);
            Map properties2 = fileInfo.getProperties();
            ContentDataWithId contentData = (ContentDataWithId)properties2.get(QName.createQName((String)"{http://www.alfresco.org/model/content/1.0}content"));
            String encoding = contentData.getEncoding();
            Assert.assertEquals((Object)expectedEncoding, (Object)encoding);
        }
        finally {
            authenticationComponent.clearCurrentSecurityContext();
        }
    }

    private NodeRef cmisIdToNodeRef(String nodeId) {
        int idx = nodeId.indexOf(";");
        if (idx != -1) {
            nodeId = nodeId.substring(0, idx);
        }
        NodeRef nodeRef = new NodeRef(nodeId);
        return nodeRef;
    }

    private Holder<String> getHolderOfObjectOfLatestVersion(CmisService cmisService, String repositoryId, Holder<String> currentHolder) {
        ObjectData oData = cmisService.getObjectOfLatestVersion(repositoryId, (String)currentHolder.getValue(), null, Boolean.FALSE, null, null, null, null, null, null, null);
        return new Holder((Object)oData.getId());
    }

    @Test
    public void testGetRepositoryInfos() {
        boolean cmisEx = false;
        List<RepositoryInfo> infoDataList = null;
        try {
            infoDataList = this.withCmisService(new CmisServiceCallback<List<RepositoryInfo>>(){

                @Override
                public List<RepositoryInfo> execute(CmisService cmisService) {
                    ExtensionDataImpl result = new ExtensionDataImpl();
                    ArrayList extensions = new ArrayList();
                    result.setExtensions(extensions);
                    return cmisService.getRepositoryInfos((ExtensionsData)result);
                }
            });
        }
        catch (CmisRuntimeException cmisRuntimeException) {
            cmisEx = true;
        }
        Assert.assertNotNull((String)(cmisEx ? "CmisRuntimeException was thrown. Please, take a look on ALF-20389" : "No CMIS repository information was retrieved"), infoDataList);
    }

    @Test
    public void testCancelCheckout() {
        final TestContext testContext = new TestContext();
        final String folderName = "testfolder." + GUID.generate();
        final String docName = "testdoc.txt." + GUID.generate();
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            final FileInfo folderInfo = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

                public FileInfo execute() throws Throwable {
                    NodeRef companyHomeNodeRef = CMISTest.this.repositoryHelper.getCompanyHome();
                    FileInfo folderInfo = CMISTest.this.fileFolderService.create(companyHomeNodeRef, folderName, ContentModel.TYPE_FOLDER);
                    CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)folderName));
                    FileInfo fileInfo = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), docName, ContentModel.TYPE_CONTENT);
                    CMISTest.this.nodeService.setProperty(fileInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)docName));
                    return folderInfo;
                }
            });
            final ObjectData objectData = this.withCmisService(new CmisServiceCallback<ObjectData>(){

                @Override
                public ObjectData execute(CmisService cmisService) {
                    List repositories = cmisService.getRepositoryInfos(null);
                    Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                    RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                    String repositoryId = repo.getId();
                    testContext.setRepositoryId(repositoryId);
                    ObjectData objectData = cmisService.getObjectByPath(repositoryId, "/" + folderName + "/" + docName, null, Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(true), null);
                    testContext.setObjectData(objectData);
                    Holder objectId = new Holder((Object)objectData.getId());
                    testContext.setObjectId((Holder<String>)objectId);
                    cmisService.checkOut(repositoryId, objectId, null, new Holder((Object)true));
                    return objectData;
                }
            });
            this.withCmisService(new CmisServiceCallback<Void>(){

                @Override
                public Void execute(CmisService cmisService) {
                    try {
                        ObjectData originalDoc = cmisService.getObject(testContext.getRepositoryId(), objectData.getId(), null, Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(true), null);
                        AllowableActions allowableActions = originalDoc.getAllowableActions();
                        Assert.assertNotNull((Object)allowableActions);
                        Assert.assertFalse((boolean)allowableActions.getAllowableActions().contains(org.apache.chemistry.opencmis.commons.enums.Action.CAN_DELETE_OBJECT));
                        cmisService.deleteObjectOrCancelCheckOut(testContext.getRepositoryId(), objectData.getId(), Boolean.TRUE, null);
                        Assert.fail();
                    }
                    catch (CmisConstraintException cmisConstraintException) {}
                    return null;
                }
            });
            this.withCmisService(new CmisServiceCallback<Void>(){

                @Override
                public Void execute(CmisService cmisService) {
                    cmisService.deleteObjectOrCancelCheckOut(testContext.getRepositoryId(), (String)testContext.getObjectId().getValue(), Boolean.TRUE, null);
                    return null;
                }
            });
            this.withCmisService(new CmisServiceCallback<Void>(){

                @Override
                public Void execute(CmisService cmisService) {
                    ObjectData originalDoc = cmisService.getObject(testContext.getRepositoryId(), objectData.getId(), null, Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(true), null);
                    Map properties = originalDoc.getProperties().getProperties();
                    PropertyData isVersionSeriesCheckedOutProp = (PropertyData)properties.get("cmis:isVersionSeriesCheckedOut");
                    Assert.assertNotNull((Object)isVersionSeriesCheckedOutProp);
                    Boolean isVersionSeriesCheckedOut = (Boolean)isVersionSeriesCheckedOutProp.getFirstValue();
                    Assert.assertNotNull((Object)isVersionSeriesCheckedOut);
                    Assert.assertEquals((Object)Boolean.FALSE, (Object)isVersionSeriesCheckedOut);
                    return null;
                }
            });
            this.withCmisService(new CmisServiceCallback<Void>(){

                @Override
                public Void execute(CmisService cmisService) {
                    cmisService.deleteObject(testContext.getRepositoryId(), objectData.getId(), Boolean.valueOf(true), null);
                    return null;
                }
            });
            List children = (List)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<FileInfo>>(){

                public List<FileInfo> execute() throws Throwable {
                    List children = CMISTest.this.fileFolderService.list(folderInfo.getNodeRef());
                    return children;
                }
            });
            Assert.assertEquals((long)0L, (long)children.size());
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testDeleteTree() {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        FileInfo parentFolder = null;
        FileInfo childFolder1 = null;
        try {
            String parentFolderName = "parentFolder" + GUID.generate();
            parentFolder = this.createContent(parentFolderName, null, false);
            final NodeRef parentFolderNodeRef = parentFolder.getNodeRef();
            final String parentFolderID = parentFolderNodeRef.getId();
            String childFolder1Name = "childFolder1" + GUID.generate();
            childFolder1 = this.createContent(parentFolder, childFolder1Name, null, false);
            final NodeRef childFolder1NodeRef = childFolder1.getNodeRef();
            String childFolder2Name = "childFolder2" + GUID.generate();
            String docName = "testdoc.txt" + GUID.generate();
            final NodeRef childFolder2NodeRef = this.createContent(childFolder1, childFolder2Name, docName, false).getNodeRef();
            List childFolder2FileList = this.fileFolderService.list(childFolder2NodeRef);
            final NodeRef childFolder2FileNodeRef = ((FileInfo)childFolder2FileList.get(0)).getNodeRef();
            List<RepositoryInfo> repositories = this.withCmisService(new CmisServiceCallback<List<RepositoryInfo>>(){

                @Override
                public List<RepositoryInfo> execute(CmisService cmisService) {
                    List repositories = cmisService.getRepositoryInfos(null);
                    return repositories;
                }
            });
            Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
            RepositoryInfo repo = repositories.get(0);
            final String repositoryId = repo.getId();
            this.withCmisService(new CmisServiceCallback<Void>(){

                @Override
                public Void execute(CmisService cmisService) {
                    FailedToDeleteData failedItems = cmisService.deleteTree(repositoryId, parentFolderID, Boolean.TRUE, UnfileObject.DELETE, Boolean.TRUE, null);
                    Assert.assertEquals((long)failedItems.getIds().size(), (long)0L);
                    NodeRef archiveRootNode = CMISTest.this.nodeArchiveService.getStoreArchiveNode(CMISTest.this.repositoryHelper.getCompanyHome().getStoreRef());
                    NodeRef archivedParentFolderNodeRef = CMISTest.this.nodeArchiveService.getArchivedNode(parentFolderNodeRef);
                    Assert.assertTrue((boolean)CMISTest.this.nodeService.getPrimaryParent(archivedParentFolderNodeRef).getParentRef().equals((Object)archiveRootNode));
                    NodeRef archivedChildFolder1NodeRef = CMISTest.this.nodeArchiveService.getArchivedNode(childFolder1NodeRef);
                    Assert.assertTrue((boolean)CMISTest.this.nodeService.getPrimaryParent(archivedChildFolder1NodeRef).getParentRef().equals((Object)archivedParentFolderNodeRef));
                    Assert.assertFalse((boolean)CMISTest.this.nodeService.getPrimaryParent(archivedChildFolder1NodeRef).getParentRef().equals((Object)archiveRootNode));
                    NodeRef archivedChildFolder2NodeRef = CMISTest.this.nodeArchiveService.getArchivedNode(childFolder2NodeRef);
                    Assert.assertTrue((boolean)CMISTest.this.nodeService.getPrimaryParent(archivedChildFolder2NodeRef).getParentRef().equals((Object)archivedChildFolder1NodeRef));
                    Assert.assertFalse((boolean)CMISTest.this.nodeService.getPrimaryParent(archivedChildFolder2NodeRef).getParentRef().equals((Object)archiveRootNode));
                    NodeRef archivedChildFolder2FileNodeRef = CMISTest.this.nodeArchiveService.getArchivedNode(childFolder2FileNodeRef);
                    Assert.assertTrue((boolean)CMISTest.this.nodeService.getPrimaryParent(archivedChildFolder2FileNodeRef).getParentRef().equals((Object)archivedChildFolder2NodeRef));
                    Assert.assertFalse((boolean)CMISTest.this.nodeService.getPrimaryParent(archivedChildFolder2FileNodeRef).getParentRef().equals((Object)archiveRootNode));
                    return null;
                }
            });
        }
        finally {
            if (parentFolder != null && this.fileFolderService.exists(parentFolder.getNodeRef())) {
                this.fileFolderService.delete(parentFolder.getNodeRef());
            }
            AuthenticationUtil.popAuthentication();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testDeleteFolder() {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        testFolderMap = new HashMap<FileInfo, Boolean>(4);
        try {
            folderName = "testfolder" + GUID.generate();
            docName = "testdoc.txt" + GUID.generate();
            folder = this.createContent(folderName, docName, false);
            testFolderMap.put(folder, Boolean.FALSE);
            folderNameEmpty = "testfolder_empty1" + GUID.generate();
            folderEmpty = this.createContent(folderNameEmpty, null, false);
            testFolderMap.put(folderEmpty, Boolean.TRUE);
            folderNameRule = "testfolde_rule" + GUID.generate();
            docNameRule = "testdoc_rule.txt" + GUID.generate();
            folderWithRule = this.createContent(folderNameRule, docNameRule, true);
            testFolderMap.put(folderWithRule, Boolean.FALSE);
            folderNameEmptyRule = "testfolde_empty_rule1" + GUID.generate();
            folderEmptyWithRule = this.createContent(folderNameEmptyRule, null, true);
            testFolderMap.put(folderEmptyWithRule, Boolean.TRUE);
            this.withCmisService(new CmisServiceCallback<Void>(){

                @Override
                public Void execute(CmisService cmisService) {
                    List repositories = cmisService.getRepositoryInfos(null);
                    RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                    String repositoryId = repo.getId();
                    for (Map.Entry entry : testFolderMap.entrySet()) {
                        ObjectData objectData = cmisService.getObjectByPath(repositoryId, "/" + ((FileInfo)entry.getKey()).getName(), null, Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(true), null);
                        Holder objectId = new Holder((Object)objectData.getId());
                        try {
                            cmisService.deleteObjectOrCancelCheckOut(repositoryId, (String)objectId.getValue(), Boolean.TRUE, null);
                        }
                        catch (CmisConstraintException cmisConstraintException) {
                            Assert.assertTrue(((Boolean)entry.getValue() == false ? 1 : 0) != 0);
                            continue;
                        }
                        Assert.assertTrue((boolean)((Boolean)entry.getValue()));
                    }
                    return null;
                }
            });
        }
        finally {
            ** for (entry : testFolderMap.entrySet())
        }
lbl-1000:
        // 1 sources

        {
            if (!this.fileFolderService.exists(((FileInfo)entry.getKey()).getNodeRef())) continue;
            this.fileFolderService.delete(((FileInfo)entry.getKey()).getNodeRef());
            continue;
        }
lbl32:
        // 1 sources

        AuthenticationUtil.popAuthentication();
    }

    @Test
    public void testOperationsOnReadOnlyLockedNode() {
        final String folderName = "testfolder." + GUID.generate();
        final String docName = "testdoc.txt." + GUID.generate();
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        try {
            final FileInfo fileInfo = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

                public FileInfo execute() throws Throwable {
                    NodeRef companyHomeNodeRef = CMISTest.this.repositoryHelper.getCompanyHome();
                    FileInfo folderInfo = CMISTest.this.fileFolderService.create(companyHomeNodeRef, folderName, ContentModel.TYPE_FOLDER);
                    CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)folderName));
                    FileInfo fileInfo = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), docName, ContentModel.TYPE_CONTENT);
                    CMISTest.this.nodeService.setProperty(fileInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)docName));
                    CMISTest.this.versionService.createVersion(fileInfo.getNodeRef(), new HashMap());
                    CMISTest.this.lockService.lock(fileInfo.getNodeRef(), LockType.READ_ONLY_LOCK, 0, true);
                    return fileInfo;
                }
            });
            this.withCmisService(new CmisServiceCallback<Void>(){

                @Override
                public Void execute(CmisService cmisService) {
                    List repositories = cmisService.getRepositoryInfos(null);
                    Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                    RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                    String repositoryId = repo.getId();
                    ObjectData objectData = cmisService.getObjectByPath(repositoryId, "/" + folderName + "/" + docName, null, Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(true), null);
                    cmisService.getAllVersions(repositoryId, objectData.getId(), fileInfo.getNodeRef().getId(), null, Boolean.valueOf(true), null);
                    return null;
                }
            });
            this.withCmisService(new CmisServiceCallback<Void>(){

                @Override
                public Void execute(CmisService cmisService) {
                    List repositories = cmisService.getRepositoryInfos(null);
                    Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                    RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                    String repositoryId = repo.getId();
                    ObjectData objectData = cmisService.getObjectByPath(repositoryId, "/" + folderName + "/" + docName, null, Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(true), null);
                    String objectId = objectData.getId();
                    try {
                        cmisService.deleteObject(repositoryId, objectId, Boolean.valueOf(true), null);
                        Assert.fail((String)"Locked node should not be deletable.");
                    }
                    catch (CmisUpdateConflictException cmisUpdateConflictException) {}
                    return null;
                }
            });
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testOrderByCreationAndModificationDate() {
        final ArrayList nodes = new ArrayList(10);
        final ArrayList expectedChildrenByCreationDate = new ArrayList(10);
        final ArrayList expectedChildrenByModificationDate = new ArrayList(10);
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    NodeRef companyHomeNodeRef = CMISTest.this.repositoryHelper.getCompanyHome();
                    String folderName = GUID.generate();
                    FileInfo folderInfo = CMISTest.this.fileFolderService.create(companyHomeNodeRef, folderName, ContentModel.TYPE_FOLDER);
                    CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)folderName));
                    Assert.assertNotNull((Object)folderInfo);
                    nodes.add(folderInfo);
                    int i = 0;
                    while (i < 5) {
                        String docName = GUID.generate();
                        FileInfo fileInfo = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), docName, ContentModel.TYPE_CONTENT);
                        Assert.assertNotNull((Object)fileInfo);
                        CMISTest.this.nodeService.setProperty(fileInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)docName));
                        expectedChildrenByCreationDate.add(0, fileInfo);
                        nodes.add(fileInfo);
                        Thread.sleep(400L);
                        ++i;
                    }
                    i = 5;
                    while (i > 0) {
                        FileInfo fileInfo = (FileInfo)nodes.get(i);
                        Assert.assertNotNull((Object)fileInfo);
                        CMISTest.this.nodeService.setProperty(fileInfo.getNodeRef(), ContentModel.PROP_DESCRIPTION, (Serializable)((Object)GUID.generate()));
                        fileInfo = CMISTest.this.fileFolderService.getFileInfo(fileInfo.getNodeRef());
                        Assert.assertNotNull((Object)fileInfo);
                        expectedChildrenByModificationDate.add(0, fileInfo);
                        Thread.sleep(400L);
                        --i;
                    }
                    return null;
                }
            });
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
        this.withCmisService(new CmisServiceCallback<Void>(){

            @Override
            public Void execute(CmisService cmisService) {
                FileInfo expectedChild;
                String actualObjectId;
                PropertyData pObjectId;
                Map properties;
                List repositories = cmisService.getRepositoryInfos(null);
                Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                String repositoryId = repo.getId();
                String folderId = ((FileInfo)nodes.get(0)).getNodeRef().getId();
                String orderBy = "cmis:creationDate DESC";
                ObjectInFolderList children = cmisService.getChildren(repositoryId, folderId, null, orderBy, Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(false), BigInteger.valueOf(Integer.MAX_VALUE), BigInteger.valueOf(0L), null);
                int i = 0;
                for (ObjectInFolderData child : children.getObjects()) {
                    properties = child.getObject().getProperties().getProperties();
                    pObjectId = (PropertyData)properties.get("cmis:versionSeriesId");
                    actualObjectId = (String)pObjectId.getFirstValue();
                    PropertyData pCreationDate = (PropertyData)properties.get("cmis:creationDate");
                    GregorianCalendar actualCreationDate = (GregorianCalendar)pCreationDate.getFirstValue();
                    expectedChild = (FileInfo)expectedChildrenByCreationDate.get(i++);
                    Assert.assertEquals((Object)expectedChild.getNodeRef().toString(), (Object)actualObjectId);
                    Assert.assertEquals((long)expectedChild.getCreatedDate().getTime(), (long)actualCreationDate.getTimeInMillis());
                }
                orderBy = "cmis:lastModificationDate DESC";
                children = cmisService.getChildren(repositoryId, folderId, null, orderBy, Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(false), BigInteger.valueOf(Integer.MAX_VALUE), BigInteger.valueOf(0L), null);
                i = 0;
                for (ObjectInFolderData child : children.getObjects()) {
                    properties = child.getObject().getProperties().getProperties();
                    pObjectId = (PropertyData)properties.get("cmis:versionSeriesId");
                    actualObjectId = (String)pObjectId.getFirstValue();
                    PropertyData pModificationDate = (PropertyData)properties.get("cmis:lastModificationDate");
                    GregorianCalendar actualModificationDate = (GregorianCalendar)pModificationDate.getFirstValue();
                    expectedChild = (FileInfo)expectedChildrenByModificationDate.get(i++);
                    Assert.assertEquals((Object)expectedChild.getNodeRef().toString(), (Object)actualObjectId);
                    Assert.assertEquals((long)expectedChild.getModifiedDate().getTime(), (long)actualModificationDate.getTimeInMillis());
                }
                return null;
            }
        });
    }

    @Test
    public void testSecondaryTypes() {
        final String repositoryId = this.withCmisService(new CmisServiceCallback<String>(){

            @Override
            public String execute(CmisService cmisService) {
                List repositories = cmisService.getRepositoryInfos(null);
                Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                String repositoryId = repo.getId();
                return repositoryId;
            }
        }, CmisVersion.CMIS_1_1);
        String objectId = this.withCmisService(new CmisServiceCallback<String>(){

            @Override
            public String execute(CmisService cmisService) {
                PropertiesImpl properties = new PropertiesImpl();
                String objectTypeId = "cmis:document";
                properties.addProperty((PropertyData)new PropertyIdImpl("cmis:objectTypeId", objectTypeId));
                String fileName = "textFile" + GUID.generate();
                properties.addProperty((PropertyData)new PropertyStringImpl("cmis:name", fileName));
                ContentStreamImpl contentStream = new ContentStreamImpl(fileName, "text/plain", "Simple text plain document");
                String objectId = cmisService.create(repositoryId, (Properties)properties, CMISTest.this.repositoryHelper.getCompanyHome().getId(), (ContentStream)contentStream, VersioningState.MAJOR, null, null);
                return objectId;
            }
        }, CmisVersion.CMIS_1_1);
        final Holder objectIdHolder = new Holder((Object)objectId);
        this.withCmisService(new CmisServiceCallback<Void>(){

            @Override
            public Void execute(CmisService cmisService) {
                PropertiesImpl properties = new PropertiesImpl();
                properties.addProperty((PropertyData)new PropertyStringImpl("cmis:secondaryObjectTypeIds", Arrays.asList("P:cm:indexControl")));
                cmisService.updateProperties(repositoryId, objectIdHolder, null, (Properties)properties, null);
                return null;
            }
        }, CmisVersion.CMIS_1_1);
        Properties currentProperties = this.withCmisService(new CmisServiceCallback<Properties>(){

            @Override
            public Properties execute(CmisService cmisService) {
                Properties properties = cmisService.getProperties(repositoryId, (String)objectIdHolder.getValue(), null, null);
                return properties;
            }
        }, CmisVersion.CMIS_1_1);
        List secondaryTypeIds = ((PropertyData)currentProperties.getProperties().get("cmis:secondaryObjectTypeIds")).getValues();
        Assert.assertTrue((boolean)secondaryTypeIds.contains("P:cm:indexControl"));
        HashSet<String> sysAspectsToAdd = new HashSet<String>(Arrays.asList("P:sys:undeletable", "P:sys:hidden"));
        Assert.assertEquals((long)0L, (long)secondaryTypeIds.stream().filter(sysAspectsToAdd::contains).count());
        Assert.assertTrue((boolean)secondaryTypeIds.contains("P:sys:localized"));
        secondaryTypeIds.remove("P:cm:indexControl");
        secondaryTypeIds.addAll(sysAspectsToAdd);
        final PropertiesImpl newProperties = new PropertiesImpl();
        newProperties.addProperty((PropertyData)new PropertyStringImpl("cmis:secondaryObjectTypeIds", secondaryTypeIds));
        String updatedName = "My_new_name_" + UUID.randomUUID().toString();
        newProperties.replaceProperty((PropertyData)new PropertyStringImpl("cmis:name", updatedName));
        this.withCmisService(new CmisServiceCallback<Void>(){

            @Override
            public Void execute(CmisService cmisService) {
                Holder latestObjectIdHolder = CMISTest.this.getHolderOfObjectOfLatestVersion(cmisService, repositoryId, (Holder<String>)objectIdHolder);
                cmisService.updateProperties(repositoryId, latestObjectIdHolder, null, (Properties)newProperties, null);
                return null;
            }
        }, CmisVersion.CMIS_1_1);
        Properties currentProperties1 = this.withCmisService(new CmisServiceCallback<Properties>(){

            @Override
            public Properties execute(CmisService cmisService) {
                Holder latestObjectIdHolder = CMISTest.this.getHolderOfObjectOfLatestVersion(cmisService, repositoryId, (Holder<String>)objectIdHolder);
                Properties properties = cmisService.getProperties(repositoryId, (String)latestObjectIdHolder.getValue(), null, null);
                return properties;
            }
        }, CmisVersion.CMIS_1_1);
        secondaryTypeIds = ((PropertyData)currentProperties1.getProperties().get("cmis:secondaryObjectTypeIds")).getValues();
        Assert.assertFalse((boolean)secondaryTypeIds.contains("P:cm:indexControl"));
        Assert.assertEquals((Object)updatedName, (Object)((PropertyData)currentProperties1.getProperties().get("cmis:name")).getFirstValue());
        Assert.assertEquals((long)0L, (long)secondaryTypeIds.stream().filter(sysAspectsToAdd::contains).count());
        Assert.assertTrue((boolean)secondaryTypeIds.contains("P:sys:localized"));
    }

    @Test
    public void testIntegerBoudaries() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            try {
                final FileInfo fileInfo = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

                    public FileInfo execute() throws Throwable {
                        NodeRef companyHomeNodeRef = CMISTest.this.repositoryHelper.getCompanyHome();
                        QName testIntTypeQName = QName.createQName((String)"http://testCMISIntegersModel/1.0/", (String)"testintegerstype");
                        String folderName = GUID.generate();
                        FileInfo folderInfo = CMISTest.this.fileFolderService.create(companyHomeNodeRef, folderName, ContentModel.TYPE_FOLDER);
                        CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)folderName));
                        Assert.assertNotNull((Object)folderInfo);
                        String docName = GUID.generate();
                        FileInfo fileInfo = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), docName, testIntTypeQName);
                        Assert.assertNotNull((Object)fileInfo);
                        CMISTest.this.nodeService.setProperty(fileInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)docName));
                        return fileInfo;
                    }
                });
                this.withCmisService(new CmisServiceCallback<Void>(){

                    @Override
                    public Void execute(CmisService cmisService) {
                        BigInteger aValue;
                        List repositories = cmisService.getRepositoryInfos(null);
                        Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                        RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                        String repositoryId = repo.getId();
                        String objectIdStr = fileInfo.getNodeRef().toString();
                        org.apache.chemistry.opencmis.commons.definitions.TypeDefinition typeDef = cmisService.getTypeDefinition(repositoryId, "D:tcim:testintegerstype", null);
                        PropertyIntegerDefinitionImpl intNoBoundsTypeDef = (PropertyIntegerDefinitionImpl)typeDef.getPropertyDefinitions().get("tcim:int");
                        PropertyIntegerDefinitionImpl longNoBoundsTypeDef = (PropertyIntegerDefinitionImpl)typeDef.getPropertyDefinitions().get("tcim:long");
                        PropertyIntegerDefinitionImpl intWithBoundsTypeDef = (PropertyIntegerDefinitionImpl)typeDef.getPropertyDefinitions().get("tcim:intwithbounds");
                        PropertyIntegerDefinitionImpl longWithBoundsTypeDef = (PropertyIntegerDefinitionImpl)typeDef.getPropertyDefinitions().get("tcim:longwithbounds");
                        BigInteger minInteger = BigInteger.valueOf(Integer.MIN_VALUE);
                        BigInteger maxInteger = BigInteger.valueOf(Integer.MAX_VALUE);
                        BigInteger minLong = BigInteger.valueOf(Long.MIN_VALUE);
                        BigInteger maxLong = BigInteger.valueOf(Long.MAX_VALUE);
                        Assert.assertTrue((boolean)intNoBoundsTypeDef.getMinValue().equals(minInteger));
                        Assert.assertTrue((boolean)intNoBoundsTypeDef.getMaxValue().equals(maxInteger));
                        Assert.assertTrue((boolean)longNoBoundsTypeDef.getMinValue().equals(minLong));
                        Assert.assertTrue((boolean)longNoBoundsTypeDef.getMaxValue().equals(maxLong));
                        Assert.assertTrue((boolean)intWithBoundsTypeDef.getMinValue().equals(BigInteger.valueOf(-10L)));
                        Assert.assertTrue((boolean)intWithBoundsTypeDef.getMaxValue().equals(BigInteger.valueOf(10L)));
                        Assert.assertTrue((boolean)longWithBoundsTypeDef.getMinValue().equals(BigInteger.valueOf(-10L)));
                        Assert.assertTrue((boolean)longWithBoundsTypeDef.getMaxValue().equals(BigInteger.valueOf(10L)));
                        try {
                            aValue = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(1L));
                            CMISTest.this.setProperiesToObject(cmisService, repositoryId, objectIdStr, "tcim:long", aValue);
                            Assert.fail();
                        }
                        catch (Exception e) {
                            Assert.assertTrue((boolean)(e instanceof CmisConstraintException));
                        }
                        try {
                            aValue = BigInteger.valueOf(Integer.MAX_VALUE).add(BigInteger.valueOf(1L));
                            CMISTest.this.setProperiesToObject(cmisService, repositoryId, objectIdStr, "tcim:int", aValue);
                            Assert.fail();
                        }
                        catch (Exception e) {
                            Assert.assertTrue((boolean)(e instanceof CmisConstraintException));
                        }
                        try {
                            aValue = BigInteger.valueOf(11L);
                            CMISTest.this.setProperiesToObject(cmisService, repositoryId, objectIdStr, "tcim:intwithbounds", aValue);
                            Assert.fail();
                        }
                        catch (Exception e) {
                            Assert.assertTrue((boolean)(e instanceof CmisConstraintException));
                        }
                        try {
                            aValue = BigInteger.valueOf(11L);
                            CMISTest.this.setProperiesToObject(cmisService, repositoryId, objectIdStr, "tcim:longwithbounds", aValue);
                            Assert.fail();
                        }
                        catch (Exception e) {
                            Assert.assertTrue((boolean)(e instanceof CmisConstraintException));
                        }
                        return null;
                    }
                }, CmisVersion.CMIS_1_0);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                AuthenticationUtil.popAuthentication();
            }
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    private void setProperiesToObject(CmisService cmisService, String repositoryId, String objectIdStr, String propertyStr, BigInteger bigIntValue) throws CmisConstraintException {
        Properties properties = cmisService.getProperties(repositoryId, objectIdStr, null, null);
        PropertyIntegerImpl pd = (PropertyIntegerImpl)properties.getProperties().get(propertyStr);
        pd.setValue((Object)bigIntValue);
        ArrayList<PropertyIntegerImpl> propsList = new ArrayList<PropertyIntegerImpl>();
        propsList.add(pd);
        PropertiesImpl newProps = new PropertiesImpl(propsList);
        cmisService.updateProperties(repositoryId, new Holder((Object)objectIdStr), null, (Properties)newProps, null);
    }

    @Test
    public void testMNT9090() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            try {
                final FileInfo fileInfo = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

                    public FileInfo execute() throws Throwable {
                        NodeRef companyHomeNodeRef = CMISTest.this.repositoryHelper.getCompanyHome();
                        String folderName = GUID.generate();
                        FileInfo folderInfo = CMISTest.this.fileFolderService.create(companyHomeNodeRef, folderName, ContentModel.TYPE_FOLDER);
                        CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)folderName));
                        Assert.assertNotNull((Object)folderInfo);
                        String docName = GUID.generate();
                        FileInfo fileInfo = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), docName, ContentModel.TYPE_CONTENT);
                        Assert.assertNotNull((Object)fileInfo);
                        CMISTest.this.nodeService.setProperty(fileInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)docName));
                        QName ASPECT_AUDIO = QName.createQName((String)"http://www.alfresco.org/model/audio/1.0", (String)"audio");
                        HashMap aspectProperties = new HashMap();
                        CMISTest.this.nodeService.addAspect(fileInfo.getNodeRef(), ASPECT_AUDIO, aspectProperties);
                        return fileInfo;
                    }
                });
                this.withCmisService(new CmisServiceCallback<Void>(){

                    @Override
                    public Void execute(CmisService cmisService) {
                        List repositories = cmisService.getRepositoryInfos(null);
                        Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                        RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                        String repositoryId = repo.getId();
                        String objectIdStr = fileInfo.getNodeRef().toString();
                        Holder objectId = new Holder((Object)objectIdStr);
                        BigInteger value = BigInteger.valueOf(0x80000000L);
                        PropertiesImpl properties = new PropertiesImpl();
                        ArrayList<CmisExtensionElementImpl> extensions = new ArrayList<CmisExtensionElementImpl>();
                        CmisExtensionElementImpl valueElem = new CmisExtensionElementImpl("http://www.alfresco.org", "value", null, ((Object)value).toString());
                        ArrayList<CmisExtensionElementImpl> valueElems = new ArrayList<CmisExtensionElementImpl>();
                        valueElems.add(valueElem);
                        ArrayList<CmisExtensionElementImpl> children = new ArrayList<CmisExtensionElementImpl>();
                        HashMap<String, String> attributes = new HashMap<String, String>();
                        attributes.put("propertyDefinitionId", "audio:trackNumber");
                        children.add(new CmisExtensionElementImpl("http://www.alfresco.org", "propertyInteger", attributes, valueElems));
                        ArrayList<CmisExtensionElementImpl> propertyValuesExtension = new ArrayList<CmisExtensionElementImpl>();
                        propertyValuesExtension.add(new CmisExtensionElementImpl("http://www.alfresco.org", "properties", null, children));
                        CmisExtensionElementImpl setAspectsExtension = new CmisExtensionElementImpl("http://www.alfresco.org", "setAspects", null, propertyValuesExtension);
                        extensions.add(setAspectsExtension);
                        properties.setExtensions(extensions);
                        cmisService.updateProperties(repositoryId, objectId, null, (Properties)properties, null);
                        Assert.fail();
                        return null;
                    }
                }, CmisVersion.CMIS_1_0);
            }
            catch (CmisConstraintException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("Value is out of range for property"));
                AuthenticationUtil.popAuthentication();
            }
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testGetContentChanges() {
        this.setupAudit();
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            this.createContent("testfolder" + GUID.generate(), "testdoc.txt" + GUID.generate(), false);
            this.createContent("testfolder" + GUID.generate(), "testdoc.txt" + GUID.generate(), false);
            this.createContent("testfolder" + GUID.generate(), "testdoc.txt" + GUID.generate(), false);
            Holder changeLogToken = new Holder();
            ObjectList ol = this.cmisConnector.getContentChanges(changeLogToken, new BigInteger("2"));
            Assert.assertEquals((long)2L, (long)ol.getObjects().size());
            Assert.assertEquals((String)"ChangeLogToken should be latest from retrieved entries.", (Object)"2", (Object)changeLogToken.getValue());
            Assert.assertTrue((boolean)ol.hasMoreItems());
            changeLogToken.setValue((Object)Integer.toString(0));
            ol = this.cmisConnector.getContentChanges(changeLogToken, new BigInteger("2"));
            Assert.assertEquals((long)2L, (long)ol.getObjects().size());
            Assert.assertEquals((String)"ChangeLogToken should be latest from retrieved entries.", (Object)"2", (Object)changeLogToken.getValue());
            Assert.assertTrue((boolean)ol.hasMoreItems());
            Long latestToken = (Long)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                public Long execute() throws Exception {
                    return Long.parseLong(CMISTest.this.cmisConnector.getRepositoryInfo(CmisVersion.CMIS_1_1).getLatestChangeLogToken());
                }
            }, true, false);
            Long fromToken = latestToken - 2L;
            changeLogToken.setValue((Object)fromToken.toString());
            ol = this.cmisConnector.getContentChanges(changeLogToken, new BigInteger("20"));
            Assert.assertEquals((long)3L, (long)ol.getObjects().size());
            Assert.assertNotNull((Object)changeLogToken.getValue());
            Assert.assertEquals((String)"ChangeLogToken should be the latest from all entries.", (Object)latestToken.toString(), (Object)changeLogToken.getValue());
            Assert.assertFalse((boolean)ol.hasMoreItems());
        }
        finally {
            this.auditSubsystem.destroy();
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testIsLatestMajorVersion() {
        new TestContext();
        final PropertiesImpl properties = new PropertiesImpl();
        String objectTypeId = "cmis:document";
        properties.addProperty((PropertyData)new PropertyIdImpl("cmis:objectTypeId", objectTypeId));
        String fileName = "textFile" + GUID.generate();
        properties.addProperty((PropertyData)new PropertyStringImpl("cmis:name", fileName));
        final ContentStreamImpl contentStream = new ContentStreamImpl(fileName, "text/plain", "Simple text plain document");
        this.withCmisService(new CmisServiceCallback<String>(){

            @Override
            public String execute(CmisService cmisService) {
                List repositories = cmisService.getRepositoryInfos(null);
                Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                String repositoryId = repo.getId();
                String objectId = cmisService.create(repositoryId, (Properties)properties, CMISTest.this.repositoryHelper.getCompanyHome().getId(), (ContentStream)contentStream, VersioningState.MINOR, null, null);
                ObjectData cmidDoc = cmisService.getObject(repositoryId, objectId, null, Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(false), null);
                List properties2 = cmidDoc.getProperties().getPropertyList();
                boolean found = false;
                PropertyData propIsLatestMajorVersion = null;
                for (PropertyData property : properties2) {
                    if (!property.getId().equals("cmis:isLatestMajorVersion")) continue;
                    found = true;
                    propIsLatestMajorVersion = property;
                    break;
                }
                Assert.assertTrue((String)"The CMISDictionaryModel.PROP_IS_LATEST_MAJOR_VERSION property was not found", (boolean)found);
                if (found) {
                    Assert.assertFalse((String)"The CMISDictionaryModel.PROP_IS_LATEST_MAJOR_VERSION should be false as minor version was created", (boolean)((Boolean)propIsLatestMajorVersion.getValues().get(0)));
                }
                return objectId;
            }
        });
    }

    @Test
    public void testItems() {
        this.withCmisService(new CmisServiceCallback<String>(){

            @Override
            public String execute(CmisService cmisService) {
                List repositories = cmisService.getRepositoryInfos(null);
                Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                String repositoryId = repo.getId();
                org.apache.chemistry.opencmis.commons.definitions.TypeDefinition def = cmisService.getTypeDefinition(repositoryId, "cmis:item", null);
                Assert.assertNotNull((String)"the cmis:item type is not defined", (Object)def);
                cmisService.getTypeDefinition(repositoryId, "I:cm:person", null);
                Assert.assertNotNull((String)"the I:cm:person type is not defined", (Object)def);
                ObjectList result = cmisService.query(repositoryId, "select * from cm:person", Boolean.FALSE, Boolean.TRUE, IncludeRelationships.NONE, "", BigInteger.TEN, BigInteger.ZERO, null);
                Assert.assertTrue((String)"", (result.getNumItems().intValue() > 0 ? 1 : 0) != 0);
                return "";
            }
        }, CmisVersion.CMIS_1_1);
    }

    @Test
    public void testItemRelations() {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        final String FOLDER_NAME = "testItemRelations-FOLDER" + GUID.generate();
        final String DOCUMENT_NAME = "testItemRelations-DOCUMENT" + GUID.generate();
        final String CLIENT_NAME = "Some Test Client " + GUID.generate();
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    NodeRef companyHomeNodeRef = CMISTest.this.repositoryHelper.getCompanyHome();
                    FileInfo folderInfo = CMISTest.this.fileFolderService.create(companyHomeNodeRef, FOLDER_NAME, ContentModel.TYPE_FOLDER);
                    CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)FOLDER_NAME));
                    Assert.assertNotNull((Object)folderInfo);
                    FileInfo document = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), DOCUMENT_NAME, ContentModel.TYPE_CONTENT);
                    Assert.assertNotNull((Object)document);
                    CMISTest.this.nodeService.setProperty(document.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)DOCUMENT_NAME));
                    return null;
                }
            });
            this.withCmisService(new CmisServiceCallback<String>(){

                @Override
                public String execute(CmisService cmisService) {
                    List repositories = cmisService.getRepositoryInfos(null);
                    Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                    RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                    String repositoryId = repo.getId();
                    org.apache.chemistry.opencmis.commons.definitions.TypeDefinition tpdfn = cmisService.getTypeDefinition(repositoryId, "I:sctst:client", null);
                    Assert.assertNotNull((String)"the I:sctst:client type is not defined", (Object)tpdfn);
                    org.apache.chemistry.opencmis.commons.definitions.TypeDefinition aspectDfn = cmisService.getTypeDefinition(repositoryId, "P:sctst:clientRelated", null);
                    Assert.assertNotNull((String)"the P:sctst:clientRelated aspect is not defined", (Object)aspectDfn);
                    org.apache.chemistry.opencmis.commons.definitions.TypeDefinition relDfn = cmisService.getTypeDefinition(repositoryId, "R:sctst:relatedClients", null);
                    Assert.assertNotNull((String)"the R:sctst:relatedClients association is not defined", (Object)relDfn);
                    PropertiesImpl properties = new PropertiesImpl();
                    properties.addProperty((PropertyData)new PropertyIdImpl("cmis:objectTypeId", tpdfn.getId()));
                    properties.addProperty((PropertyData)new PropertyStringImpl("cmis:name", CLIENT_NAME));
                    properties.addProperty((PropertyData)new PropertyStringImpl("sctst:clientId", "id" + GUID.generate()));
                    properties.addProperty((PropertyData)new PropertyStringImpl("sctst:clientName", CLIENT_NAME));
                    ObjectData folderData = cmisService.getObjectByPath(repositoryId, "/" + FOLDER_NAME, null, null, null, null, null, null, null);
                    cmisService.createItem(repositoryId, (Properties)properties, folderData.getId(), null, null, null, null);
                    ObjectData contentData = cmisService.getObjectByPath(repositoryId, "/" + FOLDER_NAME + "/" + DOCUMENT_NAME, null, null, null, null, null, null, null);
                    Properties props = cmisService.getProperties(repositoryId, contentData.getId(), null, null);
                    PropertyData propAspects = (PropertyData)props.getProperties().get("cmis:secondaryObjectTypeIds");
                    List aspects = propAspects.getValues();
                    aspects.add("P:sctst:clientRelated");
                    properties = new PropertiesImpl();
                    properties.addProperty((PropertyData)new PropertyStringImpl("cmis:secondaryObjectTypeIds", aspects));
                    cmisService.updateProperties(repositoryId, new Holder((Object)contentData.getId()), null, (Properties)properties, null);
                    aspects = ((PropertyData)cmisService.getProperties(repositoryId, contentData.getId(), null, null).getProperties().get("cmis:secondaryObjectTypeIds")).getValues();
                    Assert.assertTrue((String)"P:sctst:clientRelated excpected", (boolean)aspects.contains("P:sctst:clientRelated"));
                    ObjectData itemData = cmisService.getObjectByPath(repositoryId, "/" + FOLDER_NAME + "/" + CLIENT_NAME, null, null, null, null, null, null, null);
                    properties = new PropertiesImpl();
                    properties.addProperty((PropertyData)new PropertyIdImpl("cmis:objectTypeId", "R:sctst:relatedClients"));
                    properties.addProperty((PropertyData)new PropertyIdImpl("cmis:sourceId", contentData.getId()));
                    properties.addProperty((PropertyData)new PropertyIdImpl("cmis:targetId", itemData.getId()));
                    cmisService.createRelationship(repositoryId, (Properties)properties, null, null, null, null);
                    return "";
                }
            }, CmisVersion.CMIS_1_1);
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testMNT10529() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            try {
                final Pair folderAndDocument = (Pair)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Pair<FileInfo, FileInfo>>(){

                    public Pair<FileInfo, FileInfo> execute() throws Throwable {
                        NodeRef companyHomeNodeRef = CMISTest.this.repositoryHelper.getCompanyHome();
                        String folderName = GUID.generate();
                        FileInfo folderInfo = CMISTest.this.fileFolderService.create(companyHomeNodeRef, folderName, ContentModel.TYPE_FOLDER);
                        CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)folderName));
                        Assert.assertNotNull((Object)folderInfo);
                        String docName = GUID.generate();
                        FileInfo document = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), docName, ContentModel.TYPE_CONTENT);
                        Assert.assertNotNull((Object)document);
                        CMISTest.this.nodeService.setProperty(document.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)docName));
                        return new Pair((Object)folderInfo, (Object)document);
                    }
                });
                this.withCmisService(new CmisServiceCallback<Void>(){

                    @Override
                    public Void execute(CmisService cmisService) {
                        List repositories = cmisService.getRepositoryInfos(null);
                        Assert.assertNotNull((Object)repositories);
                        Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                        RepositoryInfo repo = (RepositoryInfo)repositories.iterator().next();
                        String repositoryId = repo.getId();
                        String objectIdStr = ((FileInfo)folderAndDocument.getFirst()).getNodeRef().toString();
                        ObjectInFolderList children = cmisService.getChildren(repositoryId, objectIdStr, null, "cmis:name ASC", Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(false), null, null, null);
                        this.assertChildren((Pair<FileInfo, FileInfo>)folderAndDocument, children);
                        children = cmisService.getChildren(repositoryId, objectIdStr, null, "cmis:name ASC, cmis:creationDate ASC", Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(false), null, null, null);
                        this.assertChildren((Pair<FileInfo, FileInfo>)folderAndDocument, children);
                        children = cmisService.getChildren(repositoryId, objectIdStr, null, "    cmis:name ASC", Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(false), null, null, null);
                        this.assertChildren((Pair<FileInfo, FileInfo>)folderAndDocument, children);
                        children = cmisService.getChildren(repositoryId, objectIdStr, null, "    cmis:name ASC, cmis:creationDate ASC   ", Boolean.valueOf(false), IncludeRelationships.NONE, null, Boolean.valueOf(false), null, null, null);
                        this.assertChildren((Pair<FileInfo, FileInfo>)folderAndDocument, children);
                        return null;
                    }

                    private void assertChildren(Pair<FileInfo, FileInfo> folderAndDocument2, ObjectInFolderList children) {
                        Assert.assertNotNull((Object)children);
                        Assert.assertTrue((1L == children.getNumItems().longValue() ? 1 : 0) != 0);
                        PropertyData nameData = (PropertyData)((ObjectInFolderData)children.getObjects().iterator().next()).getObject().getProperties().getProperties().get("cmis:name");
                        Assert.assertNotNull((Object)nameData);
                        Object name = nameData.getValues().iterator().next();
                        Assert.assertEquals((Object)((FileInfo)folderAndDocument2.getSecond()).getName(), name);
                    }
                }, CmisVersion.CMIS_1_0);
            }
            catch (CmisConstraintException e) {
                Assert.fail((String)e.toString());
                AuthenticationUtil.popAuthentication();
            }
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Category(value={RedundantTests.class})
    @Test
    public void mnt10548test() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        final Pair folderAndDocument = (Pair)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Pair<FileInfo, FileInfo>>(){
            private static final String TEST_NAME = "mnt10548test-";

            public Pair<FileInfo, FileInfo> execute() throws Throwable {
                NodeRef companyHomeNodeRef = CMISTest.this.repositoryHelper.getCompanyHome();
                String folderName = TEST_NAME + GUID.generate();
                FileInfo folderInfo = CMISTest.this.fileFolderService.create(companyHomeNodeRef, folderName, ContentModel.TYPE_FOLDER);
                CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)folderName));
                Assert.assertNotNull((Object)folderInfo);
                String docName = TEST_NAME + GUID.generate();
                FileInfo document = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), docName, ContentModel.TYPE_CONTENT);
                Assert.assertNotNull((Object)document);
                CMISTest.this.nodeService.setProperty(document.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)docName));
                NodeRef nodeRef = document.getNodeRef();
                CMISTest.this.taggingService.addTag(nodeRef, "tag1");
                CMISTest.this.taggingService.addTag(nodeRef, "tag2");
                CMISTest.this.taggingService.addTag(nodeRef, "tag3");
                return new Pair((Object)folderInfo, (Object)document);
            }
        });
        ObjectData objData = this.withCmisService(new CmisServiceCallback<ObjectData>(){
            private static final String FILE_FOLDER_SEPARATOR = "/";

            @Override
            public ObjectData execute(CmisService cmisService) {
                List repositories = cmisService.getRepositoryInfos(null);
                Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                String repositoryId = repo.getId();
                String path = FILE_FOLDER_SEPARATOR + ((FileInfo)folderAndDocument.getFirst()).getName() + FILE_FOLDER_SEPARATOR + ((FileInfo)folderAndDocument.getSecond()).getName();
                ObjectData objData = cmisService.getObjectByPath(repositoryId, path, null, Boolean.valueOf(false), null, null, Boolean.valueOf(false), Boolean.valueOf(false), null);
                return objData;
            }
        }, CmisVersion.CMIS_1_1);
        Map cmisProps = objData.getProperties().getProperties();
        String taggable = ContentModel.ASPECT_TAGGABLE.getPrefixedQName((NamespacePrefixResolver)this.namespaceService).toPrefixString();
        PropertyData propData = (PropertyData)cmisProps.get(taggable);
        Assert.assertNotNull((Object)propData);
        List props = propData.getValues();
        Assert.assertTrue((props.size() == 3 ? 1 : 0) != 0);
        for (Object o : props) {
            Assert.assertTrue((String)(o.getClass() + " found but String expected"), (boolean)(o instanceof String));
        }
    }

    @Test
    public void testMNT10021() throws Exception {
        final String folderName = "testfolder." + GUID.generate();
        final String docName = "testdoc.txt." + GUID.generate();
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            try {
                this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Throwable {
                        NodeRef companyHomeNodeRef = CMISTest.this.repositoryHelper.getCompanyHome();
                        FileInfo folderInfo = CMISTest.this.fileFolderService.create(companyHomeNodeRef, folderName, ContentModel.TYPE_FOLDER);
                        CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)folderName));
                        Assert.assertNotNull((Object)folderInfo);
                        FileInfo document = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), docName, ContentModel.TYPE_CONTENT);
                        Assert.assertNotNull((Object)document);
                        CMISTest.this.nodeService.setProperty(document.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)docName));
                        CMISTest.this.lockService.lock(document.getNodeRef(), LockType.READ_ONLY_LOCK, 0, true);
                        return null;
                    }
                });
                ObjectData objectData = this.withCmisService(new CmisServiceCallback<ObjectData>(){

                    @Override
                    public ObjectData execute(CmisService cmisService) {
                        List repositories = cmisService.getRepositoryInfos(null);
                        Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                        RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                        String repositoryId = repo.getId();
                        ObjectData objectData = cmisService.getObjectByPath(repositoryId, "/" + folderName + "/" + docName, null, Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(true), null);
                        return objectData;
                    }
                }, CmisVersion.CMIS_1_0);
                List propertyExtensionList = objectData.getProperties().getExtensions();
                Assert.assertEquals((String)"propertyExtensionList should be singletonList", (long)propertyExtensionList.size(), (long)1L);
                List extensions = ((CmisExtensionElement)propertyExtensionList.iterator().next()).getChildren();
                for (CmisExtensionElement extension : extensions) {
                    if (!"properties".equals(extension.getName())) continue;
                    List propExtensions = extension.getChildren();
                    Assert.assertTrue((String)"cmisObject should contain aspect properties", (propExtensions.size() > 0 ? 1 : 0) != 0);
                    for (CmisExtensionElement prop : propExtensions) {
                        Map cmisAspectProperty = prop.getAttributes();
                        Set cmisAspectPropertyNames = cmisAspectProperty.keySet();
                        Assert.assertTrue((String)"propertyDefinitionId attribute should be present", (boolean)cmisAspectPropertyNames.contains("propertyDefinitionId"));
                        Assert.assertTrue((String)"queryName attribute should be present", (boolean)cmisAspectPropertyNames.contains("queryName"));
                        Assert.assertTrue((String)"displayName attribute should be present for property of test node", (boolean)cmisAspectPropertyNames.contains("displayName"));
                        Assert.assertTrue((String)"localName attribute should be present for property of test node", (boolean)cmisAspectPropertyNames.contains("localName"));
                        Assert.assertEquals((long)cmisAspectPropertyNames.size(), (long)4L);
                        for (String aspectPropertyName : cmisAspectPropertyNames) {
                            String value = (String)cmisAspectProperty.get(aspectPropertyName);
                            Assert.assertTrue((String)("value for " + aspectPropertyName + " should be present"), (value != null && value.length() > 0 ? 1 : 0) != 0);
                        }
                    }
                }
            }
            catch (CmisConstraintException e) {
                Assert.fail((String)e.toString());
                AuthenticationUtil.popAuthentication();
            }
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void dictionaryTest() {
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                M2Model customModel = M2Model.createModel((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("dictionary/dictionarydaotest_model1.xml"));
                CMISTest.this.dictionaryDAO.putModel(customModel);
                Assert.assertNotNull((Object)CMISTest.this.cmisDictionaryService.findType("P:cm:dublincore"));
                TypeDefinitionWrapper td = CMISTest.this.cmisDictionaryService.findType("D:daotest1:type1");
                Assert.assertNotNull((Object)td);
                return null;
            }
        }, (String)"user1", (String)"tenant1");
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                Assert.assertNotNull((Object)CMISTest.this.cmisDictionaryService.findType("P:cm:dublincore"));
                TypeDefinitionWrapper td = CMISTest.this.cmisDictionaryService.findType("D:daotest1:type1");
                Assert.assertNull((Object)td);
                return null;
            }
        }, (String)"user2", (String)"tenant2");
    }

    @Test
    public void testMNT13529() throws Exception {
        this.setupAudit();
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            final Long appId = this.auditSubsystem.getAuditApplicationByName("CMISChangeLog").getApplicationId();
            RetryingTransactionHelper.RetryingTransactionCallback<Void> deletedCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    CMISTest.this.auditDAO.deleteAuditEntries(appId, null, null);
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deletedCallback);
            String initialChangeLogToken = this.withCmisService(new CmisServiceCallback<String>(){

                @Override
                public String execute(CmisService cmisService) {
                    List repositories = cmisService.getRepositoryInfos(null);
                    Assert.assertNotNull((Object)repositories);
                    Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                    RepositoryInfo repo = (RepositoryInfo)repositories.iterator().next();
                    return repo.getLatestChangeLogToken();
                }
            }, CmisVersion.CMIS_1_1);
            Assert.assertNotNull((Object)initialChangeLogToken);
            Assert.assertEquals((Object)"0", (Object)initialChangeLogToken);
        }
        finally {
            this.auditSubsystem.destroy();
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testCMISChangeLogObjectIds() throws Exception {
        this.setupAudit();
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            final String changeToken = this.withCmisService(new CmisServiceCallback<String>(){

                @Override
                public String execute(CmisService cmisService) {
                    List repositories = cmisService.getRepositoryInfos(null);
                    Assert.assertNotNull((Object)repositories);
                    Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                    RepositoryInfo repo = (RepositoryInfo)repositories.iterator().next();
                    return repo.getLatestChangeLogToken();
                }
            }, CmisVersion.CMIS_1_1);
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    NodeRef companyHomeNodeRef = CMISTest.this.repositoryHelper.getCompanyHome();
                    String folder = GUID.generate();
                    FileInfo folderInfo = CMISTest.this.fileFolderService.create(companyHomeNodeRef, folder, ContentModel.TYPE_FOLDER);
                    CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)folder));
                    Assert.assertNotNull((Object)folderInfo);
                    String content = GUID.generate();
                    FileInfo document = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), content, ContentModel.TYPE_CONTENT);
                    Assert.assertNotNull((Object)document);
                    CMISTest.this.nodeService.setProperty(document.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)content));
                    CMISTest.this.permissionService.setPermission(document.getNodeRef(), "SomeAuthority", "ExecuteContent", true);
                    CMISTest.this.fileFolderService.delete(document.getNodeRef());
                    CMISTest.this.fileFolderService.delete(folderInfo.getNodeRef());
                    return null;
                }
            });
            this.withCmisService(new CmisServiceCallback<Void>(){

                @Override
                public Void execute(CmisService cmisService) {
                    List repositories = cmisService.getRepositoryInfos(null);
                    Assert.assertNotNull((Object)repositories);
                    Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                    String repositoryId = ((RepositoryInfo)repositories.iterator().next()).getId();
                    ObjectList changes = cmisService.getContentChanges(repositoryId, new Holder((Object)changeToken), Boolean.TRUE, null, Boolean.FALSE, Boolean.FALSE, BigInteger.valueOf(1000L), null);
                    for (ObjectData od : changes.getObjects()) {
                        ChangeType changeType = od.getChangeEventInfo().getChangeType();
                        Object objectId = ((PropertyData)od.getProperties().getProperties().get("cmis:objectId")).getValues().get(0);
                        Assert.assertFalse((String)("CMISChangeEvent " + changeType + " should store short form of objectId " + objectId), (boolean)objectId.toString().contains(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.toString()));
                    }
                    int expectAtLeast = changes.getObjects().size();
                    changes = cmisService.getContentChanges(repositoryId, new Holder((Object)changeToken), Boolean.TRUE, null, Boolean.FALSE, Boolean.FALSE, null, null);
                    Assert.assertTrue((String)"Expected to still get changes", (changes.getObjects().size() >= expectAtLeast ? 1 : 0) != 0);
                    changes = cmisService.getContentChanges(repositoryId, new Holder((Object)changeToken), Boolean.TRUE, null, Boolean.FALSE, Boolean.FALSE, BigInteger.valueOf(0L), null);
                    Assert.assertTrue((String)"Expected to still get changes", (changes.getObjects().size() >= expectAtLeast ? 1 : 0) != 0);
                    changes = cmisService.getContentChanges(repositoryId, new Holder((Object)changeToken), Boolean.TRUE, null, Boolean.FALSE, Boolean.FALSE, BigInteger.valueOf(1L), null);
                    Assert.assertEquals((String)"Expected to still get changes", (long)changes.getObjects().size(), (long)1L);
                    changes = cmisService.getContentChanges(repositoryId, new Holder((Object)changeToken), Boolean.TRUE, null, Boolean.FALSE, Boolean.FALSE, BigInteger.valueOf(Integer.MAX_VALUE), null);
                    Assert.assertTrue((String)"Expected to still get changes", (changes.getObjects().size() >= expectAtLeast ? 1 : 0) != 0);
                    try {
                        changes = cmisService.getContentChanges(repositoryId, new Holder((Object)changeToken), Boolean.TRUE, null, Boolean.FALSE, Boolean.FALSE, BigInteger.valueOf(-1L), null);
                        Assert.fail((String)"Negative maxItems is expected to fail");
                    }
                    catch (CmisInvalidArgumentException cmisInvalidArgumentException) {}
                    return null;
                }
            }, CmisVersion.CMIS_1_1);
        }
        finally {
            this.auditSubsystem.destroy();
            AuthenticationUtil.popAuthentication();
        }
    }

    private void setupAudit() {
        UserAuditFilter userAuditFilter = new UserAuditFilter();
        userAuditFilter.setUserFilterPattern("System;.*");
        userAuditFilter.afterPropertiesSet();
        AuditComponent auditComponent = (AuditComponent)ctx.getBean("auditComponent");
        auditComponent.setUserAuditFilter(userAuditFilter);
        AuditServiceImpl auditServiceImpl = (AuditServiceImpl)ctx.getBean("auditService");
        auditServiceImpl.setAuditComponent(auditComponent);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> initAudit = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Exception {
                CMISTest.this.auditSubsystem.stop();
                CMISTest.this.auditSubsystem.setProperty("audit.enabled", "true");
                CMISTest.this.auditSubsystem.setProperty("audit.cmischangelog.enabled", "true");
                CMISTest.this.auditSubsystem.start();
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)initAudit, false, true);
    }

    @Test
    public void testMoveRenameWithCMISshouldBeAuditedAsUPDATE() throws Exception {
        this.setupAudit();
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            Assert.assertTrue((String)"Audit is not enabled", (boolean)this.auditSubsystem.isAuditEnabled());
            Assert.assertNotNull((String)"CMIS audit is not enabled", (Object)this.auditSubsystem.getAuditApplicationByName("CMISChangeLog"));
            NodeRef companyHomeNodeRef = this.repositoryHelper.getCompanyHome();
            String folder = GUID.generate();
            FileInfo folderInfo = this.fileFolderService.create(companyHomeNodeRef, folder, ContentModel.TYPE_FOLDER);
            String actualToken = (String)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                public String execute() throws Exception {
                    return CMISTest.this.cmisConnector.getRepositoryInfo(CmisVersion.CMIS_1_1).getLatestChangeLogToken();
                }
            }, true, false);
            String content = GUID.generate();
            FileInfo document = this.fileFolderService.create(folderInfo.getNodeRef(), content, ContentModel.TYPE_CONTENT);
            Assert.assertNotNull((Object)document);
            this.nodeService.setProperty(document.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)content));
            Holder changeLogToken = new Holder();
            changeLogToken.setValue((Object)actualToken);
            ObjectList changeLog = this.cmisConnector.getContentChanges(changeLogToken, new BigInteger("10"));
            List events = changeLog.getObjects();
            int count = events.size();
            Assert.assertEquals((long)3L, (long)count);
            Assert.assertEquals(((PropertyData)((ObjectData)events.get(0)).getProperties().getPropertyList().get(0)).getValues().get(0), (Object)folderInfo.getNodeRef().getId());
            Assert.assertEquals((Object)((ObjectData)events.get(0)).getChangeEventInfo().getChangeType(), (Object)ChangeType.CREATED);
            Assert.assertTrue((boolean)((String)((PropertyData)((ObjectData)events.get(1)).getProperties().getPropertyList().get(0)).getValues().get(0)).contains(document.getNodeRef().getId()));
            Assert.assertEquals((Object)((ObjectData)events.get(1)).getChangeEventInfo().getChangeType(), (Object)ChangeType.CREATED);
            Assert.assertTrue((boolean)((String)((PropertyData)((ObjectData)events.get(2)).getProperties().getPropertyList().get(0)).getValues().get(0)).contains(document.getNodeRef().getId()));
            Assert.assertEquals((Object)((ObjectData)events.get(2)).getChangeEventInfo().getChangeType(), (Object)ChangeType.UPDATED);
            String actualToken2 = (String)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                public String execute() throws Exception {
                    return CMISTest.this.cmisConnector.getRepositoryInfo(CmisVersion.CMIS_1_1).getLatestChangeLogToken();
                }
            }, true, false);
            this.nodeService.setProperty(document.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)(String.valueOf(content) + "-updated")));
            changeLogToken = new Holder();
            changeLogToken.setValue((Object)actualToken2);
            changeLog = this.cmisConnector.getContentChanges(changeLogToken, new BigInteger("10"));
            events = changeLog.getObjects();
            count = events.size();
            Assert.assertEquals((long)2L, (long)count);
            Assert.assertEquals((String)"Rename operation should be shown as an UPDATE in the CMIS change log", (Object)((ObjectData)events.get(1)).getChangeEventInfo().getChangeType(), (Object)ChangeType.UPDATED);
            String targetFolder = GUID.generate();
            FileInfo targetFolderInfo = this.fileFolderService.create(companyHomeNodeRef, targetFolder, ContentModel.TYPE_FOLDER);
            String actualToken3 = (String)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                public String execute() throws Exception {
                    return CMISTest.this.cmisConnector.getRepositoryInfo(CmisVersion.CMIS_1_1).getLatestChangeLogToken();
                }
            }, true, false);
            this.nodeService.moveNode(document.getNodeRef(), targetFolderInfo.getNodeRef(), ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS);
            changeLogToken = new Holder();
            changeLogToken.setValue((Object)actualToken3);
            changeLog = this.cmisConnector.getContentChanges(changeLogToken, new BigInteger("10"));
            events = changeLog.getObjects();
            count = events.size();
            Assert.assertEquals((long)2L, (long)count);
            Assert.assertEquals((String)"Move operation should be shown as an UPDATE in the CMIS change log", (Object)((ObjectData)events.get(1)).getChangeEventInfo().getChangeType(), (Object)ChangeType.UPDATED);
        }
        finally {
            this.auditSubsystem.destroy();
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testDecimalDefaultBoundaries() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            this.withCmisService(new CmisServiceCallback<Void>(){

                @Override
                public Void execute(CmisService cmisService) {
                    List repositories = cmisService.getRepositoryInfos(null);
                    Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                    RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                    String repositoryId = repo.getId();
                    org.apache.chemistry.opencmis.commons.definitions.TypeDefinition decimalTypeDef = cmisService.getTypeDefinition(repositoryId, "D:tcdm:testdecimalstype", null);
                    PropertyDecimalDefinitionImpl floatNoBoundsTypeDef = (PropertyDecimalDefinitionImpl)decimalTypeDef.getPropertyDefinitions().get("tcdm:float");
                    PropertyDecimalDefinitionImpl doubleNoBoundsTypeDef = (PropertyDecimalDefinitionImpl)decimalTypeDef.getPropertyDefinitions().get("tcdm:double");
                    PropertyDecimalDefinitionImpl floatWithBoundsTypeDef = (PropertyDecimalDefinitionImpl)decimalTypeDef.getPropertyDefinitions().get("tcdm:floatwithbounds");
                    PropertyDecimalDefinitionImpl doubleWithBoundsTypeDef = (PropertyDecimalDefinitionImpl)decimalTypeDef.getPropertyDefinitions().get("tcdm:doublewithbounds");
                    Assert.assertNull((Object)floatNoBoundsTypeDef.getMinValue());
                    Assert.assertNull((Object)floatNoBoundsTypeDef.getMaxValue());
                    Assert.assertNull((Object)doubleNoBoundsTypeDef.getMinValue());
                    Assert.assertNull((Object)doubleNoBoundsTypeDef.getMaxValue());
                    Assert.assertTrue((boolean)floatWithBoundsTypeDef.getMinValue().equals(BigDecimal.valueOf(-10.0)));
                    Assert.assertTrue((boolean)floatWithBoundsTypeDef.getMaxValue().equals(BigDecimal.valueOf(10.0)));
                    Assert.assertTrue((boolean)doubleWithBoundsTypeDef.getMinValue().equals(BigDecimal.valueOf(-10.0)));
                    Assert.assertTrue((boolean)doubleWithBoundsTypeDef.getMaxValue().equals(BigDecimal.valueOf(10.0)));
                    return null;
                }
            }, CmisVersion.CMIS_1_1);
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testExtensionDataIsReturnedViaCmis1_1() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        final String FOLDER = "testExtensionDataIsReturnedViaCmis1_1-" + GUID.generate();
        final String CONTENT = String.valueOf(FOLDER) + "-file";
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    FileInfo folderInfo = CMISTest.this.fileFolderService.create(CMISTest.this.repositoryHelper.getCompanyHome(), FOLDER, ContentModel.TYPE_FOLDER);
                    CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)FOLDER));
                    Assert.assertNotNull((Object)folderInfo);
                    FileInfo document = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), CONTENT, ContentModel.TYPE_CONTENT);
                    Assert.assertNotNull((Object)document);
                    CMISTest.this.nodeService.setProperty(document.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)CONTENT));
                    HashMap<QName, Double> props = new HashMap<QName, Double>();
                    props.put(ContentModel.PROP_LATITUDE, 1.0);
                    props.put(ContentModel.PROP_LONGITUDE, 1.0);
                    CMISTest.this.nodeService.addAspect(document.getNodeRef(), ContentModel.ASPECT_GEOGRAPHIC, props);
                    return null;
                }
            });
            ObjectData objectData = this.withCmisService(new CmisServiceCallback<ObjectData>(){

                @Override
                public ObjectData execute(CmisService cmisService) {
                    List repositories = cmisService.getRepositoryInfos(null);
                    Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                    RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                    String repositoryId = repo.getId();
                    ObjectData objectData = cmisService.getObjectByPath(repositoryId, "/" + FOLDER + "/" + CONTENT, null, Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(true), null);
                    return objectData;
                }
            }, CmisVersion.CMIS_1_1);
            List extensions = ((CmisExtensionElement)objectData.getProperties().getExtensions().iterator().next()).getChildren();
            HashSet<String> appliedAspects = new HashSet<String>();
            HashSet<String> aspectProperties = new HashSet<String>();
            for (CmisExtensionElement extension : extensions) {
                if ("properties".equals(extension.getName())) {
                    List propExtensions = extension.getChildren();
                    Assert.assertTrue((String)"cmisObject should contain aspect properties", (propExtensions.size() > 0 ? 1 : 0) != 0);
                    for (CmisExtensionElement prop : propExtensions) {
                        Map cmisAspectProperty = prop.getAttributes();
                        Set cmisAspectPropertyNames = cmisAspectProperty.keySet();
                        Assert.assertTrue((String)"propertyDefinitionId attribute should be present", (boolean)cmisAspectPropertyNames.contains("propertyDefinitionId"));
                        aspectProperties.add((String)cmisAspectProperty.get("propertyDefinitionId"));
                    }
                    continue;
                }
                if (!"appliedAspects".equals(extension.getName())) continue;
                appliedAspects.add(extension.getValue());
            }
            Assert.assertTrue((String)("Extensions should contain " + ContentModel.ASPECT_GEOGRAPHIC), (boolean)appliedAspects.contains("P:cm:geographic"));
            Assert.assertTrue((String)("Extensions should contain " + ContentModel.PROP_LATITUDE), (boolean)aspectProperties.contains("cm:latitude"));
            Assert.assertTrue((String)("Extensions should contain " + ContentModel.PROP_LONGITUDE), (boolean)aspectProperties.contains("cm:longitude"));
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testRemoveACL() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        String groupName = "group" + GUID.generate();
        String testGroup = "GROUP_" + groupName;
        try {
            try {
                if (!this.authorityService.authorityExists(testGroup)) {
                    this.authorityService.createAuthority(AuthorityType.GROUP, groupName);
                }
                final FileInfo document = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

                    public FileInfo execute() throws Throwable {
                        NodeRef companyHomeNodeRef = CMISTest.this.repositoryHelper.getCompanyHome();
                        String folderName = GUID.generate();
                        FileInfo folderInfo = CMISTest.this.fileFolderService.create(companyHomeNodeRef, folderName, ContentModel.TYPE_FOLDER);
                        CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)folderName));
                        Assert.assertNotNull((Object)folderInfo);
                        String docName = GUID.generate();
                        FileInfo document = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), docName, ContentModel.TYPE_CONTENT);
                        Assert.assertNotNull((Object)document);
                        CMISTest.this.nodeService.setProperty(document.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)docName));
                        return document;
                    }
                });
                Set permissions = this.permissionService.getAllSetPermissions(document.getNodeRef());
                Assert.assertEquals((long)permissions.size(), (long)1L);
                AccessPermission current = (AccessPermission)permissions.iterator().next();
                Assert.assertEquals((Object)current.getAuthority(), (Object)"GROUP_EVERYONE");
                Assert.assertEquals((Object)current.getPermission(), (Object)"Consumer");
                this.permissionService.setPermission(document.getNodeRef(), testGroup, "Coordinator", true);
                permissions = this.permissionService.getAllSetPermissions(document.getNodeRef());
                HashMap<String, String> docPermissions = new HashMap<String, String>();
                for (AccessPermission permission : permissions) {
                    docPermissions.put(permission.getAuthority(), permission.getPermission());
                }
                Assert.assertTrue((boolean)docPermissions.keySet().contains(testGroup));
                Assert.assertEquals(docPermissions.get(testGroup), (Object)"Coordinator");
                this.withCmisService(new CmisServiceCallback<Void>(){

                    @Override
                    public Void execute(CmisService cmisService) {
                        List repositories = cmisService.getRepositoryInfos(null);
                        Assert.assertNotNull((Object)repositories);
                        Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                        RepositoryInfo repo = (RepositoryInfo)repositories.iterator().next();
                        String repositoryId = repo.getId();
                        String docIdStr = document.getNodeRef().toString();
                        AccessControlListImpl acesToPut = new AccessControlListImpl();
                        List acesList = Collections.emptyList();
                        acesToPut.setAces(acesList);
                        cmisService.applyAcl(repositoryId, docIdStr, (Acl)acesToPut, AclPropagation.REPOSITORYDETERMINED);
                        return null;
                    }
                }, CmisVersion.CMIS_1_1);
                permissions = this.permissionService.getAllSetPermissions(document.getNodeRef());
                docPermissions = new HashMap();
                for (AccessPermission permission : permissions) {
                    docPermissions.put(permission.getAuthority(), permission.getPermission());
                }
                Assert.assertFalse((boolean)docPermissions.keySet().contains(testGroup));
                Assert.assertEquals((long)permissions.size(), (long)1L);
                current = (AccessPermission)permissions.iterator().next();
                Assert.assertEquals((Object)current.getAuthority(), (Object)"GROUP_EVERYONE");
                Assert.assertEquals((Object)current.getPermission(), (Object)"Consumer");
            }
            catch (CmisConstraintException e) {
                Assert.fail((String)e.toString());
                if (this.authorityService.authorityExists(testGroup)) {
                    this.authorityService.deleteAuthority(testGroup);
                }
                AuthenticationUtil.popAuthentication();
            }
        }
        finally {
            if (this.authorityService.authorityExists(testGroup)) {
                this.authorityService.deleteAuthority(testGroup);
            }
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testACE2904() {
        final String[] types = new String[]{"cmis:document", "cmis:relationship", "cmis:folder", "cmis:policy", "cmis:item", "R:cm:replaces", "P:cm:author", "I:cm:cmobject"};
        final String[] displayNames = new String[]{"Document", "Relationship", "Folder", "Policy", "Item Type", "Replaces", "Author", "Object"};
        final String[] descriptions = new String[]{"Document Type", "Relationship Type", "Folder Type", "Policy Type", "CMIS Item", "Replaces", "Author", "I:cm:cmobject"};
        CmisServiceCallback<String> callback = new CmisServiceCallback<String>(){

            @Override
            public String execute(CmisService cmisService) {
                List repositories = cmisService.getRepositoryInfos(null);
                Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                String repositoryId = repo.getId();
                int i = 0;
                while (i < types.length) {
                    org.apache.chemistry.opencmis.commons.definitions.TypeDefinition def = cmisService.getTypeDefinition(repositoryId, types[i], null);
                    Assert.assertNotNull((String)("The " + types[i] + " type is not defined"), (Object)def);
                    Assert.assertNotNull((String)"The display name is incorrect. Please, refer to ACE-2904.", (Object)def.getDisplayName());
                    Assert.assertEquals((String)"The display name is incorrect. Please, refer to ACE-2904.", (Object)def.getDisplayName(), (Object)displayNames[i]);
                    Assert.assertEquals((String)"The description is incorrect. Please, refer to ACE-2904.", (Object)def.getDescription(), (Object)descriptions[i]);
                    for (PropertyDefinition property : def.getPropertyDefinitions().values()) {
                        Assert.assertNotNull((String)"Property definition dispaly name is incorrect. Please, refer to ACE-2904.", (Object)property.getDisplayName());
                        Assert.assertNotNull((String)"Property definition description is incorrect. Please, refer to ACE-2904.", (Object)property.getDescription());
                    }
                    ++i;
                }
                return "";
            }
        };
        this.withCmisService(callback, CmisVersion.CMIS_1_1);
        this.withCmisService(callback, CmisVersion.CMIS_1_0);
    }

    @Test
    public void testACE3322() {
        final String[] types = new String[]{"cmis:document", "cmis:relationship", "cmis:folder", "cmis:item"};
        CmisServiceCallback<String> callback = new CmisServiceCallback<String>(){

            @Override
            public String execute(CmisService cmisService) {
                int i = 0;
                while (i < types.length) {
                    List baseTypes = CMISTest.this.cmisDictionaryService.getBaseTypes();
                    Assert.assertNotNull((Object)baseTypes);
                    this.checkDefs(baseTypes);
                    List children = CMISTest.this.cmisDictionaryService.getChildren(types[i]);
                    Assert.assertNotNull((Object)children);
                    this.checkDefs(children);
                    ++i;
                }
                return "";
            }

            private void checkDefs(List<TypeDefinitionWrapper> defs) {
                for (TypeDefinitionWrapper def : defs) {
                    Assert.assertNotNull((String)"Type definition was not updated. Please refer to ACE-3322", (Object)def.getTypeDefinition(false).getDisplayName());
                    Assert.assertNotNull((String)"Type definition was not updated. Please refer to ACE-3322", (Object)def.getTypeDefinition(false).getDescription());
                    for (PropertyDefinitionWrapper property : def.getProperties()) {
                        Assert.assertNotNull((String)"Display name is null", (Object)property.getPropertyDefinition().getDisplayName());
                        Assert.assertNotNull((String)"Description is null", (Object)property.getPropertyDefinition().getDescription());
                    }
                }
            }
        };
        this.withCmisService(callback, CmisVersion.CMIS_1_1);
    }

    @Test
    public void testSetDeleteAppendContentStreamVersioning() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        final String DOC1 = "documentProperties1-" + GUID.generate();
        try {
            final FileInfo doc = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

                public FileInfo execute() throws Throwable {
                    FileInfo document = CMISTest.this.fileFolderService.create(CMISTest.this.repositoryHelper.getCompanyHome(), DOC1, ContentModel.TYPE_CONTENT);
                    CMISTest.this.nodeService.setProperty(document.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)DOC1));
                    HashMap<QName, Object> props = new HashMap<QName, Object>();
                    props.put(ContentModel.PROP_TITLE, "Initial Title");
                    props.put(ContentModel.PROP_DESCRIPTION, "Initial Description");
                    CMISTest.this.nodeService.addAspect(document.getNodeRef(), ContentModel.ASPECT_TITLED, props);
                    props = new HashMap();
                    props.put(ContentModel.PROP_INITIAL_VERSION, true);
                    props.put(ContentModel.PROP_AUTO_VERSION, true);
                    props.put(ContentModel.PROP_AUTO_VERSION_PROPS, true);
                    CMISTest.this.versionService.ensureVersioningEnabled(document.getNodeRef(), props);
                    return document;
                }
            });
            this.withCmisService(new CmisServiceCallback<Void>(){

                @Override
                public Void execute(CmisService cmisService) {
                    String documentNodeRefId = doc.getNodeRef().toString();
                    String repositoryId = ((RepositoryInfo)cmisService.getRepositoryInfos(null).get(0)).getId();
                    ObjectInfo objInfoInitialVersion = cmisService.getObjectInfo(repositoryId, documentNodeRefId);
                    Assert.assertTrue((String)"We had just created the document - it should be version 1.0", (boolean)objInfoInitialVersion.getId().endsWith("1.0"));
                    ContentStreamImpl contentStream = new ContentStreamImpl(null, "text/plain", "Content " + GUID.generate());
                    Holder objectIdHolder = new Holder((Object)documentNodeRefId);
                    cmisService.setContentStream(repositoryId, objectIdHolder, Boolean.valueOf(true), null, (ContentStream)contentStream, null);
                    Assert.assertTrue((String)"The \"output\" parameter should returns the newly created version id: 1.1", (boolean)((String)objectIdHolder.getValue()).endsWith("1.1"));
                    ObjectInfo objInfoAfterSetContentStream = cmisService.getObjectInfo(repositoryId, (String)objectIdHolder.getValue());
                    Assert.assertTrue((String)"The object info should reflect the version requested: 1.1", (boolean)objInfoAfterSetContentStream.getId().endsWith("1.1"));
                    cmisService.deleteContentStream(repositoryId, objectIdHolder, null, null);
                    Assert.assertTrue((String)"The \"output\" parameter should returns the newly created version id: 1.2", (boolean)((String)objectIdHolder.getValue()).endsWith("1.2"));
                    objInfoAfterSetContentStream = cmisService.getObjectInfo(repositoryId, (String)objectIdHolder.getValue());
                    Assert.assertTrue((String)"The object info should reflect the version requested: 1.2", (boolean)objInfoAfterSetContentStream.getId().endsWith("1.2"));
                    cmisService.appendContentStream(repositoryId, objectIdHolder, null, (ContentStream)contentStream, true, null);
                    Assert.assertTrue((String)"The \"output\" parameter should returns the newly created version id: 1.3", (boolean)((String)objectIdHolder.getValue()).endsWith("1.3"));
                    objInfoAfterSetContentStream = cmisService.getObjectInfo(repositoryId, (String)objectIdHolder.getValue());
                    Assert.assertTrue((String)"The object info should reflect the version requested: 1.3", (boolean)objInfoAfterSetContentStream.getId().endsWith("1.3"));
                    return null;
                }
            }, CmisVersion.CMIS_1_1);
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testUpdatePropertiesSetDeleteContentVersioning() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        final String FOLDER = "testUpdatePropertiesSetDeleteContentVersioning-" + GUID.generate();
        final String DOC1 = "documentProperties1-" + GUID.generate();
        final String DOC2 = "documentProperties2-" + GUID.generate();
        final String DOC3 = "documentProperties3-" + GUID.generate();
        final String DOC4 = "documentProperties4-" + GUID.generate();
        try {
            final List docs = (List)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<FileInfo>>(){

                public List<FileInfo> execute() throws Throwable {
                    FileInfo folderInfo = CMISTest.this.fileFolderService.create(CMISTest.this.repositoryHelper.getCompanyHome(), FOLDER, ContentModel.TYPE_FOLDER);
                    CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)FOLDER));
                    Assert.assertNotNull((Object)folderInfo);
                    ArrayList<FileInfo> docs = new ArrayList<FileInfo>();
                    FileInfo document = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), DOC1, ContentModel.TYPE_CONTENT);
                    CMISTest.this.nodeService.setProperty(document.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)DOC1));
                    docs.add(document);
                    document = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), DOC2, ContentModel.TYPE_CONTENT);
                    CMISTest.this.nodeService.setProperty(document.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)DOC2));
                    docs.add(document);
                    document = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), DOC3, ContentModel.TYPE_CONTENT);
                    CMISTest.this.nodeService.setProperty(document.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)DOC3));
                    docs.add(document);
                    document = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), DOC4, ContentModel.TYPE_CONTENT);
                    CMISTest.this.nodeService.setProperty(document.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)DOC4));
                    docs.add(document);
                    HashMap<QName, Object> props = new HashMap<QName, Object>();
                    props.put(ContentModel.PROP_TITLE, "Initial Title");
                    props.put(ContentModel.PROP_DESCRIPTION, "Initial Description");
                    for (FileInfo fileInfo : docs) {
                        CMISTest.this.nodeService.addAspect(fileInfo.getNodeRef(), ContentModel.ASPECT_TITLED, props);
                    }
                    props = new HashMap();
                    props.put(ContentModel.PROP_INITIAL_VERSION, true);
                    props.put(ContentModel.PROP_AUTO_VERSION, false);
                    props.put(ContentModel.PROP_AUTO_VERSION_PROPS, false);
                    CMISTest.this.versionService.ensureVersioningEnabled(((FileInfo)docs.get(0)).getNodeRef(), props);
                    props.put(ContentModel.PROP_AUTO_VERSION, false);
                    props.put(ContentModel.PROP_AUTO_VERSION_PROPS, true);
                    CMISTest.this.versionService.ensureVersioningEnabled(((FileInfo)docs.get(1)).getNodeRef(), props);
                    props.put(ContentModel.PROP_AUTO_VERSION, true);
                    props.put(ContentModel.PROP_AUTO_VERSION_PROPS, false);
                    CMISTest.this.versionService.ensureVersioningEnabled(((FileInfo)docs.get(2)).getNodeRef(), props);
                    props.put(ContentModel.PROP_AUTO_VERSION, true);
                    props.put(ContentModel.PROP_AUTO_VERSION_PROPS, true);
                    CMISTest.this.versionService.ensureVersioningEnabled(((FileInfo)docs.get(3)).getNodeRef(), props);
                    return docs;
                }
            });
            this.assertVersions(((FileInfo)docs.get(0)).getNodeRef(), "1.0", VersionType.MAJOR);
            this.assertVersions(((FileInfo)docs.get(1)).getNodeRef(), "1.0", VersionType.MAJOR);
            this.assertVersions(((FileInfo)docs.get(2)).getNodeRef(), "1.0", VersionType.MAJOR);
            this.assertVersions(((FileInfo)docs.get(3)).getNodeRef(), "1.0", VersionType.MAJOR);
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<Void>>(){

                public List<Void> execute() throws Throwable {
                    for (FileInfo fileInfo : docs) {
                        Map props = CMISTest.this.nodeService.getProperties(fileInfo.getNodeRef());
                        props.put(ContentModel.PROP_DESCRIPTION, "description-" + GUID.generate());
                        props.put(ContentModel.PROP_TITLE, "title-" + GUID.generate());
                        CMISTest.this.nodeService.setProperties(fileInfo.getNodeRef(), props);
                    }
                    return null;
                }
            });
            this.assertVersions(((FileInfo)docs.get(0)).getNodeRef(), "1.0", VersionType.MAJOR);
            this.assertVersions(((FileInfo)docs.get(1)).getNodeRef(), "1.1", VersionType.MINOR);
            this.assertVersions(((FileInfo)docs.get(2)).getNodeRef(), "1.0", VersionType.MAJOR);
            this.assertVersions(((FileInfo)docs.get(3)).getNodeRef(), "1.1", VersionType.MINOR);
            final String repositoryId = this.withCmisService(new CmisServiceCallback<String>(){

                @Override
                public String execute(CmisService cmisService) {
                    String repositoryId = ((RepositoryInfo)cmisService.getRepositoryInfos(null).get(0)).getId();
                    for (FileInfo fileInfo : docs) {
                        PropertiesImpl properties = new PropertiesImpl();
                        properties.addProperty((PropertyData)new PropertyStringImpl("cmis:description", "description-" + GUID.generate()));
                        cmisService.updateProperties(repositoryId, new Holder((Object)fileInfo.getNodeRef().toString()), null, (Properties)properties, null);
                    }
                    PropertiesImpl properties = new PropertiesImpl();
                    properties.addProperty((PropertyData)new PropertyStringImpl("cmis:secondaryObjectTypeIds", "P:cm:lockable"));
                    Set existingAspects = CMISTest.this.nodeService.getAspects(((FileInfo)docs.get(0)).getNodeRef());
                    cmisService.updateProperties(repositoryId, new Holder((Object)((FileInfo)docs.get(0)).getNodeRef().toString()), null, (Properties)properties, null);
                    Set updatedAspects = CMISTest.this.nodeService.getAspects(((FileInfo)docs.get(0)).getNodeRef());
                    updatedAspects.removeAll(existingAspects);
                    Assert.assertEquals((Object)ContentModel.ASPECT_LOCKABLE, updatedAspects.iterator().next());
                    return repositoryId;
                }
            }, CmisVersion.CMIS_1_1);
            this.assertVersions(((FileInfo)docs.get(0)).getNodeRef(), "1.0", VersionType.MAJOR);
            this.assertVersions(((FileInfo)docs.get(1)).getNodeRef(), "1.2", VersionType.MINOR);
            this.assertVersions(((FileInfo)docs.get(2)).getNodeRef(), "1.0", VersionType.MAJOR);
            this.assertVersions(((FileInfo)docs.get(3)).getNodeRef(), "1.2", VersionType.MINOR);
            this.withCmisService(new CmisServiceCallback<Void>(){

                @Override
                public Void execute(CmisService cmisService) {
                    for (FileInfo fileInfo : docs) {
                        ContentStreamImpl contentStream = new ContentStreamImpl(null, "text/plain", "Content " + GUID.generate());
                        cmisService.setContentStream(repositoryId, new Holder((Object)fileInfo.getNodeRef().toString()), Boolean.valueOf(true), null, (ContentStream)contentStream, null);
                    }
                    return null;
                }
            }, CmisVersion.CMIS_1_1);
            this.assertVersions(((FileInfo)docs.get(0)).getNodeRef(), "1.0", VersionType.MAJOR);
            this.assertVersions(((FileInfo)docs.get(1)).getNodeRef(), "1.2", VersionType.MINOR);
            this.assertVersions(((FileInfo)docs.get(2)).getNodeRef(), "1.1", VersionType.MINOR);
            this.assertVersions(((FileInfo)docs.get(3)).getNodeRef(), "1.3", VersionType.MINOR);
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<Void>>(){

                public List<Void> execute() throws Throwable {
                    for (FileInfo fileInfo : docs) {
                        ContentWriter writer = CMISTest.this.contentService.getWriter(fileInfo.getNodeRef(), ContentModel.PROP_CONTENT, true);
                        writer.putContent("Content " + GUID.generate());
                    }
                    return null;
                }
            });
            this.assertVersions(((FileInfo)docs.get(0)).getNodeRef(), "1.0", VersionType.MAJOR);
            this.assertVersions(((FileInfo)docs.get(1)).getNodeRef(), "1.2", VersionType.MINOR);
            this.assertVersions(((FileInfo)docs.get(2)).getNodeRef(), "1.2", VersionType.MINOR);
            this.assertVersions(((FileInfo)docs.get(3)).getNodeRef(), "1.4", VersionType.MINOR);
            this.withCmisService(new CmisServiceCallback<Void>(){

                @Override
                public Void execute(CmisService cmisService) {
                    for (FileInfo fileInfo : docs) {
                        cmisService.deleteContentStream(repositoryId, new Holder((Object)fileInfo.getNodeRef().toString()), null, null);
                    }
                    return null;
                }
            }, CmisVersion.CMIS_1_1);
            this.assertVersions(((FileInfo)docs.get(0)).getNodeRef(), "1.0", VersionType.MAJOR);
            this.assertVersions(((FileInfo)docs.get(1)).getNodeRef(), "1.2", VersionType.MINOR);
            this.assertVersions(((FileInfo)docs.get(2)).getNodeRef(), "1.3", VersionType.MINOR);
            this.assertVersions(((FileInfo)docs.get(3)).getNodeRef(), "1.5", VersionType.MINOR);
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    private void assertVersions(final NodeRef nodeRef, final String expectedVersionLabel, final VersionType expectedVersionType) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<Void>>(){

            public List<Void> execute() throws Throwable {
                Assert.assertTrue((String)"Node should be versionable", (boolean)CMISTest.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE));
                Version version = CMISTest.this.versionService.getCurrentVersion(nodeRef);
                Assert.assertNotNull((Object)version);
                Assert.assertEquals((Object)expectedVersionLabel, (Object)version.getVersionLabel());
                Assert.assertEquals((Object)expectedVersionType, (Object)version.getVersionType());
                return null;
            }
        });
        this.withCmisService(new CmisServiceCallback<Void>(){

            @Override
            public Void execute(CmisService cmisService) {
                String repositoryId = ((RepositoryInfo)cmisService.getRepositoryInfos(null).get(0)).getId();
                ObjectData data = cmisService.getObjectOfLatestVersion(repositoryId, nodeRef.toString(), null, Boolean.FALSE, null, null, null, null, null, null, null);
                Assert.assertNotNull((Object)data);
                PropertyData prop = (PropertyData)data.getProperties().getProperties().get("cmis:versionLabel");
                Object versionLabelCmisValue = prop.getValues().get(0);
                Assert.assertEquals((Object)expectedVersionLabel, versionLabelCmisValue);
                return null;
            }
        }, CmisVersion.CMIS_1_1);
    }

    @Test
    public void testLastVersionOfVersionSeries() {
        SimpleCallContext context = new SimpleCallContext("admin", "admin", CmisVersion.CMIS_1_0);
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        final String FOLDER = "testUpdatePropertiesSetDeleteContentVersioning-" + GUID.generate();
        final String DOC = "documentProperties-" + GUID.generate();
        try {
            final NodeRef nodeRef = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                public NodeRef execute() throws Throwable {
                    FileInfo folderInfo = CMISTest.this.fileFolderService.create(CMISTest.this.repositoryHelper.getCompanyHome(), FOLDER, ContentModel.TYPE_FOLDER);
                    CMISTest.this.nodeService.setProperty(folderInfo.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)FOLDER));
                    Assert.assertNotNull((Object)folderInfo);
                    FileInfo document = CMISTest.this.fileFolderService.create(folderInfo.getNodeRef(), DOC, ContentModel.TYPE_CONTENT);
                    CMISTest.this.nodeService.setProperty(document.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)DOC));
                    CMISTest.this.nodeService.setProperty(document.getNodeRef(), ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"Initial doc"));
                    return document.getNodeRef();
                }
            });
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    Assert.assertNull((Object)CMISTest.this.versionService.getVersionHistory(nodeRef));
                    HashMap<QName, Boolean> props = new HashMap<QName, Boolean>();
                    props.put(ContentModel.PROP_INITIAL_VERSION, false);
                    props.put(ContentModel.PROP_AUTO_VERSION, false);
                    props.put(ContentModel.PROP_AUTO_VERSION_PROPS, false);
                    CMISTest.this.versionService.ensureVersioningEnabled(nodeRef, props);
                    return null;
                }
            });
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    Assert.assertNotNull((Object)CMISTest.this.versionService.getVersionHistory(nodeRef));
                    CMISTest.this.versionService.createVersion(nodeRef, null);
                    return null;
                }
            });
            String NEW_DOC_NAME = (String)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                public String execute() throws Throwable {
                    String newDocName = String.valueOf(DOC) + GUID.generate();
                    CMISTest.this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_AUTHOR, null);
                    CMISTest.this.nodeService.setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)newDocName));
                    return newDocName;
                }
            });
            CmisService cmisService = this.factory.getService((CallContext)context);
            String repositoryId = ((RepositoryInfo)cmisService.getRepositoryInfos(null).get(0)).getId();
            List versions = cmisService.getAllVersions(repositoryId, nodeRef.toString(), null, null, null, null);
            Assert.assertNotNull((Object)versions);
            ObjectData latestVersion = (ObjectData)versions.get(0);
            ObjectData object = cmisService.getObjectByPath(repositoryId, "/" + FOLDER + "/" + NEW_DOC_NAME, null, null, null, null, Boolean.valueOf(false), Boolean.valueOf(false), null);
            Assert.assertNotNull((Object)latestVersion);
            Assert.assertNotNull((Object)object);
            Object objectDescriptionString = ((PropertyData)object.getProperties().getProperties().get("cmis:name")).getValues().get(0);
            Object latestVersionDescriptionString = ((PropertyData)latestVersion.getProperties().getProperties().get("cmis:name")).getValues().get(0);
            Assert.assertEquals(objectDescriptionString, latestVersionDescriptionString);
            HashSet<String> documentAspects = new HashSet<String>();
            for (CmisExtensionElement cmisEE : ((CmisExtensionElement)object.getProperties().getExtensions().get(0)).getChildren()) {
                documentAspects.add(cmisEE.getValue());
            }
            HashSet<String> latestVersionAspects = new HashSet<String>();
            for (CmisExtensionElement cmisEE : ((CmisExtensionElement)latestVersion.getProperties().getExtensions().get(0)).getChildren()) {
                latestVersionAspects.add(cmisEE.getValue());
            }
            Assert.assertEquals(latestVersionAspects, documentAspects);
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testVersioningPropertiesHaveDefaultValue() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            final NodeRef documentNodeRef = this.withCmisService(new CmisServiceCallback<NodeRef>(){

                @Override
                public NodeRef execute(CmisService cmisService) {
                    String repositoryId = ((RepositoryInfo)cmisService.getRepositoryInfos(null).get(0)).getId();
                    String rootNodeId = cmisService.getObjectByPath(repositoryId, "/", null, Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(true), null).getId();
                    ArrayList<Object> propsList = new ArrayList<Object>();
                    propsList.add(new PropertyStringImpl("cmis:name", "Folder-" + GUID.generate()));
                    propsList.add(new PropertyIdImpl("cmis:objectTypeId", "cmis:folder"));
                    String folderId = cmisService.createFolder(repositoryId, (Properties)new PropertiesImpl(propsList), rootNodeId, null, null, null, null);
                    propsList = new ArrayList();
                    propsList.add(new PropertyStringImpl("cmis:name", "File-" + GUID.generate()));
                    propsList.add(new PropertyIdImpl("cmis:objectTypeId", "cmis:document"));
                    String nodeId = cmisService.createDocument(repositoryId, (Properties)new PropertiesImpl(propsList), folderId, null, null, null, null, null, null);
                    return new NodeRef(nodeId.substring(0, nodeId.indexOf(59)));
                }
            }, CmisVersion.CMIS_1_1);
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<Void>>(){

                public List<Void> execute() throws Throwable {
                    Assert.assertTrue((boolean)CMISTest.this.nodeService.exists(documentNodeRef));
                    Assert.assertTrue((boolean)CMISTest.this.nodeService.hasAspect(documentNodeRef, ContentModel.ASPECT_VERSIONABLE));
                    AspectDefinition ad = CMISTest.this.dictionaryService.getAspect(ContentModel.ASPECT_VERSIONABLE);
                    Map properties = ad.getProperties();
                    QName[] qNameArray = new QName[]{ContentModel.PROP_INITIAL_VERSION, ContentModel.PROP_AUTO_VERSION, ContentModel.PROP_AUTO_VERSION_PROPS};
                    int n = qNameArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        QName qName = qNameArray[n2];
                        Serializable property = CMISTest.this.nodeService.getProperty(documentNodeRef, qName);
                        Assert.assertNotNull((Object)property);
                        org.alfresco.service.cmr.dictionary.PropertyDefinition pd = (org.alfresco.service.cmr.dictionary.PropertyDefinition)properties.get(qName);
                        Assert.assertNotNull((Object)pd.getDefaultValue());
                        Assert.assertEquals((Object)property, (Object)Boolean.parseBoolean(pd.getDefaultValue()));
                        ++n2;
                    }
                    return null;
                }
            });
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testCreateDocWithVersioningStateNone() throws Exception {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            final String repositoryId = this.withCmisService(new CmisServiceCallback<String>(){

                @Override
                public String execute(CmisService cmisService) {
                    List repositories = cmisService.getRepositoryInfos(null);
                    Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                    RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                    String repositoryId = repo.getId();
                    return repositoryId;
                }
            }, CmisVersion.CMIS_1_1);
            final NodeRef documentNodeRef = this.withCmisService(new CmisServiceCallback<NodeRef>(){

                @Override
                public NodeRef execute(CmisService cmisService) {
                    PropertiesImpl properties = new PropertiesImpl();
                    String objectTypeId = "cmis:document";
                    properties.addProperty((PropertyData)new PropertyIdImpl("cmis:objectTypeId", objectTypeId));
                    String fileName = "textFile" + GUID.generate();
                    properties.addProperty((PropertyData)new PropertyStringImpl("cmis:name", fileName));
                    ContentStreamImpl contentStream = new ContentStreamImpl(fileName, "text/plain", "Simple text plain document");
                    String nodeId = cmisService.create(repositoryId, (Properties)properties, CMISTest.this.repositoryHelper.getCompanyHome().getId(), (ContentStream)contentStream, VersioningState.NONE, null, null);
                    return new NodeRef(nodeId.substring(0, nodeId.indexOf(59)));
                }
            }, CmisVersion.CMIS_1_1);
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<Void>>(){

                public List<Void> execute() throws Throwable {
                    Assert.assertTrue((boolean)CMISTest.this.nodeService.exists(documentNodeRef));
                    Assert.assertFalse((boolean)CMISTest.this.nodeService.hasAspect(documentNodeRef, ContentModel.ASPECT_VERSIONABLE));
                    return null;
                }
            });
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void testCMISGetObjectParents() throws Exception {
        this.setupAudit();
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            final NodeRef folderWithTwoParents = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                public NodeRef execute() throws Throwable {
                    NodeRef companyHomeNodeRef = CMISTest.this.repositoryHelper.getCompanyHome();
                    String folder1 = GUID.generate();
                    FileInfo folderInfo1 = CMISTest.this.fileFolderService.create(companyHomeNodeRef, folder1, ContentModel.TYPE_FOLDER);
                    Assert.assertNotNull((Object)folderInfo1);
                    String folder2 = GUID.generate();
                    FileInfo folderInfo2 = CMISTest.this.fileFolderService.create(companyHomeNodeRef, folder2, ContentModel.TYPE_FOLDER);
                    Assert.assertNotNull((Object)folderInfo2);
                    String folder11 = GUID.generate();
                    FileInfo folderInfo11 = CMISTest.this.fileFolderService.create(folderInfo1.getNodeRef(), folder11, ContentModel.TYPE_FOLDER);
                    Assert.assertNotNull((Object)folderInfo11);
                    CMISTest.this.nodeService.addChild(folderInfo2.getNodeRef(), folderInfo11.getNodeRef(), ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS);
                    return folderInfo11.getNodeRef();
                }
            });
            this.withCmisService(new CmisServiceCallback<Void>(){

                @Override
                public Void execute(CmisService cmisService) {
                    List repositories = cmisService.getRepositoryInfos(null);
                    Assert.assertNotNull((Object)repositories);
                    Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                    String repositoryId = ((RepositoryInfo)repositories.iterator().next()).getId();
                    List parents = cmisService.getObjectParents(repositoryId, folderWithTwoParents.getId(), null, Boolean.FALSE, IncludeRelationships.NONE, "cmis:none", Boolean.FALSE, null);
                    Assert.assertEquals((long)2L, (long)parents.size());
                    return null;
                }
            }, CmisVersion.CMIS_1_1);
        }
        finally {
            this.auditSubsystem.destroy();
            AuthenticationUtil.popAuthentication();
        }
    }

    @Test
    public void getAllVersionsWithNullObjectId() {
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        final String folderName = "testfolder" + GUID.generate();
        final String docName = "testdoc.txt" + GUID.generate();
        NodeRef folderRef = this.createContent(folderName, docName, false).getNodeRef();
        List folderFileList = this.fileFolderService.list(folderRef);
        final NodeRef fileRef = ((FileInfo)folderFileList.get(0)).getNodeRef();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                CMISTest.this.versionService.createVersion(fileRef, null);
                return null;
            }
        });
        List<ObjectData> versions = this.withCmisService(new CmisServiceCallback<List<ObjectData>>(){

            @Override
            public List<ObjectData> execute(CmisService cmisService) {
                String repositoryId = ((RepositoryInfo)cmisService.getRepositoryInfos(null).get(0)).getId();
                ObjectData objectData = cmisService.getObjectByPath(repositoryId, "/" + folderName + "/" + docName, null, Boolean.valueOf(true), IncludeRelationships.NONE, null, Boolean.valueOf(false), Boolean.valueOf(true), null);
                Holder objectId = new Holder((Object)objectData.getId());
                cmisService.checkOut(repositoryId, objectId, null, new Holder((Object)true));
                List versions = cmisService.getAllVersions(repositoryId, null, fileRef.toString(), null, null, null);
                return versions;
            }
        });
        Assert.assertEquals((long)2L, (long)versions.size());
        Assert.assertEquals((Object)((PropertyData)versions.get(0).getProperties().getProperties().get("cmis:versionLabel")).getFirstValue(), (Object)"pwc");
        Assert.assertEquals((Object)((PropertyData)versions.get(1).getProperties().getProperties().get("cmis:versionLabel")).getFirstValue(), (Object)"0.1");
    }

    @Test
    public void aPrivateCopyMustContainTheWorkingCopyAspect_CMIS_1_1_Version() {
        final String repositoryId = this.withCmisService(new CmisServiceCallback<String>(){

            @Override
            public String execute(CmisService cmisService) {
                List repositories = cmisService.getRepositoryInfos(null);
                RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                String repositoryId = repo.getId();
                return repositoryId;
            }
        }, CmisVersion.CMIS_1_1);
        Properties currentProperties = this.withCmisService(new CmisServiceCallback<Properties>(){

            @Override
            public Properties execute(CmisService cmisService) {
                PropertiesImpl properties = new PropertiesImpl();
                String objectTypeId = "cmis:document";
                properties.addProperty((PropertyData)new PropertyIdImpl("cmis:objectTypeId", objectTypeId));
                String fileName = "textFile" + GUID.generate();
                properties.addProperty((PropertyData)new PropertyStringImpl("cmis:name", fileName));
                ContentStreamImpl contentStream = new ContentStreamImpl(fileName, "text/plain", "Simple text plain document");
                String objectId = cmisService.create(repositoryId, (Properties)properties, CMISTest.this.repositoryHelper.getCompanyHome().getId(), (ContentStream)contentStream, VersioningState.MAJOR, null, null);
                Holder objectIdHolder = new Holder((Object)objectId);
                cmisService.checkOut(repositoryId, objectIdHolder, null, null);
                ObjectData pwc = cmisService.getObject(repositoryId, (String)objectIdHolder.getValue(), null, null, null, null, null, null, null);
                pwc.getProperties();
                Properties propertiesValues = pwc.getProperties();
                return propertiesValues;
            }
        }, CmisVersion.CMIS_1_1);
        List secondaryTypeIds = ((PropertyData)currentProperties.getProperties().get("cmis:secondaryObjectTypeIds")).getValues();
        Assert.assertTrue((boolean)secondaryTypeIds.contains("P:cm:workingcopy"));
    }

    @Category(value={FrequentlyFailingTests.class})
    @Test
    public void aPrivateCopyMustAllowTheAdditionOfAspects_CMIS_1_1_Version() {
        final String repositoryId = this.withCmisService(new CmisServiceCallback<String>(){

            @Override
            public String execute(CmisService cmisService) {
                List repositories = cmisService.getRepositoryInfos(null);
                RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                String repositoryId = repo.getId();
                return repositoryId;
            }
        }, CmisVersion.CMIS_1_1);
        Properties currentProperties = this.withCmisService(new CmisServiceCallback<Properties>(){

            @Override
            public Properties execute(CmisService cmisService) {
                PropertiesImpl properties = new PropertiesImpl();
                String objectTypeId = "cmis:document";
                properties.addProperty((PropertyData)new PropertyIdImpl("cmis:objectTypeId", objectTypeId));
                String fileName = "textFile" + GUID.generate();
                properties.addProperty((PropertyData)new PropertyStringImpl("cmis:name", fileName));
                ContentStreamImpl contentStream = new ContentStreamImpl(fileName, "text/plain", "Simple text plain document");
                String objectId = cmisService.create(repositoryId, (Properties)properties, CMISTest.this.repositoryHelper.getCompanyHome().getId(), (ContentStream)contentStream, VersioningState.MAJOR, null, null);
                Holder objectIdHolder = new Holder((Object)objectId);
                cmisService.checkOut(repositoryId, objectIdHolder, null, null);
                cmisService.getObject(repositoryId, (String)objectIdHolder.getValue(), null, null, null, null, null, null, null);
                properties = new PropertiesImpl();
                properties.addProperty((PropertyData)new PropertyStringImpl("cmis:secondaryObjectTypeIds", Arrays.asList("P:cm:summarizable")));
                properties.addProperty((PropertyData)new PropertyStringImpl("cm:summary", "My summary"));
                cmisService.updateProperties(repositoryId, objectIdHolder, null, (Properties)properties, null);
                cmisService.checkIn(repositoryId, objectIdHolder, Boolean.valueOf(false), null, null, "checkin", null, null, null, null);
                Properties propertiesValues = cmisService.getProperties(repositoryId, (String)objectIdHolder.getValue(), null, null);
                return propertiesValues;
            }
        }, CmisVersion.CMIS_1_1);
        List secondaryTypeIds = ((PropertyData)currentProperties.getProperties().get("cmis:secondaryObjectTypeIds")).getValues();
        Assert.assertTrue((boolean)secondaryTypeIds.contains("P:cm:summarizable"));
        Assert.assertEquals(((PropertyData)currentProperties.getProperties().get("cm:summary")).getValues().get(0), (Object)"My summary");
    }

    @Test
    public void testSearchPreviousDelete() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            try {
                final NodeRef companyHome = this.repositoryHelper.getCompanyHome();
                RetryingTransactionHelper.RetryingTransactionCallback<Object> testCallbackFolder = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    public Object execute() throws Throwable {
                        NodeRef parentFolder = CMISTest.this.createFolder(companyHome, "testCreateParent" + GUID.generate(), ContentModel.TYPE_FOLDER);
                        return parentFolder;
                    }
                };
                final NodeRef parentFolder = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)testCallbackFolder, false, true);
                final ArrayList folders = new ArrayList();
                RetryingTransactionHelper.RetryingTransactionCallback<Object> testCallbackChilds = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    public Object execute() throws Throwable {
                        int i = 0;
                        while (i < 10) {
                            folders.add(CMISTest.this.createFolder(parentFolder, "testCreateList-" + GUID.generate() + i, ContentModel.TYPE_FOLDER));
                            ++i;
                        }
                        return folders;
                    }
                };
                this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)testCallbackChilds, false, true);
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (final NodeRef node : folders) {
                            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                                public Void doWork() throws Exception {
                                    CMISTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                                        public Void execute() throws Throwable {
                                            CMISTest.this.nodeService.deleteNode(node);
                                            return null;
                                        }
                                    }, false, true);
                                    return null;
                                }
                            }, (String)AuthenticationUtil.getAdminUserName());
                        }
                    }
                });
                this.withCmisService(new CmisServiceCallback<String>(){

                    @Override
                    public String execute(CmisService cmisService) {
                        List repositories = cmisService.getRepositoryInfos(null);
                        Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                        RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                        String repositoryId = repo.getId();
                        String queryString = "SELECT cmis:name, cmis:objectId FROM cmis:folder WHERE IN_FOLDER('" + parentFolder + "')";
                        cmisService.query(repositoryId, queryString, Boolean.FALSE, Boolean.TRUE, IncludeRelationships.NONE, "", BigInteger.TEN, BigInteger.ZERO, null);
                        return "";
                    }
                }, CmisVersion.CMIS_1_1);
            }
            catch (Exception e) {
                Assert.fail((String)e.toString());
                executorService.shutdownNow();
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }

    @Test
    public void testMNT20006() throws Exception {
        NodeRef fileNode;
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        final String nonMemberUsername = "user" + System.currentTimeMillis();
        final String nonMemberPassword = "pass" + System.currentTimeMillis();
        final String siteId = "site" + System.currentTimeMillis();
        try {
            fileNode = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                public NodeRef execute() throws Throwable {
                    CMISTest.this.authenticationService.createAuthentication(nonMemberUsername, nonMemberPassword.toCharArray());
                    HashMap<QName, String> props = new HashMap<QName, String>();
                    String email = String.valueOf(nonMemberUsername) + "@testcmis.com";
                    props.put(ContentModel.PROP_USERNAME, nonMemberUsername);
                    props.put(ContentModel.PROP_FIRSTNAME, nonMemberUsername);
                    props.put(ContentModel.PROP_LASTNAME, nonMemberUsername);
                    props.put(ContentModel.PROP_EMAIL, email);
                    PersonService.PersonInfo personInfo = CMISTest.this.personService.getPerson(CMISTest.this.personService.createPerson(props));
                    Assert.assertNotNull((String)"Null person info", (Object)personInfo);
                    SiteInfo siteInfo = CMISTest.this.siteService.createSite("myPreset", siteId, "myTitle", "myDescription", SiteVisibility.PRIVATE);
                    Assert.assertNotNull((String)"Null site info", (Object)siteInfo);
                    NodeRef siteDocLib = CMISTest.this.siteService.createContainer(siteId, "documentLibrary", ContentModel.TYPE_FOLDER, null);
                    Assert.assertNotNull((String)"Null site doclib", (Object)siteDocLib);
                    String nodeName = "node" + System.currentTimeMillis() + ".txt";
                    NodeRef fileNode = CMISTest.this.nodeService.createNode(siteDocLib, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTENT).getChildRef();
                    ContentWriter writer = CMISTest.this.contentService.getWriter(fileNode, ContentModel.PROP_CONTENT, true);
                    writer.putContent("my node content");
                    CMISTest.this.nodeService.setProperty(fileNode, ContentModel.PROP_TITLE, (Serializable)((Object)nodeName));
                    CMISTest.this.nodeService.setProperty(fileNode, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"my description"));
                    Assert.assertNotNull((String)"Null file node", (Object)fileNode);
                    Assert.assertTrue((boolean)CMISTest.this.nodeService.exists(fileNode));
                    CMISTest.this.permissionService.setPermission(fileNode, nonMemberUsername, "SiteCollaborator", true);
                    return fileNode;
                }
            });
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
        Boolean updated = this.withCmisService(nonMemberUsername, nonMemberPassword, new CmisServiceCallback<Boolean>(){

            @Override
            public Boolean execute(CmisService cmisService) {
                Boolean updated = true;
                try {
                    List repositories = cmisService.getRepositoryInfos(null);
                    Assert.assertTrue((repositories.size() > 0 ? 1 : 0) != 0);
                    RepositoryInfo repo = (RepositoryInfo)repositories.get(0);
                    String repositoryId = repo.getId();
                    Holder objectIdHolder = new Holder((Object)fileNode.toString());
                    PropertiesImpl newProperties = new PropertiesImpl();
                    newProperties.addProperty((PropertyData)new PropertyStringImpl("cmis:description", "new node description"));
                    cmisService.updateProperties(repositoryId, objectIdHolder, null, (Properties)newProperties, null);
                }
                catch (Exception exception) {
                    updated = false;
                }
                return updated;
            }
        }, CmisVersion.CMIS_1_1);
        Assert.assertTrue((String)"Document metadata not updated", (boolean)updated);
    }

    private NodeRef createFolder(NodeRef parentNodeRef, String folderName, QName folderType) throws IOException {
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_NAME, folderName);
        NodeRef nodeRef = this.nodeService.getChildByName(parentNodeRef, ContentModel.ASSOC_CONTAINS, folderName);
        if (nodeRef != null) {
            this.nodeService.deleteNode(nodeRef);
        }
        QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)folderName));
        nodeRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, assocQName, folderType, properties).getChildRef();
        return nodeRef;
    }

    private static interface CmisServiceCallback<T> {
        public T execute(CmisService var1);
    }

    public static class SimpleCallContext
    implements CallContext {
        private final Map<String, Object> contextMap = new HashMap<String, Object>();
        private CmisVersion cmisVersion;

        public SimpleCallContext(String user, String password, CmisVersion cmisVersion) {
            this.contextMap.put("username", user);
            this.contextMap.put("password", password);
            this.cmisVersion = cmisVersion;
        }

        public String getBinding() {
            return "local";
        }

        public Object get(String key) {
            return this.contextMap.get(key);
        }

        public String getRepositoryId() {
            return (String)this.get("repositoryId");
        }

        public String getUsername() {
            return (String)this.get("username");
        }

        public String getPassword() {
            return (String)this.get("password");
        }

        public String getLocale() {
            return null;
        }

        public BigInteger getOffset() {
            return (BigInteger)this.get("offset");
        }

        public BigInteger getLength() {
            return (BigInteger)this.get("length");
        }

        public boolean isObjectInfoRequired() {
            return false;
        }

        public File getTempDirectory() {
            return null;
        }

        public int getMemoryThreshold() {
            return 0;
        }

        public long getMaxContentSize() {
            return Long.MAX_VALUE;
        }

        public boolean encryptTempFiles() {
            return false;
        }

        public CmisVersion getCmisVersion() {
            return this.cmisVersion;
        }
    }

    private static class TestContext {
        private String repositoryId = null;
        private ObjectData objectData = null;
        private Holder<String> objectId = null;

        public String getRepositoryId() {
            return this.repositoryId;
        }

        public void setRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        public void setObjectData(ObjectData objectData) {
            this.objectData = objectData;
        }

        public Holder<String> getObjectId() {
            return this.objectId;
        }

        public void setObjectId(Holder<String> objectId) {
            this.objectId = objectId;
        }
    }
}

