/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.commands.CompoundCommand;
import org.alfresco.filesys.repo.rules.commands.CopyContentCommand;
import org.alfresco.filesys.repo.rules.commands.DeleteFileCommand;
import org.alfresco.filesys.repo.rules.commands.MoveFileCommand;
import org.alfresco.filesys.repo.rules.commands.RenameFileCommand;
import org.alfresco.filesys.repo.rules.operations.MoveFileOperation;
import org.alfresco.filesys.repo.rules.operations.RenameFileOperation;
import org.alfresco.jlan.server.filesys.FileName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScenarioDoubleRenameShuffleInstance
implements ScenarioInstance {
    private static Log logger = LogFactory.getLog(ScenarioDoubleRenameShuffleInstance.class);
    InternalState internalState = InternalState.NONE;
    private Date startTime = new Date();
    private String fileMiddle;
    private String fileFrom;
    private String fileEnd;
    private ScenarioInstance.Ranking ranking;
    private boolean deleteBackup;
    private boolean moveAsSystem;
    private Pattern interimPattern;
    private long timeout = 30000L;
    private boolean isComplete;
    private String folderMiddle;
    private String folderEnd;
    private Map<String, String> renames = new HashMap<String, String>();

    @Override
    public Command evaluate(Operation operation) {
        Date now = new Date();
        if (now.getTime() > this.startTime.getTime() + this.getTimeout()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Instance timed out");
            }
            this.isComplete = true;
            return null;
        }
        switch (this.internalState) {
            case NONE: {
                if (operation instanceof RenameFileOperation) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Got first rename - tracking rename: " + operation));
                    }
                    RenameFileOperation r = (RenameFileOperation)operation;
                    this.fileMiddle = r.getFrom();
                    this.fileEnd = r.getTo();
                    String[] paths = FileName.splitPath((String)r.getFromPath());
                    this.folderMiddle = paths[0];
                    String[] paths2 = FileName.splitPath((String)r.getToPath());
                    this.folderEnd = paths2[0];
                    this.internalState = InternalState.RENAME1;
                    return new RenameFileCommand(r.getFrom(), r.getTo(), r.getRootNodeRef(), r.getFromPath(), r.getToPath());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"State error, expected a RENAME");
                }
                this.isComplete = true;
            }
            case RENAME1: {
                Matcher m;
                Operation r;
                if (operation instanceof RenameFileOperation) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Tracking rename: " + operation));
                    }
                    if (this.fileMiddle.equalsIgnoreCase(((RenameFileOperation)(r = (RenameFileOperation)operation)).getTo())) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Got second rename");
                        }
                        this.fileFrom = ((RenameFileOperation)r).getFrom();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Go and shuffle! fromName:" + this.fileFrom + " middle: " + this.fileMiddle + " end: " + this.fileEnd));
                        }
                        String[] paths = FileName.splitPath((String)((RenameFileOperation)r).getFromPath());
                        String oldFolder = paths[0];
                        ArrayList<Command> commands = new ArrayList<Command>();
                        RenameFileCommand r1 = new RenameFileCommand(this.fileEnd, this.fileMiddle, ((RenameFileOperation)r).getRootNodeRef(), String.valueOf(oldFolder) + "\\" + this.fileEnd, String.valueOf(oldFolder) + "\\" + this.fileMiddle);
                        commands.add(r1);
                        CopyContentCommand copyContent = new CopyContentCommand(this.fileFrom, this.fileMiddle, ((RenameFileOperation)r).getRootNodeRef(), String.valueOf(oldFolder) + "\\" + this.fileFrom, String.valueOf(oldFolder) + "\\" + this.fileMiddle);
                        commands.add(copyContent);
                        if (this.deleteBackup) {
                            logger.debug((Object)"deleteBackup option turned on");
                            DeleteFileCommand d1 = new DeleteFileCommand(oldFolder, ((RenameFileOperation)r).getRootNodeRef(), String.valueOf(oldFolder) + "\\" + this.fileFrom);
                            commands.add(d1);
                        } else {
                            RenameFileCommand r2 = new RenameFileCommand(this.fileFrom, this.fileEnd, ((RenameFileOperation)r).getRootNodeRef(), String.valueOf(oldFolder) + "\\" + this.fileFrom, String.valueOf(oldFolder) + "\\" + this.fileEnd);
                            commands.add(r2);
                        }
                        this.isComplete = true;
                        return new CompoundCommand(commands);
                    }
                }
                if (!(operation instanceof MoveFileOperation)) break;
                if (logger.isDebugEnabled()) {
                    logger.info((Object)("Tracking rename: " + operation));
                }
                if (this.fileMiddle.equalsIgnoreCase(((MoveFileOperation)(r = (MoveFileOperation)operation)).getTo())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Got second rename");
                    }
                    this.fileFrom = ((MoveFileOperation)r).getFrom();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Go and shuffle! fromName:" + this.fileFrom + " middle: " + this.fileMiddle + " end: " + this.fileEnd));
                    }
                    String[] paths = FileName.splitPath((String)((MoveFileOperation)r).getFromPath());
                    String oldFolder = paths[0];
                    ArrayList<Command> commands = new ArrayList<Command>();
                    RenameFileCommand r1 = new RenameFileCommand(this.fileEnd, this.fileMiddle, ((MoveFileOperation)r).getRootNodeRef(), String.valueOf(this.folderEnd) + "\\" + this.fileEnd, String.valueOf(this.folderMiddle) + "\\" + this.fileMiddle);
                    commands.add(r1);
                    CopyContentCommand copyContent = new CopyContentCommand(this.fileFrom, this.fileMiddle, ((MoveFileOperation)r).getRootNodeRef(), String.valueOf(oldFolder) + "\\" + this.fileFrom, String.valueOf(this.folderMiddle) + "\\" + this.fileMiddle);
                    commands.add(copyContent);
                    if (this.deleteBackup) {
                        logger.debug((Object)"deleteBackup option turned on");
                        DeleteFileCommand d1 = new DeleteFileCommand(oldFolder, ((MoveFileOperation)r).getRootNodeRef(), String.valueOf(oldFolder) + "\\" + this.fileFrom);
                        commands.add(d1);
                    } else {
                        MoveFileCommand m1 = new MoveFileCommand(this.fileFrom, this.fileEnd, ((MoveFileOperation)r).getRootNodeRef(), String.valueOf(oldFolder) + "\\" + this.fileFrom, String.valueOf(this.folderEnd) + "\\" + this.fileEnd, this.isMoveAsSystem());
                        commands.add(m1);
                    }
                    this.isComplete = true;
                    return new CompoundCommand(commands);
                }
                if (this.interimPattern == null || !(m = this.interimPattern.matcher(((MoveFileOperation)r).getFromPath())).matches() || !((MoveFileOperation)r).getFrom().equals(((MoveFileOperation)r).getTo())) break;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Got system move from temporary folder: " + ((MoveFileOperation)r).getFrom() + " to " + ((MoveFileOperation)r).getToPath()));
                }
                return new MoveFileCommand(((MoveFileOperation)r).getFrom(), ((MoveFileOperation)r).getTo(), ((MoveFileOperation)r).getRootNodeRef(), ((MoveFileOperation)r).getFromPath(), ((MoveFileOperation)r).getToPath(), true);
            }
        }
        return null;
    }

    public boolean isMoveAsSystem() {
        return this.moveAsSystem;
    }

    public void setMoveAsSystem(boolean moveAsSystem) {
        this.moveAsSystem = moveAsSystem;
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    public String toString() {
        return "ScenarioDoubleRename:" + this.fileMiddle;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setDeleteBackup(boolean deleteBackup) {
        this.deleteBackup = deleteBackup;
    }

    public boolean isDeleteBackup() {
        return this.deleteBackup;
    }

    public void setInterimPattern(Pattern interimPattern) {
        this.interimPattern = interimPattern;
    }

    static enum InternalState {
        NONE,
        RENAME1,
        RENAME2;

    }
}

