/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.quickshare;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.quickshare.QuickShareLinkExpiryActionException;
import org.alfresco.repo.quickshare.QuickShareLinkExpiryActionImpl;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.quickshare.QuickShareLinkExpiryAction;
import org.alfresco.service.cmr.quickshare.QuickShareLinkExpiryActionPersister;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.ParameterCheck;

public class QuickShareLinkExpiryActionPersisterImpl
implements QuickShareLinkExpiryActionPersister {
    protected static final NodeRef QUICK_SHARE_LINK_EXPIRY_ACTIONS_ROOT = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "shared_link_expiry_actions_space");
    private NodeService nodeService;
    private RuntimeActionService runtimeActionService;
    private BehaviourFilter behaviourFilter;
    private ImporterBootstrap importerBootstrap;
    private Properties bootstrapView;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRuntimeActionService(RuntimeActionService runtimeActionService) {
        this.runtimeActionService = runtimeActionService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void setBootstrapView(Properties bootstrapView) {
        this.bootstrapView = bootstrapView;
    }

    @Override
    public void saveQuickShareLinkExpiryAction(QuickShareLinkExpiryAction linkExpiryAction) {
        ParameterCheck.mandatory((String)"linkExpiryAction", (Object)linkExpiryAction);
        NodeRef actionNodeRef = this.findOrCreateActionNode(linkExpiryAction);
        try {
            this.behaviourFilter.disableBehaviour(actionNodeRef);
            this.runtimeActionService.saveActionImpl(actionNodeRef, linkExpiryAction);
        }
        finally {
            this.behaviourFilter.enableBehaviour(actionNodeRef);
        }
    }

    @Override
    public NodeRef getQuickShareLinkExpiryActionNode(QName linkExpiryActionName) {
        ParameterCheck.mandatory((String)"linkExpiryActionName", (Object)linkExpiryActionName);
        NodeRef rootNodeRef = this.getOrCreateActionsRootNodeRef();
        List childAssocs = this.nodeService.getChildAssocs(rootNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)linkExpiryActionName);
        if (!childAssocs.isEmpty()) {
            if (childAssocs.size() > 1) {
                throw new QuickShareLinkExpiryActionException("Multiple quick share link expiry actions with the name: " + linkExpiryActionName + " exist!");
            }
            return ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
        }
        return null;
    }

    @Override
    public QuickShareLinkExpiryAction loadQuickShareLinkExpiryAction(QName linkExpiryActionName) {
        NodeRef actionNode = this.getQuickShareLinkExpiryActionNode(linkExpiryActionName);
        return this.loadQuickShareLinkExpiryAction(actionNode);
    }

    @Override
    public QuickShareLinkExpiryAction loadQuickShareLinkExpiryAction(NodeRef linkExpiryActionNodeRef) {
        if (linkExpiryActionNodeRef != null) {
            Action action = this.runtimeActionService.createAction(linkExpiryActionNodeRef);
            return new QuickShareLinkExpiryActionImpl(action);
        }
        return null;
    }

    @Override
    public void deleteQuickShareLinkExpiryAction(QuickShareLinkExpiryAction linkExpiryAction) {
        ParameterCheck.mandatory((String)"linkExpiryAction", (Object)linkExpiryAction);
        NodeRef actionNodeRef = this.findOrCreateActionNode(linkExpiryAction);
        if (actionNodeRef != null) {
            this.nodeService.deleteNode(actionNodeRef);
        }
    }

    private NodeRef findOrCreateActionNode(QuickShareLinkExpiryAction linkExpiryAction) {
        QName actionQName = linkExpiryAction.getActionQName();
        NodeRef actionNode = this.getQuickShareLinkExpiryActionNode(actionQName);
        if (actionNode == null) {
            NodeRef rootNodeRef = this.getOrCreateActionsRootNodeRef();
            actionNode = this.runtimeActionService.createActionNodeRef(linkExpiryAction, rootNodeRef, ContentModel.ASSOC_CONTAINS, actionQName);
        }
        return actionNode;
    }

    private NodeRef getOrCreateActionsRootNodeRef() {
        if (!this.nodeService.exists(QUICK_SHARE_LINK_EXPIRY_ACTIONS_ROOT)) {
            ArrayList<Properties> singletonList = new ArrayList<Properties>();
            singletonList.add(this.bootstrapView);
            this.importerBootstrap.setBootstrapViews(singletonList);
            this.importerBootstrap.setUseExistingStore(true);
            this.importerBootstrap.bootstrap();
            if (!this.nodeService.exists(QUICK_SHARE_LINK_EXPIRY_ACTIONS_ROOT)) {
                throw new QuickShareLinkExpiryActionException("Couldn't import the quick share link expiry actions root node.");
            }
        }
        return QUICK_SHARE_LINK_EXPIRY_ACTIONS_ROOT;
    }
}

