/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.workflow;

import java.util.Optional;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;

public final class FailedWorkflowDeployment {
    private FailedWorkflowDeployment() {
    }

    public static WorkflowDeployment deploymentForbidden(String workflowName, String reason) {
        return new DeploymentFailure(workflowName, reason);
    }

    public static Optional<String> getFailure(WorkflowDeployment workflowDeployment) {
        if (!(workflowDeployment instanceof DeploymentFailure)) {
            return Optional.empty();
        }
        return Optional.of(workflowDeployment.getProblems()[0]);
    }

    private static class DeploymentFailure
    extends WorkflowDeployment {
        private static final String UNDEFINED = "undefined";

        private DeploymentFailure(String workflowName, String problemDescription) {
            super(DeploymentFailure.failedDefinition(workflowName), problemDescription);
        }

        private static WorkflowDefinition failedDefinition(String workflowName) {
            String definitionName = workflowName == null ? UNDEFINED : workflowName;
            return new WorkflowDefinition(UNDEFINED, definitionName, UNDEFINED, UNDEFINED, UNDEFINED, null);
        }
    }
}

