/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.validator;

import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.ValidationResult;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.validator.DbValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class NameValidator
implements DbValidator {
    private Pattern pattern;
    private static final Log log = LogFactory.getLog(NameValidator.class);

    @Override
    public void validate(DbObject reference, DbObject target, DiffContext ctx) {
        String name = target.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validating: pattern: [" + this.pattern + "], reference: " + reference + ", target: " + target));
        }
        if (this.pattern != null && !this.pattern.matcher(name).matches()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Pattern [" + this.pattern + "] not matched."));
            }
            String message = I18NUtil.getMessage((String)"system.schema_comp.name_validator", (Object[])new Object[]{this.pattern});
            ValidationResult result = new ValidationResult(new DbProperty(target, "name"), message);
            ctx.getComparisonResults().add(result);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Pattern [" + this.pattern + "] matched OK."));
        }
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public void setProperty(String name, String value) {
        if (name.equals("pattern") && value != null) {
            Pattern pattern = Pattern.compile(value);
            this.setPattern(pattern);
        }
    }

    @Override
    public String getProperty(String name) {
        if (name.equals("pattern") && this.pattern != null) {
            return this.pattern.toString();
        }
        return null;
    }

    @Override
    public Set<String> getPropertyNames() {
        TreeSet<String> props = new TreeSet<String>();
        props.add("pattern");
        return props;
    }

    @Override
    public boolean validates(String fieldName) {
        ParameterCheck.mandatoryString((String)"fieldName", (String)fieldName);
        return fieldName.equals("name");
    }

    @Override
    public boolean validatesFullObject() {
        return false;
    }
}

