/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forum;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.forum.CommentService;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForumPostBehaviours
implements NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy {
    public static final int COUNT_TRIGGER_VALUE = -1;
    private static final Log log = LogFactory.getLog(ForumPostBehaviours.class);
    private PolicyComponent policyComponent;
    private CommentService commentService;
    private NodeService nodeService;
    private NodeService rawNodeService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setCommentService(CommentService commentService) {
        this.commentService = commentService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRawNodeService(NodeService nodeService) {
        this.rawNodeService = nodeService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ForumModel.ASPECT_COMMENTS_ROLLUP, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, ForumModel.TYPE_POST, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ForumModel.TYPE_POST, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
    }

    @Override
    public void onUpdateProperties(NodeRef commentsRollupNode, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        Integer newCommentCountInt;
        Serializable newCommentCount = after.get(ForumModel.PROP_COMMENT_COUNT);
        if (newCommentCount != null && (newCommentCountInt = (Integer)newCommentCount) == -1) {
            Integer realCommentTotal;
            if (log.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append(commentsRollupNode).append(" had its ").append(ForumModel.PROP_COMMENT_COUNT.getLocalName()).append(" property set to ").append(newCommentCountInt);
                log.debug((Object)msg.toString());
                log.debug((Object)"Triggering a comment recount...");
            }
            if ((realCommentTotal = this.calculateCommentTotalByNodeCounting(commentsRollupNode)) != null && realCommentTotal != -1) {
                this.nodeService.setProperty(commentsRollupNode, ForumModel.PROP_COMMENT_COUNT, (Serializable)realCommentTotal);
            }
        }
    }

    private Integer calculateCommentTotalByNodeCounting(NodeRef discussableNode) {
        Integer result = null;
        if (this.nodeService.hasAspect(discussableNode, ForumModel.ASPECT_DISCUSSABLE)) {
            NodeRef topicNode = this.commentService.getShareCommentsTopic(discussableNode);
            if (log.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Recounting comments for node ").append(discussableNode);
                log.debug((Object)msg.toString());
                msg = new StringBuilder();
                msg.append("Topic node: ").append(topicNode);
                log.debug((Object)msg.toString());
            }
            if (topicNode != null) {
                HashSet<QName> childNodeTypeQNames = new HashSet<QName>();
                childNodeTypeQNames.add(ForumModel.TYPE_POST);
                List fmPostChildren = this.rawNodeService.getChildAssocs(topicNode, childNodeTypeQNames);
                result = fmPostChildren.size();
            }
        }
        return result;
    }

    @Override
    public void onCreateNode(final ChildAssociationRef childAssocRef) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                ForumPostBehaviours.this.adjustCommentCount(childAssocRef.getChildRef(), true);
                return null;
            }
        });
    }

    @Override
    public void beforeDeleteNode(final NodeRef nodeRef) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                ForumPostBehaviours.this.adjustCommentCount(nodeRef, false);
                return null;
            }
        });
    }

    private void adjustCommentCount(NodeRef fmPostNode, boolean incrementing) {
        NodeRef discussableAncestor = this.commentService.getDiscussableAncestor(fmPostNode);
        if (discussableAncestor != null) {
            if (this.discussableNodeRequiresFullRecount(discussableAncestor)) {
                Integer recount = this.calculateCommentTotalByNodeCounting(discussableAncestor);
                if (recount != null) {
                    this.nodeService.addAspect(discussableAncestor, ForumModel.ASPECT_COMMENTS_ROLLUP, null);
                    int newCountValue = recount;
                    if (!incrementing) {
                        --newCountValue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(discussableAncestor + " newCountValue: " + newCountValue));
                    }
                    this.nodeService.setProperty(discussableAncestor, ForumModel.PROP_COMMENT_COUNT, (Serializable)Integer.valueOf(newCountValue));
                }
            } else {
                Integer existingCommentCount = (Integer)this.nodeService.getProperty(discussableAncestor, ForumModel.PROP_COMMENT_COUNT);
                int existingCommentCountInt = existingCommentCount == null ? 0 : existingCommentCount;
                int delta = incrementing ? 1 : -1;
                this.nodeService.setProperty(discussableAncestor, ForumModel.PROP_COMMENT_COUNT, (Serializable)Integer.valueOf(existingCommentCountInt + delta));
            }
        }
    }

    private boolean discussableNodeRequiresFullRecount(NodeRef discussableNode) {
        boolean result;
        if (!this.nodeService.hasAspect(discussableNode, ForumModel.ASPECT_DISCUSSABLE)) {
            throw new AlfrescoRuntimeException("Node did not have fm:discussable aspect as expected.");
        }
        if (!this.nodeService.hasAspect(discussableNode, ForumModel.ASPECT_COMMENTS_ROLLUP)) {
            result = true;
        } else {
            Integer existingCommentCount = (Integer)this.nodeService.getProperty(discussableNode, ForumModel.PROP_COMMENT_COUNT);
            boolean bl = result = existingCommentCount == null || existingCommentCount <= -1;
        }
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append(discussableNode).append(" does");
            if (!result) {
                msg.append(" not");
            }
            msg.append(" require full comment recount");
            log.debug((Object)msg.toString());
        }
        return result;
    }
}

